<?php
# @Author: Rainer Imb <consentio>
# @Date:   2018-08-25 01:40:07
# @Email:  imb@consentio.at
# @Project: consentio mccurdy
# @Filename: cocron.php
# @Last modified by:   consentio
# @Last modified time: 2022-05-28T16:59:45+02:00
# @License: GPL 2.0

# get and extend config
require_once ("lib/conf_inc.php");
require_once ("lib/share.php");
require_once ("lib/access.php");
require_once ("lib/cms.php");

// debug mode: display errors
if (isset($con['debug'])) {
	error_reporting(E_ALL);
	ini_set("display_errors", 1);
	}

$con['version'] = open_txt(basename(__DIR__).'/lib/version.txt');
$con['coco'] = "/".basename(__DIR__);

/**
 * @var array all plugins with a generator
 */
$generators = ['announces', 'carousel', 'webshop', 'gastro'];

try {
	$dns = $dba['db_driver'].":dbname=".$dba['database'].";host=".$dba['host'].";charset=utf8";
    $db = new PDO($dns, $dba['db_user'], $dba['db_pw']);
	}
catch (PDOException $e) {
    echo 'Connection failed: ' . $e->getMessage();
	exit;
	}

used_langs();

$html = [
	'user'		=> ['language' => $con['ln']],
	"con"		=> $con,
	"myurl"		=> basename(__FILE__),
	"dir"		=> $_SERVER['DOCUMENT_ROOT']
	];

$website = read_settings(['group' => 'cms']);
$now = time();
$date = param('_f') == 't' ? 0 : strtotime($website['last_update']);

// allow update all 30 min
if (($now - $date) > 1800) {
	$today = date('Y-m-d');
	$arg = $db->exec("update `content` set `published` = 2 where `c_start` = '$today'");
	$arg = $db->exec("update `content` set `published` = 1 where `c_end` = '$today'");
	foreach ($generators as $plugin) {generate_plugin($plugin);}
	generate();
	write_setting(['table' => 'cms_settings', 'key' => 'last_update', 'group' => 'cms', 'lang' => '*', 'rule' => $con['rule'], 'value' => date('Y-m-d H:i:s')]);

	// dump data
	exec("mysqldump --user={$dba['db_user']} --password={$dba['db_pw']} --host={$dba['host']} {$dba['database']} --result-file=lib/sql/{$dba['database']}.sql 2>&1", $output);

	$end = microtime(true);
	$time = sprintf('%0.4f ms', 1000*($end-$_SERVER["REQUEST_TIME_FLOAT"]));
	if ($time > 1000) {$time = sprintf('%0.4f s', $end-$_SERVER["REQUEST_TIME_FLOAT"]);}
	echo $time;
	}
$db = null;

function generate_plugin($plugin) {
	$check = get_one_register(['action' => $plugin]);
	if (isset($check['reg'])) {
		//echo "$plugin:  {$check['plugin']} -";
		include_once ("plugins/{$check['plugin']}_generator.php");
		if (class_exists("{$check['plugin']}_generator")) {
			$func = "{$check['plugin']}_generator";
			$myclass = new $func();
			$myclass->generate();
			}
		else {
			$func = "generate_{$check['plugin']}";
			$func();
			}
		}
	}
?>
