<?php
# a libary of functions used for consentio cms
# @Author: Rainer Imb <imb>
# @Date:   2018-05-28 12:17:47
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-08-30T19:01:45+02:00
# @License: GPL 2.0

require_once ("generator.php");

/**
 * start with an overview
 * @param array $html the html-data
 * @return array $html the modified html-data
 */
function overview($html) {
	global $website, $con;
	$html['content'] = get_board($html, "ALL");
	$html['formtitle'] = i18n('overview');
	$html['left'] = bubble_text('common.intro');
	$html['left'] .= "<p><strong>".i18n('last_update')."</strong>: ".$website['last_update']."</p>";

	// cowa
	$cowa = read_settings(['group' => 'cowa']);
	if (isset($cowa['token'])) {
		require_once('plugins/cowac.php');
		$link = $html['myurl']."?sid={$html['sid']}&amp;_id=cowa_client";
		$html['left'] .= htmltag('h2', '', htmltag('a', 'href="'.$link.'"', i18n('cowa')));
		$oCowa = new cowa($cowa);
		$html['left'] .= $oCowa->embed('daily');
		$html['scripts'] .= "<script src='/js/jQcharts.js' type='text/javascript'></script>";
		}

	// webshop
	$test = get_one_register(['action' => 'webshop']);
	if (isset($test['reg'])) {
		require_once('plugins/shop_checks.php');
		$check = new shop_checks();
		$html['left'] .= $check->get_info();
		}

	// sys-checks
	if ($html['user']['name'] == "Startuser") {
		$html['left'] .= say_mess(i18n('alter_def_user')."<p class='alright'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id=user&amp;todo=edit&amp;rid=1'>".i18n('ok')."</a></p>", '', 'warning');
		}
	if (file_exists('evaluate.php')) {
		if (!unlink('evaluate.php')) {$html['left'] .= say_mess('Cannot remove evaluate.php!', i18n('error'), 'error');}
		}
	if ($website['website_url'] == '/') {
		$html['left'] .= say_mess(i18n('make_settings')."<p class='alright'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id=web_settings'>".i18n('ok')."</a></p>", '', 'warning');
		}
	if (ini_get('allow_url_fopen') && $html['user']['level'] >= 3) {
		$txt = @fopen("https://www.consentio.at/central/update{$html['con']['version']}.json", "r");
		if($txt){
			$json = stream_get_contents($txt); fclose($txt);
			$upd = json_decode($json, true);
			if ($upd['ver'] != $con['version']) {$html['left'] .= say_mess(i18n('new_updates')."<p class='alright'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id=update'>".i18n('ok')."</a></p>", i18n('info'), 'info');}
			}
		}
	$html['gui'] = 3;
	return $html;
	}

function add_new_lang_col() {
	global $db, $con;
	$arg = $db->prepare("SHOW FULL COLUMNS FROM `i18n`;");
	$arg->execute();
	$cols = array();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		if ($data['Type'] == 'varchar(64)') {array_push($cols, $data['Field']);}
		}
	foreach (array_keys($con['langs']) as $ln) {
		if (!in_array($ln, $cols)) {
			$arg = $db->prepare("ALTER IGNORE TABLE `i18n` ADD COLUMN `$ln` varchar( 64 ) NOT NULL DEFAULT ''");
			$arg->execute();
			}
		}
	}

/**
 * multilingual support
 * @param array iso-code of languages to be used for multilingual support
 */
function set_multilingual($langs) {
	global $db, $con;
	$arg = $db->prepare("UPDATE `languages` SET `multilingual` = '' WHERE `multilingual` = 'on';");
	$arg->execute();
	$in = implode("','", $langs);
	// you must not delete the default language
	if (!$in) {$in = $con['ln'];}
	$arg = $db->prepare("UPDATE `languages` SET `multilingual` = 'on' WHERE `iso639` in('$in');");
	$arg->execute();
	}

/**
 * writes components in db
 * @param array $data the input
 */
function write_component($data)	{
	global $db;
	if (!array_key_exists('custom', $data)) {$data['custom'] = '';}
	if (!array_key_exists('title', $data)) {$data['title'] = '';}
	$arg = $db->prepare("SELECT `id` FROM `components` WHERE `name` = ? AND `lang` = ?;");
	$arg->execute(array($data['component'], $data['lang']));
	$id = $arg->fetch(PDO::FETCH_ASSOC);
	$taint = [$data['component'], $data['title'], $data['html'], $data['lang'], $data['active'], $data['custom']];
	$query = "INSERT INTO `components` SET `name` = ?, `title` = ?, `content` = ?, `lang` = ?, `active` = ?, `custom` = ?;";
	if ($id) {
		$query = "UPDATE `components` SET `title` = ?, `content` = ?, `lang` = ?, `active` = ?, `custom` = ? where `id` = '{$id['id']}'";
		array_shift($taint);
		}
	$arg = $db->prepare($query);
	$arg->execute($taint);
	}

/**
 * read a component
 * @param array name and lang of component
 * @return string component
 */
function read_component($data)	{
	global $db;
	$arg = $db->prepare("SELECT `content` FROM `components` WHERE `name` = ? AND `lang` = ?;");
	$arg->execute(array($data['component'], $data['lang']));
	$data = $arg->fetch(PDO::FETCH_ASSOC);
	$c = $arg->rowCount() ? $data['content'] : '';
	return $c;
	}

/**
 * delete a component
 * @param  array name and lang of component
 */
function delete_component($data)	{
	global $db;
	$arg = $db->prepare("DELETE FROM `components` WHERE `name` = ? AND `lang` = ?;");
	$arg->execute(array($data['component'], $data['lang']));
	}

function form_by_type($type) {
	global $html, $website;
	check_content_types();

	// content filter
	// pages and content types that behaves like pages may be
	// removed in the set attribute dialog
	$form = ["html"	=> $html];
	$extra = ['pages']; $view = [i18n('only_pages')];
	foreach ($website['content_types'] as $k=>$v) {
		if ($v['move']) {
			array_push($extra, $k);
			array_push($view, i18n('only_'.$k));
			}
		}
	$inputs = ['c_filter' => ['type' => 'array', 'extra' => $extra, 'view' => $view, 'all' => 1, 'raw' => 1,]];
	$obj =  new access($form);
	$inputs = $obj->get_params($inputs);
	if ($inputs['c_filter']['value']) {$inputs['c_filter']['css_label'] = "filtered";}
	$inputs['c_filter']['caption'] .= bubble('pages.c_filter');
	$view_sel = $obj->input_array($inputs['c_filter']);

	$clause = "`type` <> 'root'";
	$attr = ['published', 'template'];
	$tablefields = ["id", "type", "published", "sort", "title", "parent", "body", "lang", "update"];
	if ($inputs['c_filter']['value']) {
		$c = $inputs['c_filter']['value'];
		$clause = "`type` = '$c'";
		array_push($attr, 'parent');
		if (in_array($c, ['article', 'products'])){array_splice($tablefields, 4, 0, 'picture');}
		//if ($c == 'article'){array_splice($tablefields, 4, 0, 'top');}
		}

	$nodel = explode(',', $website['homepages']);
	$allow_box = 'both';
	$allow_del = true;
	$no_edit = [];
	$edit_only = check_restricted_access($html['user']['id']);

	if ($html['user']['level'] < 2) {
		$allow_box = false;
		$allow_del = false;
		};

	$form = [
		"html"			=> $html,
		"title"			=> i18n('pages'),
		"table"			=> "content",
		"myconf"		=> "pages",
		"orderby"		=> "sort",
		"human"			=> "title",
		"filters"		=> ["lang", "parent"],
		"search"		=> ["fulltext", "title", "short", "body"],
		"table_fields"	=> $tablefields,
		"clause"		=> $clause,
		"in_searchform"	=> $view_sel,
		"allow_box"		=> $allow_box,
		"allow_edit"	=> 'cms_edit_by_type',
		"allow_del"		=> $allow_del,
		"attr_to_set"	=> $attr,
		"no_del"		=> $nodel,
		"no_edit"		=> $no_edit,
		];
	if (!empty($edit_only)) {$form['edit_only'] = $edit_only;}
	return $form;
	}

function generate() {
	global $db, $con, $website;

	// generate page-plugins first
	if (!isset($website['content_types'])) {check_content_types();}
	foreach ($website['content_types'] as $k=>$v) {
		if ($v['generate']) {
			$check = get_one_register(['action' => $k]);
			if (isset($check['reg'])) {
				//echo "$plugin:  {$check['plugin']} -";
				include_once ("plugins/{$check['plugin']}_generator.php");
				if (class_exists("{$check['plugin']}_generator")) {
					$func = "{$check['plugin']}_generator";
					$myclass = new $func();
					$myclass->generate();
					}
				else {
					$func = "generate_{$check['plugin']}";
					$func();
					}
				}
			}
		}

	// generate pages
	$page = new coco([
		 'deflang'	=> $con['ln'],
		 'cms_dir'	=> $_SERVER['DOCUMENT_ROOT'],
		 'version'	=> $con['version'],
		 'charset'	=> $con['charset'],
		 'defaults'	=> $website,
		 'codir'	=> $con['coco']
		 ]);

	$query = "SELECT * FROM `content` WHERE `published` > 1 AND `generate` = 1 ORDER BY `parentsort`;";
	$arg = $db->prepare($query);
	$arg->execute();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		if ($data['folder'] == 1 && $data['parent'] == 1) {$root = $data['id'];};
		$data['ajax'] = $con['coco']."/";
		$page->build_page($data);
		$page->save();
		}
	$page->sitemap();
	write_setting(['table' => 'cms_settings', 'key' => 'last_update', 'group' => 'cms', 'lang' => '*', 'rule' => $con['rule'], 'value' => date('Y-m-d H:i:s')]);
	}

function dynamic($id) {
	global $db, $dba, $con, $html, $website;
	$con['coco'] = array_reverse(explode("/", __DIR__))[1]; # qui qu'a vu coco

	$html = [
		"content"		=> "&nbsp;",
		"scripts"		=> '',
		"con"			=> $con,
		"bubbles"		=> "",
		"plugin"		=> "",
		"feedback"		=> "",
		"popup"			=> "",
		"sid"			=> clean_var(param('sid'), "n"),
		"myurl"			=> "index.html",
		"dir"			=> $_SERVER['DOCUMENT_ROOT']
		];

	try {
		$dns = $dba['db_driver'].":dbname=".$dba['database'].";host=".$dba['host'].";charset=utf8";
		$db = new PDO($dns, $dba['db_user'], $dba['db_pw']);
		}
	catch (PDOException $e) {
		echo 'Connection failed: ' . $e->getMessage();
		exit;
		}

	used_langs();
	if (!isset($con['mylang'])) {
		$ln = param('lang') ? clean_var(param('lang'), 'wr') : $con['ln'];
		$ln = in_array($ln, array_keys($con['langs'])) ? $ln : $con['ln'];
		$html['user']['language'] = $ln;
		}
	else {$html['user']['language'] = $con['mylang'];}
	$html['user']['name'] = '';
	$html['user']['level'] = 0;
	$website = read_settings(['group' => 'cms']);
	check_content_types();

	$page = new coco([
		'deflang'	=> $con['ln'],
		'cms_dir'	=> $_SERVER['DOCUMENT_ROOT'],
		'version'	=> $con['version'],
		'charset'	=> $con['charset'],
		'defaults'	=> $website
		]);

	if (!$id) {$id = 1;}
	if( $id == 'search') {
		$data = public_search($html);
		$sb = $html['user']['language'] == $con['ln'] ? 'SEARCHBOX' : 'SEARCHBOX_'.$html['user']['language'];
		$page->all_components[$sb] = "&nbsp;";
		}
	elseif ($id == 'rubric') {
		require_once("../{$con['coco']}/plugins/news_generator.php");
		$data = build_rubric($html);
		}
	elseif (preg_match('/\D/', $id)) {
		$html['action'] = $id;
		$data = content_of_plugin($html);
		if (isset($data['components'])) {$page->all_components = array_merge($page->all_components, $data['components']);}
		}
	else {
		$data = get_page_data($id);
		// fall back to homepage if page doesn't exists
		if(!isset($data['body'])) {$data = get_page_data(2);}
		}
	if (param('_w')) {$data['body'] = safe_highlight($data['body'], clean_var(param('_w'), 'w'));}
	$data['ajax'] = "/{$con['coco']}/";
	// print version with zero template
	if (param('_pr') == 1) {$page->zero_template($data['template']);}
	if ($data['type'] == 'article') {
		require_once("../{$con['coco']}/plugins/news_generator.php");
		$data['body'] .= make_related_news($data);
		}
	if ($data['template'] == "ajax") {$out = $data['body'];}
	// print version as pdf
	elseif (param('_pr') == 2) {
		require_once("../{$con['coco']}/plugins/news_pdf.php");
		$pdf = new news_pdf(['news' => $id]);
		$out = $pdf->make_pdf();
		}
	else {
		$page->build_page($data);
		$out = $page->page;
		}
	$db = null;
	return $out;
	}

function get_page_data($id) {
	global $db;
	$query = "SELECT * FROM `content` WHERE `id` = ?;";
	$arg = $db->prepare($query);
	$arg->execute(array($id));
	$data = $arg->fetch(PDO::FETCH_ASSOC);
	return $data;
	}

function inputs_by_type($type) {
	global $html;
	list($extra, $view, $icons) = get_content_types(0, "all");
	$inputs = [
		'title' =>	[
			'type' => 'text',
			'duty' => 1,
			],
		'short' =>	[
			'caption'	=> i18n('short_title'),
			'type' 		=> 'text',
			'size' 		=> 20,
			'max_size' 	=> 20,
			'duty'		=> 1,
			'data_attr' =>	'data-ref="title"',
			'css_class'	=> 'loose'
			],
		'author'		=>	[
			'type'		=> 'text',
			'default'	=> $html['user']['name']
			],
		'lang'	=>	[
			'caption'	=> i18n('language'),
			'abbr'		=> get_icon('languages', i18n('language')),
			'type'		=> 'readonly_lookup',
			'default'	=> $html['con']['ln'],
			"lid"		=> "iso639",
			"lord"		=> "language",
			"lval"		=> "language",
			"lclause"	=> " where `multilingual` = 'on'",
			"ltable"	=> "languages"
			],
		'body' =>	[
			'caption'	=> i18n('text'),
			'type' => 'wysiwyg',
			'duty' => 1,
			],
		'keywords' =>	[
			'type' => 'text',
			],
		'description' =>	[
			'type' => 'bigtext',
			"rows"		=> 3
			],
		'head' =>	[
			'type' => 'bigtext',
			"rows"		=> 3
			],
		"label1"		=> [
			"caption"		=> i18n('publish'),
			"icon"		=> "world",
			"type"		=> "fieldset"
			],
		'published'		=>	[
			'type'		=> 'radio',
			'abbr'		=> get_icon('world', i18n('published')),
			'extra'		=> [i18n('offline'), i18n('published'), i18n('menue')." &amp; ".i18n('published')],
			'fontawesome'		=> ['globe-delete', 'globe', 'globe-add'],
			'default'	=> 1
			],
		'parent' =>	[
			'caption'	=> i18n('folder'),
			'type' => 'lookup',
			"lid"		=> "id",
			"lval"		=> "graduated",
			"lord"		=> "parentsort",
			"ltable"	=> "folder_view",
			"lclause"	=> "`type` IN ('root', 'folder', 'node')",
			'duty' => 1
			],
		'template' =>	[
			'caption'	=> i18n('template'),
			'type'		=> 'lookup',
			'default'	=> 2,
			"lid"		=> "id",
			"lval"		=> "name",
			"lord"		=> "id",
			"ltable"	=> "templates",
			"lclause"	=> " where `id` > 1",
			'duty' => 1
			],
		'sort'			=>	[
			'abbr'		=> substr(i18n('sort'), 0, 4).".",
			'type'		=> 'sort',
			'default'	=> 10
			],
		'show_title' =>	[
			'type' => 'flag',
			'default' => 'on',
			],
		'cron'		=> [
			"icon"		=> "clock",
			"collapsed"	=> 1,
			"type"		=> "fieldset",
			"in_body"	=> "<p>".i18n('menue').", ".i18n('published').":</p>"
			],
		'c_start' =>	[
			'caption'	=> i18n('start'),
			'type' => 'date',
			'duty' => 1,
			'default' => '1970-01-01',
			],
		'c_end' =>	[
			'caption'	=> i18n('end'),
			'type' => 'date',
			'duty' => 1,
			'default' => '2500-12-31',
			],
		"info"		=> [
			"icon"		=> "info",
			"type"		=> "fieldset"
			],
		'type' =>	[
			'type'		=> 'hidden',
			'default'	=> "pages"
			],
		'folder' =>	[
			'type'		=> 'hidden',
			'default'	=> 0
			],
		'written' =>	[
			'type' => 'readonly',
			'default' => date('Y-m-d H:i:s'),
			],
		'update' =>	[
			'caption'	=> i18n('last_update'),
			'abbr'	=> get_icon('clock', i18n('last_update')),
			'type' => 'readonly'
			],
		'last_editor' =>	[
			'caption'	=> i18n('by'),
			'type' => 'readonly_lookup',
			"lid"		=> "id",
			"lval"		=> "name",
			"lord"		=> "name",
			"ltable"	=> "user"
			],
		'generate' =>	['type'		=> 'hidden'],
		'file' =>	[
			'type' => 'readonly'
			],
		'c_filter' =>	[
			'type' => 'free',
			'value' => clean_var(param('c_filter'),'w')
			]
		];
	switch ($type) {
		case "pages": break;
		case "homepage":
			$inputs = [
				'body' 		=> $inputs['body'],
				'lang'		=>	$inputs['lang'],
				'folder' 	=> $inputs['folder'],
				'c_filter' 	=> $inputs['c_filter'],
				'update' =>	[
					'type' => 'readonly',
					'value' => date('Y-m-d H:i:s'),
					],
				'last_editor' 		=> $inputs['last_editor'],
				'title'		=>	[
					'type'		=> 'hidden'
					],
				'sort'		=>	[
					'type'		=> 'hidden'
					],
				'parent'		=>	[
					'type'		=> 'hidden',
					'lclause'	=> '' // just to avoid missing index
					],
				'type' =>	[
					'type' => 'hidden',
					'default' => 'homepage',
					],
				'update'		=> $inputs['update']
				];
			break;
		case "node":
		case "folder":
			$inputs = [
			'title' 		=>	$inputs['title'],
			'short' 		=>	$inputs['short'],
			'folder' 		=> $inputs['folder'],
			'lang'			=>	$inputs['lang'],
			'description' 	=>	[
				'caption'	=> i18n('preface'),
				'type' 		=> 'bigtext',
				"rows"		=> 6
				],
			'type' 			=>	[
				"caption"	=> i18n('view_of_folder'),
				'type'		=> 'radio',
				'extra'		=> ['folder', 'node'],
				'view'		=> [i18n('auto_overview'), i18n('first_page')],
				'icons'		=> ['folder', 'folder_page'],
				'raw'		=> 1,
				'default' 	=> 'folder'
				],
			'generate' =>	['type'		=> 'hidden'],
			"label1"		=> $inputs['label1'],
			'published'		=> $inputs['published'],
			'parent' 		=> $inputs['parent'],
			'template' 		=> $inputs['template'],
			'sort' 			=> $inputs['sort'],
			'folder'		=> [
				'type'		=> 'hidden',
				'default'	=> 1
				],
			'file' =>	[
				'type' => 'readonly',
				],
			'update'		=> $inputs['update'],
			'last_editor' 		=> $inputs['last_editor']
			];
			break;
		case "link":
			$inputs = [
				'title' 		=>	$inputs['title'],
				'short' 		=>	$inputs['short'],
				'lang'			=>	$inputs['lang'],
				'file' =>	[
					'type'	=> 'file',
					'extra'	=> 'browser',
					'dir'	=> 'documents'
					],
				'description' 		=> $inputs['description'],
				'generate' =>	[
					'type'		=> 'hidden',
					'value'		=> 0
					],
				'folder' 		=> $inputs['folder'],
				'parent' 		=> $inputs['parent'],
				'published'		=> $inputs['published'],
				'sort' 			=> $inputs['sort'],
				'type' =>	[
					'type' => 'hidden',
					'default' => 'link',
					],
				'update'		=> $inputs['update'],
				'last_editor' 		=> $inputs['last_editor']
				];
			break;
		case "plugin":
			$inputs = [
				'title' 		=>	$inputs['title'],
				'short' 		=>	$inputs['short'],
				'folder' 		=> $inputs['folder'],
				'lang'			=>	$inputs['lang'],
				"label1"		=> $inputs['label1'],
				'published'		=> $inputs['published'],
				'parent' 		=> $inputs['parent'],
				'template' 		=> $inputs['template'],
				'sort' 			=> $inputs['sort'],
				'c_filter' 	=> $inputs['c_filter'],
				'info'		=> $inputs['info'],
				'file' =>	['type' => 'readonly'],
				'update'		=> $inputs['update'],
				'last_editor' 		=> $inputs['last_editor'],
				'written'		=> $inputs['written'],
				'cron'			=> $inputs['cron'],
				'c_start'		=> $inputs['c_start'],
				'c_end'			=> $inputs['c_end']
				];
			break;
		case "test":
		$inputs = [
				   'type' => ['type' => 'text'],
				   'lang' => ['type' => 'lang']
				   ]; break;
		case "assistant":
		$inputs = [
			'title' 		=>	$inputs['title'],
			'folder' 		=> $inputs['folder'],
			'published'		=> $inputs['published'],
			'parent' 		=> $inputs['parent'],
			'file' =>	[
				'type' => 'readonly'
				],
			"target"		=> [
				"type"		=> "free"
				],
			'type'			=> [
				'type'		=> 'array',
				'raw'		=> 1,
				'extra'		=> $extra,
				'view'		=> $view,
				'fontawesome'		=> $icons
				]
			];
			break;
		default:
		$mud = get_icon('preview', i18n('preview'));
		$inputs['id'] = [
			'caption'	=> i18n('preview'),
			'abbr'	=> $mud.'&nbsp;',
			'type'	=> "custom",
			'view'	=> 'cms_preview'
			];
		$inputs['type'] = [
			'type'		=> 'array',
			'raw'		=> 1,
			'extra'		=> $extra,
			'view'		=> $view,
			'fontawesome'		=> $icons
			];
		$inputs['parent']['lclause'] = '';
		$inputs['picture'] = ['type' => 'image'];
		}
	if ($html['user']['level'] <= 2) {
		if (array_key_exists('head', $inputs)) {unset($inputs['head']);}
		}
	return $inputs;
	}

function pages_tabs($parent) {
	global $html;
	$tabs = array(
		[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id=pages&amp;todo=edit&amp;parent=$parent", "inactive", "add"],
		[i18n('pages'), $html['myurl']."?sid={$html['sid']}&amp;_id=pages", "active", "pages"],
		[i18n('web_settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=web_settings", "inactive", "world-edit"]
		);
	if ($html['action'] == "templates") {
		$tabs[0] = [i18n('add_template'), $html['myurl']."?sid={$html['sid']}&amp;_id=templates&amp;todo=edit", "inactive", "window-maximize-add"];
		}
	if ($html['action'] == "components") {
		$tabs[0] = [i18n('new_entry').' (Code)', $html['myurl']."?sid={$html['sid']}&amp;_id=components&amp;todo=edit&amp;type=1", "inactive", "meta"];
		array_unshift($tabs, [i18n('new_entry').' (WYSIWYG)', $html['myurl']."?sid={$html['sid']}&amp;_id=components&amp;todo=edit&amp;type=2", "inactive", "add"]);
		}
	if ($html['user']['level'] < 2) {
		$tabs = array([i18n('pages'), $html['myurl']."?sid={$html['sid']}&amp;_id=pages", "active", "pages"]);
		}
	return $tabs;
	}

function content_tree($open, $action) {
	global $db, $html, $con;
	$tree = "";
	$c_filter = param('c_filter') ? "&amp;c_filter=".param('c_filter') : '';

	$item = [
		"caption"	=> i18n('all'),
		"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}",
		"state"		=> "all"
		];
	if (!$open) {$item['emph'] = true;}
	$tree .= list_item($item);

	$arg = $db->prepare("SELECT `id`, `lang` FROM `content` WHERE `type` = 'root' and `published` > 1;");
	$arg->execute();
	$home = 'home';
	while ($rootfolder = $arg->fetch(PDO::FETCH_ASSOC)) {
		$roots = [
			"parent"	=> $rootfolder['id'],
			"pfield"	=> "parent",
			"field"		=> "title",
			"table"		=> "folder_view",
			"sort"		=> "parent",
			"index"		=> 0,
			"open"		=> $open,
			"action"	=> "$action&amp;lang=".$rootfolder['lang'].$c_filter
			];
		if (param('c_filter')) {
			$fl = clean_var(param('c_filter'), 'w');
			$fos = ['pages' => 'folder', 'article' => 'rubric', 'products' => 'goodsgroup'];
			$roots['exclusive'] = $fos[$fl];
			}
		$subtree = branch($roots);
		$item = [
			"caption"	=> $con['langs'][$rootfolder['lang']],
			"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}&amp;parent={$rootfolder['id']}&amp;lang=".$rootfolder['lang'],
			"sort"		=> "sort",
			"state"		=> $home,
			"sub"		=> htmltag('ul', '', $subtree)
			];
		if ($open == $rootfolder['id']) {$item['emph'] = true;}
		$tree .= list_item($item);
		$home = "langs";
		}

	if ($html['user']['level'] > 1 && !preg_match('/^assistant/', $action)) {
		$item = [
			"caption"	=> i18n('web_settings'),
			"link"		=> "{$html['myurl']}?_id=web_settings&amp;sid={$html['sid']}",
			"state"		=> "globe-edit"
			];
		$tree .= list_item($item);
		}

	if ( preg_match('/^assistant/', $action)){
		$subtree = next_dir($action, $html['dir']."/documents", '');
		if ($subtree) {$subtree = "<ul>$subtree</ul>";}
		$state = param('_docs') ? 'folder-open' : 'folder';
		$item = [
			"caption"	=> i18n('documents'),
			"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}&amp;_docs=1",
			"state"		=> $state,
			"color"		=> 'green',
			"sub"		=> $subtree
			];
		$tree .= list_item($item);
		$check['action'] = 'basic_crm';
		$check = get_one_register($check);
		if(isset($check['reg'])) {
			$state = param('_forms') ? 'folder-open' : 'folder';
			$item = [
				"caption"	=> i18n('forms'),
				"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}&amp;_forms=1",
				"color"		=> 'blue',
				"state"		=> $state
				];
			$tree .= list_item($item);
			}
		}
	$tree = parse_in('gui_tree', ['treelist' => $tree]);
	return $tree;
	}

function set_first_page($id, $inputs) {
	global $db;
	$arg = $db->prepare("SELECT `file` FROM `content` WHERE `parent` = ? ORDER BY `sort` ASC LIMIT 1;");
	$arg->execute(array($id));
	$data = $arg->fetch(PDO::FETCH_ASSOC);
	$inputs['file']['value'] = $data['file'] ? $data['file'] : $inputs['file']['value'];
	$inputs['type']['value'] = $data['file'] ? 'node' : 'folder';
	return $inputs;
	}

function reset_folder($id) {
	global $db;
	$arg = $db->prepare("SELECT `title` FROM `content` WHERE `id` = ?;");
	$arg->execute(array($id));
	$data = $arg->fetch(PDO::FETCH_ASSOC);
	$filename = preg_replace("/\s/", "-", $data['title']);
	$filename = "/".ansitrans($filename).".html";
	return $filename;
	}

function rebuild_roots() {
	global $db, $con;
	$langs = array_keys($con['langs']);
	$homepages = array();
	$roots = array();
	$arg = $db->prepare("SELECT `id`, `type`, `lang` FROM `content` WHERE `type` IN ('root', 'homepage');");
	$arg->execute();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		if ($data['type'] == 'root'){$roots[$data['lang']] = $data['id'];}
		elseif ($data['type'] == 'homepage'){$homepages[$data['lang']] = $data['id'];}
		if (!in_array($data['lang'], $langs)) {
			$arg2 = $db->prepare("UPDATE `content` SET `published` = 1 WHERE `id` = {$data['id']};");
			$arg2->execute();
			}
		}

	foreach ($langs as $l) {
		if (array_key_exists($l, $roots)) {
			$arg = $db->prepare("UPDATE `content` SET `published` = 2 WHERE `id` = {$roots[$l]};");
			$arg->execute();
			}
		else {
			$arg = $db->prepare("INSERT INTO `content` (`title`, `short`, `lang`, `published`, `parent`,  `file`, `type`, `folder`, `template`, `show_title`)
			VALUES ('Home', 'Home', '$l', 2, 0, '/Sitemap_$l.html', 'root', 1, 2, '');");
			$arg->execute();
			$roots[$l] = $db->lastInsertId('id');
			}
		}
	$home_ids = array();
	foreach ($langs as $l) {
		if (array_key_exists($l, $homepages)) {
			$arg = $db->exec("UPDATE `content` SET `published` = 3 WHERE `id` = '{$homepages[$l]}'");
			array_push($home_ids, $homepages[$l]);
			}
		else {
			$arg = $db->exec("INSERT INTO `content` (`title`, `short`, `body`, `lang`, `published`, `parent`,  `file`, `type`, `folder`, `template`, `show_title`)
			VALUES ('Home', 'Home', '<p>{$con['langs'][$l]}</p>', '$l', 3, {$roots[$l]}, '/index_$l.html', 'homepage', 0, 1, '');");
			array_push($home_ids, $db->lastInsertId('id'));
			}
		}
	write_setting(['table' => 'cms_settings', 'key' => 'homepages', 'group' => 'cms', 'lang' => '*', 'rule' => $con['rule'], 'value' => implode(',', $home_ids)]);
	}

function check_content_types(){
	global $db, $website;
	$arg = $db->prepare("SELECT * FROM `content_types`;");
	$arg->execute();
	$website['content_types'] = array();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		$website['content_types'][$data['type']] = $data;
		}
	}

function check_restricted_access($uid){
	global $db;
	$res = [];
	try {
		$arg = $db->prepare("SELECT * FROM `user_restrictions` WHERE `uid` = ? AND `group` = 'content';");
		$arg->execute([$uid]);
			if ($arg->rowCount()) {
			$data = $arg->fetch(PDO::FETCH_ASSOC);
			$res = explode(',', $data['allowed']);
			}
		}
	catch (PDOException $e) {$res = [];}
	return $res;
	}

function get_content_types($type, $which) {
	global $db, $website;
	// the usual suspects
	$extra = ['homepage', 'pages', 'folder', 'node', 'link'];
	$view = [i18n('homepage'), i18n('page'), i18n('auto_overview'), i18n('first_page'), i18n('link')];
	$icons = ['homepage','page', 'folder', 'folder_page', 'link'];
	if ($which == "new") {
		$allow = ['root', 'folder', 'node'];
		if (in_array($type, $allow)) {
			$extra = ['pages', 'folder', 'link'];
			$view = [i18n('page'), i18n('folder'), i18n('link')];
			$icons = ['file-alt-add', 'folder_add', 'link_add'];
			}
		else {$extra = [];	$view = [];	$icons = [];}
		}
	// are there any registered page plugins?
	foreach ($website['content_types'] as $data) {
		if ($which == "new") {
			$allow = explode(',', $data['new_in_type']);
			if (in_array($type, $allow)) {
				if (!$data['icon_add']) {$data['icon_add'] = $data['icon'];}
				array_push($extra, $data['type']);
				array_push($view, i18n($data['name']));
				array_push($icons, $data['icon_add']);
				}
			}
		else {
			if (!$data['name']) {$data['name'] = $data['type'];}
			array_push($extra, $data['type']);
			array_push($view, i18n($data['name']));
			array_push($icons, $data['icon']);
			}
		}
	return array($extra, $view, $icons);
	}

/*
 * raise sort order in content table for a new 10
 * @param1 string parent id
 * @param2 string content_type
 */
function raise_order($parent, $type) {
	global $db;
	$arg = $db->prepare("UPDATE `content` SET `sort` = `sort`+10 WHERE `parent` = ? AND `type` = ?;");
	$arg->execute(array($parent, $type));
	}

/**
 * preview icon and action
 * custom field
 */
function cms_preview($val, $field, $rec) {
	$mud = get_icon('preview', i18n('preview'));
	$input;
	if (in_array($rec['type'], ['link', 'node'])) {$input = '&nbsp;';}
	else {$input = "&nbsp;<a href=\"/content/?_id=$val\" data-app=\"preview\">$mud</a>";}
	return $input;
	}

/**
 * edit icon and action takes care of content type
 */
function cms_edit_by_type ($url, $rec) {
	$pages = ['homepage', 'pages', 'folder', 'node', 'link'];
	$single = ['gastro']; // just edit one content page
	if (!in_array($rec['type'], $pages)) {
		$url = str_replace('_id=pages', "_id={$rec['type']}", $url);
		}
	if (in_array($rec['type'], $single)) {
		$url = preg_replace("/\&amp\;todo=edit\&amp\;rid=\d+/", '', $url);
		}
	return $url;
	}

/**
 * generate searchbox an language selection
 */
function gen_components() {
	global $con;
	$switch = array();
	foreach ($con['langs'] as $sl=>$sll) {
		$l =  $con['ln'] == $sl ? "/index.html" : "/index_$sl.html";
		$switch[$sl] = "<a href=\"$l\">".strtoupper($sl)."</a>";
		}
	foreach ($con['langs'] as $l=>$ll) {
		// searchbox
		$data['label'] = $con['ln'] == $l ? i18n('search') : sys_trans('search', $l);
		$data['lang'] = $l;
		$Cdata = ['component' => 'SEARCHBOX', 'html' => parse_in('cms_pages_searchbox', $data), 'lang' => $l, 'active' => 'on'];
		write_component($Cdata);
		$data['content'] = '';
		if (sizeof($switch) > 1) {
			foreach ($switch as $sk=>$sv) {
				$usk = strtoupper($sk);
				$data['content'] .= $sk == $l ? " | $usk" : " | $sv";
				}
			$data['content'] .= ' |';
			}
		$Cdata = ['component' => 'LANG_SWITCH', 'html' => parse_in('cms_pages_lang_sel', $data), 'lang' => $l, 'active' => 'on'];
		write_component($Cdata);
		}
	}

function public_search ($html) {

	$check = get_one_register(['action' => 'article']);
	$sel_order = isset($check['reg']) ? ['score', 'update'] : '';

	$form = [
		"html"			=> $html,
		"title"			=> i18n('search'),
		"table"			=> "content",
		"myconf"		=> "search",
		"maxsize"		=> 300,
		"no_logical"	=> 1,
		"orderby"		=> 'score',
		"defsort"		=> "DESC",
		"human"			=> "title",
		"search"		=> ["fulltext"],
		"filters"		=> ["lang"],
		"table_fields"	=> ["id", "lang", "short", "title", "body", "type", "file", "update"],
		"clause"		=> " `folder` <> 1 AND `published` > 1 AND `type` != 'homepage'",
		"sort_select"	=> $sel_order,
		"sort_select_view"	=> ['most_relevant', 'recent']
		];
	$inputs = [
		'id' =>	['type' => 'text'],
		'lang' =>	['type' => 'hidden'],
		'title' =>	['type' => 'text'],
		'type' =>	['type' => 'text'],
		'short' =>	['type' => 'text'],
		'body' =>	['type' => 'wysiwyg'],
		'type' =>	['type'	=> 'text'],
		'update' =>	['type' => 'text'],
		'file' =>	['type' => 'text']
		];
	$obj = new access($form);
	$table = $obj->table($inputs);
	$table['content'] = $obj->searchform;
	$ob = param('_ob') ? param('_ob') : 'score';
	if (param('_w')) {
		$table['content'] .= $obj->offsetText;
		$css = "second";
		$max = 0;
		foreach ($obj->table_rows as $row) {
			if ($ob == 'score') {
				$max = $max ? $max : $row['score'];
				$score = $max ? intval(($row['score'] / $max)*10)/2 : 0.5;
				$row['score'] = stars($score);
				}
			else {$row['score'] = '';}
			$css = $css == "second" ? "prime" : "second";
			$row['class'] = $css;
			$words = urlencode($obj->words);
			$row['link'] = "?_id={$row['id']}&amp;_w=$words";
			if ($row['type'] == 'link') {$row['link'] = "/".$row['file'];}
			if ($row['type'] == 'products') {$row['link'] = "{$row['file']}?_w=$words";}
			$row['icon'] = "";
			$table['content'] .= parse_in('cms_search_item', $row);
			}
		if ($obj->rows > 50) {$table['content'] .= $obj->offsetText;}
		elseif ($obj->rows == 0) {$table['content'] .= htmltag('p', 'class="center"', '0 '.i18n('hits'));}
		//$table['content'] .= $obj->query;
		}
	$table['template'] = 2;
	return form2page($table);
	}

function content_of_plugin($html) {
	$html = frontend_register($html);
	if ($html['plugin']) {
		include_once ("../{$html['con']['coco']}/plugins/{$html['plugin']}.php");
		// as class
		if (class_exists($html['plugin'])) {
			$myclass = new $html['plugin']();
			$html = $myclass->plugin($html);
			}
		// procedural
		else {$html = plugin($html);}
		$html['template'] = isset($html['template']) ? $html['template'] : 2;
		$data = form2page($html);
		}
	else {$data = get_page_data(2);}
	return $data;
	}

function frontend_register($html) {
	global $db;
	$arg = $db->prepare("SELECT `plugin`, `tab`, `gui` FROM `register` WHERE `call` = ? and `frontend` = ?;");
	$arg->execute(array($html['action'], 'on'));
	$data = $arg->fetch(PDO::FETCH_ASSOC);
	// a frontend plugin has to be registered correctly, there is no default pass-through
	$html['plugin'] = $data['plugin'];
	$html['tab'] = $data['tab'];
	return $html;
	}

/**
 * some data of parent folder
 * @param string id of parent
 * @return array the language code, the name and the type of the parent folder
 */
function parents_def($parent) {
	global $db, $con;
	$arg = $db->prepare("SELECT `short`, `lang`, `type` FROM `content` WHERE `id` = ?;");
	$arg->execute(array($parent));
	if ($arg->RowCount()) {
		$d = $arg->fetch(PDO::FETCH_ASSOC);
		$l = $d['lang'];
		$n = $d['short'];
		$t = $d['type'];
		}
	else {
		$l = $con['ln'];
		$n = 'Home';
		$t = 'root';
		}
	return array($l, $n, $t);
	}

/**
 * select entries that are supposed for each language
 * @param array data with keys like LOGO, LOGO_en, LOGO_fr...
 * @param string iso code language
 * @return array with LOGO_en as LOGO if 'en' is the required language
 */
function my_language($data, $l) {
	foreach ($data as $k=>$a) {
		$tr = $k."_".$l;
		$data[$k] = isset($data[$tr]) ? $data[$tr] : $data[$k];
		}
	return $data;
	}

function stars($s) {
	$stars = '';
	$a = floor($s);
	for ($i=0; $i < $a; $i++) {$fas = ['icon' => 'star', 'size' => 'xs', 'alt' => ''];	$stars .= get_awesome($fas);}
	if ($s > $a) {$fas = ['icon' => 'star-half', 'size' => 'xs', 'alt' => '']; $stars .= get_awesome($fas);}
	if ($stars) {$stars = htmltag('span', 'class="grey"', $stars);}
	return $stars;
	}

function form2page($form) {
	$co = array_key_exists('components', $form) ?  $form['components'] : array();
	$parent = array_key_exists('parent', $form) ?  $form['parent'] : 1;
	$show_title = array_key_exists('show_title', $form) ?  $form['show_title'] : 'on';
	$formtitle = array_key_exists('formtitle', $form) ?  $form['formtitle'] : '';
	$data = [
		'id'			=> '',
		'parent'		=> $parent,
		'root'			=> 1,
		'short'			=> $formtitle,
		'title'			=> $formtitle,
		'body'			=> $form['content'],
		'components'	=> $co,
		'lang'			=> $form['user']['language'],
		'type'			=> 'page',
		'show_title'	=> $show_title,
		'template'		=> $form['template'],
		'file'			=> '',
		'description'	=> '',
		'picture'	=> '',
		'keywords'		=> '',
		'scripts'		=> $form['scripts']
		];
	return $data;
	}
?>
