CREATE TABLE `clients` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `salutation` tinyint(4) NOT NULL DEFAULT '1',
  `title` varchar(12) DEFAULT NULL,
  `name` varchar(128) NOT NULL DEFAULT '',
  `prename` varchar(128) NOT NULL DEFAULT '',
  `company` varchar(255) DEFAULT NULL,
  `company_line2` varchar(126) DEFAULT NULL,
  `username` varchar(64) DEFAULT NULL,
  `street` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `province` varchar(128) DEFAULT NULL,
  `postal_code` varchar(28) DEFAULT NULL,
  `country` varchar(128) DEFAULT NULL,
  `salutation2` tinyint(4) NOT NULL DEFAULT '1',
  `title2` varchar(12) DEFAULT NULL,
  `name2` varchar(128) DEFAULT NULL,
  `prename2` varchar(128) DEFAULT NULL,
  `company2` varchar(255) DEFAULT NULL,
  `company2_line2` varchar(126) DEFAULT NULL,
  `street2` varchar(255) DEFAULT NULL,
  `city2` varchar(255) DEFAULT NULL,
  `province2` varchar(128) DEFAULT NULL,
  `postal_code2` varchar(28) DEFAULT NULL,
  `country2` varchar(128) DEFAULT NULL,
  `use_del` varchar(2) DEFAULT NULL,
  `phone` varchar(128) DEFAULT NULL,
  `fax` varchar(128) DEFAULT NULL,
  `mobile` varchar(128) DEFAULT NULL,
  `email` varchar(128) DEFAULT NULL,
  `level` tinyint(4) NOT NULL DEFAULT '1',
  `pwd` varchar(100) DEFAULT NULL,
  `currentsid` varchar(20) DEFAULT NULL,
  `tan` varchar(12) DEFAULT NULL,
  `promo` char(3) DEFAULT NULL,
  `discount` tinyint(4) DEFAULT NULL,
  `UID` varchar(16) DEFAULT NULL,
  `notes` text,
  `mailformat` varchar(6) NOT NULL DEFAULT 'html',
  `registered` TIMESTAMP NULL,
  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `editor` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `name` (`name`,`prename`,`company`,`company_line2`,`street`,`email`,`notes`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `clients_groups` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `clients_groups` ( `id`, `name`, `description`)
VALUES ( '1', 'User', 'einfacher Benutzer, default user');

CREATE TABLE `get_before_post` (
  `tan` varchar(12) NOT NULL DEFAULT '',
  `ip` varchar(28) DEFAULT NULL,
  `get_stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `post_stamp` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`tan`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `crm_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `active` varchar(2) NOT NULL,
  `settings` text NOT NULL,
  `header` varchar(64) NOT NULL,
  `footer` varchar(64) NOT NULL,
  `confirmation` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `crm_forms` ( `id`, `name`, `active`, `settings`, `header`, `footer`, `confirmation`)
VALUES ( '1', 'inquiry', 'on', '{\r\n    "salutation": {\r\n        "type": "array",\r\n        "default": 1,\r\n        "duty": 1\r\n    },\r\n    "title": {\r\n        "type": "text"\r\n    },\r\n    "prename": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "name": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "company": {\r\n        "type": "text"\r\n    },\r\n    "company_line2": {\r\n        "type": "text"\r\n    },\r\n    "email": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "street": {\r\n        "type": "text"\r\n    },\r\n    "city": {\r\n        "type": "text"\r\n    },\r\n    "postal_code": {\r\n        "type": "text"\r\n    },\r\n    "country": {\r\n        "type": "country",\r\n        "default": "at"\r\n    },\r\n    "phone": {\r\n        "type": "text"\r\n    },\r\n    "fax": {\r\n        "type": "text"\r\n    },\r\n    "mobile": {\r\n        "type": "text"\r\n    },\r\n    "level": {\r\n        "type": "hidden",\r\n        "default": 1\r\n    },\r\n    "promo": {\r\n        "type": "flag"\r\n    },\r\n    "notes": {\r\n        "type": "bigtext",\r\n        "cols": 50,\r\n        "rows": 10\r\n    }\r\n}', 'inquiry_header', 'inquiry_privacy', 'inquiry_confirmation'),
( '3', 'registration', 'on', '{\r\n    "salutation": {\r\n        "type": "array",\r\n        "default": 1,\r\n        "duty": 1\r\n    },\r\n    "title": {\r\n        "type": "text"\r\n    },\r\n    "prename": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "name": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "company": {\r\n        "type": "text"\r\n    },\r\n    "company_line2": {\r\n        "type": "text"\r\n    },\r\n    "UID": {\r\n        "type": "text"\r\n    },\r\n    "email": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "street": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "city": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "postal_code": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "country": {\r\n        "type": "country",\r\n        "default": "at",\r\n        "duty": 1\r\n    },\r\n    "phone": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "fax": {\r\n        "type": "text"\r\n    },\r\n    "mobile": {\r\n        "type": "text"\r\n    },\r\n    "level": {\r\n        "type": "hidden",\r\n        "default": 1\r\n    },\r\n    "promo": {\r\n        "type": "flag"\r\n    },\r\n    "notes": {\r\n        "type": "bigtext",\r\n        "cols": 45,\r\n        "rows": 10\r\n    }\r\n}', 'registry_header', 'inquiry_privacy', 'registry_confirmation'),
( '2', 'newsletter', 'on', '{\r\n    "salutation": {\r\n        "type": "array",\r\n        "default": 1,\r\n        "duty": 1\r\n    },\r\n    "title": {\r\n        "type": "text"\r\n    },\r\n    "prename": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "name": {\r\n        "type": "text",\r\n        "duty": 1\r\n    },\r\n    "company": {\r\n        "type": "text"\r\n    },\r\n    "company_line2": {\r\n        "type": "text"\r\n    },\r\n    "email": {\r\n        "type": "email",\r\n        "duty": 1\r\n    },\r\n    "promo": {\r\n        "type": "hidden",\r\n        "default": "on"\r\n    }\r\n}', 'newsletter_header', 'inquiry_privacy', 'newsletter_confirmation');

CREATE TABLE `crm_messages` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `key` varchar(64) NOT NULL,
  `value` text NOT NULL,
  `group` varchar(32) NOT NULL,
  `lang` varchar(2) NOT NULL DEFAULT '*',
  `rule` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `crm_messages` ( `id`, `key`, `value`, `group`, `lang`, `rule`)
VALUES ( '1', 'inquiry_privacy', '*) Die mit Stern markierten Felder bitte unbedingt ausfüllen.\r\n\r\nDie von Ihnen zur Verfügung gestellten personenbezogenen Daten verwenden wir im Allgemeinen, um Ihre Anfragen zu beantworten, Ihre Aufträge zu bearbeiten oder Ihnen Zugang zu bestimmten Informationen oder Angeboten zu verschaffen. Die Daten werden von uns weder an Dritte weitergegeben, noch von uns selbst zur Unterstützung unserer Kundenbeziehung verwendet, so letzterem nicht explizit zugestimmt wird.', 'forms', 'de', '1'),
( '2', 'inquiry_header', 'Wir beantworten Ihnen gerne alle Fragen bezüglich unserer Produkte und Dienstleistungen.', 'forms', 'de', '1'),
( '3', 'inquiry_confirmation', 'Vielen Dank für Ihr Interesse. Sie erhalten in Kürze eine Antwort auf Ihre Anfrage.', 'forms', 'de', '1'),
( '4', 'newsletter_header', 'Unser Newsletter informiert Sie über alle wichtigen Dinge.', 'forms', 'de', '1'),
( '5', 'newsletter_confirmation', 'Vielen Dank, dass Sie sich für unseren Newsletter interessieren.', 'forms', 'de', '1'),
( '6', 'registry_header', 'Bitte geben Sie hier Ihre Kundendaten an.', 'forms', 'de', '1'),
( '7', 'registry_confirmation', 'Viele Dank, dass Sie sich für unsere Angebote interessieren.', 'forms', 'de', '1'),
( '8', 'inquiry_header', 'We like to answer any question you want to know about our products and services.', 'forms', 'en', '1');

CREATE TABLE IF NOT EXISTS `newsletter_templates` (
  `id` bigint(20)  NOT NULL auto_increment,
  `subject` varchar(126) NOT NULL DEFAULT '',
  `body` text NULL,
  `date` date  NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM;

CREATE TABLE `newsletter_mailings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `subject` varchar(256) DEFAULT NULL,
  `body` longtext,
  `count` bigint unsigned NOT NULL DEFAULT '0',
  `closed` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM;

CREATE TABLE `mailing_list` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(128) NOT NULL DEFAULT '',
  `mailing` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mailing` (`mailing`)
) ENGINE=MyISAM;

INSERT INTO `i18n` SET `index` = 'sending_newsletter', `group` = 'common', `de` = 'Mails werden gesendet in', `en` = 'Mails will be send in';

INSERT INTO `register_groups` (`name`, `sort`) VALUES ('clients', '50');

INSERT INTO `register` ( `name`, `call`, `plugin`, `tab`, `params`, `gui`, `top`, `start`, `group`, `icon`, `image`, `level`, `sort`, `frontend`)
VALUES ('clients', 'basic_crm', 'basic_crm', '9999999', '', '1', 'on', 'on', 'on', 'address-card-o', '0', '2', '260', ''),
('clients_groups', 'clients_groups', 'basic_crm', '9999999', '', '1', '', 'on', 'on', 'users', '0', '2', '270', ''),
('inquiry', 'inquiry', 'inquiry', '', '', '1', '', '', '', 'default', '0', '1', '10', 'on'),
('SMTP', 'crm_settings', 'basic_crm', '9999999', '', '1', '', '', 'on', 'envelope', '0', '2', '280', ''),
('forms', 'crm_forms', 'basic_crm', '9999999', '', '1', '', '', 'on', 'clipboard', '0', '3', '300', ''),
('messages', 'crm_messages', 'basic_crm', '9999999', '', '1', '', '', 'on', 'comments', '0', '2', '290', ''),
('newsletter', 'newsletter', '', '9999999', '', '1', '', 'on', 'on', 'far-envelope', '0', '1', '295', ''),
('templates', 'newsletter_templates', 'newsletter', '9999999', '', '1', '', '', '', 'hand-o-up', '0', '1', '296', '');

UPDATE `register` SET `tab` = (SELECT `id` FROM `register_groups` WHERE `name` = 'clients') WHERE `tab` = '9999999';

INSERT INTO `i18n` (`index`, `group`, `en`, `de`)
VALUES ('confirmation', 'common', 'Text of Confirmation', 'Bestätigungstext'),
('messages', 'common', 'Descriptions and Declarations', 'Texte und Erläuterungen'),
('forms', 'common', 'Forms', 'Formulare'),
('clients_groups', 'common', 'Groups of Clients', 'Kundengruppen'),
('UID', 'common', 'VAT', 'UID'),
('nd_line', 'common', 'Second line', 'zweite Zeile'),
('phone', 'common', 'Telephone', 'Telefon'),
('company', 'common', 'Company', 'Firma'),
('fax', 'common', 'Fax', 'Fax'),
('mobile', 'common', 'Mobile', 'Mobiltelefon'),
('province', 'common', 'Province', 'Land'),
('postal_code', 'common', 'Postal Code', 'PLZ'),
('street', 'common', 'Street', 'Straße'),
('city', 'common', 'City', 'Stadt'),
('salutation', 'common', 'Salutation', 'Anrede'),
('mr', 'common', 'Mr.', 'Herr'),
('ms', 'common', 'Ms.', 'Frau'),
('clients', 'common', 'Clients', 'Kunden'),
('prename', 'common', 'Prename', 'Vorname'),
('level', 'common', 'Level', 'Status'),
('username', 'common', 'Username', 'Benutzername'),
('notes', 'common', 'Notes', 'Anmerkungen'),
('promo', 'common', 'Sign up for Newsletter', 'Newsletter abonnieren'),
('inquiry', 'common', 'Inquiry', 'Anfrage'),
('newsletter', 'common', 'Newsletter', 'Newsletter'),
('registration', 'common', 'Registration', 'Registrierung'),
('submit', 'common', 'Submit', 'Senden'),
('client', 'common', 'Client', 'Kunde'),
('SMTP', 'common', 'SMTP-Settings', 'SMTP-Einstellungen'),
('reply', 'common', 'Address of Sender', 'Adresse des Senders'),
('admin_mail', 'common', 'Address of Administrator', 'Adresse des Administrators'),
('sender_name', 'common', 'Name of Sender', 'Name des Senders'),
('subject', 'common', 'Subject', 'Betreff'),
('send_to', 'common', 'Send To', 'Senden an'),
('send_as_test', 'common', 'Send a test email to', 'Testweise senden an'),
('send', 'common', 'Send', 'Senden'),
('send_newsletter', 'common', 'Newsletter was sent to', 'Der Newsletter wurde gesendet an'),
('vcard', 'common', 'Visit Card (vcard)', 'Visitenkarte (vcard)');

INSERT INTO `html_snippets` SET `key` = 'cms_newsletter', `description` = 'complete html frame for newsletter including a small css', `code` = '<!DOCTYPE html>\n<html>\n<head>\n<title>&&&&Subject&&&&</title>\n<style type="text/css">\n\nbody {\n  font-family: Tahoma, Verdana, Arial, sans-serif;\n  font-size: 100%;\n  color: #666666;\n  background-color: #FEFEFE;\n }\n\ndiv#site {\n  max-width: 55em;\n }\n\n#site p.lead {\n  font-weight: bold;\n  text-indent: 0px;\n }\n\n#site p.picturetext, p.copyright {\n font-size: 0.8em;\n }\n\n#site h1 {\n  font-size: 1.2em;\n  font-weight: bold;\n  color: #4AAF4A;\n  padding: 3px;\n }\n\n#site h2 {\n  color: #444444;\n  font-size: 1.1em;\n  font-weight: bold;\n }\n\n#site h3 {\n  color: #444444;\n  font-size: 1.1em;\n  font-weight: normal;\n }\n\n#site a {\n  font-weight: bold;\n  color: #4AAF4A;\n }\n\n#site .right {\n  float: right;\n  margin: 0px 0px 0px 12px;\n }\n\n#site .left {\n  float: left;\n  margin: 0px 12px 0px 0px;\n  }\n  \n.clrfx:before, .clrfx:after {\n  content: "\0020";\n  clear: both;\n  display: table;\n }\n\n.clrfx:after {\n  clear: both;\n }\n\n</style>\n</head>\n<body>\n<div id="site">\n&&&&html&&&&\n</div>\n</body>\n</html>', `group` = '4';
