CREATE TABLE `announces` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `link` varchar(100) DEFAULT NULL,
  `text` text NOT NULL,
  `active` char(2) DEFAULT NULL,
  `start` date NOT NULL DEFAULT '1970-01-01',
  `end` date NOT NULL DEFAULT '2500-12-31',
  `box` smallint(6) NOT NULL,
  `sort` smallint(2) NOT NULL DEFAULT '0',
  `picture` varchar(64) DEFAULT NULL,
  `alternative` varchar(128) DEFAULT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '1',
  `lang` varchar(2) NOT NULL DEFAULT 'en',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `announces` (`id`, `title`, `link`, `text`, `active`, `start`, `end`, `box`, `sort`, `picture`, `alternative`, `type`, `lang`) VALUES
(9, 'Consentio CMS', '', '', '2', '1970-01-01', '2500-12-31', 1, 0, '', '', 2, 'de'),
(6, 'McCurdy', '', 'Consentio 3 (McCurdy) ist die vollständige Neuprogrammierung von Consentio 2 vormals Webfruits.', '3', '1970-01-01', '2500-12-31', 1, 10, 'mccurdy.png', 'McCurdy', 1, 'de');

CREATE TABLE `boxes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `index` varchar(32) NOT NULL,
  `box` varchar(64) NOT NULL,
  `title` varchar(64) NOT NULL,
  `image` varchar(64) NOT NULL,
  `imagedir` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `boxes` (`id`, `name`, `index`, `box`, `title`, `image`, `imagedir`) VALUES
(1, 'Inhaltseite links', 'ANNOUNCE_BOX', 'cms_announces_box1', 'cms_announces_title1', 'cms_announces_img1', 'cinemascope'),
(2, 'Startseite', 'ALT_ANNOUNCE_BOX', 'cms_announces_box1', 'cms_announces_title1', 'cms_announces_img1', 'small');

CREATE TABLE `cms_settings` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `key` varchar(64) NOT NULL,
  `value` varchar(255) NOT NULL,
  `group` varchar(32) NOT NULL,
  `lang` varchar(2) NOT NULL DEFAULT '*',
  `rule` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `cms_settings` (`key`, `value`, `group`, `lang`, `rule`) VALUES
('website_title', 'Meine Website', 'cms', '*', 1),
('website_keywords', 'meine, Schlüssel, Wörter', 'cms', '*', 1),
('website_author', 'Mein Name', 'cms', '*', 1),
('website_description', 'Ein, zwei Sätze', 'cms', '*', 1),
('country', 'at', 'cms', '*', 1),
('def_css', 'yo-greyhound.css', 'cms', '*', 1),
('skip_home', '', 'cms', '*', 1),
('breadcrumb', 'on', 'cms', '*', 1),
('sub_nav', 'on', 'cms', '*', 1),
('website_url', '/', 'cms', '*', 1),
('website_logo', 'mccurdy.png', 'cms', '*', 1),
('website_lead_img', 'IMG_2780.JPG', 'cms', '*', 1),
('last_update', '1970-01-01 12:00:00', 'cms', '*', 1),
('homepages', '2', 'cms', '*', 1),
('act_layout', '1', 'cms', '*', 1),
('css_generation', '2', 'cms', '*', '1'),
('header_layout', 'stack', 'cms', '*', '1'),
('footer_layout', 'big', 'cms', '*', '1');

CREATE TABLE `components` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `title` varchar(64) NOT NULL DEFAULT '',
  `description` text DEFAULT NULL,
  `content` text  NULL,
  `custom` char(2)  DEFAULT NULL,
  `active` char(2) DEFAULT NULL,
  `lang` varchar(2) NOT NULL DEFAULT 'de',
  `type` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `components` (`name`, `title`, `description`, `content`, `custom`, `active`, `lang`, `type`) VALUES
('SEARCHBOX', 'Suche', '', '<div id="searcharea" class="hide-mobile">\r\n<form action="/content/" method="get" enctype="application/x-www-form-urlencoded">\r\n\t<input type="hidden" name="lang" value="de" />\r\n\t<input type="hidden" name="_id" value="search" />\r\n\t<input type="hidden" name="_s" value="fulltext" />\t\r\n\t<label for="sf" class="hidden">Suche</label>\r\n\t<input id="sf" type="text" name="_w" size="17" maxlength="25" value="" class="search" placeholder="Suche" /><i class="fas fa-search fa-lg" data-app="yo-submit"></i>\r\n</form>\r\n</div>\r\n<span id="msearch" class="show-mobile-in"><a href="/content/?_id=search"><i class="fas fa-search fa-2x"></i></a></span>\t\t\r\n\t\t', '', 'on', 'de', '1'),
('FOOTER_NAV', 'Fußzeilen Navigation', NULL, '<div class="row clrfx">\r\n\t<h2><i class="fas fa-lightbulb"></i> Über uns<br></h2>\r\n\r\n\t<ul>\r\n\t\t<li><a href="/Impressum.html">Impressum</a></li>\r\n\t\t<li><a href="/Allgemeine-Geschaeftsbedingungen.html">Allgemeine Geschäftsbedingungen</a><br></li>\r\n\t\t<li><a href="/Datenschutzerklaerung.html">Datenschutzerklärung</a></li>\r\n\t</ul>\r\n</div>\r\n', 'on', 'on', 'de', '2'),
('GENERATOR', 'Consentio CMS', NULL, '<div class="innerbox">\r\n\t<p class="center">\r\n \t\t<a href="https://www.consentio.at" target="_blank"><img title="Consentio CMS" alt="Consentio CMS" src="/graphics/Consentio-w.svg"  width="120"></a>\r\n\t</p>\r\n</div>', 'on', 'on', 'de', '1'),
('FOOTER_INFO', 'Fußzeilen Information', NULL, '<div class="row clrfx">\r\n\t<h2><i class="fas fa-globe"></i> Kontakt</h2>\r\n\r\n\t<p>ACME GesmbH &amp;Co KG</p><p>Am Erfolgsweg 1<br></p>\r\n</div>\r\n', 'on', 'on', 'de', '2'),
('SMALL_GENERATOR', 'Consentio CMS small', NULL, '<p class="alright"><a href="https://www.consentio.at"target="_blank"><img title="Consentio CMS" alt="Consentio CMS" src="/graphics/consentioHoch.svg" height="12" width="22"></a></p>', 'on', 'on', 'de', '1');

CREATE TABLE `container` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` varchar(64) NOT NULL DEFAULT '',
  `link` varchar(128) NOT NULL DEFAULT '',
  `sort` int(11) NOT NULL DEFAULT '10',
  `box` bigint(20) NOT NULL DEFAULT '0',
  `start` date NOT NULL DEFAULT '1970-01-01',
  `end` date NOT NULL DEFAULT '2500-12-31',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `container` (`id`, `text`, `link`, `sort`, `box`, `start`, `end`) VALUES
(1, 'Consentio-Website', 'http://consentio.at', 10, 9, '1970-01-01', '2500-12-31'),
(2, 'Dokumentation', 'http://consentio.at/Dokumentation.html', 20, 9, '1970-01-01', '2500-12-31');

CREATE TABLE `content` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `short` varchar(20) NOT NULL DEFAULT '',
  `body` text,
  `lang` varchar(2) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `c_start` date NOT NULL DEFAULT '1970-01-01',
  `c_end` date NOT NULL DEFAULT '2500-12-31',
  `show_title` varchar(2) DEFAULT NULL,
  `author` varchar(64) NOT NULL DEFAULT '',
  `parent` bigint(20) NOT NULL DEFAULT '1',
  `sort` bigint(20) NOT NULL DEFAULT '0',
  `parentsort` bigint(20) DEFAULT NULL,
  `graduated` varchar(255) DEFAULT NULL,
  `file` varchar(128) DEFAULT NULL,
  `written` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update` timestamp NULL DEFAULT NULL,
  `last_editor` BIGINT(20) NOT NULL DEFAULT 0,
  `type` varchar(32) NOT NULL DEFAULT 'pages',
  `folder` tinyint(4) NOT NULL DEFAULT '0',
  `generate` tinyint(4) NOT NULL DEFAULT '1',
  `foreign` bigint(20) DEFAULT NULL,
  `template` varchar(16) NOT NULL DEFAULT '2',
  `head` text,
  `description` text,
  `keywords` text,
  `picture` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `title` (`title`,`body`,`description`,`keywords`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `content` (`title`, `short`, `body`, `lang`, `published`, `c_start`, `c_end`, `show_title`, `author`, `parent`, `sort`, `parentsort`, `graduated`, `file`, `written`, `update`, `last_editor`, `type`, `folder`, `generate`, `foreign`, `template`, `head`, `description`, `keywords`, `picture`) VALUES
('Home', 'Home', '', 'de', '2', '1970-01-01', '2500-12-31', '', '', '0', '0', '1', ' Home', '/Sitemap.html', '2015-09-30 18:33:46', NULL, '0', 'root', '1', '1', NULL, '2', NULL, NULL, NULL, NULL),
('Home', 'Home', '<div class="row clrfx yo-outset"><div class="col w33p"><h2>1. Lorem ipsum<br></h2><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div><div class="col w33p"><h2>2. Dolor<br></h2><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div><div class="col w33p"><h2>3. Sit amet<br></h2><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div></div><p><br></p>', 'de', '3', '1970-01-01', '2500-12-31', '', '', '1', '10', '2', '— Home', '/index.html', '2015-09-30 18:33:46', '2019-04-11 16:00:08', '1', 'homepage', '0', '1', NULL, '1', '', '', '', NULL),
('Stile der Formatvorlagen', 'Stile', '<h1>Überschrift 1</h1>\r\n<h2>Überschrift 2<br></h2>\r\n<h3>Überschrift 3<br></h3>\r\n<h4>Überschrift 4</h4>\r\n\r\n<p class="clrfx"><strong>Absatz</strong> Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>\r\n\r\n<p class="lead"><u>Vorspann</u> Lorem ipsum dolor sit amet, consetetur sadipscing<a href="#ftn0" id="aftn0" class="aftn"><sup>1)</sup></a> elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>\r\n<hr>\r\n\r\n<p class="capital"><strong>Absatz mit Initialie</strong> Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>\r\n\r\n<div class="box">\r\n\t<h2><strong>Box</strong></h2>\r\n\r\n\t<p>Lorem ipsum dolor sit amet... Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n</div>\r\n\r\n<ul>\r\n\t<li>liste</li>\r\n\r\n\t<ul>\r\n\t\t<li>einschub liste</li>\r\n\t\t<li>einschub liste<br></li>\r\n\t</ul>\r\n\t<li>liste</li>\r\n\t<li>liste</li>\r\n</ul>\r\n\r\n<div class="leftfloat" style="width:250px">\r\n\t<a href="/pictures/normal/IMG_2780.JPG" data-app="lightbox" title="Kathedrale Santa Maria del Fiore"><img alt="Kathedrale Santa Maria del Fiore" src="/pictures/small/IMG_2780.JPG" width="250" height="187"></a>\r\n\t<p class="picturetext">Bildunterschrift</p>\r\n\r\n\t<p class="copyright">© Copyright</p>\r\n</div>\r\n\r\n<p><strong>Absatz mit Bildobjekt links (mit Bildunterschrift)</strong> Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p><div class="row clrfx yo-outset"><div class="col w33p"><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div><div class="col w33p"><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div><div class="col w33p"><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div></div><ul class="row yo-tiles"><li class="t3 box"><h2>Lorem ipsum</h2><p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est.</p><p class="flex-bottom">Semper ad finem</p></li><li class="t3 box"><h2>Lorem ipsum</h2><p>At vero eos et accusam et justo duo dolores et ea rebum. </p><p class="flex-bottom">Semper ad finem</p></li><li class="t3 box"><h2>Lorem ipsum</h2><p>At vero eos et accusam et justo duo dolores et ea rebum. </p><p class="flex-bottom">Semper ad finem</p></li></ul><div class="row clrfx yo-outset"><div class="col w50p"><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div><div class="col w50p"><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div></div><ul class="row yo-tiles"><li class="t2 box"><h2>Lorem ipsum</h2><p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est.</p><p class="flex-bottom">Semper ad finem</p></li><li class="t2 box"><h2>Lorem ipsum</h2><p>At vero eos et accusam et justo duo dolores et ea rebum. </p><p class="flex-bottom">Semper ad finem</p></li></ul><div class="row clrfx yo-outset"><div class="col w25p"><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div><div class="col w25p"><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div><div class="col w25p"><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div><div class="col w25p"><p>At vero eos et accusam et justo duo dolores et ea rebum. </p></div></div><table style="width: 98%;" class="Gitternetz">\r\n\r\n\t<caption>Eine kleine Tabelle</caption>\r\n\r\n\t<tbody>\r\n\r\n\t\t<tr>\r\n\t\t\t<th style="width:25%" scope="col">Tabellenkopf<br></th>\r\n\t\t\t<th style="width:25%" scope="col">Tabellenkopf</th>\r\n\t\t\t<th style="width:25%" scope="col">Tabellenkopf</th>\r\n\t\t\t<th style="width:25%" scope="col">Tabellenkopf</th>\r\n\t\t</tr>\r\n\r\n\t\t<tr>\r\n\t\t\t<th style="width:25%" scope="row">Spaltenkopf</th>\r\n\t\t\t<td style="width:25%">Zelle<br></td>\r\n\t\t\t<td style="width:25%">Zelle</td>\r\n\t\t\t<td style="width:25%">Zelle</td>\r\n\t\t</tr>\r\n\r\n\t\t<tr>\r\n\t\t\t<th style="width:25%" scope="row">Spaltenkopf</th>\r\n\t\t\t<td style="width:25%">Zelle</td>\r\n\t\t\t<td style="width:25%">Zelle</td>\r\n\t\t\t<td style="width:25%">Zelle</td>\r\n\t\t</tr>\r\n\r\n\t\t<tr>\r\n\t\t\t<th style="width:25%" scope="row">Spaltenkopf</th>\r\n\t\t\t<td style="width:25%">Zelle</td>\r\n\t\t\t<td style="width:25%">Zelle</td>\r\n\t\t\t<td style="width:25%">Zelle</td>\r\n\t\t</tr>\r\n\t</tbody>\r\n</table>\r\n\r\n<div class="footnote">\r\n\t<hr class="fnline">\r\n\r\n\t<p><a href="#aftn0" id="ftn0" class="ftn">↑</a> 1) <span id="pftn0">Eine Fußnote</span></p>\r\n</div>\r\n', 'de', '3', '1970-01-01', '2500-12-31', 'on', 'Startuser', '1', '40', '7', '— Stile', '/Stile-der-Formatvorlagen.html', '2015-10-08 14:23:33', '2019-05-13 16:32:11', '1', 'pages', '0', '1', NULL, '2', NULL, NULL, NULL, NULL),
('Impressum', 'Impressum', '<p><span style="font-weight: bold;"><span style="font-style: italic;">[ Dies ist eine empfohlene Vorlage zur individuellen Bearbeitung ]</span></span><br></p><p>Informationspflicht laut §5 E-Commerce Gesetz, §14 Unternehmensgesetzbuch, §63 Gewerbeordnung und Offenlegungspflicht laut §25 Mediengesetz.\r\n</p><p>MusterFirma<br>\r\nMax Mustermann<br>\r\nMusterstrasse 1, Stiege 1 Tür 1,<br>\r\n1234 Musterstadt<br>\r\nÖsterreich</p>\r\n<p><strong>Unternehmensgegenstand:</strong> <br>\r\n<strong>UID-Nummer:</strong> <br>\r\n<strong>Firmenbuchnummer:</strong><strong></strong> <br></p>\r\n<p><strong>Tel.:</strong>&nbsp;01234/56789<br>\r\n<strong>Fax:</strong>&nbsp;01234/56789-0</p>\r\n<p><strong>Mitglied bei:</strong> <br>\r\n<strong>Berufsrecht:</strong>&nbsp;Gewerbeordnung: <a href="http://www.ris.bka.gv.at" target="_blank">www.ris.bka.gv.at</a></p>\r\n<p><strong>Aufsichtsbehörde/Gewerbebehörde:</strong> <br>\r\n<strong>Berufsbezeichnung:</strong></p><h2>EU-Streitschlichtung\r\n</h2><p>Angaben zur Online-Streitbeilegung: Verbraucher haben die Möglichkeit, Beschwerden an die OnlineStreitbeilegungsplattform der EU zu richten:&nbsp;<a>https://ec.europa.eu/consumers/odr/main/index.cfm?event=main.home2.show&amp;lng=DE</a>. Sie können allfällige Beschwerde auch an die oben angegebene E-Mail-Adresse richten.</p>\r\n<h2>Haftung für Inhalte dieser Webseite</h2>\r\n<p>Wir entwickeln die Inhalte dieser Webseite ständig weiter und bemühen uns korrekte und aktuelle Informationen bereitzustellen. Leider können wir keine Haftung für die Korrektheit aller Inhalte auf dieser Webseite übernehmen, speziell für jene die seitens Dritter bereitgestellt wird. Sollten Ihnen problematische oder rechtswidrige Inhalte auffallen, bitte wir Sie uns umgehend zu kontaktieren, Sie finden die Kontaktdaten im Impressum.</p>\r\n<h2>Haftung für Links auf dieser Webseite</h2>\r\n<p>Unsere Webseite enthält Links zu anderen Webseiten für deren Inhalt wir nicht verantwortlich sind. Wenn Ihnen rechtswidrige Links auf unserer Webseite auffallen, bitte wir Sie uns zu kontaktieren, Sie finden die Kontaktdaten im Impressum.</p>\r\n<h2>Urheberrechtshinweis</h2>\r\n<p>Alle Inhalte dieser Webseite (Bilder, Fotos, Texte, Videos) unterliegen dem Urheberrecht. Falls notwendig, werden wir die unerlaubte Nutzung von Teilen der Inhalte unserer Seite rechtlich verfolgen.</p>', 'de', '2', '1970-01-01', '2500-12-31', 'on', 'Startuser', '13', '10', '4', '—— Impressum', '/Impressum.html', '2019-03-27 18:05:43', '2019-05-01 12:33:38', '1', 'pages', '0', '1', NULL, '2', NULL, NULL, NULL, NULL),
('Allgemeine Geschäftsbedingungen', 'AGB', '<p><span style="font-style: italic;"><span style="font-weight: bold;">[ Fügen Sie hier Ihre</span></span><span style="font-style: italic;"><span style="font-weight: bold;"> Allgemeine Geschäftsbedingungen</span></span><span style="font-style: italic;"><span style="font-weight: bold;"> ein]</span></span><br></p>', 'de', '2', '1970-01-01', '2500-12-31', 'on', 'Startuser', '13', '20', '5', '—— AGB', '/Allgemeine-Geschaeftsbedingungen.html', '2019-03-27 18:19:37', '2019-04-03 11:58:15', '1', 'pages', '0', '1', NULL, '3', NULL, NULL, NULL, NULL),
('Datenschutzerklärung', 'Datenschutz', ' <p><span style="font-style: italic;"><span style="font-weight: bold;">[ Dies ist eine empfohlene Vorlage zur individuellen Bearbeitung ]</span></span><br></p><p>Der Schutz Ihrer persönlichen Daten ist uns ein besonderes Anliegen. Wir verarbeiten Ihre Daten daher ausschließlich auf Grundlage der gesetzlichen Bestimmungen (DSGVO, TKG 2003). In diesen Datenschutzinformationen informieren wir Sie über die wichtigsten Aspekte der Datenverarbeitung im Rahmen unserer Website.&nbsp;</p>\r\n<h2>Kontakt mit uns</h2> <p>Wenn Sie per Formular auf der Website oder per E-Mail Kontakt mit uns aufnehmen, werden Ihre angegebenen Daten zwecks Bearbeitung der Anfrage und für den Fall von Anschlussfragen sechs Monate bei uns gespeichert. Diese Daten geben wir nicht weiter.&nbsp;</p>\r\n<h2>Datenspeicherung</h2> <p>Wir weisen darauf hin, dass zum Zweck der Vertragsabwicklung folgende Daten bei uns gespeichert werden: <br></p> <p>Name, Adresse, E-Mail-Adresse<br></p> <p>Die von Ihnen bereit gestellten Daten sind zur Vertragserfüllung bzw zur Durchführung vorvertraglicher Maßnahmen erforderlich. Ohne diese Daten können wir den Vertrag mit Ihnen nicht abschließen. Eine Datenübermittlung an Dritte erfolgt nicht, mit Ausnahme der Übermittlung der Kreditkartendaten an die abwickelnden Bankinstitute / Zahlungsdienstleister zum Zwecke der Abbuchung des Einkaufspreises, an das von uns beauftragte Transportunternehmen/Versandunternehmen zur Zustellung der Ware sowie an unseren Steuerberater zur Erfüllung unserer steuerrechtlichen Verpflichtungen.<br></p> <p>Im Falle eines Vertragsabschlusses werden sämtliche Daten aus dem Vertragsverhältnis bis zum Ablauf der steuerrechtlichen Aufbewahrungsfrist (7 Jahre) gespeichert. <br clear="all"> </p> <p>Die Daten Name, Anschrift, gekaufte Waren und Kaufdatum werden darüber hinaus gehend bis zum Ablauf der Produkthaftung (10 Jahre) gespeichert. Die Datenverarbeitung erfolgt auf Basis der gesetzlichen Bestimmungen des § 96 Abs 3 TKG sowie des Art 6 Abs 1 lit a (Einwilligung) und/oder lit b (notwendig zur Vertragserfüllung) der DSGVO. </p>\r\n<h2>Cookies</h2> <p>Unsere Website verwendet so genannte Cookies. Dabei handelt es sich um kleine Textdateien, die mit Hilfe des Browsers auf Ihrem Endgerät abgelegt werden. Sie richten keinen Schaden an. <br></p> <p>Wir nutzen Cookies ausschließlich für eine Session ID, um einen Kaufvorgang aufrecht zu erhalten. Dieser Form von Cookies bedarf es keiner Einwilligung seitens des Benutzers. Es werden keinerlei dauerhafte Cookies von uns oder Dritten gespeichert.<br></p> <p>Wenn Sie dies nicht wünschen, so können Sie Ihren Browser so einrichten, dass er Sie über das Setzen von Cookies informiert und Sie dies nur im Einzelfall erlauben. </p> <p>Bei der Deaktivierung von Cookies kann die Funktionalität unserer Website eingeschränkt sein.</p><h2>Web-Analyse</h2> <p>Unsere Website verwendet die bei uns lokal installierte Webanalyse Consentio Web Analytics, die ohne Cookies auskommt.<br></p> <p>Ihre IP-Adresse wird erfasst, aber umgehend durch Einwegverschlüsselung anonymisiert. Dadurch ist nur mehr eine grobe Lokalisierung möglich. </p> <p>Es werden keine Daten an externe Dienstleister weitergegeben.<br></p> <p>Die detaillierten Nutzerdaten werden für die Dauer von drei Jahren aufbewahrt, danach nur noch als Summen für Jahresstatistiken.</p>\r\n<h2>Newsletter</h2> <p>Sie haben die Möglichkeit, über unsere Website unseren Newsletter zu abonnieren. Hierfür benötigen wir Ihre E-Mail-Adresse und ihre Erklärung, dass Sie mit dem Bezug des Newsletters einverstanden sind.</p> <p>Das Abo des Newsletters können Sie jederzeit stornieren. Senden Sie Ihre Stornierung bitte an folgende E-Mail-Adresse: <span style="font-style: italic;"><span style="font-weight: bold;">[ bitte einfügen ] </span></span>Wir löschen anschließend umgehend Ihre Daten im Zusammenhang mit dem Newsletter-Versand. </p>\r\n<h2>Ihre Rechte</h2> <p>Ihnen stehen grundsätzlich die Rechte auf Auskunft, Berichtigung, Löschung, Einschränkung, Datenübertragbarkeit, Widerruf und Widerspruch zu. Wenn Sie glauben, dass die Verarbeitung Ihrer Daten gegen das Datenschutzrecht verstößt oder Ihre datenschutzrechtlichen Ansprüche sonst in einer Weise verletzt worden sind, können Sie sich bei der Aufsichtsbehörde beschweren. In Österreich ist dies die Datenschutzbehörde.&nbsp;</p><p>\r\nSie erreichen uns unter folgenden Kontaktdaten: </p><p><span style="font-style: italic;"><span style="font-weight: bold;">[ bitte einfügen ]</span></span><br></p>', 'de', '2', '1970-01-01', '2500-12-31', 'on', 'Startuser', '13', '30', '6', '—— Datenschutz', '/Datenschutzerklaerung.html', '2019-03-27 18:37:25', '2019-03-27 18:43:08', '1', 'pages', '0', '1', NULL, '2', NULL, NULL, NULL, NULL),
('Über uns', 'Über uns', NULL, 'de', '2', '1970-01-01', '2500-12-31', NULL, '', '1', '10', '3', '— Über uns', '/Ueber-uns.html', '2019-03-27 18:43:44', '2019-05-13 16:31:45', '1', 'folder', '1', '1', NULL, '2', NULL, NULL, NULL, NULL);


CREATE VIEW `folder_view` AS select `content`.`id` AS `id`,`content`.`title` AS `title`,`content`.`short` AS `short`,`content`.`lang` AS `lang`,`content`.`sort` AS `sort`,`content`.`parentsort` AS `parentsort`,`content`.`graduated` AS `graduated`,`content`.`parent` AS `parent`,`content`.`type` AS `type`,`content`.`file` AS `file` from `content` where (`content`.`folder` = 1);

CREATE TABLE `content_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(32) NOT NULL,
  `name` varchar(32) DEFAULT NULL,
  `icon` varchar(32) NOT NULL,
  `icon_add` varchar(32) DEFAULT NULL,
  `new_in_type` varchar(255) NOT NULL,
  `generate` tinyint(1) DEFAULT '0',
  `move` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT INTO `register` (`name`, `call`, `plugin`, `tab`, `params`, `gui`, `top`, `start`, `group`, `icon`, `image`, `level`, `sort`, `frontend`) VALUES
('lang_settings', 'lang_settings', 'pages', '3', '', 0, '', '', 'on', 'comment-o', 0, 2, 170, ''),
('announces', 'announces', 'announces', '5', '', 0, 'on', 'on', 'on', 'align-center', 0, 1, 250, ''),
('new_teaser', 'announces', 'announces', '5', '&todo=edit', 0, '', 'on', 'on', 'align-center-add', 0, 1, 280, ''),
('container', 'container', 'announces', '5', '', 0, '', '', '', 'list-ul', 0, 1, 270, ''),
('new_container', 'announces', 'announces', '5', '&todo=edit&type=2', 0, '', 'on', '', 'list-ul-add', 0, 1, 290, ''),
('Boxes Definition', 'boxes_admin', 'announces', '5', '', 0, '', 'on', '', 'wrench', 0, 3, 300, ''),
('web_settings', 'web_settings', 'pages', '3', '', 0, '', 'on', 'on', 'globe-edit', 0, 2, 150, ''),
('content', 'pages', '', '3', '', 0, 'on', 'on', 'on', 'copy', 0, 1, 120, ''),
('new_folder', 'pages', '', '3', '&todo=edit&type=folder', 0, '', 'on', '', 'folder_add', 0, 1, 140, ''),
('templates', 'templates', 'pages', '3', '', 0, '', '', 'on', 'book', 0, 3, 230, ''),
('new_page', 'pages', '', '3', '&todo=edit&type=pages', 0, '', 'on', '', 'far-file_add', 0, 1, 130, ''),
('components', 'components', 'pages', '3', '', 0, '', '', 'on', 'puzzle-piece', 0, 2, 200, ''),
('designer', 'load_layout', 'pages', '3', '', '1', '', 'on', 'on', 'paint-brush', '0', '2', '240', '');

CREATE TABLE `templates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `index` varchar(32) NOT NULL,
  `head` varchar(64) DEFAULT NULL,
  `body` varchar(64) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `header` varchar(64) DEFAULT NULL,
  `footer` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `templates` (`id`, `name`, `index`, `head`, `body`, `title`, `header`, `footer`) VALUES
(1, 'Startseite', 'cms_layout_start', 'cms_head', 'cms_pages_body_start', 'cms_pages_title', 'cms_pages_header', 'cms_pages_footer'),
(2, 'Standard', 'cms_layout_standard', 'cms_head', 'cms_pages_body1', 'cms_pages_title', 'cms_pages_header', 'cms_pages_footer'),
(3, 'Ganze Breite', 'cms_layout_one_col', 'cms_head', 'cms_pages_body2', 'cms_pages_title', 'cms_pages_header', 'cms_pages_footer');
