
CREATE TABLE IF NOT EXISTS `cowa_browsers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `short` varchar(16) NOT NULL,
  `name` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `cowa_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` bigint(20) NOT NULL,
  `referer_url` text NOT NULL,
  `user_agent` varchar(127) DEFAULT NULL,
  `resolution` varchar(9) NOT NULL,
  `location_ip` varchar(16) NOT NULL,
  `location_browser_lang` varchar(20) NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '1',
  `page` varchar(128) NOT NULL,
  `title` varchar(128) DEFAULT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `cowa_os` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `short` varchar(16) NOT NULL,
  `name` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `cowa_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` bigint(20) NOT NULL,
  `title` varchar(128) NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `cowa_referrer` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `host` varchar(32) NOT NULL,
  `site_id` int(10) unsigned NOT NULL,
  `is_spam` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `cowa_sites` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(127) NOT NULL,
  `url` varchar(255) NOT NULL,
  `aliases` varchar(255) DEFAULT NULL,
  `token` varchar(16) NOT NULL,
  `created` date DEFAULT NULL,
  `google_rank` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `indexed_pages` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `cowa_sum` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `year` smallint(5) unsigned NOT NULL,
  `month` tinyint(3) unsigned NOT NULL,
  `day` tinyint(3) unsigned NOT NULL,
  `visits` bigint(20) unsigned NOT NULL,
  `views` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`year`,`month`,`day`),
  KEY `date` (`date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `cowa_views` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `visit_id` bigint(20) unsigned NOT NULL,
  `page_id` bigint(20) DEFAULT NULL,
  `page` varchar(128) NOT NULL,
  `time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `cowa_visitors` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) NOT NULL,
  `ip` varchar(16) NOT NULL,
  `country` char(2) NOT NULL,
  `region` char(64) DEFAULT NULL,
  `city` varchar(64) DEFAULT NULL,
  `latitude` float(10,6) DEFAULT NULL,
  `longitude` float(10,6) DEFAULT NULL,
  `resolved` varchar(64) DEFAULT NULL,
  `visits` int(11) NOT NULL DEFAULT '1',
  `views` int(11) NOT NULL DEFAULT '1',
  `first_visit` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_visit` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`),
  KEY `site_id` (`site_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `cowa_visits` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) NOT NULL,
  `visitor_id` bigint(20) NOT NULL,
  `bro_id` int(11) NOT NULL,
  `os_id` int(11) NOT NULL,
  `ref_id` bigint(20) NOT NULL,
  `referrer` varchar(128) NOT NULL,
  `resolution` varchar(16) DEFAULT NULL,
  `time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `cowa_words` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(64) NOT NULL,
  `site_id` bigint(20) unsigned NOT NULL,
  `visit_id` bigint(20) unsigned NOT NULL,
  `count` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`visit_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


CREATE VIEW `cowa_visits_view` AS select `cowa_views`.`id` AS `id`,`cowa_visits`.`site_id` AS `site_id`,`cowa_visits`.`time` AS `time`,`cowa_visits`.`id` AS `vid`,dayofmonth(`cowa_visits`.`time`) AS `day` from (`cowa_visits` left join `cowa_views` on((`cowa_views`.`visit_id` = `cowa_visits`.`id`)));
