CREATE TABLE `allergen` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(28) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `allergen` ( `id`, `name`)
VALUES ( '1', 'Gluten'),
( '2', 'Krebstiere'),
( '3', 'Eier'),
( '4', 'Fisch'),
( '5', 'Erdnüsse'),
( '6', 'Sojabohnen'),
( '7', 'Milch'),
( '8', 'Schalenfrüchte'),
( '9', 'Sellerie'),
( '10', 'Senf'),
( '11', 'Sesamsamen'),
( '12', 'Schwefeldioxid/Sulphite'),
( '13', 'Lupinen'),
( '14', 'Weichtiere');

CREATE TABLE `gastro` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `daily` varchar(2) DEFAULT NULL,
  `day` date NOT NULL,
  `meal` varchar(126) NOT NULL DEFAULT '',
  `starter` varchar(126) DEFAULT NULL,
  `dessert` varchar(126) DEFAULT NULL,
  `description` text,
  `price` decimal(10,2) NOT NULL,
  `sort` tinyint(4) NOT NULL DEFAULT '1',
  `allergen` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `gastro_junction_allergen` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id_gastro` bigint(20) unsigned NOT NULL,
  `id_allergen` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_gastro` (`id_gastro`),
  KEY `id_allergen` (`id_allergen`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `i18n` (`index`, `group`, `en`, `de`) VALUES
('gastro', 'common', 'Set Meal', 'Tagesmenüs'),
('set_meal', 'common', 'Set Meal', 'Tagesmenüs'),
('meal', 'gastro', 'Meal', 'Menü'),
('starter', 'gastro', 'Starter', 'Vorspeise'),
('dessert', 'gastro', 'Dessert', 'Nachspeise'),
('for_days', 'gastro', 'for ... days', 'für ... Tage'),
('allergen', 'common', 'Allergen', 'Allergene')
('jan', 'common', 'January', 'Jänner'),
('feb', 'common', 'February', 'Feber'),
('mar', 'common', 'March', 'März'),
('apr', 'common', 'April', 'April'),
('may', 'common', 'May', 'Mai'),
('jun', 'common', 'June', 'Juni'),
('jul', 'common', 'July', 'Juli'),
('aug', 'common', 'August', 'August'),
('sep', 'common', 'September', 'September'),
('oct', 'common', 'October', 'Oktober'),
('nov', 'common', 'November', 'November'),
('dec', 'common', 'December', 'Dezember'),
('today', 'common', 'today', 'Heute'),
('mon', 'common', 'Monday', 'Montag'),
('tue', 'common', 'Tuesday', 'Dienstag'),
('wed', 'common', 'Wednesday', 'Mittwoch'),
('thu', 'common', 'Thursday', 'Donnerstag'),
('fri', 'common', 'Friday', 'Freitag'),
('sat', 'common', 'Saturday', 'Samstag'),
('sun', 'common', 'Sunday', 'Sonntag'),
('price', 'common', 'Price', 'Preis');

INSERT INTO `i18n` SET `index` = 'insert_menue', `group` = 'common', `de` = 'Menü einfügen', `en` = 'Insert Meals';

INSERT INTO `content_types` (`type`, `name`, `icon`, `icon_add`, `new_in_type`, `generate`, `move`)
VALUES ('gastro', 'gastro', 'cutlery', NULL, '', '0', '1');
INSERT INTO `register` (`name`, `call`, `plugin`, `tab`, `params`, `gui`, `top`, `start`, `group`, `icon`, `image`, `level`, `sort`, `frontend`)
VALUES ('gastro', 'gastro', NULL, '7', '', '1', '', 'on', 'on', 'cutlery', '0', '1', '230', ''),
('gastro_settings', 'gastro_settings', 'gastro', '7', '', '1', '', '', '', 'default', '0', '1', '300', '');

INSERT INTO `html_snippets` (`key`, `code`, `group`, `description`)
VALUES ('cms_gastro', '<div class="gastrobox">\r\n<h2>&&&&title&&&&</h2>\r\n<p>&&&&date&&&&</p>\r\n&&&&list&&&&\r\n</div>', '14', 'Gastro Box'),
('cms_gastro_meal', '<h3>&&&&heading&&&&</h3>\r\n&&&&description&&&&&&&&starter&&&&&&&&dessert&&&&&&&&allergen&&&&\r\n<p class="alright">&&&&price&&&&</p>\r\n<hr>\r\n', '14', 'one meal');
