CREATE TABLE `slide_show` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) NOT NULL,
  `text` text,
  `interval` tinyint(4) NOT NULL DEFAULT '6',
  `auto` varchar(2) NOT NULL DEFAULT 'on',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `slider_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `picture` varchar(128) NOT NULL DEFAULT '0',
  `title` varchar(128) DEFAULT NULL,
  `copyright` varchar(64) DEFAULT NULL,
  `text` text,
  `slider` bigint(20) unsigned NOT NULL DEFAULT '0',
  `sort` bigint(20) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `html_snippets` (`key`, `code`, `group`, `description`) VALUES
('cms_slider_script', '<script src="/js/responsiveslides.min.js"></script>\r\n<link rel="stylesheet" href="/css/slides.css" type="text/css" />', '14', ''),
('cms_slider', '<div class="rslides_container">\r\n&&&&list&&&&\r\n</div>\r\n&&&&text&&&&\r\n<script>\r\n$(document).ready(function($) {$(\'.rslides\').responsiveSlides({\r\n  auto: &&&&auto&&&&,\r\n  speed: 500,\r\n  timeout: &&&&interval&&&&000,\r\n  pager: true,\r\n  nav: true,\r\n  namespace: "centered-btns",\r\n  prevText: "Previous",\r\n  nextText: "Next",\r\n  maxwidth: 1200,\r\n  })\r\n});\r\n</script>\r\n', '14', ''),
('cms_slider_item', '<li>\r\n<img src="/pictures/normal/&&&&picture&&&&" width="&&&&width&&&&" height="&&&&height&&&&" alt="&&&&alt&&&&" />\r\n&&&&title&&&&\r\n</li>\r\n', '14', ''),
('cms_slider_caption', '<p class="caption">&&&&title&&&&</p>', '14', '');

INSERT INTO `i18n` SET `index` = 'slide_show', `group` = 'common', `de` = 'Dia-Show', `en` = 'Slide-Show';

INSERT INTO `content_types` (`type`, `name`, `icon`, `icon_add`, `new_in_type`, `generate`, `move`)
VALUES ('slide_show', 'slide_show', 'film', 'film-add', 'root,folder,node', '0', '1');

INSERT INTO `register` (`name`, `call`, `plugin`, `tab`, `params`, `gui`, `top`, `start`, `group`, `icon`, `image`, `level`, `sort`, `frontend`) VALUES
('slide_show', 'slide_show', 'slide_show', '3', '', '1', '', '', '', 'film', '0', '1', '0', ''),
('slide_images', 'slide_images', 'slide_show', '3', '', '5', '', '', '', 'default', '0', '1', '0', '');
