INSERT INTO `i18n` (`index`, `group`, `en`, `de`) VALUES
('page', 'pages', 'Page', 'Seite'),
('files', 'common', 'Files', 'Dateien'),
('warning', 'common', 'Advice', 'Hinweis'),
('top', 'register', 'Tab', 'Karteireiter'),
('groups', 'common', 'Groups', 'Gruppen'),
('register', 'register', 'Menu Rgister', 'Menü-Register'),
('frontend', 'register', 'Frontend', 'Frontend'),
('color', 'common', 'Color', 'Farbe'),
('used_color', 'cssadmin', 'Used Colors', 'Benutzte Farben'),
('code', 'common', 'Code', 'Code'),
('page_templates', 'pages', 'Template Management', 'Vorlagen-Verwaltung'),
('dump_table', 'tables', 'Dump of Table', 'Tabellen-Dump'),
('execute', 'tables', 'Execute', 'Ausführen'),
('index', 'languages', 'i18n Keyword', 'i18n-Schlüssel'),
('chapter', 'common', 'Chapter', 'Kapitel');
UPDATE `html_snippets` SET `code` = '<body>\r\n<div id="site" class="grid clrfx">\r\n&&&&header&&&&\r\n<div id="content" class="clrfx">\r\n<aside class="col w3">\r\n	&&&&formtitle&&&&\r\n	&&&&left&&&&\r\n</aside>\r\n<main class="col w9">\r\n	&&&&content&&&&\r\n</main>\r\n</div>\r\n<footer class="col w12 clrfx">\r\n<div class="foot">\r\n&&&&footer&&&&\r\n</div>\r\n&&&&bubbles&&&&\r\n</footer>\r\n</div> <!-- site -->\r\n<!-- &&&&timestamp&&&& GUI: &&&&gui&&&& -->\r\n</body>\r\n</html>',`group` = 2,`description` = 'GUI template with header, aside and footer' WHERE `html_snippets`.`key` = 'gui_main_1';
UPDATE `html_snippets` SET `code` = '<body>\r\n<div id="site" class="grid clrfx">\r\n&&&&header&&&&\r\n<div id="content" class="clrfx">\r\n<main class="col w12">\r\n	&&&&formtitle&&&&\r\n	&&&&content&&&&\r\n</main>\r\n</div>\r\n<footer class="col w12 clrfx">\r\n<div class="foot">\r\n&&&&footer&&&&\r\n</div>\r\n&&&&bubbles&&&&\r\n</footer>\r\n</div> <!-- site -->\r\n<!-- &&&&timestamp&&&& GUI: &&&&gui&&&& -->\r\n</body>\r\n</html>',`group` = 2,`description` = 'GUI Template with header without aside' WHERE `html_snippets`.`key` = 'gui_main_2';
UPDATE `html_snippets` SET `code` = '<body id="single">\r\n<div id="site" class="clrfx">\r\n<main>\r\n	&&&&formtitle&&&&\r\n	&&&&content&&&&\r\n	&&&&bubbles&&&&\r\n</main>\r\n</div> <!-- site -->\r\n<!-- &&&&timestamp&&&& GUI: &&&&gui&&&& -->\r\n</body>\r\n</html>',`group` = 2,`description` = 'GUI template for popup and iframe' WHERE `html_snippets`.`key` = 'gui_main_3';
UPDATE `html_snippets` SET `code` = '<body id="single">\r\n<div id="site" class="grid clrfx">\r\n\r\n<aside class="col w3">\r\n	&&&&formtitle&&&&\r\n	&&&&left&&&&\r\n</aside>\r\n<main class="col w9">\r\n	&&&&content&&&&\r\n	&&&&bubbles&&&&\r\n</main>\r\n</div> <!-- site -->\r\n<!-- &&&&timestamp&&&& GUI: &&&&gui&&&& -->\r\n</body>\r\n</html>',`group` = 2,`description` = 'GUI with ASIDE without HEADER' WHERE `html_snippets`.`key` = 'gui_main_4';
UPDATE `html_snippets` SET `code` = '<body>\r\n<div id="site" class="grid clrfx">\r\n&&&&header&&&&\r\n<div id="content" class="clrfx">\r\n<aside class="col w4">\r\n	&&&&formtitle&&&&\r\n	&&&&left&&&&\r\n</aside>\r\n<main class="col w8">\r\n	&&&&content&&&&\r\n</main>\r\n</div>\r\n<footer class="col w12 clrfx">\r\n<div class="foot">\r\n&&&&footer&&&&\r\n</div>\r\n&&&&bubbles&&&&\r\n</footer>\r\n</div> <!-- site -->\r\n<!-- &&&&timestamp&&&& GUI: &&&&gui&&&& -->\r\n</body>\r\n</html>',`group` = 2,`description` = 'Overview with a bigger aside' WHERE `html_snippets`.`key` = 'gui_main_5';
UPDATE `html_snippets` SET `code` = '<!DOCTYPE html>\r\n<html>\r\n<head>\r\n<title>&&&&headtitle&&&&</title>\r\n<meta http-equiv="content-type" content="text/html; charset=utf-8" />\r\n<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">\r\n<link rel="shortcut icon" href="/graphics/favicon.png" />\r\n<link rel="stylesheet" href="/css/teslagrid.css" type="text/css" />\r\n<link rel="stylesheet" href="/css/common_master.css" type="text/css" />\r\n<link rel="stylesheet" href="/css/&&&&CSS&&&&.css" type="text/css" />\r\n<script src=''/js/jQuery.js'' type=''text/javascript''></script>\r\n<script src=''/js/backend_utilities.js'' type=''text/javascript''></script>\r\n&&&&scripts&&&&\r\n</head>\r\n',`group` = 9,`description` = 'the head section' WHERE `html_snippets`.`key` = 'gui_head';

UPDATE `i18n` SET `group` = 'common' where `index` LIKE 'scheme%';
DROP TABLE IF EXISTS `help`;
DROP TABLE IF EXISTS `help_folder`;
CREATE TABLE `help_folder` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short` varchar(32) NOT NULL,
  `parent` bigint(20) NOT NULL,
  `sort` bigint(20) DEFAULT NULL,
  `language` varchar(2) NOT NULL DEFAULT 'de',
  `parentsort` bigint(20) NOT NULL,
  `graduated` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `help_folder` ( `id`, `name`, `short`, `parent`, `sort`, `language`, `parentsort`, `graduated`)
VALUES ( '1', 'Hilfe', '', '0', '40', 'de', '1', ' Hilfe'),
( '2', 'Seitenverwaltung', '', '1', '20', 'de', '3', '— Seitenverwaltung'),
( '3', 'Teaser und Container', '', '1', '30', 'de', '5', '— Teaser und Container'),
( '4', 'Dateimanager', '', '1', '50', 'de', '9', '— Dateimanager'),
( '5', 'Einstellungen', '', '1', '60', 'de', '10', '— Einstellungen'),
( '6', 'Bilddatenbank', '', '1', '40', 'de', '6', '— Bilddatenbank'),
( '7', 'CMS Einstellungen', '', '2', '0', 'de', '4', '—— CMS Einstellungen'),
( '8', 'Bildmanipulationen', '', '6', '20', 'de', '8', '—— Bildmanipulationen'),
( '9', 'Allgemeines', '', '1', '10', 'de', '2', '— Allgemeines'),
( '10', 'Bildermappe', '', '6', '10', 'de', '7', '—— Bildermappe'),
( '11', 'Benutzerverwaltung', '', '5', '10', 'de', '11', '—— Benutzerverwaltung'),
( '12', 'Menü-Register', '', '5', '20', 'de', '12', '—— Menü-Register'),
( '13', 'CSS Manager', '', '5', '30', 'de', '13', '—— CSS Manager'),
( '14', 'HTML-Vorlagen', '', '5', '40', 'de', '14', '—— HTML-Vorlagen'),
( '15', 'Sprachen Internationalisierung', '', '5', '50', 'de', '15', '—— Sprachen Internationalisierung'),
( '16', 'Datenbank', '', '5', '60', 'de', '16', '—— Datenbank'),
( '17', 'Plugins', '', '1', '70', 'de', '17', '— Plugins');

CREATE TABLE `help` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parent` bigint(20) NOT NULL,
  `header` varchar(200) DEFAULT NULL,
  `body` text NOT NULL,
  `sort` bigint(20) DEFAULT NULL,
  `tooltip` varchar(64) NOT NULL,
  `language` varchar(2) NOT NULL DEFAULT 'de',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `header` (`header`,`body`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `help` ( `id`, `parent`, `header`, `body`, `sort`, `tooltip`, `language`)
VALUES ( '1', '3', 'Teaser', '<p>Teaser und Container heben Inhalte hervor oder fassen sie zusammen.</p>', '410', 'common.announces', 'de'),
( '2', '3', 'Titel', '<p>Der Titel eines Teasers oder Ankündigungkastens<br></p>', '870', 'announces.title', 'de'),
( '4', '2', 'Seiten', '<p>Erstellen und Verwalten von Inhaltsseiten</p>', '460', 'common.pages', 'de'),
( '5', '2', 'Ordner', '<p>Ordner zur Verzweigung und Gruppierung von Seiten oder weiteren Ordnern</p>', '630', 'common.folder', 'de'),
( '6', '2', 'Verknüpfung', 'Stellt im Menü eine Verknüpfung zu diversen Inhalten her.', '640', 'common.link', 'de'),
( '7', '6', 'Bilder', '<p>Übersicht über alle verfügbaren Bilder mit Suchfunktion und Beschlagwortung.</p>', '270', 'common.images', 'de'),
( '8', '5', 'Einstellungen', '<p>Einstellungen, Konfigurationen, Werkzeuge...</p>', '860', 'common.settings', 'de'),
( '9', '7', 'CMS-Einstellungen', '<p>CMS-spezifische Einstellungen und Konfigurationen</p>', '650', 'web_settings', 'de'),
( '10', '1', 'Übersicht', '<p>Die Übersicht bietet Zugang zu allen verfügbaren Funktionen.<br></p>', '620', 'common.intro', 'de'),
( '11', '4', 'Dateimanager', '<p>Dateien wie PDFs hochladen, verwalten und veröffentlichen<br></p>', '220', 'common.filemanager', 'de'),
( '12', '1', 'Consentio CMS und Framework', '<p>Consentio kombiniert ein Framework zur Datenerfassung und -ausgabe mit einem Redaktionssystem für Websites. Dieses ist für die Erstellung von Websites mit umfangreichen und weitverzweigten Inhalten ausgerichtet.</p><p>Prinzipiell trennt ein Content Management System (CMS) den Inhalt \r\n(Content) von der Darstellung (Design). Dadurch kann sich der Benutzer \r\nauf das konzentrieren, worum es eigentlich geht, nämlich auf den Inhalt, der vorrangig durch das Seitenmanagement bewerkstelligt wird. <br></p>', '430', 'common.preface', 'de'),
( '28', '7', 'Website-Titel', '<p>Der Titel der Website ist die Top-Inhaltsbeschreibung der Website und \r\nsomit ein wesentliches Kriterium für Suchmaschinen. Der Titel wird auch \r\nim Fenstertitel des Browsers angezeigt.</p><p>Geben Sie der Website einen kurzen, prägnanten Titel.<br></p>', '670', 'web_settings.website_title', 'de'),
( '13', '2', 'Inhaltseiten', '<p>Eine Seite oder Inhaltsseite bildet einen eigenständigen Bereich innerhalb der Website, der über die Navigationsleiste, einem Link oder anderen Navigationselementen aufgerufen werden kann.</p><p>Um eine neue Seite zu erstellen, klicken Sie auf den Karteireiter "Neuer Eintrag" und danach auf "Seite". Um eine vorhandene Seite zu bearbeiten, klicken Sie in der Tabellenübersicht auf das Bearbeiten-Icon der gewünschten Seite.</p><p>Klicken Sie auf "Speichern", wenn Änderungen gespeichert werden sollen.</p><p>Um eine Seite zu löschen, klicken Sie auf den Lösch-Icon der gewünschten Seite. Um mehrere Seiten gleichzeitig zu löschen, klicken Sie die Auswahl-Box der gewünschten Seiten an und danach auf "Löschen" am Tabellenbeginn.<br></p>', '470', 'pages', 'de'),
( '14', '2', 'Titel', '<p>Der Titel der Seite bildet zugleich die Überschrift und wird für die Namensgebung der HTML-Datei verwendet. Geben Sie Ihrer Seite einen aussagekräftigen Titel.<br></p>', '480', 'pages.title', 'de'),
( '15', '2', 'Kurztitel', '<p>Der Kurztitel wird für den Menü-Eintrag verwendet, er sollte mit dem Titel nachvollziehbar zusammenhängen, muss jedoch entscheidend kurz sein.<br></p>', '490', 'pages.short', 'de'),
( '16', '2', 'Autor', '<p>Das Autoren-Feld gibt Auskunft über den Urheber der Seite für interne \r\nZwecke. Der Name des angemeldeten Benutzers wird hier automatisch \r\neingetragen. Das Feld kann aber gegebenenfalls überschrieben werden. Der\r\n Autor scheint auf der veröffentlichten Website <strong>nicht</strong> auf.\r\n</p>', '500', 'pages.author', 'de'),
( '17', '2', 'Sprache', '<p>Die Sprache ergibt sich aus der Auswahl des Sprachbereiches, aus der heraus die Seite angelegt wurde. Wollen Sie eine andere Sprache verwenden, wählen Sie im linken Baum einen anderen Sprachbereich oder Ordner dieses Bereiches aus und gehen dann auf  "Neue Seite".<br></p>', '510', 'pages.lang', 'de'),
( '18', '2', 'Textkörper', '<p>Der Textkörper ist der eigentliche Inhalt der Seite. Der Text lässt sich mit Hilfe des\r\n Editors vielseitig formatieren, wodurch vom einfachen Fließtext bis zum\r\n raffiniert gestalteten Design alles möglich ist. Die\r\n Bedeutung der einzelnen Schaltfläche gehen weitgehend mit denen \r\nherkömmlicher Programme konform.</p><p>Für eine vollständige Erläuterung zum Editor bitte auf den Infopunkt klicken.<br></p>', '520', 'pages.body', 'de'),
( '19', '2', 'Der Editor', '<p>Die Textkörper von Seiten oder diverser Plugins erlauben die Formatierung des Textes und das Einfügen von Tabellen, Links und Bildern. Damit wird technisch gesehen aus reinem Text HTML-formatierter Code. Für den Benutzer bietet der Editor JQwys den Komfort, nicht im Code arbeiten zu müssen, sondern direkt in einer dem Endergebnis ähnlichen Darstellung. Dass diese nicht 1:1 dem Design auf der Website entspricht, hat freilich mit der Individualität der Designs zu tun. Darüber hinaus verfolgt der Editor das Prinzip What you see is what you mean (WYSIWYM). Das bedeutet, dass die Textstruktur optisch unterstützt wird. Man sieht praktisch auf einem Blick, ob Absätze, Überschriften oder Auflistungen richtig gesetzt sind.</p><h4>Die Funktionen von JQWys im Überblick</h4><h5><img src="/js/images/code.png" alt=""> HTML anzeigen/verstecken</h5><p>Mit diesem Button wechseln wir von der <abbr title="Hypertext Metalanguage" lang="en">HTML</abbr>-Ansicht zur Design-Ansicht. Damit haben Profis die volle Kontrolle über den HTML-Quellcode.<br></p><h5><img src="/js/images/paragraph.png" alt=""> Absatz</h5><p>Dieser Button ist identisch mit der Auswahl "Absatz" im nächstfolgenden Auswahlfeld und zeichnet den aktuellen Block, in dem der Text-Cursor steht, als Absatz aus. Ein Block ist ein durch "Return" beendeter Textabschnitt. Um innerhalb eines Absatzes einen so genannten "weichen" Zeilenumbruch zu erwirken, drückt man Shift und Return gleichzeitig.</p><h5>Textformat auswählen</h5><p>In diesem Auswahlfeld wird dem aktuellen Block, in dem der Text-Cursor steht, die jeweils erforderliche Textstruktur zugeordnet, die da sind:</p><ul><li>Einfacher Absatz und Absätze mit spezieller Gestaltung wie: Vorspann, Bildunterschrift und Copyright.</li><li>Überschrift 1 (Titel), welcher nur in Ausnahmefällen zum Einsatz kommt, da diese Überschriften-Ebene bereits für den Titel der Seite benutzt wird.</li><li>Überschrift 2 (Zwischentitel) unterteilt den Inhalt einer Seite in Abschnitte.</li><li>Überschrift 3 unterteilt den Inhalt innerhalb eines durch Überschrift 2 geteilten Abschnitts in weitere inhaltlich untergeordnete Abschnitte.</li><li>Überschrift 4 unterteilt den Inhalt innerhalb eines durch Überschrift 3 geteilten Abschnitts in weitere inhaltlich untergeordnete Abschnitte.</li><li>und so weiter...<br></li></ul><h5><img src="/js/images/left.png" alt=""> Linksbündig</h5><p>...setzt den aktuellen Block linksbündig, was dem Standard entspricht.<br></p><h5><img src="/js/images/center.png" alt=""> Zentriert</h5><p>...zentriert den aktuellen Block. Beispiel:</p><p>Ein wenig zentrierter Text, um sich abzuheben.<br>Zentrierter Text hat keine Funktion als Überschrift.<br></p><h5><img src="/js/images/right.png" alt=""> Rechtbündig</h5><p>...setzt den aktuellen Block rechtsbündig. Beispiel:</p><p>Zitat Eduard Schmidt<br></p><h5><img src="/js/images/justify.png" alt=""> Blocksatz</h5><p>...richten den aktuellen Block als Blocksatz aus. Das heißt, die Wörter einer Zeile werden so ausgerichtet, dass sie links und rechts bündig abschließen. Da es bei HTML keinen Standard zur Silbentrennung gibt, kommt es rasch zu einem uneinheitlichen auseinandergerissen Schriftbild. Prinzipiell ist Blocksatz daher nur für kurze Passagen und zur Hervorhebung von Textteilen empfehlenswert – wie in diesem Fall.<br></p><h5><img src="/js/images/ol.png" alt=""> Geordnete Liste einfügen</h5><p>Mit einem Klick auf diesen Button wird mit einer durchnummerierten Auflistung begonnen, oder markierte Absätze in eine Auflistung umgewandelt. Beispiel:</p><ol><li>Brot</li><li>Milch</li><li>Butter<br></li></ol><h5><img src="/js/images/ul.png" alt=""> Ungeordnete Liste einfügen</h5><p>...ist ähnlich wie die geordnete Liste jedoch ohne Nummerierung. Beispiel:</p><ul><li>Brot</li><li>Milch</li><li>Butter</li></ul><p>Um eine Auflistung zu beenden, drücken wir zweimal Return und wechseln mit dem Absatz-Button (siehe oben) wieder in den Absatz-Modus. Um innerhalb eines Listenpunktes einen Zeilenumbruch zu erwirken, drücken wir Shift und Return gleichzeitig.<br></p><h5><img src="/js/images/indent.png" alt=""> Einzug erhöhen</h5><p>Mit dieser Funktion lassen sich verschachtelte Listen erstellen. Es lassen sich jedoch auch einfache Absätze einrücken.<br></p><h5><img src="/js/images/outdent.png" alt=""> Einzug vermindern</h5><p>...macht den Einzug wieder rückgängig.<br></p><h5><img src="/js/images/bold.png" alt=""> Fett</h5><p>Mit einem Klick auf diesen Button wird der aktuell markierte Text fett dargestellt.<br></p><h5><img src="/js/images/italic.png" alt=""> Kursiv</h5><p>Mit einem Klick auf diesen Button wird der aktuell markierte Text kursiv dargestellt.</p><h5><img src="/js/images/underline.png" alt=""> Unterstrichen</h5><p>Mit einem Klick auf diesen Button wird der aktuell markierte Text unterstrichen dargestellt.<br></p><h5><img src="/js/images/strike.png" alt=""> Durchgestrichen</h5><p>Mit einem Klick auf diesen Button wird der aktuell markierte Text durchgestrichen dargestellt.<br></p><h5><img src="/js/images/sup.png" alt=""> Text hochstellen</h5><p>Damit können etwa Hochkommastellen dargestellt werden: 10<sup>3</sup> oder m<sup>2</sup>. Das Hoch- oder Tiefstellen sollte keinesfalls zur Verkleinerung der Schrift verwendet werden.<br></p><h5><img src="/js/images/sub.png" alt=""> Text tiefstellen</h5><p>Damit lassen sich Indizes, Suffixe und dergleichen darstellen wie etwa bei chemischen Formeln: CO<sub>2</sub>.<br></p><h5><img src="/js/images/undo.png" alt=""> Befehle rückgängig machen</h5><p>Damit können Eingaben und Befehle wieder rückgängig gemacht werden. Funktioniert nicht im Internet Explorer!<br></p><h5><img src="/js/images/redo.png" alt=""> Befehle wiederherstellen</h5><p>Damit können rückgängig gemachte Eingaben und Befehle wiederhergestellt werden. Funktioniert nicht im Internet Explorer!</p><h5><img src="/js/images/link.png" alt=""> Link einfügen</h5><p>Dieser Button öffnet den Dialog, um Verknüpfungen (Links) herzustellen. Zuerst wählen wir die Textpassage aus, mit der wir verlinken wollen. Nach dem Öffnen des Dialog können wir unter <acronym title="Uniform Resource Locator" lang="en">URL</acronym> eine mit http:// beginnende Internetadresse eingeben. Verlinkungen auf eigene Angebote lassen sich am einfachsten über den Linkassistenten (Klick auf das Ordner-Symbol) bewerkstelligen.</p><p>Unter "Titel" kann ein zusätzlicher Text zur Beschreibung des Links eingegeben werden, was vor allem dann notwendig ist, wenn der verlinkte Text über den Link nichts aussagt, wie etwa "hier", "weiter" oder "mehr". Unter "Ziel" haben wir die Möglichkeit, einen Link in einem neuen Fenster öffnen zu lassen. In diesem Fall kann im Titel auch mit "Öffnet in neuem Fenster" darauf hingewiesen werden.</p><p>Der Link wird nach einem Klick auf "OK" gesetzt.<br></p><h5><img src="/js/images/unlink.png" alt=""> Link entfernen</h5><p>Entfernt einen zuvor markierten Link.<br></p><h5><img src="/js/images/specialchar.png" alt=""> Sonderzeichen einfügen</h5><p>Dieser Button öffnet den Dialog zur Auswahl von Sonderzeichen. Das gewünschte Sonderzeichen wird einfach angeklickt, um es an der aktuellen Cursorposition einzufügen. Damit lassen sich vor allem gängige typographische Zeichen verwenden, die auf der Tastatur nicht vertreten sind, wie etwa der Gedankenstrich (–), der lange Gedankenstrich (—) oder das Copyright-Zeichen (©), um nur einige zu nennen.<br></p><h5><img src="/js/images/image.png" alt=""> Bild einfügen</h5><p>Öffnet den Dialog zum Einfügen eines Bildes oder eines Bildobjektes aus der Bilddatenbank. Dazu geben wir unter URL den absoluten Pfad einer Bilddatei ein oder wählen mit Hilfe des Bildassistenten ein Bild aus der Bilddatenbank aus. Bei letzterer Methode sind wir auf der sicheren Seite.</p><p>Unter Alternativtext geben wir in einem kurzen Satz über den Inhalt des Bildes Bescheid, zum Beispiel: "Eingestürztes Haus in Köln". Der Alternativtext kann bei rein dekorativen Grafiken entfallen.</p><p>Unter "Größe" kann zwischen den vorskalierten Bildgrößen aus der Bilddatenbank ausgewählt werden. Ein Haken bei "vergrößern" erlaubt die Vergrößerung des Bildes mit einem so genannten Lightbox-Effekt.</p><p>Der Umfluss kontrolliert die Lage des Bildes etwa links oder rechts vom Text. Beides lässt sich freilich nur dann bewerkstelligen, wenn die Größe des Bildes es sinnvollerweise zulässt. Andernfalls ist es besser, keinen Umfluss einzustellen (Standard).</p><p>Im Allgemeinen orientiert sich die Positionierung des Bildes am Text-Cursor, allerdings sollte man diese im besten Fall zu Beginn eines Absatzes wählen und nicht irgendwo mitten in einem Textfluss, da dieser sonst unterbrochen wird. Man braucht also den Cursor nicht rechts platzieren, um ein Bild rechts vom Absatz zu haben.</p><p>Mit Bildunterschrift und Copyright lassen sich die entsprechenden Texte eingeben. Ein Ausfüllen dieser Texte bewirkt in Zusammenhang das Einfügen eines HTML-Konstruktes.<br></p><h5><img src="/js/images/wai_tool.png" alt=""> Werkzeuge zur Zugänglichkeit</h5><p>Mit diesem Werkzeug lassen sich einige Auszeichnungen realisieren, die für barrierefreie Texte notwendig sind: Auszeichnung von Sprachwechsel, von Abkürzungen und Akronymen. Zuerst den Text markieren. Unter "Auszeichnung" zwischen "Sprache", "Abkürzung" und "Akronym" wählen. Bei Sprachwechsel unter "Sprache" die von der Standardsprache abweichende Sprache auswählen, etwa "English" wie in diesem Beispiel: some english text. Die Auszeichnung hat in der Regel keine optische Auswirkung auf der Website, wird jedoch im Editor grau unterstrichen und mit dem ISO-Code der Sprache versehen (etwa "EN" für Englisch). Mit dem Einsatz von Sprachwechsel können Screenreader die abweichenden Texte wieder korrekt vorlesen und Suchmaschinen die Texte besser indizieren.</p><p>Abkürzungen wie z.B. sollten generell vermieden werden, da sie weder hübsch aussehen noch das Textverständnis fördern. Mit "Abkürzung" lässt sich der markierte Text, die Abkürzung, mit der Langversion ergänzen: <abbr title="zum Beispiel">z.B.</abbr> Das macht freilich nur Sinn bei aus irgendwelchen Gründen unvermeidbaren Abkürzungen, etwa in juristischen Texten.</p><p>Das Gleiche gilt für Akronym. Akronyme sind Abkürzungen eines Begriffes, die aber wie ein Wort ausgesprochen werden, wie etwa <acronym title="National Aeronautics and Space Administration" lang="en">NASA</acronym>. In diesem Fall ist das Akronym auch in einer abweichenden Sprache, was hier in der selben Auszeichnung mit dem Sprachattribut ausgewählt werden kann.</p><p>Abkürzungen und Akronyme haben je nach Design eine graue Unterlinie oder werden gar nicht gesondert angezeigt. In jedem Fall wird ein so genanntes Tooltip mit der ausgeschriebenen Version ausgegeben, sobald der Mauszeiger darüber geht. Hauptsächlich dient das Werkzeug für Screenreader und für die semantische Korrektheit des Textes.<br></p><h5><img src="/js/images/table.png" alt=""> Tabelle einfügen</h5><p>Mit diesem Dialog wird das Einfügen einer Datentabelle ermöglicht, die im Design vordefiniert ist und bei nicht missbräuchlicher Verwendung barrierefrei ist. Dazu notwendig sind die Angaben einer Tabellenüberschrift sowie das Hinzufügen von Spalten- und Zeilenköpfe.</p><h5><img src="/js/images/pastetext.png"> Reinen Text einfügen</h5><p>Ein Klick auf diesen Icon öffnet ein Eingabefeld, das es ermöglicht, kopierte Passagen als reinen Text einzufügen. In der Regel ist das die sicherste Variante, Texte aus anderen Programmen sauber auf die Website zu bringen. Der Text kann im Nachhinein mit den entsprechenden Absatz- und Überschriftenformaten strukturiert werden.<br></p><h5><img src="/js/images/removeformat.png" alt=""> Formatierungen entfernen</h5><p>Beim Kopieren eines Textes von einer Textverarbeitung oder aus einem anderen Medium kommen in der Regel unerwünschte und zumeist einfach falsche und irritierende Formatierungen mit. Mit einem Klick auf diesen Button werden sämtliche Formatierungen entfernt.<br></p><h5><img src="/js/images/striptags.png" alt=""> HTML säubern (nach Kopieren)</h5><p>Ähnlich wie Formatierung entfernen ist dieses Werkzeug, wobei jedoch Textstrukturen wie Absätze und Überschriften sowie Bilder erhalten bleiben.</p>', '530', '', 'de'),
( '20', '2', 'Suchbegriffe', '<p>Geben Sie hier mit Komma getrennt Schlüsselwörter ein, die speziell zu \r\ndieser Seite passen und noch nicht in den allgemeinen Schlüsselwörtern \r\n(CMS-Einstellungen) enthalten sind.</p><p>Dies dient zur Suchmaschinen-Optimierung der Website.<br></p>', '540', 'pages.keywords', 'de'),
( '21', '2', 'Beschreibung', '<p>Geben Sie hier in ein, zwei Sätzen eine kurze Beschreibung des \r\nSeiteninhaltes an. Dieser ersetzt die allgemeine Beschreibung aus den CMS-Einstellungen und wird auch in Übersichtsseiten herangezogen.<br></p>', '550', 'pages.description', 'de'),
( '22', '2', 'Veröffentlichen', '<p>Hier wird der Status der Veröffentlichung angegeben. Eine Seite kann offline also für Besucher uneinsichtig sein, was eine gute Wahl ist, solange die Seite noch nicht fertiggestellt ist.</p><p>Eine veröffentlichte Seite ist in der Suche auffindbar und kann über andere Navigationselemente zugänglich gemacht werden, wie das gerne für Impressum, AGB, Datenschutzerklärung und dergleichen gemacht wird.</p><p>In der Regel wird eine Seite auch in der Menüleiste und der Subnaviagtion aufscheinen, in diesem Fall wird der dritte Punkt ausgewählt.<br></p>', '560', 'pages.published', 'de'),
( '23', '2', 'Ordner der Seite', '<p>Der Ordner zeigt an, wo die Seite in der Menüstruktur und im Inhaltsverzeichnis aufscheint. Unterste Ebene ist der Ordner <strong>"Home"</strong>. Sämtliche Seiten und Ordner, die sich in HOME befinden, werden in der Hauptnavigation angezeigt.</p><p>Jeder\r\n Ordner kann wiederum weitere Ordner und Seiten beinhalten.</p>', '570', 'pages.parent', 'de'),
( '24', '2', 'Vorlagen', '<p>Sollten mehrere Vorlagen für das Seiten-Layout vorliegen, kann hier die entsprechende Vorlage gewählt werden.</p><p> \r\n  Die Vorlagen können von Benutzern mit Status Administrator verwaltet werden.</p>', '580', 'pages.template', 'de'),
( '25', '2', 'Sortieren', '<p>Die Seiten erscheinen in den Menüpunkten und in den \r\nInhaltsverzeichnissen in der Reihenfolge ihrer Eingabe. Das heißt: die \r\nzuletzt erstellte Seite ist als erste zu sehen. Um die Reihenfolge \r\nbeliebig zu manipulieren, gibt es das Sortierfeld.</p><p>Sortierungen können bequemer in der Tabellenübersicht vorgenommen werden.<br></p>', '590', 'pages.sort', 'de'),
( '26', '2', 'Titel anzeigen', '<p>Das Häkchen entscheidet, ob der Titel innerhalb der Seite angezeigt \r\nwerden soll, oder nicht. Sollte der Titel nicht angezeigt werden, \r\nempfiehlt es sich, diesen mit dem Format "Überschrift 1" im Textkörper der \r\nSeite einzufügen. Bei dieser Variante kann der Titel im Design der Seite\r\n integriert werden, etwa mit einem rechts- oder linksbündigen Bild.</p>', '600', 'pages.show_title', 'de'),
( '27', '2', 'Zeitsteuerung', '<p>Die Veröffentlichung (im Menü) kann auch zeitgesteuert erfolgen. Das Start-Datum setzt die Seite in den Modus "Menü & veröffentlicht", das Ende-Datum setzt sie offline.</p><p>Klappen Sie den Bereich bei Bedarf aus.<br></p>', '610', 'pages.cron', 'de'),
( '29', '7', 'Website URL', '<p>Die Internetadresse der Website inklusive http://www.<br></p>', '680', 'web_settings.website_url', 'de'),
( '30', '7', 'Das Logo der Website', '<p>Das Logo der Website dient zur unverwechselbaren Identifikation. Laden Sie hier die Bilddatei hoch oder wählen Sie eine bereits vorhandene aus. Beachten Sie, dass die Abmessungen des Bildes im Rahmen der wiedergegebenen Größe sein sollen.<br></p>', '690', 'web_settings.website_logo', 'de'),
( '31', '7', 'Schlüsselwörter', '<p>Geben Sie hier zehn bis <strong>maximal zwanzig</strong> wesentliche Schlüsselwörter ein,\r\n die den Inhalt der Website klassifizieren. Dadurch können Suchmaschinen\r\n die Website bestimmten Suchkriterien besser zuordnen. Diese Angaben werden mit den individuellen Suchbegriffen einzelner Seiten kombiniert.<br></p>', '700', 'web_settings.website_keywords', 'de'),
( '32', '7', 'Autor', '<p>Tragen Sie hier den Namen des Autors oder des Betreibers ein. Die Angabe scheint in den Meta-Daten auf.<br></p>', '720', 'web_settings.website_author', 'de'),
( '33', '7', 'Meta-Beschreibung', '<p>Umreißen Sie in ein, zwei Sätzen den Inhalt der Website. Diese Beschreibung kann durch die individuelle Beschreibung einer Seite überschrieben werden. Auch diese Angabe dient der Suchmaschinenoptimierung.</p>', '710', 'web_settings.website_description', 'de'),
( '34', '7', 'Design-tragendes Stylesheet', '<p>Hier steht der Dateiname des Stylesheets, das die Design-Definitionen \r\nder Website beinhaltet. Dieser kann gegebenenfalls auf eine bestehende \r\nalternative Datei verändert werden.</p>', '730', 'web_settings.def_css', 'de'),
( '35', '7', '"Home" nicht anzeigen', '<p>Der Menüpunkt "Home" in der Navigationsleiste kann hier optional ausgeschaltet werden. Sie gewinnen dadurch Platz.<br></p>', '740', 'web_settings.skip_home', 'de'),
( '36', '7', 'Breadcrumb anzeigen', '<p>Hier kann die Breadcrumb global aktiviert oder deaktiviert werden. Die Brotkrumen-Navigation zeigt die vertikale Position einer Seite an und dient somit der Orientierung. Bei Websites mit geringem Inhaltsvolumen kann diese ausgeschaltet werden.<br></p>', '750', 'web_settings.breadcrumb', 'de'),
( '37', '7', 'Subnavigation anzeigen', '<p>Hier kann die Sub-Navigation global aktiviert oder deaktiviert werden. Sie zeigt parallel positionierte Inhalte an und dient der Übersichtlichkeit. Bei Websites mit geringem Inhaltsvolumen kann diese ausgeschaltet werden.</p>', '760', 'web_settings.sub_nav', 'de'),
( '38', '7', 'Internationalisierung', '<p>Sollte die Website mehrere Sprachversionen unterstützen, sollten auch die Metadaten übersetzt werden. Im linken Übersichtsbaum kann die jeweilige Sprache abweichend zur Standardsprach ausgewählt werden.<br></p>', '660', '', 'de'),
( '39', '3', 'Teaser und Container', '<p>\r\nMithilfe der <span style="font-weight: bold;" class="langatt" lang="en">Teaser</span> lenken Sie die Aufmerksamkeit Ihrer Besucher auf spezielle Inhalte. Ein Teaser oder Ankündigungskasten kann aus Titel, Text und/oder Bild sowie einem Link bestehen<br></p><p>Ein <span class="langatt" lang="en"><span style="font-weight: bold;">Container</span></span> sieht ähnlich aus wie ein <span class="langatt" lang="en">Teaser</span>, kann jedoch mehrere\r\nVerweise auf andere Inhalte aufnehmen. Mit Container lassen sich also\r\nje nach Bedarf weitere Navigationselemente erstellen.</p><p>Für Teaser und Container sind Bereiche vorgesehen, die vom Administrator bei Bedarf ergänzt oder modifiziert werden können.<br></p>', '420', 'announces', 'de'),
( '40', '3', 'Link', '<p>Tragen Sie hier die URL des Links ein zu dem der Kasteninhalt oder ein Container-Punkt führen soll.</p><p>Wollen Sie zum Beispiel, dass der Eintrag zur Nachrichtenseite "Der Standard" führt, schreiben Sie hier <a href="http://www.derstandard.at">"http://www.derstandard.at".</a>  Um einen Link auf die eigene Seite einzufügen, benutzen Sie den <em>Linkassistenten</em> indem Sie auf das Ordnersymbol klicken. Es geht dann ein neues Fenster auf, in dem  die betreffende Seite bequem ausgewählt werden kann.</p>', '890', 'announces.link', 'de'),
( '41', '3', 'Text des Teasers', '<p>Geben Sie hier beliebigen Text \r\nein. Beachten Sie jedoch, dass zuviel Text die Übersichtlichkeit Ihrer \r\nWebseite beeinträchtigen kann.</p>', '900', 'announces.text', 'de'),
( '42', '3', 'Bereich', '<p>Hier können sie wählen, in welchem Bereich der Teaser aufscheinen soll.<br></p>', '910', 'announces.active', 'de'),
( '43', '3', 'Sortieren', '<p>Die Teaser erscheinen in der Reihenfolge ihrer Eingabe. Das heißt: der \r\nzuletzt erstellte Kasten ist als erster zu sehen. Um die Reihenfolge \r\nbeliebig zu manipulieren, gibt es das Sortierfeld.</p><p>Sortierungen können bequemer in der Tabellenübersicht vorgenommen werden.</p>', '920', 'announces.sort', 'de'),
( '44', '3', 'Sprachauswahl', '<p>Bei Mehrsprachigkeit kann hier ausgewählt werden, zu welcher Sprachvariante der Teaser gehört.<br></p>', '930', 'announces.lang', 'de'),
( '45', '3', 'Bild hinzufügen', '<p>Sie können Ihrem Kasten ein kleines Bild hinzufügen. Dazu sind zwei Methoden möglich.</p><ol><li>Das Bild befindet sich in Form einer digitalen Bilddatei (JPG, GIF, PNG) auf Ihrem Rechner.<br>In diesem Fall gehen Sie unter "<strong>Bild hochladen</strong>"\r\n auf "Durchsuchen". Es öffnet sich ein Fenster, mit dessen Hilfe Sie \r\neine Bilddatei von der Festplatte Ihres Computers auswählen können. <br></li><li>Das Bild wurde bereits hochgeladen und befindet sich in der Bilddatenbank.<br>Klicken Sie unter "<strong>vorhandenes Bild</strong>"\r\n auf das Ordnersymbol. Es öffnet sich ein Fenster, mit dessen Hilfe Sie \r\neine Bilddatei aus der Bilddatenbank auswählen können. Der Dateiname \r\nsowie die Kleindarstellung des Bildes werden angezeigt.</li></ol>', '940', 'announces.picture', 'de'),
( '46', '3', 'Alternativtext', '<p>Beschreiben Sie hier in aller Kürze, was auf dem Bild zu sehen \r\nist. Der Alternativtext kann entfallen, wenn ein Bild ausschließlich als\r\n Dekoration dient.</p>', '950', 'announces.alternative', 'de'),
( '47', '3', 'Zeitsteuerung', '<p>Das Erscheinen des Teasers kann auch zeitgesteuert erfolgen. Das \r\nStart-Datum aktiviert den Eintrag im angegebenen Bereich, \r\ndas Ende-Datum setzt ihn inaktiv.</p><p>Klappen Sie den Bereich bei Bedarf aus.</p>', '960', 'announces.cron', 'de'),
( '48', '3', 'Container-Titel', '<p>Geben Sie hier eine kurzen Bezeichnungstext für den Container-Eintrag ein. </p>', '980', 'container.text', 'de'),
( '49', '3', 'Container-Einträge', '<p>Um einen neuen \r\nEintrag für einen Container zu erstellen, klicken Sie auf "Neuer \r\nEintrag". Bestehende Einträge werden mit einem Klick auf das \r\nEditiersymbol zur Bearbeitung geöffnet.</p><p>Einzelne Einträge werden mit einem Klick auf das Löschsymbo gelöscht.</p><p>Um die Einträge zu sortieren, ziehen Sie die Tabellenzeilen in die gewünschte Reihenfolge. Danach klicken Sie auf "Sortieren".</p>', '970', 'container', 'de'),
( '50', '3', 'Link eines Container-Eintrages', '<p>Geben Sie hier einen Link ein \r\noder suchen Sie mit Hilfe des Linkassistenten nach einer Seite oder \r\neinem Dokument Ihrer eigenen Website. Zum Öffnen des Linkassistenten \r\nklicken Sie auf das Ordnersymbol neben dem Eingabefeld.\r\n</p>', '990', 'container.link', 'de'),
( '51', '6', 'Bildarchiv', '<p>Das Bildarchiv bietet eine Übersicht über \r\nalle vorhandenen Bilder, die in Ihrer Website verwendet werden können, \r\noder bereits verwendet worden sind. <br></p><p>Die Bilder lassen sich \r\nhier auf den Webserver hochladen, beschriften, katalogisieren und \r\ngegebenenfalls nachbearbeiten (drehen, spiegeln, zurechtschneiden).</p>', '280', 'images', 'de'),
( '52', '6', 'Bild hochladen', '<p>Mit einem Klick auf die\r\n Schaltfläche "Durchsuchen" öffnet sich der Datei-Manager Ihres \r\nWebbrowsers. Hier suchen Sie das gewünschte Bild aus. Beachten Sie, dass\r\n im Web ausschließlich die Bildformate <strong>PNG,</strong> <strong>GIF,</strong> <strong>JPG</strong> verwendbar sind.</p>\r\n  <p>Um mehrere Bilder gleichzeitig hochzuladen, können Sie Bilddateien aus einem Dateibrowser direkt in das vorgesehene Feld ziehen.<br></p>', '310', 'images.filename', 'de'),
( '53', '6', 'Titel', '<p>Ein aussagekräftiger Titel hilft \r\nIhnen, Bilder später wieder mit Hilfe von Suchbegriffen zu finden. Dies \r\nist vor allem beim Aufbau größerer Bildarchive von Vorteil.\r\n</p>', '290', 'images.title', 'de'),
( '54', '6', 'Beschreibung', '<p>Vor allem beim Aufbau großer Bildarchive leistet das Beschreibungsfeld nützlich Dienste.</p>', '300', 'images.description', 'de'),
( '55', '6', 'Mappe', '<p>Wählen Sie hier jene Mappe \r\n(Bildordner) aus, in der Sie das Bild ablegen wollen. Die Mappen selbst \r\nkönnen Sie unter "Neue Mappe" anlegen.</p>', '330', 'images.parent', 'de'),
( '56', '6', 'Urheberrecht', '<p>Geben Sie hier zur internen Klärung den Inhaber der Urheberrechte an.<br></p>', '320', 'images.copyright', 'de'),
( '57', '8', 'Beschneiden', '<p>Hier lassen sich Bilder, die bereits in der Bilddatenbank sind und somit am Server, nachträglich beschneiden.</p><p>Positionieren\r\n sie den Rahmen an die gewünschte Stelle des Bildes, indem Sie mit \r\ngedrückter linker Maustaste den Ausschnitt bewegen.<br></p><p>Die \r\ngewünschte Ausschnittsgröße erhalten Sie, indem Sie die Anfasser des \r\nRahmens mit gedrückter Maustaste in die gewünschte Länge oder Breite \r\nziehen.</p><p>Sobald der Rahmen dem neuen Ausschnitt entspricht, kann das Bild mit einem Klick auf "Beschneiden" zugeschnitten werden.</p><p>Ferner haben Sie die Wahl entweder das Originalbild zu überschreiben oder den Namen für eine neue Bild-Datei anzugeben.</p><p>Es können auch fixe Seitenverhältnisse wie 4:3, 3:4 oder 16:9 ausgewählt werden. <br></p>', '340', 'images.crop', 'de'),
( '58', '8', 'Spiegeln', '<p>Das Bild kann bei Bedarf horizontal oder vertikal gespiegelt werden. Wählen Sie dazu das gewünschte Resultat aus<br></p><p>Ferner haben Sie die Wahl entweder das Originalbild zu überschreiben oder den Namen für eine neue Bild-Datei anzugeben.</p>', '350', 'images.mirror', 'de'),
( '59', '8', 'Rotieren', '<p>Wählen Sie die gewünschte Rotation aus. <br></p><p>Ferner haben Sie die Wahl entweder das Originalbild zu überschreiben oder den Namen für eine neue Bild-Datei anzugeben.</p>', '360', 'images.rotate', 'de'),
( '60', '6', 'Bildvorschau', '<p>Hier sehen Sie alle verfügbaren vorskalierten Bildgrößen.<br></p>', '370', 'images.preview', 'de'),
( '61', '8', 'Bildname', '<p>Geben Sie hier einen neuen Dateinamen des Bildes ein, falls das bestehende nicht überschrieben werden soll. Das ist vor allem für Bilder ratsam, die auf der Website bereits im Einsatz sind.<br></p>', '400', 'images.newfile', 'de'),
( '62', '9', 'Die Benutzeroberfläche', '<p>Die Benutzeroberfläche teilt sich in folgende Areale auf:</p><ul><li>Statusleiste</li><ul><li>Name und Link zur Website</li><li>Anzeige von Meldungen<br>Ein gelbes Dreieck weist auf etwaige Meldungen hin, die bereits ausgeblendet worden sind und mit einem Klick auf das Symbol wieder eingeblendet werden können.<br></li><li>Link zur Hilfe</li><li>Benutzer<br>Der Icon gibt Auskunft über den Benutzerstatus.</li><li>Link zur Abmedlung<br></li></ul><li>Karteireiter mit Hauptmenü<br>sie beinhaltet alle wesentlichen Funktionen von Consentio.</li><li>Hierarchische Darstellung von Daten<br>Auf\r\n der linken Seite wird in Form von verschachtelten Ordnern die \r\nhierarchische Struktur der jeweils angezeigten Daten sichtbar. Wobei \r\noffene Aktenordner den momentanen Ort anzeigen.</li><li>Datenanzeige oder Eingabemaske<br>Auf\r\n der rechten Seite im Hauptfenster sind schließlich die Daten des \r\ngewünschten Menüs oder Ordners sichtbar. Das ist in der Regel eine Liste\r\n der vorhandenen Daten mit Suchfunktion oder eine Eingabemaske, um Daten zu bearbeiten \r\noder neu zu kreieren.</li></ul>', '380', '', 'de'),
( '63', '9', 'Sortieren in Listenansicht', '<p>In vielen Fällen kann eine beliebige Reihenfolge der diversen Einträge (zum Beispiel beim Seitenmanagement) durch das Sortieren hergestellt werden.<br></p><p>Das Sortieren der\r\n Reihenfolge in der Listenansicht wird entweder durch ein Ziehen des \r\nbetreffenden Eintrages (Tabellenzeile) an die gewünschte Stelle \r\nbewerkstelligt oder durch Manipulation des Sortierschlüssels. Sollte \r\netwa ein Eintrag zwischen zwei anderen Einträgen rutschen, deren \r\nSortierschlüssel 20 und 30 betragen, geben Sie einfach eine Zahl \r\nzwischen 20 und 30 ein.</p><p>Ist die gewünschte Reihenfolge hergestellt, klicken Sie auf "Sortieren" am Listenende.</p><p>In\r\n vielen Fällen ist eine Sortierung nur innerhalb eines bestimmten \r\nBereiches möglich. Im Seiten-Management zum Beispiel erfolgt die \r\nÄnderung der Reihenfolge nur innerhalb eines Ordners, der links im Baum \r\nausgewählt werden kann.</p>', '390', 'common.sort', 'de'),
( '64', '10', 'Bildermappe', '<p>Unter <strong>"Mappe"</strong> lassen \r\nsich beliebig viele ineinander verschachtelte Mappen anlegen, in die Sie\r\n Ihre Bilder ablegen oder weiter Mappen erstellen. Damit lässt sich bei \r\nnachvollziehbarer Logik auch bei einem großen Bildarchiv Übersicht \r\nbewahren.</p>', '260', 'img_folder', 'de'),
( '65', '10', 'Titel der Mappe', '<p>Geben Sie hier einen aussagekräftigen Begriff ein, der den Themenschwerpunkt der darin enthaltenen Bilder angibt, z.B. "<em>Politiker</em>", <em>"Katzen"</em> oder dergleichen.\r\n</p>', '250', 'img_folder.name', 'de'),
( '66', '10', 'Mappe der Mappe', '<p>Wählen Sie hier die Mappe aus, in der diese Mappe enthalten sein soll, z.B. könnte "<em>Politiker</em>" in der Mappe "<em>Menschen</em>" angelegt werden. Die unterste Ebene ist "<em>Bilddatenbank</em>".</p>', '240', 'img_folder.parent', 'de'),
( '67', '4', 'Dateien hochladen', '<p>Dateien, die den Besuchern zum Herunterladen angeboten werden, werden im "Dateimanager" hochgeladen. Sämtliche hochgeladenen Dateien lassen sich mit dem Link-Assistenten unter dem Punkt <em>"Dokumente"</em> als Link verknüpfen.</p><p>Im Verzeichnis "<em>documents</em>" können auch beliebig viele Unterverzeichnisse anlegt werden.</p><p>In der linken Spalte finden Sie dieVerzeichnis -Übersicht. Rechts werden die Verzeichnisse und Dateien des gewählten Verzeichnisses \r\nangezeigt. Diese können je nach Dateityp heruntergeladen oder besichtigt\r\n sowie gelöscht werden.</p><p>Benutzer mit Wartungsstatus haben hier darüber hinaus Zugriff auf systemrelevante Dateien und Verzeichnisse, etwa um Grafiken hochzuladen oder Skriptdateien zu editieren.<br></p>', '230', 'filemanager', 'de'),
( '68', '4', 'Hochladen', '<p>Unter "Hochladen" wählen Sie mit "Durchsuchen" eine Datei von Ihrem \r\nPC aus. Mit einem Klick auf  OK, laden Sie die Datei in das aktuelle \r\nVerzeichnis des Webservers. Um in einen anderen Ordner zu gelangen, \r\nwählen Sie links den gewünschten Ordner aus.</p>\r\n<h3>Mehr Komfort mit HTML5</h3><p>Browser, die Funktionen von HTML5 \r\nunterstützen, bieten ferner die Möglichkeit, mehrere Dateien \r\ngleichzeitig hochzuladen. Mit gedrückter STRG-Taste lassen sich im mit\r\n "Durchsuchen" geöffnetem Fenster mehrere Dateien auswählen. Man kann \r\naber auch von einem beliebigen Dateimanager Dateien in das dafür \r\nvorgesehene Feld ziehen.</p>\r\n<p>Das Hochladen erfolgt unmittelbar und wird mit einem \r\nFortschrittsbalken angezeigt. Sobald alle Dateien eine Rückmeldung \r\nerhalten haben, sind diese verfügbar.</p>', '440', 'uploads', 'de'),
( '69', '4', 'Neuer Ordner', '<p>Geben Sie hier den Namen des \r\nneuen Ordners an. Mit einem Klick auf "OK" wird der Ordner im aktuellen \r\nVerzeichnis angelegt. <br></p>', '450', 'filemanager.newdir', 'de'),
( '70', '7', 'Sprachen festlegen', '<p>Wenn die Website in mehreren Sprachen verfügbar sein soll, können hier die Sprachvarianten aktiviert und deaktiviert werden.</p>', '770', 'lang_settings', 'de'),
( '71', '7', 'Komponenten', '<p>Komponenten sind HTML-Teile der Website, die entweder generiert werden oder frei zu erstellen und zu bearbeiten sind. Je nach Bedarf kann für die einzelne Komponente ein WYSIWYG-Editor oder ein Skripteditor verwendet werden. Letzteres empfiehlt sich für eingebettete Javascripts.</p><p>Komponenten werden in den HTML-Vorlagen als Platzhalter eingefügt.<br></p>', '780', 'components', 'de'),
( '72', '7', 'Name der Komponente', '<p>Ein Name wie zum Beispiel MY_OWN_PRIVATE_ONE kann in den HTML-Vorlagen als Platzhalter &&&&MY_OWN_PRIVATE_ONE&&&& eingefügt werden.<br></p><p>Der Name der Komponente wird in Großbuchstaben geschrieben und darf keine Leerzeichen enthalten. </p>', '790', 'components.name', 'de'),
( '73', '7', 'Titel der Komponente', '<p>Ein aussagekräftiger, für Menschen verständlicher Titel für die Komponente.<br></p>', '800', 'components.title', 'de'),
( '74', '7', 'Bechreibung', '<p>Eine Beschreibung hilft vor allem bei Javascript-Komponenten den Sinn und Verwendungszweck einer Komponente festzuhalten.<br></p>', '810', 'components.description', 'de'),
( '75', '7', 'Aktivierung', '<p>Komponenten können hier auch vorübergehend deaktiviert werden, ohne dass man den Platzhalter aus der oder den Vorlagen löscht.<br></p>', '820', 'components.active', 'de'),
( '76', '7', 'Sprachgültigkeit', '<p>Die Gültigkeit einer Komponente kann für bestimmte Sprachen oder sprachübergreifend (mit *) angegeben werden.<br></p>', '830', 'components.lang', 'de'),
( '77', '7', 'Typ', '<p>Hier kann der Typ zwischen Skript und WYSIWYG geändert werden. Nach der Speicherung wird die Komponente mit dem passenden Editor geöffnet. Beachten Sie, dass Javascript im WYSIWYG-Editor beeinträchtigt werden kann.<br></p>', '840', 'components.type', 'de'),
( '78', '7', 'Vorlagen Manager', '<p>Hier werden die Seitenvorlagen erstellt oder bearbeitet. Wählen Sie für die jeweiligen Bereich der Seitenvorlage eine passende HTML-Vorlage aus.</p><p>Neue HTML-Vorlagen werden unter HTML-Vorlagen angelegt oder modifiziert.<br></p>', '850', 'templates', 'de'),
( '79', '7', 'Name der Seitenvorlage', '<p>Geben Sie hier den Namen der Vorlage an, so wie er im Auswahlfeld der Seitenverwaltung aufscheinen soll.<br></p>', '880', 'templates.name', 'de'),
( '80', '11', 'Benutzer', '<p>In der Benutzerverwaltung wird festgelegt, wer auf die Verwaltung der \r\nWebsite zugreifen darf, und welche Befugnisse der Benutzer dabei hat.</p>', '210', 'user', 'de'),
( '81', '11', 'Benutzername', '<p>Geben Sie hier den Namen des Benutzers an, mit dem sich der Benutzer anmelden soll. <em>Für das Nachrichten-Modul</em><span style="font-style: italic;"> </span>empfiehlt es sich, den vollständigen Namen anzugeben, da dieser als Autor redaktioneller Artikel aufscheint.\r\n</p>', '200', 'user.name', 'de'),
( '82', '11', 'Kürzel', '<p>Das Kürzel dient zur Identifikation des Benutzers und wird beim Nachrichten-Modul als Autorenkürzel angezeigt.\r\n</p>', '190', 'user.short', 'de'),
( '83', '11', 'Benutzerstatus', '<p>\r\nWählen Sie hier aus welchen Benutzerstatus der Benutzer haben soll.</p><ul><li><strong>Benutzer:</strong></li><ul><li>Seiten anlegen und editieren</li><li>Teaser anlegen und editieren</li><li>Bilder hochladen<br></li></ul><li><strong>Administrator</strong>:</li><ul><li>alles, was Benutzer können<br></li></ul><ul><li>Benutzer anlegen</li><li>Dateien verwalten</li><li>diverse Einstellungen vornehmen</li></ul><li><strong>Wartung</strong><br>hat darüber hinaus uneingeschränkten Zugang auf systemrelevante Einstellungen und Funktionen. (Dieser Status kann nur von Benutzern mit Wartungslevel vergeben werden.)<br></li></ul>', '180', 'user.level', 'de'),
( '84', '11', 'Farbschema', '<p>Wählen Sie ein Farbschema aus.<br></p>', '170', 'user.scheme', 'de'),
( '85', '11', 'Optionen', '<p>Hier kann der Benutzer sein Passwort ändern, Sprache und Farbschema der Benutzeroberfläche auswählen sowie die Hilfepunkte aktivieren oder deaktivieren.<br></p>', '160', 'options', 'de'),
( '86', '12', 'Menü-Register', '<p>Verwaltung der registrierten Funktionen und ihr Aufscheinen in den diversen Menüs.<br></p>', '20', 'register', 'de'),
( '87', '12', 'Name', '<p>Der Name ist der i18n-Schlüssel, der unter Sprachen einzutragen und zu übersetzen ist. Nicht übersetzte Namen werden mit eckigen Klammern versehen.<br></p>', '30', 'register.name', 'de'),
( '88', '12', 'Funktionsaufruf', '<p>Der Name, mit dem die Funktion aufgerufen wird (identisch mit dem Parameter _id und der Vorgabe $forms[\'myconf\']).<br></p>', '50', 'register.call', 'de'),
( '89', '12', 'Plugin', '<p>Der Name des Plugins, in dem sich die Funktion befindet.</p><p>Beispiele: Die Funktion "foo" befindet sich in bar.php, so wird hier "bar" eingegeben. Die Funktion "bar" ist in "bar.php", so braucht hier nichts eingetragen werden.<br></p>', '40', 'register.plugin', 'de'),
( '90', '12', 'zusätzliche Parameter', '<p>Allfällige zusätzliche Parameter für den Funktionsaufruf, wie etwa "&todo=edit", um in die Eingabemaske eines neuen Datensatzes zu gelangen.<br></p>', '60', 'register.params', 'de'),
( '91', '12', 'Vorlage für GUI', '<p>Auswahl der Vorlage von der Benutzeroberfläche.<br></p>', '70', 'register.gui', 'de'),
( '92', '12', 'Benutzer-Status', '<p>Ab welchem Benutzer-Status kann diese Funktion aufgerufen werden.<br></p>', '80', 'register.level', 'de'),
( '93', '12', 'Icon', '<p>Auswahl des Icons, der die Funktion darstellt. Neue Icons können in die Verzeichnisse co_icons (16*16px) und co_icons/48 (48*48px) hochgeladen werden.<br></p>', '90', 'register.icon', 'de'),
( '94', '12', 'Gruppe', '<p>Auswahl der Gruppe, in der die Funktion enthalten ist.<br></p>', '100', 'register.tab', 'de'),
( '95', '12', 'In der Übersicht', '<p>Die Funktion in der Übersicht aktivieren.<br></p>', '120', 'register.start', 'de'),
( '96', '12', 'Im Karteireiter', '<p>Die Funktion als Karteireiter anzeigen.<br></p>', '130', 'register.top', 'de'),
( '97', '12', 'In der Gruppen-Ansicht', '<p>Die Funktion in einer Gruppenansicht anzeigen.<br></p>', '140', 'register.group', 'de'),
( '98', '12', 'Im Frontend zulassen', '<p>Die Funktion darf auch aus dem Frontend, also ohne Login aufgerufen werden (bei Einhaltung aller Vorsichtsmaßnahmen).<br></p>', '150', 'register.frontend', 'de'),
( '99', '12', 'CSS Manager', '<p>In der CSS Verwaltung können die Stylesheets in einem Code-Editor berabeitet werden. Wählen Sie links die CSS-Datei aus, die bearbeitet werden soll.</p><p>Die Farbpalette hilft, Farben zu mischen und Farbcodes in die Datei einzufügen.</p><p>Markieren Sie einen hexadezimalen Code im Stylesheet und laden diesen mit dem Icon mit den zwei Pfeilen in die Palette. Ein Klick auf den Icon mit dem Pfeil nach rechts fügt den Farbcode in die aktuelle Position oder Markierung im Editor ein.</p><p>Mit einem Klick auf eine beliebige Farbfläche wird die aktuelle Farbe neu geladen. Die aktuelle Farbe kann mit einem Klick auf die obere oder untere Farbfläche auf das Mischpult übertragen werden. Es werden zwischen den beiden Farbflächen nun 10 Schattierungen der beiden Farben generiert, die wiederum als aktuelle Farbe gewählt werden kann.<br></p>', '10', 'cssadmin', 'de'),
( '100', '12', 'Menü-Gruppen', '<p>Gruppen für Menüeinträge erstellen und verwalten<br></p>', '110', 'rgroups', 'de'),
( '101', '14', 'HTML-Vorlagen', '<p>Sämtliche HTML-Vorlagen und -Schnippsel sowohl für die Benutzeroberfläche (Gruppe GUI)  als auch für die Vorlagen des CMS (Gruppe CMS) werden hier zentral verwaltet.</p><br>', '0', 'snippets', 'de'),
( '102', '14', 'Schlüssel', '<p>Der Schlüssel ist eine möglichst aussagekräftige Bezeichnung ohne Leerzeichen, mit deren Hilfe dieser Schnippsel oder diese Vorlage mit der Parserfunktion aufgerufen werden kann.</p><p>Beispiel:</p><p>Der Schlüssel lautet "cms_foo_title", Die Parserfunktion kann nun mit parse_in(\'cms_foo_title\', $data) aufgerufen werden.<br></p>', '0', 'snippets.key', 'de'),
( '103', '14', 'Beschreibung der HTML-Vorlagen', '<p>HTML-Vorlagen können das Seitenlayout bestimmen oder auch nur einen winzigen Teil einer Daten-View. Um die Übersicht in der Administration zu bewahren hilft der Beschreibungstext.<br></p>', '0', 'snippets.description', 'de'),
( '104', '14', 'Der Code', '<p>Hier ist der HTML-Code zu erstellen und zu bearbeiten. Um Daten in die jeweilige Vorlage einzufügen, werden Platzhalter verwendet, die mit je vier buchhalterischen Und umschlossen sind.</p><p>In der Regel sind die Platzhalter Namen von Komponenten oder von Daten. Die Komponente mit Namen MY_OWN_ONE wird mit &&&&MY_OWN_ONE&&&& in die Vorlage gebracht.</p><p>Bei eigenen Parsern würde der Platzhalter &&&&title&&&& den Wert von $data[\'tile\'] einfügen.<br></p><p>Beispiel:</p><p>Name: cms_foo_title</p><p>HTML-Code:</p><pre><h1>&&&&title&&&&</h1><br></pre><p>bei parse_in(\'cms_foo_title\', $data) mit $data[\'title\'] = "Foo Titel" ist das Ergebnis:</p><pre><h1>Foo Titel</h1><br></pre>', '0', 'snippets.code', 'de'),
( '105', '14', 'Gruppe', '<p>Wählen Sie hier die Gruppe, in der sich die HTML-Vorlage befindet. Die verschachtelte Gruppierung dient zur Übersichtlichkeit der HTML-Vorlagen.<br></p>', '0', 'snippets.group', 'de'),
( '106', '14', 'Gruppen der HTML-Vorlagen', '<p>Die verschachtelte Gruppierung dient zur besseren Übersichtlichkeit der HTML-Vorlagen. Benutzen Sie die vorgegeben Logik soweit wie möglich.</p><p>HTML-Vorlagen für Daten-Views des Frontends zum Beispiel werden am besten in einer eigenen neuen Gruppe in CMS -> SECTION angelegt, etwaige zusätzliche Javascript-Schnippsel für Erweiterungen der Benutzeroberfläche in GUI -> SCRIPTS.<br></p>', '0', 'html_group', 'de'),
( '107', '15', 'Internationalisierung', '<p>Die Internationalisierung beruht auf dem Prinzip, dass ein i18n-Schlüssel verwendet wird, der in jede beliebige Sprache übersetzt wird. So lautet der Schlüssel für "Benutzer" "user", dieser wird, sofern die englische Sprache gefragt ist, zu "User".</p><p>Im Code wird die Ausgabe der jeweils aktuellen Sprache in diesem Fall mit i18n(\'user\') aufgerufen.</p><p>Werden im CMS weitere Sprachen aktiviert, wird der Sprachtabelle eine weitere Spalte für Übersetzungen in diese Sprache hinzugefügt. Da einige wenige Begriffe auch im Frontend verwendet werden, ist hier gegebenenfalls eine Übersetzung dieser Begriff notwendig.</p><p>Schlüssel, die nicht übersetzt sind, werden in eckiger Klammer angezeigt. Diese Schlüssel können nun in der Sprachtabelle hinzugefügt werden.</p><p>i18n steht für <em>Internationalisation</em>, ein \'i\' 18 weitere Buchstaben und ein \'n\'.<br></p>', '0', 'languages', 'de'),
( '108', '15', 'i18n Schlüssel', '<p>Das Schlüsselwort, das anstelle des übersetzten Begriffs verwendet wird.<br></p>', '0', 'languages.index', 'de'),
( '109', '15', 'Gruppe der Begriffe', '<p>Mit dem Namen des Plugins bei Gruppe werden Begriffe, die ausschließlich in einem bestimmten Plugin verwendet werden, auch nur innerhalb des angegebenen Plugins geladen. Im Zweifelsfall und für Begriffe des Frontends "common" verwenden.<br></p>', '0', 'languages.group', 'de'),
( '110', '15', 'Spracheintrag', '<p>Es folgen die Übersetzungen in die jeweilige Sprache, wobei der zweistellige ISO-Code für die jeweilige Sprache steht.<br></p>', '0', 'languages.de', 'de'),
( '111', '16', 'Datenbank', '<p>Mit diesem Werkzeug können die Tabellen der Anwendung im Rohformat betrachtet und editiert werden.</p><p>Mit dem SQL-Fenster werden SQL-Statements jeder Art ausgeführt oder angezeigt.<br></p>', '0', 'tables', 'de'),
( '112', '16', 'Tabellen-Dump', '<p>Es wird ein SQL-Dump der Tabelle oder der View in einem Textfeld ausgegeben. Der Dump kann so wie er ist andernorts eingelesen werden.<br></p>', '0', 'tables.dump', 'de');




















