<?php
# @Author: consentio
# @Date:   2022-04-09T17:30:15+02:00
# @Project: Consentio CMS
# @Filename: newsletter_mailing.php
# @Last modified by:   consentio
# @Last modified time: 2022-05-03T14:16:08+02:00
# @License: GPL 2.0
# @Copyright: IMB Webdevelopment

# get and extend config
require_once ("lib/conf_inc.php");
require_once ("lib/share.php");
require_once ("plugins/newsletter.php");
// debug mode: display errors
if (isset($con['debug'])) {
	error_reporting(E_ALL);
	ini_set("display_errors", 1);
	}

try {
	$dns = $dba['db_driver'].":dbname=".$dba['database'].";host=".$dba['host'].";charset=utf8";
    $db = new PDO($dns, $dba['db_user'], $dba['db_pw']);
	}
catch (PDOException $e) {
    echo 'Connection failed: ' . $e->getMessage();
	exit;
	}
$newsletter = new newsletter();
$out = '';

// local only
$he = $_SERVER['REMOTE_ADDR'];
$me = $_SERVER['SERVER_ADDR'];

if ($me == $he) {
	$arg = $db->prepare("SELECT * FROM `newsletter_mailings` WHERE `closed` = 0 LIMIT 1;");
	$arg->execute();
	$mailing = $arg->fetch(PDO::FETCH_ASSOC);
	// `id`, `date`, `subject`, `body`, `count`

	if ($arg->RowCount()) {
		// wait for the next day if the limit is reached
		if ($mailing['count'] >= $newsletter->limit_per_day) {
			if ($mailing['date'] < date('Y-m-d')) {
				$out = 'go on...';
				$arg = $db->prepare("UPDATE `newsletter_mailings` SET `count` = ?, `date` = ? WHERE `id` = ?;");
				$arg->execute([0, date('Y-m-d'), $mailing['id']]);
				}
			else {$out = 'waiting...';}
			}
		else {
			$arg = $db->prepare("SELECT `email` FROM `mailing_list` WHERE `mailing` = ? ORDER BY `id` ASC LIMIT $newsletter->max_recipients;");
			$arg->execute([$mailing['id']]);
			$Tos = $arg->fetchAll(PDO::FETCH_COLUMN, 0);

			if ($arg->RowCount() == 0) {
				$arg = $db->prepare("UPDATE `newsletter_mailings` SET `closed` = 1 WHERE `id` = ?;");
				$arg->execute([$mailing['id']]);
				$count = 'closed';
				}
			else {
				// burn after reading
				$arg2 = $db->prepare("DELETE FROM `mailing_list` WHERE `mailing` = ? ORDER BY `id` ASC LIMIT $newsletter->max_recipients;");
				$arg2->execute([$mailing['id']]);

				$mail = [
						'Subject'	=> $mailing['subject'],
						'html'		=> $mailing['body'],
						'Tos'		=> $Tos
						];
				$error = $newsletter->send_mail($mail);
				$count = $mailing['count'] + $newsletter->max_recipients;
				$arg = $db->prepare("UPDATE `newsletter_mailings` SET `count` = ? WHERE `id` = ?;");
				$arg->execute([$count, $mailing['id']]);
				}
			$out = "send ".$count;
			}
	}

	if ($out) {
		file_put_contents('mail_log.txt', date('y-m-d H:i:s')." $out\n", FILE_APPEND | LOCK_EX);
		}
	}
?>
