<?php
# @Author: Rainer Imb <consentio>
# @Date:   2018-08-25 01:24:13
# @Email:  imb@consentio.at
# @Project: consentio mccurdy
# @Filename: announces.php
# @Last modified by:   consentio
# @Last modified time: 2023-08-30T18:29:28+02:00
# @License: GPL 2.0

require_once('announces_generator.php');

function plugin($html) {
	switch ($html['action']) {
		case ("container"): $html = container_admin($html); break;
		case ("boxes_admin"): $html = boxes_admin($html); break;
		default: $html = announces_admin($html);
		}
	return $html;
	}

function announces_admin($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$type = clean_var(param('type'), "n");
	$type = $type ? $type : 1;
	$box = clean_var(param('active'), "n");
	$do = (param('active') and !param('words')) ? true : false;
	$boxlist = get_boxlist();

	$form = [
		"title"			=> i18n('announces'),
		"table"			=> "announces",
		"myconf"		=> "announces",
		"orderby"		=> "sort",
		"human"			=> "title",
		"html"			=> $html,
		"rid"			=> $rid,
		"filters"		=> ["active", "lang"],
		"search"		=> ["title", "text"],
		"allow_box"		=> "both",
		"attr_to_set"	=> ["active"],
		"table_fields"	=> ["type", "title", "picture", "text", "active", "lang", "sort"]
		];

		$inputs = [
		'title' =>	[
			'type' => 'text',
			'duty' => 1
			],
		'link' =>	[
			'type' => 'link',
			],
		'text' =>	[
			'type'		=> 'bigtext',
			'rows'		=> 4
			],
		'container'		=>	[
			'type'		=> 'subform',
			'conf'		=> 'container',
			'foreign'	=> 'box'
			],
		'active' =>	[
			'caption'	=> i18n('area'),
			'type'		=> 'array',
			'extra'		=> $boxlist,
			'default'	=> 1,
			'duty' => 1
			],
		'sort' =>	[
			'type' => 'sort',
			'default' => 0,
			'do' => $do,
			],
		'lang'	=>	[
			'caption'	=> i18n('language'),
			'type'		=> 'lookup',
			'default'	=> $html['con']['ln'],
			"lid"		=> "iso639",
			"lval"		=> "language",
			"lord"		=> "language",
			"ltable"	=> "languages",
			"lclause"	=> " where `multilingual` = 'on'",
			'duty' => 1
			],
		"label1"		=> [
			"caption"	=> i18n('picture'),
			"icon"		=> "image",
			"type"		=> "fieldset"
			],
		'picture' =>	[
			'type' => 'image'
			],
		'alternative'	=>	[
			'type'		=> 'text',
			],
		"cron"		=> [
			"icon"		=> "clock",
			"type"		=> "fieldset",
			"collapsed"	=> 1
			],
		'start' =>	[
			'type' => 'date',
			'duty' => 1,
			'default' => '1970-01-01',
			],
		'box' =>	[
			'caption'	=> i18n('area'),
			'type'		=> 'array',
			'extra'		=> $boxlist,
			'default'	=> 1
			],
		'end' =>	[
			'type' => 'date',
			'duty' => 1,
			'default' => '2500-12-31',
			],
		'type'			=> [
			'type'		=> 'array',
			'extra'		=> [i18n('announces'), i18n('container')],
			'fontawesome'		=> ["align-center", "list-ul"],
			'duty'		=> 1,
			'default'	=> $type,
			],
	];

	$obj = new access($form);

	$obj->set_attribute($inputs);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], 'active', $box);
		generate_announces();
		// generate all
		generate();
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			// container should reload form after first storage
			// because of subform
			if ($type == 2 and $obj->rid == "new") {$todo = "edit"; $obj->rid = $id;}
			else {
				$html['popup'] = $obj->feedback;
				generate_announces();
				generate();
				}
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {
			$inputs = $obj->get_value($inputs);
			$type = $inputs['type']['value'];
			}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$inputs['type']['type'] = "hidden";
			if ($type == 2) {
				unset($inputs['text']);
				unset($inputs['link']);
				unset($inputs['label1']);
				unset($inputs['picture']);
				unset($inputs['alternative']);
				if ($obj->rid == "new") {
					unset($inputs['container']);
					$obj->button_text = i18n('next');
					$obj->button_fa = 'chevron-circle-right';
					}
				}
			else {unset($inputs['container']);}
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
			[i18n('new_teaser'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "align-center-add"],
			[i18n('new_container'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;type=2", "inactive", "list-ul-add"],
			[i18n('announces'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", "align-center"]
			);
		if ($html['user']['level'] > 2) {
			array_push($submen, ["Box Definitions", $html['myurl']."?sid={$html['sid']}&amp;_id=boxes_admin", "inactive", "wrench"]);
			}

		$obj->before_table = make_submenu($submen);
		if (param('_del')) {
			$obj->delete();
			generate_announces();
			generate();
			}
		$html = $obj->table($inputs);
		}
	$html['left'] = box_tree($box, $boxlist);
	return $html;
	}

function container_admin($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$box = clean_var(param('box'), "n");
	$do = $box ? true : false;

	$form = [
		"title"			=> i18n('container_entries'),
		"table"			=> "container",
		"myconf"		=> "container",
		"orderby"		=> "sort",
		"human"			=> "text",
		"html"			=> $html,
		"rid"			=> $rid,
		"filters"		=> ["box"],
		"table_fields"	=> ["text", "link", "sort"],
		"searchform"	=> 0,
		];

	$inputs = [
		'text' =>	[
			'type' => 'text',
			'duty' => 1,
			],
		'link' =>	[
			'type' => 'link',
			'duty' => 1,
			],
		'sort'			=>	[
			'type'		=> 'sort',
			'duty'		=> 1,
			'default'	=> '10',
			'do'		=> $do
			],
		'box' =>	[
			'type' => 'hidden',
			'duty' => 1,
			'default' => $box
			],
		"cron"		=> [
			"icon"		=> "clock",
			"type"		=> "fieldset",
			"collapsed"	=> 1
			],
		'start' =>	[
			'type' => 'date',
			'duty' => 1,
			'default' => '1970-01-01',
			],
		'end' =>	[
			'type' => 'date',
			'duty' => 1,
			'default' => '2500-12-31',
			],
		];

	$obj = new access($form);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], 'box', $box);
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$inputs['type']['type'] = "hidden";
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;box=$box", "inactive", "add"]
			);
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		}
	$html['gui'] = 5;
	return $html;
	}

function boxes_admin($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$boxlist = get_boxlist();

	$form = [
		"title"			=> "Box Definitions",
		"table"			=> "boxes",
		"myconf"		=> "boxes_admin",
		"orderby"		=> "id",
		"human"			=> "index",
		"html"			=> $html,
		"rid"			=> $rid,
		"search"	=> ["name", "index"],
		"table_fields"	=> ["name", "index"]
		];

	$inputs = [
		'name' =>	[
			'type' => 'text',
			'duty' => 1
		],
		'index' =>	[
			'type' => 'text'
		],
		'box' =>	[
			'type' => 'suggest',
			'duty' => 1,
			"lid" => "key",
			"lval" => "key",
			"lord" => "key",
			"ltable" => "html_snippets"
		],
		'title' =>	[
			'type' => 'suggest',
			'duty' => 1,
			"lid" => "key",
			"lval" => "key",
			"lord" => "key",
			"ltable" => "html_snippets"
		],
		'image' =>	[
			'type' => 'suggest',
			'duty' => 1,
			"lid" => "key",
			"lval" => "key",
			"lord" => "key",
			"ltable" => "html_snippets"
		],
		'imagedir' =>	[
			'type' => 'array',
			'raw'	=> 1,
			'extra' => ["square", "thumbs", "small", "cinemascope", "normal"]
		]
	];


	$obj = new access($form);

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
			[i18n('announces'), $html['myurl']."?sid={$html['sid']}&amp;_id=announces", "inactive", "align-center"],
			["Box Definitions", $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", "wrench"]
			);
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		}
	$html['left'] = box_tree(0, $boxlist);
	return $html;
	}

function get_boxlist() {
	global $db;
	$boxlist = [i18n('inactive')];
	$arg = $db->prepare("select `name` from `boxes` order by `id`;");
	$arg->execute();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {array_push($boxlist, $data['name']);}
	return $boxlist;
	}

function box_tree($open, $boxlist) {
	global $html;
	array_unshift($boxlist, "all");
	$tree = "<ul id='tree' class='treeview'>";
	foreach ($boxlist as $k => $v) {
		$state = $open == $k ? "open" : "closed";
		$state = $k ? $state : "all";
		$item = [
			"caption"	=> i18n($v),
			"link"		=> "{$html['myurl']}?_id=announces&amp;sid={$html['sid']}&amp;active=$k",
			"state"		=> $state
			];
		if ($state == 'all' && !$open) {$item['emph'] = true;}
		$tree .= list_item($item);
		}
	$tree .= "</ul>\n";
	return $tree;
	}

?>
