<?php

function plugin($html) {
	$action = param('type');
	switch ($action) {
		case ("image"): $html = image_assi($html); break;
		default: $html = link_assi($html);
		}
	$html['gui'] = 4;
	return $html;
	}

function image_assi($html) {
	$rid = param('rid');
	$todo = param('todo');
	$parent = clean_var(param('parent'), "n");
	$target = clean_var(param('target'), "w");
	$form = [
		"title"			=> i18n('pictures'),
		"table"			=> "image_db",
		"myconf"		=> "assistant",
		"view"			=> "tiles",
		"orderby"		=> "upload_date",
		"human"			=> "index",
		"defsort"		=> "DESC",
		"html"			=> $html,
		"rid"			=> $rid,
		"search"		=> ["title", "filename"],
		"filters"		=> ["parent"],
		"table_fields"	=> ["filename", "title", "copyright", "parent"],
		"no_action"		=> true,
		"allow_box"		=> false,
		"allow_edit"	=> false,
		"allow_del"		=> false
		];

	$inputs = [
		"filename"	=> [
			"type"		=> "image_assistant"
			],
		"title"		=> [
			"type"		=> "text"
			],
		"copyright"		=> [
			"type"		=> "text"
			],
		"target"		=> [
			"type"		=> "free"
			],
		"type"		=> [
			"type"		=> "free"
			],
		"parent"		=> [
			"type"		=> "lookup",
			"lid"		=> "id",
			"lval"		=> "graduated",
			"lord"		=> "parentsort",
			"ltable"	=> "image_folder",
			"duty"		=> 1
			],
		];

	$obj = new access($form);
	$html = $obj->table($inputs);
	$html['left'] = img_tree($parent, "assistant&amp;target=$target&amp;type=image");
	return $html;
	}

function link_assi($html) {
	$parent = clean_var(param('parent'), "n");
	$target = clean_var(param('target'), "w");
	check_content_types();

	if (param('_docs')) {
		$basedir = $html['dir']."/documents";
		$dir = clean_var(param('_d'), "l");
		$files = scandir("$basedir/$dir");
		$data = array();

		foreach ($files as $file) {
			$dfile = "$basedir/$dir/$file";
			$file_link = "<a data-app='set_link' data-target='$target' data-value='/documents/$dir/$file'>".get_icon('link_add', i18n('link'))."</a>";

			if (!is_dir($dfile)) {
			$info = file_info($dfile);
				$data[$file] = [
					'action'	=> $file_link,
					'name'		=> $file,
					'size'		=> sizeme($info['size']),
					'mtime'		=> date("Y-m-d H:i:s", $info['mtime'])
					];
					}
				}

		$table = [
			"title"			=> i18n('ftp'),
			"myconf"		=> "assistant",
			"html"			=> $html,
			"filters"		=> ['target', 'type', '_docs'],
			"before_table"	=> "<h2>/$dir</h2>",
			"table_fields"	=> ["action", "name", "size", "mtime"]
			];

		// data_table has no types, but a type that has no sort-mechanism makes sense
		$inputs = [
			'action' =>	['type' => 'radio'],
			'name' =>	['caption' => i18n('file'), 'type' => 'radio'],
			'size' =>	['type' => 'radio'],
			'mtime' =>	['caption' => i18n('date'), 'type' => 'radio']
			];
		$obj = new access($table);
		$obj->script['set_link'] = 1;
		$obj->push_data($data);
		$html = $obj->data_table($inputs);
		}

	elseif (param('_forms')) {
		$data = read_forms($target);

		$table = [
			"title"			=> i18n('forms'),
			"myconf"		=> "assistant",
			"filters"		=> ['target', 'type', '_forms'],
			"html"			=> $html,
			"table_fields"	=> ["action", "name", "lang"]
			];

		// data_table has no types, but a type that has no sort-mechanism makes sense
		$inputs = [
			'action' =>	['type' => 'radio'],
			'name' =>	['caption' => i18n('file'), 'type' => 'radio'],
			'lang' =>	['caption' => i18n('language'), 'type' => 'radio']
			];
		$obj = new access($table);
		$obj->script['set_link'] = 1;
		$obj->push_data($data);
		$html = $obj->data_table($inputs);
		}

	else {
		$form = [
			"html"			=> $html,
			"title"			=> i18n('assistant'),
			"table"			=> "content",
			"myconf"		=> "assistant",
			"orderby"		=> "sort",
			"human"			=> "title",
			"filters"		=> ["parent"],
			"search"		=> ["fulltext"],
			"table_fields"	=> ["file", "type", "title", "published", "parent"],
			"no_action"		=> true,
			"allow_box"		=> false,
			"allow_edit"	=> false,
			"allow_del"		=> false
			];
		$inputs = inputs_by_type('assistant');
		$file_link = "<a data-app='set_link' data-target='$target' data-value='++VALUE++'>".get_icon('link_add', i18n('link'))."</a>";

		$inputs['file'] = [
			"caption"	=> i18n('link'),
			'type' => "custom",
			'view' => $file_link
			];

		$obj = new access($form);
		$obj->script['set_link'] = 1;
		$html = $obj->table($inputs);
		}
	$html['left'] = content_tree($parent, "assistant&amp;target=$target&amp;type=link");
	return $html;
	}


function img_tree($open, $action) {
	global $html;
	$tree = "";
	$item = [
		"caption"	=> i18n('all'),
		"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}",
		"state"		=> "all",
		"sub"		=> "",
		"bubble"	=> ""
		];
	$tree .= list_item($item);
	$roots = [
		"parent"	=> 0,
		"pfield"	=> "parent",
		"field"		=> "name",
		"table"		=> "image_folder",
		"sort"		=> "sort",
		"index"		=> 0,
		"open"		=> $open,
		"action"	=> $action
		];
	$tree .= branch($roots);
	$tree = parse_in('gui_tree', ['treelist' => $tree]);
	return $tree;
	}

function read_forms($target) {
	global $db, $con, $html;
	$data = array();
	$arg = $db->prepare("SELECT `name` FROM `crm_forms` WHERE `active` = 'on';");
	$arg->execute();
	$i = 0;
	while ($forms = $arg->fetch(PDO::FETCH_ASSOC)) {
		foreach (array_keys($con['langs']) as $lang) {
			$name = as_filename(sys_trans($forms['name'], $lang));
			$link = "<a data-app='set_link' data-target='$target' data-value='/content/$name.html'>".get_icon('link_add', i18n('link'))."</a>";
			$data[$i] = [
				'action'	=> $link,
				'name'		=> $name,
				'lang'		=> $lang
				];
			$i++;
			}
		}
	return $data;
	}


function sort_with($key) {
    return function ($a, $b) use ($key) {return strnatcasecmp($a[$key], $b[$key]);};
	}
?>
