<?php

/**
 * plugin bannerad
 * @package consentio
 */

class bannerad {

	private $campaigns = [];

	public $formats = [
		['short' => 'MR', 'def' => "300 &times; 250 Medium Rectangle (Content Ad/Boombox)"],
		['short' => 'SQ', 'def' => "250 &times; 250 Square Pop-Up"],
		['short' => 'VR', 'def' => "240 &times; 400 Vertical Rectangle"],
		['short' => 'LR', 'def' => "336 &times; 280 Large Rectangle"],
		['short' => 'RA', 'def' => "180 &times; 150 Rectangle"],
		['short' => 'SS', 'def' => "400 &times; 400 Superstitial / Flying Layer / AdLayer / Interstitial"],
		['short' => 'FB', 'def' => "468 &times; 60 Full Banner"],
		['short' => 'HB', 'def' => "234 &times; 60 Half Banner"],
		['short' => 'MB', 'def' => "88 &times; 31 Micro Bar"],
		['short' => 'BT', 'def' => "120/90 &times; 60 Button"],
		['short' => 'VB', 'def' => "120 &times; 240 Vertical Banner"],
		['short' => 'SB', 'def' => "125 &times; 125 Square Button"],
		['short' => 'SK', 'def' => "120/160 &times; 600 Skyscraper	"],
		['short' => 'HP', 'def' => "300 &times; 600 Half Page Ad"],
		['short' => 'LB', 'def' => "728 &times; 90 Leaderboard"]
		];

	public function plugin($html) {
		switch ($html['action']) {
			case ("creatives"): $html = $this->creatives_admin($html); break;
			case ("ad_clients"): $html = $this->clients_admin($html); break;
			case ("bannerstats"): $html = $this->bannerstats($html); break;
			default: $html = $this->bannerad_admin($html);
			}
		return $html;
		}

	private function bannerad_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('campaign'),
			"table"			=> "banner",
			"myconf"		=> "bannerad",
			"orderby"		=> "name",
			"defsort"		=> "ASC",
			"human"			=> "name",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> [ 'name','url'],
			"table_fields"	=> ['name','url', 'max', 'hold', 'client']
			];

		$inputs = [
		'name'	=> [
			'type'	=> 'text',
			],
		'url'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		//'src'	=> [
		//	'type'	=> 'text',
		//	'duty'	=> 1,
		//	],
		'client'	=> [
			'type'		=> 'lookup',
			"lval"		=> "company",
			"lord"		=> "company",
			"ltable"	=> "ad_clients",
			'duty' => 1
			],
		'from'	=> [
			'type'	=> 'date',
			'default'	=> date('Y-m-d'),
			'duty'	=> 1,
			],
		'until'	=> [
			'type'	=> 'date',
			'default'	=> date('Y-m-d', strtotime('+1 month')),
			'duty'	=> 1,
			],
		'max'	=> [
			'type'	=> 'number',
			'default' => 10000,
			'size' => 12
			],
		'hold'	=> [
			'type'	=> 'flag',
			],
		'creatives'	=> [
			'type'	=> 'ghost',
			],
		'date'	=> [
			'caption' => i18n('written'),
			'type'	=> 'readonly',
			'default' => date('Y-m-d')
			]
		];

		if (!$rid || $rid == "new") {
			$form['button_text'] = i18n('next');
			$form['button_fa'] = 'chevron-circle-right';
			}
		else {
			$inputs['creatives'] = [
			'type' => 'subform',
			'conf' => 'creatives',
			'foreign' => 'campaign',
			'height' => 450
			];
			}

		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$submen = array(
				[i18n('campaign'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;rid=$rid", "active", "lightbulb-orange"],
				[i18n('statistic'), $html['myurl']."?sid={$html['sid']}&amp;_id=adstats&amp;rid=$rid", "inactive", "chart-line"]
				);
				$obj->before_form = make_submenu($submen);
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		// default tree shows plugins of group "plugins"
		$html['left'] = get_tab_tree($html, "banner", $form['myconf'], "");;
		return $html;
		}

	private function creatives_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$campaign = clean_var(param('campaign'), "n");

		$form = [
			"title"			=> i18n('creatives'),
			"table"			=> "creatives",
			"myconf"		=> "creatives",
			"filters"		=> ['campaign'],
			"orderby"		=> "picture",
			"defsort"		=> "ASC",
			"human"			=> "picture",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> [],
			"searchform"	=> 0,
			"table_fields"	=> ['picture', 'campaign', 'width', 'height', 'type']
			];

		$inputs = [
		'picture'	=> [
			'type'	=> 'image',
			'prev_dir'	=> 'thumbs',
			'duty'	=> 1,
			'extra' => 'upload'
			],
		'campaign'	=> [
			'type'	=> 'hidden',
			'default'	=> $campaign,
			],
		'width'	=> [
			'type'	=> 'hidden',
			],
		'height'	=> [
			'type'	=> 'hidden',
			],
		'type'	=> [
			'type'	=> 'array',
			'raw'	=> true,
			'extra'	=> array_column($this->formats, 'short'),
			'view'	=> array_column($this->formats, 'def')
			],
		];


		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				if (isset($obj->uploaded_files['picture'])) {
					$new_pic = $obj->uploaded_files['picture'];
					if ($new_pic && file_exists("../pictures/$new_pic")) {
						list($x, $y) = getimagesize("../pictures//$new_pic");
						$this->def_size($x, $y, $id);
						}
					}
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				if ($obj->rid == 'new') {$inputs['type']['type'] = 'hidden';}
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;campaign=$campaign", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		// default tree shows plugins of group "plugins"
		$html['left'] = get_tab_tree($html, "banner", $form['myconf'], "");;
		return $html;
		}

	private function clients_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('ad_clients'),
			"table"			=> "ad_clients",
			"myconf"		=> "ad_clients",
			"orderby"		=> "company",
			"defsort"		=> "ASC",
			"human"			=> "company",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['company', 'name', 'notes'],
			"table_fields"	=> ['company', 'name', 'city', 'country']
			];

		$inputs = [
		'company'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'company_line2'	=> [
			'type'	=> 'text',
			],
		'salutation'	=> [
			'type'	=> 'array',
			'extra'	=> [i18n('ms'), i18n('mr')]
			],
		'title'	=> [
			'type'	=> 'text',
			],
		'prename'	=> [
			'type'	=> 'text',
			],
		'name'	=> [
			'type'	=> 'text',
			],
		'street'	=> [
			'type'	=> 'text',
			],
		'city'	=> [
			'type'	=> 'text',
			],
		'province'	=> [
			'type'	=> 'text',
			],
		'postal_code'	=> [
			'type'	=> 'text',
			],
		'country'	=> [
			'type'	=> 'country',
			'default'	=> 'at',
			'duty'	=> 1,
			],
		'phone'	=> [
			'type'	=> 'text',
			],
		'fax'	=> [
			'type'	=> 'text',
			],
		'mobile'	=> [
			'type'	=> 'text',
			],
		'email'	=> [
			'type'	=> 'text',
			],
		'tan'	=> [
			'type'	=> 'readonly',
			'default' => gen_tan(12)
			],
		'info' => [
			"icon"		=> "info",
			"type"		=> "fieldset",
			],
		'notes'	=> [
			'type'	=> 'bigtext',
			],
		'registered'	=> [
			'type'	=> 'readonly',
			'default'	=> date('Y-m-d H:i:s'),
			'duty'	=> 1,
			],
		'updated'	=> [
			'type'	=> 'readonly'
			],
		'editor'	=> [
			'type'	=> 'readonly'
			],
		];


		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$inputs['updated']['value'] = date('Y-m-d H:i:s');
				$inputs['editor']['value'] = $html['user']['name'];
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		$html['left'] = get_tab_tree($html, "banner", $form['myconf'], "");;
		return $html;
		}

		/* SELECT count(`id`) AS `count`, SUM(`click`) AS `clicks`, `year`, `month`, `day`  FROM `banner_stats` WHERE `campaign` = 3 GROUP BY `year`, `month`, `day`;
SELECT count(`id`) AS `count`, SUM(`click`) AS `clicks`, `year`, `month`  FROM `banner_stats` WHERE `campaign` = 3 GROUP BY `year`, `month`;
		*/

	private function def_size ($w, $h, $id) {
		global $db;
		$type = 'NT'; // no type
		if ($w == 300 && $h == 250) {$type = "MR";}	// Medium Rectangle (Content Ad/Boombox)
		elseif ($w == 250 && $h == 250) {$type = "SQ";} // Square Pop-Up
		elseif ($w == 240 && $h == 400) {$type = "VR";} // Vertical Rectangle
		elseif ($w == 336 && $h == 280) {$type = "LR";} // Large Rectangle
		elseif ($w == 180 && $h == 150) {$type = "RA";} // Rectangle
		elseif ($w == 400 && $h == 400) {$type = "SS";} // Superstitial / Flying Layer / AdLayer / Interstitial
		elseif ($w == 468 && $h == 60) {$type = "FB";}  // Full Banner
		elseif ($w == 234 && $h == 60) {$type = "HB";} // Half Banner
		elseif ($w == 88 && $h == 31) {$type = "MB";} // Micro Bar
		elseif ($w == 120 && ($h == 90 || $h == 60)) {$type = "BT";} // Button
		elseif ($w == 120 && $h == 240) {$type = "VB";} // Vertical Banner
		elseif ($w == 125 && $h == 125) {$type = "SB";} // Square Button
		elseif ($w == 728 && $h == 90) {$type = "LB";}
		elseif (($w == 120 || $w == 160) && $h == 600) {$type = "SK";} // Skyscraper
		elseif ($w == 300 && $h == 600) {$type = "HP";} // Half Page Ad

		$arg = $db->prepare('UPDATE `creatives` SET `width` = ?, `height` = ?, `type` = ? WHERE `id` = ?;');
		$arg->execute(array($w, $h, $type, $id));
		echo "UPDATE `creatives` SET `width` = $w, `height` = $h, `type` = $type WHERE `id` = $id;";
		}



	private function bannerstats($html) {
		$this->get_campaigns();
		$html['formtitle'] = i18n('bannerstats');
		$html['content'] = $this->campaigns();
		$html['left'] = get_tab_tree($html, "banner", $form['myconf'], "");;
		return $html;
		}

	// banner per campaign
	function campaigns() {
		global $db;
		$this->get_campaigns();
		$q = "SELECT count(`id`) AS `views`, `campaign`, sum(`click`) AS `clicks` FROM `banner_stats` group by `campaign`;";
		$arg = $db->prepare($q);
		$arg->execute();
		$months = [];
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$data['views'] -= $data['clicks'];
			$data['days'] = $this->campaigns[$data['campaign']]['days'];
			$data['campaign'] = $this->campaigns[$data['campaign']]['name'];
			$vavg = sprintf('%0.2f', $data['views']/$data['days']);
			$cavg = sprintf('%0.2f', $data['clicks']/$data['days']);
			$row = htmltag('tr', '', "<th>{$data['campaign']}</th><td>{$data['days']}</td><td>{$data['views']} ($vavg)</td><td>{$data['clicks']} ($cavg)</td>");
			array_unshift($months, $row);
			}
		$table = '';
		foreach ($months as $r) {
			$table .= "$r\n";
			}
		if ($table) {
			$table = htmltag('tr', '', "<th>".i18n('campaign')."</th><th>".i18n('days')."</th><th>".i18n('views')."</th><th>".i18n('clicks')."</th>")."\n$table";
			$table = htmltag('table', 'id="year" class="table"', $table);
			//$table = parse_in('gui_cowa_table_year', $co);
			}
		return $table;
	}

	// campaign per name
	function get_campaigns() {
		global $db;
		$q = "SELECT `id`, `name`, `from` FROM `banner` order by `id` ASC";
		$arg = $db->prepare($q);
		$arg->execute();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$interval = date_diff(date_create($data['from']), date_create('today'));
		    $days = $interval->format('%a');
			$this->campaigns[$data['id']] = ['name' => $data['name'], 'days' => $days];
			}
		}
	}
?>
