<?php

function plugin($html) {
	$todo = clean_var(param('todo'), "w");
	switch ($todo) {
		case ("deps"): $html = more_depending_inputs($html); break;
		default: $html = builder_admin($html);
		}
	return $html;
	}

function builder_admin($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$table = clean_var(param('_table'), "w");
	$fields = array();
	$url = "{$html['myurl']}?sid={$html['sid']}&amp;_id=builder";
	$left = htmltag('p', '', "Build a sketch for a plugin (controller) based on a table");
	$form = [
		"title"			=> "Plugin Builder",
		"myconf"		=> "builder",
		"button_text"	=> i18n('next'),
		"no_cancel"		=> 1,
		"html"			=> $html
		];

	if (!$table) {
		global $db;
		$arg = $db->prepare("SHOW TABLES;");
		$arg->execute();
		$tables = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
		$inputs = [
			'_name' =>	[
				'caption' => i18n('name'),
				'type'	=> 'text',
				'duty'	=> 1
				],
			'_table' =>	[
				'caption' => i18n('table'),
				'type'	=> 'array',
				'extra'	=> $tables,
				'raw'	=> 1,
				'duty'	=> 1
				]
			];
		}
	else {
		$form['submit'] = param('_fl') ? "_store3" : "_store2";
		$left .= htmltag('p', '', get_icon('parent', i18n('back'))."&nbsp;".htmltag('a', 'href="'.$url.'" class="menue"', i18n('back')));
		$dummy = [
			"table"			=> $table,
			"html"			=> $html
			];
		$dobj = new access($dummy);
		$fields = $dobj->inputs_from_table();
		unset ($fields[$dobj->primary]);
		$file = param('_fl') ? param('_fl') : clean_filename(param('_name').".php", __DIR__);
		$file = preg_replace('/\.php$/', '', $file);

		$inputs = [
			'_name' =>	[
				'caption' => i18n('name'),
				'type'		=> 'readonly',
				'value'		=> $file
				],
			'_fl' =>	[
				'caption' => get_icon('save', i18n('save'))."&nbsp;".i18n('file'),
				'type'		=> 'text',
				'size'		=> 20,
				'value'		=> $file,
				'in_body'	=> ".php"
				],
			'_table' =>	[
				'caption' => i18n('table'),
				'type'		=> 'readonly',
				'value'		=> $table
				],
			'_primary' =>	[
				'type'		=> 'readonly',
				'value'		=> $dobj->primary
				],
			'_human' =>	[
				'type'		=> 'array',
				'raw'		=> 1,
				'duty'		=> 1,
				'extra'		=> array_keys($fields)
				],
			'_search' =>	[
				'type'		=> 'text',
				'value'		=> join(', ', array_map(function($m){return "'".$m."'";}, $dobj->search))
				],
			'_tfields' =>	[
				'type'		=> 'text',
				'value'		=> join(', ', array_map(function($m){return "'".$m."'";}, array_keys($fields)))
				],
			'_oby' =>	[
				'type'		=> 'array',
				'raw'		=> 1,
				'duty'		=> 1,
				'extra'		=> array_keys($fields)
				],
			'_defsort' =>	[
				'type'		=> 'array',
				'raw'		=> 1,
				'default'	=> 'ASC',
				'extra'		=> ['ASC', 'DESC']
				]
			];

		foreach ($fields as $field=>$data) {
			$inputs[$field."_set"] = ['caption' => $field, 'type' => 'fieldset', 'in_body' => '<p>DATA TYPE: '.$data['db_Type'].'</p>'];
			$types = co_type_by_data_type($data['db_Type']);
			$inputs[$field."_caption"] = ['caption' => i18n('name'), 'type' => 'text'];
			$inputs[$field."_type"] = ['caption' => "Typ", 'type' => 'array', 'raw' => 1, 'extra' => $types, 'css_class' => 'ask_for_more', 'duty' => 1, 'default' => $types[0]];
			if (param($field."_type") == 'lookup') {
				$inputs[$field."_ltable"] = ['caption' => "Lookup-Table", 'type' => 'text'];
				$inputs[$field."_lclause"] = ['caption' => "Clause", 'type' => 'text'];
				}
			if (param($field."_extra")) {$inputs[$field."_extra"] = ['caption' => "Values", 'type' => 'text'];}
			if (param($field."_icons")) {$inputs[$field."_icons"] = ['caption' => "Values", 'type' => 'text'];}
			$def = array_key_exists('default', $data) ? $data['default'] : '';
			$inputs[$field."_default"] = ['caption' => "Default", 'type' => 'text', 'default' => $def];
			$duty = $data['db_Null'] == "YES" ? 'on' : '';
			$inputs[$field."_duty"] = ['caption' => "Duty", 'type' => 'flag'];
			}
		}

	$obj = new access($form);
	if (param('_store2')) {
		$inputs = $obj->get_params($inputs);
		if (!$obj->error) {
			$code = htmlspecialchars(get_my_code(array_keys($fields), $inputs));
			$code = htmltag('textarea', 'cols="100" rows="20" wrap="off" readonly="readonly"', $code);
			$obj->before_form = $code;
			$obj->button_text = i18n('save');
			}
		}
	if (param('_store3')) {
		$inputs = $obj->get_params($inputs);
		if (!$obj->error) {
			$code = get_my_code(array_keys($fields), $inputs);
			$f = $inputs['_fl']['value'];
			$fH = fopen(__DIR__."/$f.php", "wb");
			$fw = fwrite($fH, $code);
			fclose($fH);
			if ($fw === false) {}
			$d = array_reverse(explode("/", __DIR__))[1]."/plugins";
			$left .= htmltag('p', '', get_icon('lightbulb', i18n('execute'))."&nbsp;".htmltag('a', "href='{$html['myurl']}?sid={$html['sid']}&amp;_id=$f' class='menue' target='_blank'", i18n('execute')." $f.php"));
			$left .= htmltag('p', '', get_icon('code', i18n('edit'))."&nbsp;".htmltag('a', "href='{$html['myurl']}?sid={$html['sid']}&amp;_id=filemanager&amp;_f=$f.php&amp_d=$d' class='menue' target='_blank'", i18n('edit')." $f.php"));
			$left .= htmltag('p', '', get_icon('table', i18n('menue'))."&nbsp;".htmltag('a', "href='{$html['myurl']}?sid={$html['sid']}&amp;_id=register&amp;todo=edit&amp;call=$f&amp;name=$f&amp;icon=plugin&amp;tab=7&amp;start=on&amp;group=on&amp;_store=1' class='menue' target='_blank'", i18n('register')." $f"));;
			}
		}
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['left'] = $left;

	$html['scripts'] .= <<< "EOL"
<script type="text/javascript">
\$(document).ready(function(){\$(".ask_for_more").moreInputs({'id':"builder",'sid':"{$html['sid']}",'script':"{$html['myurl']}",'todo':'deps'})});
</script>
EOL;
	return $html;
	}

function co_type_by_data_type($t) {
	$tt = preg_replace('/\(\d+\)/', '', $t);
	$co_type = 0;
	switch (strtoupper($tt)) {
		case "TINYINT":
		case "SMALLINT":
		case "MEDIUMINT":
		case "INT":
		case "BIGINT":
		case "FLOAT":
		case "DOUBLE":
		case "DECIMAL":
		case "BIT": $co_type = 1; break;
		case "CHAR":
		case "VARCHAR": $co_type = 2; break;
		case "DATETIME":
		case "TIME":
		case "TIMESTAMP":
		case "YEAR": $co_type = 4; break;
		case "TINYTEXT":
		case "TEXT":
		case "MEDIUMTEXT":
		case "LONGTEXT": $co_type = 3; break;
		case "BINARY":
		case "VARBINARY":
		case "TINYBLOB":
		case "BLOB":
		case "MEDIUMBLOB":
		case "LONGBLOB":
		case "ENUM":
		case "SET ": $co_type = 4; break;
		case "DATE": $co_type = 4; break;
		}
	$types = ['number', 'spin', 'sort', 'hidden', 'readonly', 'array', 'radio', 'icon', 'lookup', 'custom'];
	if ($co_type == 2) {$types = ['text', 'hidden', 'readonly', 'pwd', 'link', 'suggest', 'raw array', 'raw radio', 'flag', 'country', 'image', 'custom'];}
	if ($co_type == 3) {$types = ['bigtext', 'wysiwyg','text', 'hidden', 'readonly', 'custom'];}
	if ($co_type == 4) {$types = ['date', 'timestamp'];}
	return $types;
	}

function get_my_code($fields, $inputs) {
	$model = get_model();
	$data['MYPLUGIN'] = $inputs['_name']['value'];
	$data['TABLE'] = $inputs['_table']['value'];
	$data['OBY'] = $inputs['_oby']['value'];
	$data['DEFSORT'] = $inputs['_defsort']['value'];
	$data['HUMAN'] = $inputs['_human']['value'];
	$data['SEARCH'] = $inputs['_search']['value'];
	$data['TFIELDS'] = $inputs['_tfields']['value'];
	$data['SORTING'] = "";
	$data['INPUTS'] = "\$inputs = [\n";
	foreach ($fields as $field) {
		$data['INPUTS'] .= "\t\t'$field'\t=> [\n";
		$type = $inputs[$field."_type"]['value'];
		$extra = param($field."_extra")	? param($field."_extra") : "'one', 'two', 'three', 'four'";
		$icons = param($field."_icons")	? param($field."_icons") : "";
		switch ($type) {
			case "icon":
			case "array":
				$data['INPUTS'] .= "\t\t\t'type'\t=> 'array',\n";
				$data['INPUTS'] .= "\t\t\t'extra'\t=> [$extra],\n";
				if ($icons) {$data['INPUTS'] .= "\t\t\t'icons'\t=> [$icons],\n";}
				break;
			case "raw array":
				$data['INPUTS'] .= "\t\t\t'type'\t=> 'array',\n";
				$data['INPUTS'] .= "\t\t\t'raw'\t=> 1,\n";
				$data['INPUTS'] .= "\t\t\t'extra'\t=> [$extra],\n";
				break;
			case "radio":
				$data['INPUTS'] .= "\t\t\t'type'\t=> 'radio',\n";
				$data['INPUTS'] .= "\t\t\t'extra'\t=> [$extra],\n";
				break;
			case "raw radio":
				$data['INPUTS'] .= "\t\t\t'type'\t=> 'radio',\n";
				$data['INPUTS'] .= "\t\t\t'raw'\t=> 1,\n";
				$data['INPUTS'] .= "\t\t\t'extra'\t=> [$extra],\n";
				break;
			case "suggest":
			case "lookup":
				$ltable = param($field."_ltable") ? param($field."_ltable") : 0;
				if ($ltable) {
					$l = analyse_table($ltable);
					$lclause = param($field."_lclause") ? param($field."_lclause") : 0;
					$data['INPUTS'] .= "\t\t\t'type'\t=> 'lookup',\n";
					$data['INPUTS'] .= "\t\t\t'ltable'\t=> '$ltable',\n";
					$data['INPUTS'] .= "\t\t\t'lid'\t=> '{$l['id']}',\n";
					$data['INPUTS'] .= "\t\t\t'lval'\t=> '{$l['val']}',\n";
					$data['INPUTS'] .= "\t\t\t'lord'\t=> '{$l['val']}',\n";
					$data['INPUTS'] .= "\t\t\t'lclause'\t=> '$lclause',\n";
					}
				else {$data['INPUTS'] .= "// ERROR LOOKUP TABLE MISSING\n";}
				break;
			case "timestamp":
				$data['INPUTS'] .= "\t\t\t'type'\t=> 'readonly',\n";
				if ($inputs[$field."_default"]['value'] == 'CURRENT_TIMESTAMP') {$inputs[$field."_default"]['value'] = "date('Y-m-d H:i:s')";}
				break;
			case "date":
				$data['INPUTS'] .= "\t\t\t'type'\t=> 'date',\n";
				if ($inputs[$field."_duty"]['value'] == 'on') {$inputs[$field."_default"]['value'] = "date('Y-m-d')";}
				break;
			case "sort":
				$data['INPUTS'] .= "\t\t\t'type'\t=> '$type',\n";
				$data['INPUTS'] .= "\t\t\t'do'\t=> 1,\n";
				$data['SORTING'] = "\n\tif (param('_sortlist')) {\n\t\t\$obj->sort_list();\n\t\treorder(\$form['table'], '', '');\n\t\t}";
			default: $data['INPUTS'] .= "\t\t\t'type'\t=> '$type',\n";
		}

		if ($inputs[$field."_caption"]['value']) {$data['INPUTS'] .= "\t\t\t'caption'\t=> i18n('{$inputs[$field.'_caption']['value']}'),\n";}
		if ($inputs[$field."_default"]['value']){$data['INPUTS'] .= "\t\t\t'default'\t=> {$inputs[$field."_default"]['value']},\n";}
		if ($inputs[$field."_duty"]['value']){$data['INPUTS'] .= "\t\t\t'duty'\t=> 1,\n";}
		$data['INPUTS'] .= "\t\t\t],\n";
		}
	$data['INPUTS'] .= "\t\t];\n";
	$code = preg_replace_callback("/&&&&(\w+)&&&&/", function($m) use ($data){return $data[$m[1]];}, $model);
	return $code;
	}

function analyse_table($table)	{
	global $html;
	$dummy = [
		"table"			=> $table,
		"html"			=> $html
		];
	$dobj = new access($dummy);
	$fields = $dobj->inputs_from_table();
	$l = array('id' => $dobj->primary);
	foreach ($fields as $k=>$field) {if($field['type'] == 'text') {$l['val'] = $k;}};
	return $l;
	}

function get_model() {
	$model = <<<'TNIRP'
<?php

/**
 * plugin &&&&MYPLUGIN&&&&
 * @package consentio
 */

class &&&&MYPLUGIN&&&& {

	public function plugin($html) {
		switch ($html['action']) {
			case ("SOMETHINGELSE"): $html = $this->SOMETHINGELSE_admin($html); break;
			default: $html = $this->&&&&MYPLUGIN&&&&_admin($html);
			}
		return $html;
		}

	private function &&&&MYPLUGIN&&&&_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('&&&&MYPLUGIN&&&&'),
			"table"			=> "&&&&TABLE&&&&",
			"myconf"		=> "&&&&MYPLUGIN&&&&",
			"orderby"		=> "&&&&OBY&&&&",
			"defsort"		=> "&&&&DEFSORT&&&&",
			"human"			=> "&&&&HUMAN&&&&",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> [&&&&SEARCH&&&&],
			"table_fields"	=> [&&&&TFIELDS&&&&]
			];

		&&&&INPUTS&&&&

		$obj = new access($form);
		// $obj->set_attribute($inputs);
		&&&&SORTING&&&&

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		// default tree shows plugins of group "plugins"
		$html['left'] = get_tab_tree($html, "plugins", $form['myconf'], "");;
		return $html;
		}
	}
?>
TNIRP;
	return $model;
	}

function more_depending_inputs($html) {
	$val = param('_v');
	$prae = param('_ref');
	$all = explode("_", $prae);
	switch ($val) {
		case 'raw array':
		case 'raw radio':
		case 'radio':
		case 'array':
			$html['content'] = array_fields($val, $all[0]); break;
		case 'icon':
			$html['content'] = icon_fields($val, $all[0]); break;
		case 'lookup':
		case 'suggest':
			$html['content'] = lookup_fields($val, $all[0]); break;
		default: $html['content'] = "";
		}
	$html['gui'] = 6;
	return $html;
	}

function array_fields($val, $prae) {
	global $html;
	$form = [
		"html"	=> $html
		];
	$inputs = [
		$prae.'_extra' =>	[
			'caption' => 'Values',
			'type'	=> 'text',
			'default' => "'one', 'two', 'three', 'four'"
			]
		];
	$obj = new access($form);
	$obj->add_input($inputs);
	return $obj->inputs;
	}

function icon_fields($val, $prae) {
	global $html;
	$form = [
		"html"	=> $html
		];
	$inputs = [
		$prae.'_extra' =>	[
			'caption' => 'Values',
			'type'	=> 'text',
			'default' => "'one', 'two', 'three', 'four'"
			],
		$prae.'_icons' =>	[
			'caption' => 'Values',
			'type'	=> 'text',
			'default' => "'flag1', 'flag2', 'flag3', 'flag4'"
			]
		];
	$obj = new access($form);
	$obj->add_input($inputs);
	return $obj->inputs;
	}

function lookup_fields($val, $prae) {
	global $db, $html;
	$form = [
		"html"	=> $html
		];
	$arg = $db->prepare("SHOW TABLES;");
	$arg->execute();
	$tables = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
	$inputs = [
		$prae.'_ltable' =>	[
			'caption' => 'Lookup-Table',
			'type'	=> 'array',
			'extra'	=> $tables,
			'raw'	=> 1,
			'duty'	=> 1
			],
		$prae.'_lclause' =>	[
			'caption' => 'Clause',
			'type'	=> 'text'
			]
		];
	$obj = new access($form);
	$obj->add_input($inputs);
	return $obj->inputs;
	}
?>
