<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-05-28 18:56:48
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2020-03-20 01:32:12
# @License: GPL 2.0

class callib {
	private $mon;
	private $yea;
	private $wee;
	private $day;
	private $action;
	private $moon = false;
	private $sid;
	private $events = array();
	private $feasts = array();

	public function __construct(array$form){
		$this->mon = date('m');
		$this->yea = date('Y');
		$this->wee = date('W');
		$this->day = date('d');
		foreach($form as $k=>$v){$this->{$k}=$v;}
		while (!checkdate ($this->mon, $this->day, $this->yea )) {$this->day--;} // leapyear
		}

	public function month() {
		$base = "?_id={$this->action}&amp;sid={$this->sid}";
		$month = "&amp;_y={$this->yea}&amp;_m={$this->mon}";
		$first = date('w', strtotime("{$this->yea}-{$this->mon}-1"));
		$Mon = date('M', strtotime("{$this->yea}-{$this->mon}-1"));
		$last = date('t', strtotime("{$this->yea}-{$this->mon}-1"));
		if(!$first) {$first = 7;} // sunday
		$prev = explode('-', date('Y-m', strtotime('-1 month', strtotime("{$this->yea}-{$this->mon}-1"))));
		$next = explode('-', date('Y-m', strtotime('+1 month', strtotime("{$this->yea}-{$this->mon}-1"))));
		$w = 0;
		$p = htmltag('a', "href=\"$base&amp;_y={$prev[0]}&amp;_m={$prev[1]}\"", get_icon('angle-left', '<'));
		$n = htmltag('a', "href=\"$base&amp;_y={$next[0]}&amp;_m={$next[1]}\"", get_icon('angle-right', '>'));
		$p1 = $this->yea - 1;
		$n1 = $this->yea + 1;
		$p1 = htmltag('a', "href=\"$base&amp;_y=$p1&amp;_m={$this->mon}\"", get_icon('angle-double-left ', '<<'));
		$n1 = htmltag('a', "href=\"$base&amp;_y=$n1&amp;_m={$this->mon}\"", get_icon('angle-double-right', '>>'));
		$c = htmltag('h2', '', $p.' '.i18n(strtolower($Mon)).' '.$n." &middot; $p1 {$this->yea} $n1");
		$tr = '';
		$ths = ['week', 'mo', 'tu', 'we', 'th', 'fr', 'sa', 'su'];
		foreach ($ths as $th) {	$tr .= htmltag('th', '', i18n($th));}
		$table = htmltag('tr', '', $tr);
		$wd = date('W', strtotime("{$this->yea}-{$this->mon}-1"));
		$wd = htmltag('a',"href=\"$base&amp;_y={$this->yea}&amp;_w=$wd\"", $wd );
		$tr = htmltag('th', '', $wd);
		$r = 0;
		for ($i = 1; $i < $last+$first; $i++) {
			$dn = ' ';
			$dnn = 0;
			if ($i >= $first) {$dn = 1+$i-$first; $dnn = sprintf('%02d', $dn);}
			$feast = in_array($w, [5,6]) ? ' feast' : '';
			$name = '';
			$events = '';
			$moon = $this->moon ? $this->moon($this->yea, $this->mon, $dn) : '';
			if (array_key_exists("{$this->mon}-$dnn", $this->feasts)) {
				$feast = ' feast';
				$name = $this->feasts["{$this->mon}-$dnn"];
				}
			if (array_key_exists("{$this->mon}-$dnn", $this->events)) {
				$ev = $this->events["{$this->mon}-$dnn"];
				$events .= $ev;
				}
			$today = "{$this->yea}-{$this->mon}-$dn" == date('Y-m-j') ? ' class="today"' : '';
			$an = htmltag('a', 'class="daynumber'.$feast.'" href="'.$base.$month.'&amp;_d='.$dnn.'"', $dn);
			$ins = $dn != 0 ? htmltag('div', "data-day='{$this->yea}-{$this->mon}-$dnn' data-snap='$w-$r' $today", $an.$moon.$name.$events) : '';
			$tr .= htmltag('td', '', $ins);
			$w++;
			if ($w == 7) {
				$w = 0; $r++;
				$table .= htmltag('tr', '', $tr);
				$n = $dn+1;
				$wd = date('W', strtotime("{$this->yea}-{$this->mon}-$n"));
				$wd = htmltag('a',"href=\"$base&amp;_y={$this->yea}&amp;_w=$wd\"", $wd );
				$tr = htmltag('th', '', $wd);
				}
			}
		if ($w) {
			for ($i = $w; $i <= 7-$w; $i++) {$tr .= htmltag('td', '', ' ');}
			$table .= htmltag('tr', '', $tr);
			}
		$table = htmltag('table', 'id="cal_month" class="preview"', $table);
		$c .= $table;
		return $c;
		}

		public function small_month() {
			$base = "?_id={$this->action}&amp;sid={$this->sid}&amp;view=d";
			$month = "&amp;_y={$this->yea}&amp;_m={$this->mon}";
			$first = date('w', strtotime("{$this->yea}-{$this->mon}-1"));
			$last = date('t', strtotime("{$this->yea}-{$this->mon}-1"));
			if(!$first) {$first = 7;} // sunday
			$Mon = date('M', strtotime("{$this->yea}-{$this->mon}-1"));
			$prev = explode('-', date('Y-m-d', strtotime('-1 month', strtotime("{$this->yea}-{$this->mon}-{$this->day}"))));
			$next = explode('-', date('Y-m-d', strtotime('+1 month', strtotime("{$this->yea}-{$this->mon}-{$this->day}"))));
			$w = 0;
			$p = htmltag('a', "href=\"$base&amp;_y={$prev[0]}&amp;_m={$prev[1]}&amp;_d={$prev[2]}\"", get_icon('angle-left', '<'));
			$n = htmltag('a', "href=\"$base&amp;_y={$next[0]}&amp;_m={$next[1]}&amp;_d={$next[2]}\"", get_icon('angle-right', '>'));
			$p1 = $this->yea - 1;
			$n1 = $this->yea + 1;
			$p1 = htmltag('a', "href=\"$base&amp;_y=$p1&amp;_m={$this->mon}&amp;_d={$prev[2]}\"", get_icon('angle-double-left ', '<<'));
			$n1 = htmltag('a', "href=\"$base&amp;_y=$n1&amp;_m={$this->mon}&amp;_d={$next[2]}\"", get_icon('angle-double-right', '>>'));
			$c = htmltag('h2', '', $p.' '.i18n($Mon).' '.$n." &middot; $p1 {$this->yea} $n1");
			$tr = '';
			$w = 0;
			$ths = ['week', 'mo', 'tu', 'we', 'th', 'fr', 'sa', 'su'];
			foreach ($ths as $th) {	$tr .= htmltag('th', '', i18n($th));}
			$table = htmltag('tr', '', $tr);
			$wd = date('W', strtotime("{$this->yea}-{$this->mon}-1"));
			$wd = htmltag('a',"href=\"$base&amp;_y={$this->yea}&amp;_w=$wd\"", $wd );
			$tr = htmltag('th', '', $wd);
			$r = 0;
			for ($i = 1; $i < $last+$first; $i++) {
				$dn = ' ';
				$dnn = 0;
				if ($i >= $first) {$dn = 1+$i-$first; $dnn = sprintf('%02d', $dn);}
				$today = "{$this->yea}-{$this->mon}-$dnn" == "{$this->yea}-{$this->mon}-{$this->day}" ? ' class="today"' : '';
				$an = htmltag('a', 'href="'.$base.$month.'&amp;_d='.$dnn.'"', $dn);
				$tr .= htmltag('td', $today, $an);
				$w++;
				if ($w == 7) {
					$w = 0; $r++;
					$table .= htmltag('tr', '', $tr);
					$n = $dn+1;
					$wd = date('W', strtotime("{$this->yea}-{$this->mon}-$n"));
					$wd = htmltag('a',"href=\"$base&amp;_y={$this->yea}&amp;_w=$wd\"", $wd );
					$tr = htmltag('th', '', $wd);
					}
				}
			if ($w) {
				for ($i = $w; $i <= 7-$w; $i++) {$tr .= htmltag('td', '', ' ');}
				$table .= htmltag('tr', '', $tr);
				}
			$table = htmltag('table', 'id="calendar"', $table);
			$c .= $table;
			return $c;
			}

	public function week() {
		$base = "?_id={$this->action}&amp;sid={$this->sid}&amp;view=w";
		$prev = explode('-', date('Y-W', strtotime('-1 week', strtotime($this->yea.'W'.$this->wee))));
		$next = explode('-', date('Y-W', strtotime('+1 week', strtotime($this->yea.'W'.$this->wee))));
		$p = htmltag('a', "href=\"$base&amp;_y={$prev[0]}&amp;_w={$prev[1]}\"", get_icon('angle-left', '<'));
		$n = htmltag('a', "href=\"$base&amp;_y={$next[0]}&amp;_w={$next[1]}\"", get_icon('angle-right', '>'));
		$c = htmltag('h2', '', "$p ".i18n('week')." $this->wee $n");
		$th = htmltag('th', '', i18n('hour'));
		$fdow = strtotime($this->yea.'W'.$this->wee);
		for ($i=0; $i <= 6; $i++) {
			$tday = date('Y-m-d', strtotime("+$i days", $fdow));
			$tdarr = explode('-', $tday);
			$wd = date('D', strtotime($tday));
			$feast = in_array($i, [5,6]) ? ' feast' : '';
			$name = '';
			if (array_key_exists("{$tdarr[1]}-{$tdarr[2]}", $this->feasts)) {
				$feast = ' feast';
				}
			$wd = htmltag('a', "href=\"$base&amp;_y={$tdarr[0]}&amp;_m={$tdarr[1]}&amp;_d={$tdarr[2]}\" class=\"daynumber$feast\"", "$wd $tdarr[2]");
			$moon = $this->moon ? $this->moon($tdarr[0], $tdarr[1], $tdarr[2]) : '';
			$th .= htmltag('th', '', "$wd $moon $name");
			}
		$tr = htmltag('tr', '', $th);
		for ($i = 6; $i <= 23; $i++) {
			$hh = sprintf('%02d', $i).':00';
			$td = htmltag('th', '', $hh);
			for ($ii=0; $ii <= 6; $ii++) {
				$tday = date('Y-m-d', strtotime("+$ii days", $fdow));
				$tdarr = explode('-', $tday);
				$new = htmltag('a', "href=\"$base&amp;_y={$tdarr[0]}&amp;_m={$tdarr[1]}&amp;_d={$tdarr[2]}&amp;start=$hh&amp;todo=edit\"",  htmltag('i', 'class="fas fa-plus-circle fa-lg"', ''));
				$events = '';
				if (array_key_exists("{$tdarr[2]}-$i", $this->events)) {
					$ev = $this->events["{$tdarr[2]}-$i"];
					$events .= $ev;
					}
				$ins = htmltag('div', "data-day='{$tdarr[0]}-{$tdarr[1]}-{$tdarr[2]}-$i' data-snap='$ii-$i'", $events);
				$td .= htmltag('td', '', $ins);
				}
			$tr .= htmltag('tr', '', $td);
			}
		$table = htmltag('table', 'id="cal_week" class="preview"', $tr);
		$c .= $table;
		return $c;
		}

	public function day() {
		$base = "?_id={$this->action}&amp;sid={$this->sid}&amp;view=d";
		$day = "&amp;_y={$this->yea}&amp;_m={$this->mon}&amp;_d={$this->day}";
		$prev = explode('-', date('Y-m-d', strtotime('-1 day', strtotime("{$this->yea}-{$this->mon}-{$this->day}"))));
		$next = explode('-', date('Y-m-d', strtotime('+1 day', strtotime("{$this->yea}-{$this->mon}-{$this->day}"))));
		$p = htmltag('a', "href=\"$base&amp;_y={$prev[0]}&amp;_m={$prev[1]}&amp;_d={$prev[2]}\"", get_icon('angle-left', '<'));
		$n = htmltag('a', "href=\"$base&amp;_y={$next[0]}&amp;_m={$next[1]}&amp;_d={$next[2]}\"", get_icon('angle-right', '>'));
		$c = htmltag('h2', '', "$p {$this->yea}-{$this->mon}-{$this->day} $n");
		$wd = date('D', strtotime("{$this->yea}-{$this->mon}-{$this->day}"));
		$feast = in_array($wd, ['Sat','Sun']) ? ' feast' : '';
		$name = '';
		if (array_key_exists("{$this->mon}-{$this->day}", $this->feasts)) {
			$name = $this->feasts["{$this->mon}-{$this->day}"];
			$feast = ' feast';
			}
		$wd = htmltag('span', 'class="daynumber'.$feast.'"', $wd);
		$moon = $this->moon ? $this->moon($this->yea, $this->mon, $this->day) : '';
		$th = htmltag('th', '', i18n('hour'));
		$th .= htmltag('td', '', htmltag('span', 'class="inside"', "$wd $moon $name"));
		$tr = htmltag('tr', '', $th);
		for ($i = 6; $i <= 23; $i++) {
			$hh = sprintf('%02d', $i).':00';
			$new = htmltag('a', "href=\"$base$day&amp;start=$hh&amp;todo=edit\"",  htmltag('i', 'class="fas fa-plus-circle fa-lg"', ''));
			$th = htmltag('th', '', "$hh $new");
			$events = '';
			if (array_key_exists("{$this->day}-$i", $this->events)) {
				$ev = $this->events["{$this->day}-$i"];
				$events .= $ev;
			}
			$ins = htmltag('div', "data-day='{$this->yea}-{$this->mon}-{$this->day}-$i'", $events);
			$td = htmltag('td', '', $ins);
			$tr .= htmltag('tr', '', $th.$td);
			}
		$table = htmltag('table', 'id="cal_day" class="preview"', $tr);
		$c .= $table;
		return $c;
		}

	private function moon($y,$m,$d) {
		$syn = 29.53031;
		$off = 5.36945; // maybe incorrect for europe (?)
		$moon = "";
		$days = round((strtotime("$y-$m-$d 00:00:00")-strtotime("1601-01-01 00:00:00"))/86400);
		$marks = [$off => "circle-gold", ($syn/4)+$off => "moon-gold", ($syn/2)+$off => "far-circle-gold", (($syn/4)*3)+$off => "flip-moon-gold"];
		foreach ($marks as $k=>$v) {
			if (intval(((intval(($days-$k)/$syn)+0.5)*$syn)+$k) == $days) {$moon = $v;}
			}
		if ($moon) {$moon = get_icon($moon, 'moon')." ";}
		return ($moon);
		}

	public function export() {
		}
  }

?>
