<?php

require_once('carousel_generator.php');

function plugin($html) {
	switch ($html['action']) {
		case ("car_settings"): $html = car_settings($html); break;
		default: $html = carousel_admin($html);
		}
	return $html;
	}

function carousel_admin($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$lang = param('lang') ? clean_var(param('lang'), "w") : $html['con']['ln'];

	$form = [
		"title"			=> i18n('carousel'),
		"table"			=> "carousel",
		"myconf"		=> "carousel",
		"orderby"		=> "sort",
		"human"			=> "text",
		"html"			=> $html,
		"rid"			=> $rid,
		"filters"		=> ['lang'],
		"search"		=> ['title'],
		"allow_box"		=> 'both',
		"attr_to_set"	=> ['active'],
		"table_fields"	=> ['picture', 'active', 'sort', 'title', 'text', 'link']
		];

	$inputs = [
		'title'	=> [
			'type'	=> 'text',
			],
		'text'	=> [
			'type'	=> 'bigtext',
			'rows'	=> 5
			],
		'link'	=> [
			'type'	=> 'link',
			],
		'publish' => [
			'type' => 'fieldset',
			"icon"		=> "todo"
			],
		'active'	=> [
			'type'	=> 'flag',
			],
		'lang'	=>	[
			'caption'	=> i18n('language'),
			'type'		=> 'lookup',
			'default'	=> $html['con']['ln'],
			"lid"		=> "iso639",
			"lval"		=> "language",
			"lord"		=> "language",
			"ltable"	=> "languages",
			"lclause"	=> " where `multilingual` = 'on'",
			'duty' => 1
			],
		'sort'	=> [
			'type'	=> 'sort',
			'do'	=> 1,
			'type'	=> 'sort',
			'default' => 10
			],
		'label'	=> [
			"caption"	=> i18n('picture'),
			"icon"		=> "image",
			"type"		=> "fieldset"
			],
		'picture'	=> [
			'type'	=> 'image',
			'duty'	=> 1,
			],
		'alt'	=> [
			"caption"	=> i18n('alternative'),
			'type'	=> 'text',
			],
		];


	$obj = new access($form);
	if ($obj->set_attribute($inputs)) {generate_carousel(); generate();}

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], '', '');
		generate_carousel();
		generate();
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			generate_carousel();
			generate();
			}
		}
	if ($todo == "preview") {
		$html = car_preview($lang);
		}
	elseif ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
		[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
		[i18n('carousel'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", "database-go"],
		[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=car_settings", "inactive", "wrench"]
		);
	$obj->before_table = make_submenu($submen);
		if (param('_del')) {
			$obj->delete();
			generate_carousel();
			generate();
			}
		$html = $obj->table($inputs);
		}
	$html['left'] = carousel_tree($lang, $form['myconf']);
	$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\".preview a\").popLink({header: '".i18n('preview')."', 'top': '5%', 'left': '1%', 'width': '1024', 'height': '600'});});</script>\n";
	return $html;
	}

function car_settings($html) {
	global $con;
	$form = [
		"title"			=> i18n('carousel')." &ndash; ".i18n('settings'),
		"table"			=> "cms_settings",
		"myconf"		=> "car_settings",
		"human"			=> "name",
		"no_cancel" 	=> "1",
		"table_fields"	=> ["key", "value", "lang"],
		"html"			=> $html,
		];

	$inputs = [
		"group"			=> ['type' => "free", 'default' => "carousel"],
		"rule"			=> ['type' => "free", 'default' => $con['rule']],
		"lang"			=> ['type' => "free", 'default' => '*'],
		"active"		=> [
			'type'		=> "flag"
			],
		"movement"		=> [
			'type'		=> "array",
			'raw'		=> 1,
			'duty'		=> 1,
			'default'	=> "x",
			'extra'		=> ["x", "y", "z"]
			],
		"controls"		=> [
			'type'		=> "flag"
			],
		"pager"		=> [
			'type'		=> "flag"
			],
		"auto"		=> [
			'type'		=> "flag"
			],
		"interval"		=> [
			'type'		=> "spin",
			'size'		=> 2,
			'default'	=> 6,
			'min'		=> 2,
			'max'		=> 15,
			'interval'	=> 1
			],
		"preview_width"		=> [
			'type'		=> "hidden",
			'default'	=> 746
			]
		];

	if ($html['user']['level'] > 2) {$inputs['preview_width']['type'] = 'number';}

	$obj = new access($form);
	$submen = array(
		[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id=carousel&amp;todo=edit", "inactive", "add"],
		[i18n('carousel'), $html['myurl']."?sid={$html['sid']}&amp;_id=carousel", "inactive", "database-go"],
		[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=car_settings", "active", "wrench"]
		);
	$obj->before_form = make_submenu($submen);

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {
			$obj->error = 0;
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		else {
			$obj->store_settings($inputs);
			generate_carousel();
			generate();
			$feedback = "<p>".$obj->feedback."</p><p><a href='{$html['myurl']}?_id=carousel&amp;sid={$html['sid']}' class='as_button'>".i18n('ok')."</a></p>";
			$html['content'] = say_mess($feedback, i18n('info'), 'info');
			}
		}
	else {
		$inputs = $obj->get_settings_value($inputs);
		$obj->add_input($inputs);
		$html = $obj->form();
		}
	$html['left'] = '';
	return ($html);
	}

function carousel_tree($open, $action) {
	global $html, $con;
	$tree = "";
	foreach (array_keys($con['langs']) as $lang) {
		$subitem = [
			"caption"	=> i18n('preview'),
			"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}&amp;lang=$lang&amp;todo=preview",
			"state"		=> "preview"
			];
		$subtree = list_item($subitem);
		$item = [
			"caption"	=> $con['langs'][$lang],
			"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}&amp;lang=$lang",
			"state"		=> "langs",
			"sub"		=> htmltag('ul', '', $subtree)
			];
		$tree .= list_item($item);
		}

	$tree = parse_in('gui_tree', ['treelist' => $tree]);
	return $tree;
	}

// show a preview of the carousel
function car_preview($lang) {
	global $website, $html, $con;
	$settings = read_settings(['group' => 'carousel']);
	$content = read_component(['component' => 'carousel', 'lang' => $lang]);
	$scripts = parse_in('cms_scripts', ['ajax' => '', 'scripts' => '']);
	$path = file_exists($html['dir']."/css/themes/{$website['def_css']}") ? 'themes/' : '';
	$html['content'] = <<<"TNIRP"
<!DOCTYPE html>
<html lang="$lang">
<head>
	<meta charset="{$con['charset']}" />
	<link rel="stylesheet" type="text/css" href="/css/{$path}{$website['def_css']}" />
	<title>{$website['website_title']}</title>
$scripts
</head>
<body>
<div style="width: {$settings['preview_width']}px">
$content
</div>
</body>
</html>
TNIRP;
	$html['gui'] = 6;
	$html['con'] = $con;
	$html['title'] = '';
	$html['scripts'] = '';
	return $html;
	}

?>
