<?php

function generate_carousel() {
	global $db, $con;
	$settings = read_settings(['group' => 'carousel']);
	$car = array();
	$query = "select * from `carousel` where `active` = 'on' order by `lang`, `sort`;";
	$arg = $db->prepare($query);
	$arg->execute();
	$i = 1;
	while ($a = $arg->fetch(PDO::FETCH_ASSOC)) {
		if (!array_key_exists($a['lang'], $car)) {$car[$a['lang']] = "";}
		if (!$a['alt']) {$a['alt'] = ' ';}
		$a['picture'] = parse_in('cms_carousel_picture', $a);
		if ($a['link']) {
			if ($a['text']) {
				$a['text'] = nl2br($a['text']);
				$a['more'] = sys_trans('more', $a['lang']);
				$a['text'] .= parse_in('cms_carousel_more', $a);
				$a['text'] = htmltag('p', '', $a['text']);
				}
			elseif ($a['title']) {$a['title'] = htmltag('a', "href=\"{$a['link']}\"", $a['title']);}
			$a['picture'] = htmltag('a', "href=\"{$a['link']}\"", $a['picture']);
			}
		if ($a['title']) {$a['title'] = parse_in('cms_carousel_title', $a);}
		if ($a['text'] || $a['title']) {
			$a['text'] = parse_in('cms_carousel_textcontainer', $a);
			}
		$car[$a['lang']] .= htmltag('li', 'id="car_item_'.$i.'"', $a['picture'].$a['text']);
		$i++;
		}

	foreach (array_keys($con['langs']) as $ln) {
		$carhtml = "<!-- NO CAROUSEL $ln -->";
		if (array_key_exists($ln, $car)) {
			$data = [
				"previous" => sys_trans("previous", $ln),
				"next" => sys_trans("next", $ln),
				"params" => "axis: '{$settings['movement']}',",
				"list" => $car[$ln],
				"timestamp" => date('Y-m-d H:i:s')
				];
			if ($settings['auto'] == "on") {$data['params'] .= " interval: true,";}
			if ($settings['pager'] == "on") {$data['params'] .= " pager: true,";}
			if (!$settings['controls']) {$data['params'] .= " controls: false,";}
			if ($settings['interval'] < 2) {$settings['interval'] = 2;}
			$interv = $settings['interval']*1000;
			$data['params'] .= " intervaltime: $interv,";
			$carhtml = parse_in('cms_carousel', $data);
			}
		$data = ['component' => 'CAROUSEL', 'html' => $carhtml, 'lang' => $ln, 'active' => $settings['active'], 'custom' => ''];
		write_component($data);
		}
	}

?>
