<?php
# @Author: consentio
# @Date:   2018-08-18T16:58:33+02:00
# @Last modified by:   consentio
# @Last modified time: 2023-08-21T11:12:27+02:00




include_once('gallery_generator.php');

function plugin($html) {
	if (param('todo') == 'deps') {$html['action'] = 'deps';}
	switch ($html['action']) {
		case ("deps"): $html = get_deps($html); break;
		case ("gal_images"): $html = gal_images_admin($html); break;
		default: $html = gallery_admin($html);
		}
	return $html;
	}

function gallery_admin($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$parent = clean_var(param('parent'), "n");
	$source = clean_var(param('make'), "n");

	list($mylang, $myparent, $ptype) = parents_def($parent);
	$form = form_by_type(1);
	$form['rid'] = $rid;
	$form['myconf'] = "gallery";
	$form['title'] .= " &ndash; ".i18n("gallery");
	$form['left'] = [['table' => 'gallery', 'foreign' => 'pid']];
	$or_inputs = inputs_by_type('plugin');
	$or_inputs['type'] =	['type' => 'hidden', 'default' => 'gallery'];
	$or_inputs['folder'] =	['type' => 'hidden', 'value' => 0];
	$or_inputs['parent']['default'] = $parent;

	$inputs2 = [
		'preface' => [
			'type'		=> 'wysiwyg',
			'table'		=> 1,
			'rows'		=> 15,
			],
		'gal_template' => [
			'type'		=> 'array',
			'table'		=> 1,
			'duty'		=> 1,
			'extra'		=> [i18n('gal_3_col'), i18n('gal_4_col'), i18n('gal_5_col')],
			],
		'pic_dim' => [
			'caption'	=> i18n('pic_dim'),
			'type'		=> 'array',
			'duty'		=> 1,
			'table'		=> 1,
			'extra'		=> [i18n('square'), i18n('thumbs'), i18n('cinemascope'), i18n('small')],
			],
		'images' => [
			'type' => 'subform',
			'conf' => 'gal_images',
			'foreign' => 'gallery',
			'height' => 650
			]
		];

	if ($todo == 'all') {
		gen_all_galleries();
		generate();
		}

	if (!$rid || $rid == "new") {
		$form['button_text'] = i18n('next');
		$inputs = [
			'title' 		=>	$or_inputs['title'],
			'short' 		=>	$or_inputs['short'],
			'folder' 		=> $or_inputs['folder'],
			'lang'			=>	$or_inputs['lang'],
			'parent' 		=> $or_inputs['parent'],
			'type' 			=> $or_inputs['type'],
			'file' 			=>	['type' => 'hidden'],
			'make' 			=>	[
				'caption' => i18n('img_source'),
				'type' => 'array',
				'extra' => [i18n('add_by_hand'), i18n('img_portfolio')], // , i18n('img_lightdesk')
				'css_class' => 'ask_for_more',
				'default' => 1,
				'duty'	=> 1
				]
			];
		}
	else {
		$in1 = array_slice($or_inputs, 0, 4);
		$in2 = array_slice($or_inputs, 4);
		$inputs = array_merge($in1, $inputs2, $in2);
		}


	$obj = new access($form);

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			if ($obj->rid == "new") {
				unset($inputs['make']);
				$inputs['file']['value'] = "/".clean_filename($inputs['title']['value'].".html", $html['dir']);
				$rid = $obj->store($inputs);
				$obj->rid = $rid;
				$obj->feedback = '';
				if ($source >= 1) {insert_img($rid, $source);}
				// next form
				$todo = "edit";
				$obj->button_text = i18n('save');
				$in1 = array_slice($or_inputs, 0, 4);
				$in2 = array_slice($or_inputs, 4);
				$inputs = array_merge($in1, $inputs2, $in2);
				}
			else {
				$inputs['update']['value'] = date('Y-m-d H:i:s');
				$inputs['last_editor']['value'] = $html['user']['id'];
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				generate_gallery($obj->stored, $id);
				generate();
				}
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$inputs['parent']['lclause'] .= " AND `lang` = '$mylang'";
			$inputs['lang']['default'] = $mylang;
			$obj->add_input($inputs);
			$html = $obj->form();
			$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"#ishort\").title2short();});</script>\n";
			}
		}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		if (param('_del')) {
			$records = $obj->get_multiple_values($inputs); // before we delete we need some values
			foreach ($records as $row) {
				unlink("{$html['dir']}{$row['file']}");
				}
			$obj->delete();
			generate();
			}
		$obj->myconf = 'pages'; // return to pages...
		$obj->title = i18n("pages");
		$inputs = inputs_by_type('view');
		$submen = pages_tabs($parent);
		$obj->before_table = make_submenu($submen);
		$html = $obj->table($inputs);
		$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"[data-app='preview']\").popLink({header: '".i18n('preview')."', 'top': '5%', 'left': '1%', 'width': '1024', 'height': '600'});});</script>\n";
		}
	$html['left'] = content_tree($parent, "pages");
	$html['scripts'] .= <<< "EOL"
<script type="text/javascript">
\$(document).ready(function(){\$(".ask_for_more").moreInputs({'id':"gallery",'sid':"{$html['sid']}",'script':"{$html['con']['coco']}/",'todo':'deps'})});
</script>
EOL;
	return $html;
	}

function gal_images_admin($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$gallery = clean_var(param('gallery'), "w");

	$form = [
		"title"			=> i18n('gal_images'),
		"table"			=> "gal_images",
		"myconf"		=> "gal_images",
		"orderby"		=> "sort",
		"human"			=> "picture",
		"html"			=> $html,
		"rid"			=> $rid,
		"filters"		=> ["gallery"],
		"searchform"	=> 0,
		"table_fields"	=> ['picture', 'caption', 'text', 'sort']
		];

	$inputs = [
		'picture'	=> [
			'type'	=> 'image',
			'duty'	=> 1,
			],
		'caption'	=> [
			'caption' => i18n('title'),
			'type'	=> 'text',
			],
		'copyright'	=> [
			'type'	=> 'text',
			],
		'text'	=> [
			'type'	=> 'wysiwyg',
			'config'	=> 'text',
			'rows'	=> 7,
			],
		'gallery'	=> [
			'type'	=> 'hidden',
			'default'	=> $gallery
			],
		'sort'	=> [
			'type'	=> 'sort',
			'do'	=> 1,
			'type'	=> 'sort',
			'default'	=> 1,
			]
		];


	$obj = new access($form);
	// $obj->set_attribute($inputs);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], 'gallery', $gallery);
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$submen = array(
			[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;gallery=$gallery", "inactive", "add"]
			);
		$obj->before_table = make_submenu($submen);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		}
	$html['left'] = "Do Something Here";
	return $html;
	}


function get_deps($html) {
	$val = param('_v');
	$prae = param('_ref');
	$html['content'] = "";
	if ($val == 2) {
		$form = ["html"	=> $html];
		$sel = [
			'portfolio' =>	[
				'type'	=> 'lookup',
				'duty'	=> 1,
				'lid'	=> "id",
				'lval'	=> "graduated",
				'tval'	=> "name",
				'lord'	=> "parentsort",
				'ltable'	=> "image_folder"
				],
			'import_text' => [
				'type'	=> 'flag',
				'default' => 'on'
				]
			];
		$obj = new access($form);
		$obj->add_input($sel);
		$html['content'] = $obj->inputs;
		}
	elseif ($val == 3) {
		$form = ["html"	=> $html];
		$sel = [
			'import_text' => [
				'type'	=> 'flag',
				'default' => 'on'
				]
			];
		$obj = new access($form);
		$obj->add_input($sel);
		$html['content'] = $obj->inputs;
		}
	$html['gui'] = 6;
	return $html;
	}

function insert_img($rid, $source) {
	global $db;
	if ($source == 2) {
		$pf = clean_var(param('portfolio'), 'n');
		$q = "SELECT * FROM `image_db` WHERE `parent` = ? ORDER BY `id` LIMIT 30;";
		$arg = $db->prepare($q);
		$arg->execute(array($pf));
		while ($img = $arg->fetch(PDO::FETCH_ASSOC)) {
			$img['description'] = preg_match('/^\[/', $img['description']) ? '' : htmltag('p', '', $img['description']);
			if (param('import_text') != 'on'){$img['title'] = ''; $img['description'] = '';}
			$q2 = "INSERT INTO `gal_images` SET `picture` = ?, `caption` = ?, `copyright` = ?, `text` = ?, `gallery` = ?;";
			$arg2 = $db->prepare($q2);
			$arg2->execute(array($img['filename'], $img['title'], $img['copyright'], $img['description'], $rid));
			}
		}
	}
?>
