<?php

function generate_gallery($data, $id) {
	global $website;
	if ($website['css_generation'] != 2) {generation_one($data, $id);}
	else {generation_two($data, $id);}
	}

function generation_two($data, $id) {
	global $db, $html;
	$templates = ['', 'cms_gallery_items3', 'cms_gallery_items4', 'cms_gallery_items5'];
	$dim = ['', 'square', 'thumbs', 'cinemascope', 'small'];
	$cols = $data['gal_template']+2;
	$data['gal_template'] = $templates[$data['gal_template']];
	$data['pic_dim'] = $dim[$data['pic_dim']];
	$description = strip_tags($data['preface']);
	if (!$description){$data['preface'] = "";}
	$q = "SELECT * FROM `gal_images` WHERE `gallery` = ? ORDER BY `sort`;";
	$arg = $db->prepare($q);
	$arg->execute(array($id));
	$data['list'] = '';
	$i = 0;
	while ($img = $arg->fetch(PDO::FETCH_ASSOC)) {
		$img['alt'] = '';
		$img['path'] = $data['pic_dim'];
		$img['class'] = in_array($data['pic_dim'], ['cinemascope', 'small']) ? 'class="cover320"' : '';
		if ($cols >= 5) {
			if ($img['caption']) {
				$img['alt'] = $img['caption'];
				$img['caption'] = htmltag('p', '',$img['caption']);
				}
			if ($img['copyright']) {$img['alt'] .= ' - &copy; '.$img['copyright'];}
			}
		else {
			if ($img['caption']) {
			$img['alt'] = $img['caption'];
			$img['caption'] = htmltag('h2', '',$img['caption']);
			}
			if ($img['copyright']) {$img['copyright'] = htmltag('p', 'class="copyright"', '&copy; '.$img['copyright']);}
			}
		if (!strip_tags($img['text'])){$img['text'] = "";};
		list($img['width'], $img['height']) = getimagesize("{$html['dir']}/pictures/{$data['pic_dim']}/{$img['picture']}");
		if ($i >= 10) {$img['class'] .= ' loading="lazy"';}
		$data['list'] .= parse_in($data['gal_template'], $img);
		$i++;
		}
	// close ul if row is incomplete
	$data['timestamp'] = date('Y-m-d H:i:s');
	$content = parse_in('cms_gallery', $data);
	$q = "UPDATE `content` SET `body` = ?, `description` = ?, `generate` = 1 WHERE `id` = ?;";
	$arg = $db->prepare($q);
	$arg->execute(array($content, $description, $id));
	}

function generation_one ($data, $id) {
	global $db, $html;
	$templates = ['', 'cms_gallery_items_1of3', 'cms_gallery_items_1of4', 'cms_gallery_items_1of5'];
	$dim = ['', 'square', 'thumbs', 'cinemascope', 'small'];
	$data['gal_template'] = $templates[$data['gal_template']];
	$data['pic_dim'] = $dim[$data['pic_dim']];
	$description = strip_tags($data['preface']);
	if (!$description){$data['preface'] = "";}
	$q = "SELECT * FROM `gal_images` WHERE `gallery` = ? ORDER BY `sort`;";
	$arg = $db->prepare($q);
	$arg->execute(array($id));
	$data['list'] = '';
	$i = 0;
	// we may have columns with alternative snippets for each column
	// like cms_gallery_items_1of3
	$cols = 1; $colno = 1;
	preg_match('/(\d+)of(\d+)$/', $data['gal_template'], $m);
	if (isset($m[2])) {
		$cols = $m[2];
		$data['gal_template'] = preg_replace('/(\d+)of(\d+)$/', '', $data['gal_template']);
		}
	while ($img = $arg->fetch(PDO::FETCH_ASSOC)) {
		$img['alt'] = '';
		$img['path'] = $data['pic_dim'];
		if ($cols >= 5) {
			if ($img['caption']) {
				$img['alt'] = $img['caption'];
				$img['caption'] = htmltag('p', '',$img['caption']);
				}
			if ($img['copyright']) {$img['alt'] .= ' - &copy; '.$img['copyright'];}
			}
		else {
			if ($img['caption']) {
			$img['alt'] = $img['caption'];
			$img['caption'] = htmltag('h2', '',$img['caption']);
			}
			if ($img['copyright']) {$img['copyright'] = htmltag('p', 'class="copyright"', '&copy; '.$img['copyright']);}
			}
		if (!strip_tags($img['text'])){$img['text'] = "";};
		list($img['width'], $img['height']) = getimagesize("{$html['dir']}/pictures/{$data['pic_dim']}/{$img['picture']}");
		// in the middle it is alway 2ofx
		$part = $colno == 1 || $colno == $cols ? $colno : 2;
		$snippet = $cols > 1 ? $data['gal_template']."{$part}of$cols" : $data['gal_template'];
		$data['list'] .= parse_in($snippet, $img);
		$colno++;
		if ($colno > $cols) {$colno = 1;}
		$i++;
		}
	// close ul if row is incomplete
	if ($colno != 1) {$data['list'] .= "</ul>";}
	$data['timestamp'] = date('Y-m-d H:i:s');
	$content = parse_in('cms_gallery', $data);
	$q = "UPDATE `content` SET `body` = ?, `description` = ?, `generate` = 1 WHERE `id` = ?;";
	$arg = $db->prepare($q);
	$arg->execute(array($content, $description, $id));
	}

function gen_all_galleries() {
	global $db;
	$q = "SELECT `content`.`id`, `content`.`title`, `content`.`short`, `content`.`folder`, `content`.`lang`,
	`gallery`.`preface`, `gallery`.`gal_template`, `gallery`.`pic_dim`, `content`.`published`,
	`content`.`parent`, `content`.`template`, `content`.`sort`, `content`.`file`,
	`content`.`update`, `content`.`c_start`, `content`.`c_end`, `content`.`type`
	FROM `content` LEFT JOIN `gallery` ON `content`.`id` = `gallery`.`pid`
	WHERE `published` >= 1 AND `content`.`type` = 'gallery' ORDER BY `sort`;";
	$arg = $db->prepare($q);
	$arg->execute();
	$rec = $arg->rowCount();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		generate_gallery($data, $data['id']);
		}
	}
?>
