<?php
# @Author: Rainer Imb <consentio>
# @Date:   2021-02-22 06:17:56
# @Email:  imb@consentio.at
# @Project: consentio mccurdy
# @Filename: gastro.php
# @Last modified by:   consentio
# @Last modified time: 2021-02-26 06:38:20
# @License: GPL 2.0

class gastro {

	public function plugin($html) {
		switch ($html['action']) {
			case ("gastro_settings"): $html = $this->settings($html); break;
			default: $html = $this->gastro_admin($html);
			}
		return $html;
		}

	private function gastro_admin($html) {
		require_once('gastro_generator.php');
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$call = param('temp') ? clean_var(param('temp'), 'w') : false;
		$clause = $call ? "`day` = '$call'" : '';
		$do = $call ? true : false;
		$ob = $call ? 'sort' : 'day';
		$sb = $call ? 'ASC' : 'DESC';

		$form = [
			"title"			=> i18n('gastro'),
			"table"			=> "gastro",
			"myconf"		=> "gastro",
			"orderby"		=> $ob,
			"defsort"		=> $sb,
			"human"			=> "meal",
			"html"			=> $html,
			"rid"			=> $rid,
			"allow_box"		=> "both",
			"attr_to_set"	=> ["day"],
			"search"		=> ['meal', 'description'],
			"table_fields"	=> ['day', 'meal', 'description', 'price', 'sort'],
			"clause" => $clause
			];

		$inputs = [
		'day'	=> [
			'type'	=> 'date',
			'default'	=> date('Y-m-d'),
			'duty'	=> 1,
			],
		'meal'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'starter'	=> [
			'type'	=> 'text',
			],
		'dessert'	=> [
			'type'	=> 'text',
			],
		'description'	=> [
			'type'	=> 'bigtext',
			],
		'price'	=> [
			'type'	=> 'number',
			'duty'	=> 1,
			],
		'allergen'	=> [
			'type'	=> 'multicheck',
			'ltable' => 'allergen',
			'lval'	=> 'name'
			],
		'sort'	=> [
			'type'	=> 'sort',
			'default'	=> 10,
			'do'	=> $do
		],
		'temp'	=> [
			'type'	=> 'free',
			'value'	=> $call
			]
		];


		$obj = new access($form);
		$obj->set_attribute($inputs);

		if (param('_sortlist')) {
			$obj->sort_list();
			reorder($form['table'], 'day', $call);
			$gen = new gastro_generator();
			$gen->generate();
			generate();
			}

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				$gen = new gastro_generator();
				$gen->generate();
				generate();
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		elseif (param('_set_att')) {
			$html = $obj->attr_form($inputs);
			$gen = new gastro_generator();
			$gen->generate();
			generate();
			}
		elseif ($todo == "delete" || param('_del_all')) {
			$html = $obj->ask();
			$gen = new gastro_generator();
			$gen->generate();
			generate();
			}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
				[i18n('gastro'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", "cutlery"],
				[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=gastro_settings", "inactive", "wrench"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			//echo $obj->query;
			}
		// default tree shows plugins of group "plugins"
		$html['left'] = get_tab_tree($html, "plugins", $form['myconf'], $this->tree());
		return $html;
		}

	private function settings($html) {
		global $con;
		require_once('gastro_generator.php');
		$form = [
			"title"			=> i18n('gastro')."-".i18n('settings'),
			"table"			=> "cms_settings",
			"myconf"		=> "gastro_settings",
			"human"			=> "name",
			"no_cancel" 	=> "1",
			"table_fields"	=> ["key", "value", "lang"],
			"html"			=> $html,
			];

		$inputs = [
			"group"			=> ['type' => "free", 'default' => "gastro"],
			"rule"			=> ['type' => "free", 'default' => $con['rule']],
			"lang"			=> ['type' => "free", 'default' => '*'],
			"short"			=> ['type'		=> "text"],
			"title"			=> ['type'		=> "text"],
			"folder"		=> [
				'caption'	=> i18n('folder'),
				'type' => 'lookup',
				"lid"		=> "id",
				"lval"		=> "graduated",
				"lord"		=> "parentsort",
				"ltable"	=> "folder_view",
				"lclause"	=> "`type` IN ('root', 'folder', 'node')",
				'duty' => 1
				],
			"active"		=> ['type'		=> "flag"],
			"header"		=> ['type'		=> "text"],
			"footer"		=> ['type'		=> "text"],
			"for_days"		=> [
				'type'		=> "array",
				'raw'		=> true,
				'extra'		=> [7,14,21,28],
				'duty'		=> 1
				]
			];

		$obj = new access($form);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {
				$obj->error = 0;
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			else {
				$obj->store_settings($inputs);
				$feedback = "<p>".$obj->feedback."</p><p><a href='{$html['myurl']}?_id=gastro_settings&amp;sid={$html['sid']}' class='as_button'>".i18n('ok')."</a></p>";
				$html['content'] = say_mess($feedback, i18n('info'), 'info');
				$gen = new gastro_generator();
				$gen->generate();
				generate();}
			}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
				[i18n('gastro'), $html['myurl']."?sid={$html['sid']}&amp;_id=gastro", "inactive", "cutlery"],
				[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=gastro_settings", "active", "wrench"]
				);
			$obj->before_form = make_submenu($submen);
			$inputs = $obj->get_settings_value($inputs);
			$obj->add_input($inputs);
			$html = $obj->form();
			}

		$html['left'] = get_tab_tree($html, "plugins", $form['myconf'], "");
		return ($html);
		}

	private function tree() {
		global $html;
		$tree = '';
		$call = param('day') ? clean_var(param('day'), 'w') : '';
		for ($i=0;$i <= 28; $i++) {
			$day = date('Y-m-d', strtotime("+$i day"));
			$state = $day == $call ? "open" : "closed";
			$item = [
				"caption"	=> $day,
				"link"		=> "{$html['myurl']}?_id=gastro&amp;sid={$html['sid']}&amp;temp=$day",
				"state"		=> $state
				];
			$tree .= list_item($item);
			}
		$tree = htmltag('ul', '', $tree);
		return $tree;
		}

	private function roman_figures($i) {
		$map = array('M' => 1000, 'CM' => 900, 'D' => 500, 'CD' => 400, 'C' => 100, 'XC' => 90, 'L' => 50, 'XL' => 40, 'X' => 10, 'IX' => 9, 'V' => 5, 'IV' => 4, 'I' => 1);
		$roma = '';
		while ($number > 0) {
			foreach ($map as $roman => $int) {
				if($number >= $int) {
					$number -= $int;
					$roma .= $roman;
					break;
					}
				}
			}
		return $roma;
		}
	}
?>
