<?php
# @Author: Rainer Imb <consentio>
# @Date:   2021-02-26 05:35:57
# @Email:  imb@consentio.at
# @Project: consentio mccurdy
# @Filename: gastro_generator.php
# @Last modified by:   consentio
# @Last modified time: 2021-07-06 04:23:24
# @License: GPL 2.0

class gastro_generator {
	private $allergen;
	private $cols = [15, 42, 55, 130, 150, 170, 190];
	private $rows = [5, 15];

	public function generate() {
		add_i18n('gastro');
		$this->get_allergen();
		$this->generate_box();
		$this->generate_page();
		}

	public function generate_box() {
		global $db, $con;
		$date = date('Y-m-d');
		$gastro = read_settings(['group' => 'gastro']);
		$query = "SELECT * FROM `gastro` WHERE `day` = ? ORDER BY `sort`;";
		$arg = $db->prepare($query);
		$arg->execute([$date]);
		$i = 1;
		$count = $arg->rowCount();
		$gastro['list'] = '';
		while ($d = $arg->fetch(PDO::FETCH_ASSOC)) {
			$d['count'] = $count; $d['no'] = $i;
			$gastro['list'] .= $this->one_meal($d);
			if (!array_key_exists('date', $gastro)){
				$gastro['date'] = i18n('today').' '.i18n_date($d['day'], $con['ln'], 'long');
				}
			$i++;
			}
		$file = as_filename($gastro['title']);
		$gastro['list'] .= htmltag('p', 'class="alright"', htmltag('a', "href=\"/$file.html\" class=\"as_button\"", get_icon('cutlery', ' ').' '.i18n('more')));
		$content = parse_in('cms_gastro', $gastro);
		$data = ['component' => 'GASTRO_BOX', 'html' => $content, 'lang' => '*', 'active' => $gastro['active'], 'custom' => ''];
		write_component($data);
		}

	public function generate_page() {
		global $db, $con, $html;
		$date = date('Y-m-d');
		$gastro = read_settings(['group' => 'gastro']);
		$db_action = "UPDATE";
		$arg = $db->prepare("SELECT * FROM `content` WHERE `type` = 'gastro' LIMIT 1;");
		$arg->execute();
		$page = $arg->fetch(PDO::FETCH_ASSOC);
		$pdfdata = [];

		if (!$page['id']) {
			$db_action = "INSERT INTO";
			$page['file'] = "/".clean_filename($gastro['title'].".html", $html['dir']);
			$page['written'] = date('Y-m-d H:i:s');
			}
		$page['update'] = date('Y-m-d H:i:s');
		$q = "SELECT * FROM `gastro` WHERE `day` >= ? ORDER BY `day`, `sort`;";
		$arg = $db->prepare($q);
		$arg->execute([$date]);
		$i = 1;
		$file = ansitrans($gastro['short']).'.pdf';
		$page['body'] = htmltag('p', 'class="alright"', htmltag('a', "href=\"/documents/$file\" class=\"as_button\"", get_icon('far-file-pdf', 'PDF').' '.i18n('print_version')));
		$last = false;
		while ($d = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($d['day'] != $last) {
				$page['body'] .= htmltag('h2', '', i18n_date($d['day'], $con['ln'], 'long'));
				$last = $d['day'];
				$i = 1;
				}
			$d['count'] = 2; $d['no'] = $i;
			$page['body'] .= $this->one_meal($d);
			array_push($pdfdata, $d);
			$i++;
			}
		$q = $db_action." `content` SET `title` = ?, `short` = ?, `body` = ?, `lang` = ?, `published` = ?,  `parent` = ?,  `file` = ?, `written` = ?, `update` = ?, `type` = 'gastro', `generate` = '1', `template` = '2', `show_title` = 'on'";
		if ($db_action == 'UPDATE') {$q .= " WHERE `id` = '{$page['id']}';";}
		else {$q .= ";";}
		$publ = $gastro['active'] == 'on' ? 3 : 1;
		$arg = $db->prepare($q);
		//echo $q;
		$arg->execute([$gastro['title'], $gastro['short'], $page['body'], 'de', $publ, $gastro['folder'], $page['file'], $page['written'], $page['update']]);
		$this->make_pdf($gastro, $pdfdata);
		}

	private function one_meal($d) {
		$d['heading'] = '';
		if ($d['count'] > 1) {$d['heading'] = $this->roman_figures($d['no']).'. ';}
		$d['heading'] .= $d['meal'];
		if ($d['starter']) {$d['starter'] = htmltag('p', '', i18n('starter').': '.$d['starter']);}
		if ($d['dessert']) {$d['dessert'] = htmltag('p', '', i18n('dessert').': '.$d['dessert']);}
		if ($d['description']) {$d['description'] = htmltag('p', '', $d['description']);}
		if ($d['allergen']) {$d['allergen'] = htmltag('p', 'class="picturetext"', i18n('allergen').': '.$this->get_allergen_list($d['allergen']));}
		return parse_in('cms_gastro_meal', $d);
		}

	private function roman_figures($i) {
		$map = array('M' => 1000, 'CM' => 900, 'D' => 500, 'CD' => 400, 'C' => 100, 'XC' => 90, 'L' => 50, 'XL' => 40, 'X' => 10, 'IX' => 9, 'V' => 5, 'IV' => 4, 'I' => 1);
		$roma = '';
		while ($i > 0) {
			foreach ($map as $roman => $int) {if($i >= $int) {$i -= $int; $roma .= $roman; break;}}
			}
		return $roma;
		}

	private function get_allergen() {
		global $db;
		$arg = $db->prepare("SELECT `name` FROM `allergen` ORDER BY `id`");
		$arg->execute();
		$this->allergen = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
		}

	private function get_allergen_list($al) {
		$list = "";
		$loop = explode(",", $al);
		foreach ($loop as $v) {
			$v--;
			$list .= $this->allergen[$v].', ';
			}
		if ($list) {$list = preg_replace("/,\s$/", '', $list);}
		return $list;
		}

	private function make_pdf($gastro, $data) {
		global $html, $con;
		require_once('other/FPDF/fpdf.php');
		$ln = 5;
		$y = $this->rows[1];
		$pdf = new FPDF('P','mm','A4');
		$pdf->AddPage();

		$pdf->SetLineWidth(0.1);
		$pdf->SetDrawColor(180, 180, 180);

		// write invoice address or delivery address
		$pdf->SetXY($this->cols[0], $this->rows[0]);
		$pdf->SetFont('Times','B',14);
		$pdf->MultiCell(180, $ln, utf8_decode($gastro['title']), 0, 'C');
		// logo
		// list($x, $y) = getimagesize($this->image);
		// if ($x > ($this->cols[3] - $this->cols[6])) {$w = $this->cols[6] - $this->cols[3]; $h = 0;}
		// else {$w = 0; $h = $this->rows[1] - $this->rows[0];}
		//
		// $pdf->Image($this->image, $this->cols[3], $this->rows[0], $w, $h);
		$last = false;
		foreach ($data as $set) {

			// new page
			if ($y+50 > $pdf->GetPageHeight()) {
				$pdf->AddPage();
				$y = $this->rows[1];
				}

			if ($set['day'] != $last) {
				$y += $ln;
				$pdf->SetXY($this->cols[0], $y);
				$pdf->SetFont('Times','',12);
				$myday = i18n_date($set['day'], $con['ln'], 'long');
				$pdf->MultiCell(180, $ln, utf8_decode($myday), 0, 'C');
				$y += $ln;
				$last = $set['day'];
				}

			$pdf->SetXY($this->cols[0], $y);
			$pdf->SetFont('Times','',10);
			$pdf->MultiCell(180, $ln, utf8_decode($set['meal']), 0, 'C');
			$y += $ln;
			//if ($d['starter']) {$d['starter'] = htmltag('p', '', i18n('starter').': '.$d['starter']);}
			//if ($d['dessert']) {$d['dessert'] = htmltag('p', '', i18n('dessert').': '.$d['dessert']);}
			if ($set['description']) {
				$pdf->SetFont('Times','',8);
				$pdf->SetXY($this->cols[0], $y);
				$pdf->MultiCell(180, $ln, utf8_decode($set['description']), 0, 'C');
				$y += $ln;
				}
			if ($set['starter']) {
				$pdf->SetFont('Times','',8);
				$pdf->SetXY($this->cols[0], $y);
				$pdf->MultiCell(180, $ln, utf8_decode($set['starter']), 0, 'C');
				$y += $ln;
				}
			if ($set['dessert']) {
				$pdf->SetFont('Times','',8);
				$pdf->SetXY($this->cols[0], $y);
				$pdf->MultiCell(180, $ln, utf8_decode($set['dessert']), 0, 'C');
				$y += $ln;
				}
			//if ($d['allergen']) {$d['allergen'] = htmltag('p', 'class="picturetext"', i18n('allergen').': '.$this->get_allergen_list($d['allergen']));}

			}
		// save
		$file = ansitrans($gastro['short']);
		$pdf->Output('F', $html['dir']."/documents/$file.pdf", true);
		}

	public function generate_newsletter() {
		global $db;
		$arg = $db->prepare("SELECT `title`, `body` FROM `content` WHERE `type` = 'gastro' LIMIT 1;");
		$arg->execute();
		$page = $arg->fetch(PDO::FETCH_ASSOC);
		$c = htmltag('h1', '', $page['title']);
		$c .= $page['body'];
		return [$c, $page['title']];
		}
	}
?>
