<?php
# @Author: consentio
# @Date:   2018-08-18T16:58:32+02:00
# @Last modified by:   consentio
# @Last modified time: 2023-08-30T19:10:22+02:00




function plugin($html) {
	switch ($html['action']) {
		case ("img_folder"): $html = folder_admin($html); break;
		default: $html = images_admin($html);
		}
	if (param('_store') == "silent") {
		$html['gui'] = 6;
		$html['content'] = $html['popup'] ? $html['popup'] : $html['feedback'];
		}
	return $html;
	}

function images_admin($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$parent = param('parent') ? clean_var(param('parent'), "n") : 1;
	$target = clean_var(param('target'), "w");
	$uploader = clean_var(param('_u'), "n");
	$uploaded = false;

	$dontleave = param('mode') == "multi" ? 0 : 1;
	$form = [
		"title"			=> i18n('pictures'),
		"table"			=> "image_db",
		"myconf"		=> "images",
		"defsort"		=> "DESC",
		"view"			=> "tiles",
		"human"			=> "filename",
		"q_limit"		=> 20,
		"html"			=> $html,
		"rid"			=> $rid,
		"search"		=> ["fulltext", "title", "description", "filename"],
		"filters"		=> ["parent"],
		"table_fields"	=> ["filename", "title", "parent"],
		"allow_box"		=> "both",
		"attr_to_set"	=> ["parent"],
		"dontleave" 	=> $dontleave
		];

    $inputs = [
		'filename'		=>	[
			'caption'	=> i18n('picture'),
			'type'		=> 'image',
			'extra'		=> 'upload',
			'data_attr' => 'data-preview="small"',
			'prev_dir' => 'thumbs',
			'nocache'	=> true,
			'duty'		=> 1
			],
		'title' =>	[
			'type'		=> 'text',
			],
		'description'	=>	[
			'type'	=> 'bigtext',
			],
		'parent'	=>	[
			'caption'	=> i18n('portfolio'),
			'type'	=> 'lookup',
			'lid'	=> "id",
			'lval'	=> "graduated",
			'tval'	=> "name",
			'lord'	=> "parentsort",
			'ltable'	=> "image_folder",
			'default'	=> $parent
			],
		'copyright' =>	[
			'type' => 'text',
			],
		'upload_date' =>	[
			'type' => 'readonly',
			'default'	=> date('Y-m-d H:i:s'),
			],
		'lightbox'		=>	[
			'type'		=> 'free',
			'default'	=> clean_var(param('lightbox'), "n")
			],
		];

	$sub = tabs($form['myconf'], $parent);

    $obj = new access($form);

    $obj->set_attribute($inputs);

	if (param('_cropme')) {$html['popup'] = crop_action($rid); $obj->html_in($html);}
	if (param('_mirror') || param('_rotate')) {$html['popup'] = romi_action($rid); $obj->html_in($html);}

    if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$html['feedback'] = $obj->feedback; $todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			$html['popup'] = $obj->feedback;
		}
		if ($uploader == 1) {$uploaded = $obj->uploaded_files['filename'];}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {
			$inputs['filename']['extra'] = "display";
			$inputs = $obj->get_value($inputs);
			}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$sub = toggle_submen($sub, 0);
			if ($obj->rid != "new") {
				$sub = tabs2($rid);
				$sub = toggle_submen($sub, 1);
				}
			if (param('mode') == "multi") {
				$inputs['title']['type'] = "void";
				$inputs['description']['type'] = "void";
				$sub = toggle_submen($sub, 1);
				}
			if ($uploader) {
				$reset = ['title', 'description', 'upload_date', 'copyright'];
				foreach ($reset as $k) {$inputs[$k]['type'] = 'hidden';}
				$inputs['_u'] = ['type' => 'free', 'value' => 1];
				$inputs['target'] = ['type' => 'free', 'value' => $target];
				$obj->no_cancel = 1;
				$sub = '';
				}
			$obj->add_input($inputs);
			if ($sub) {$obj->before_form = make_submenu($sub);}
			$html = $obj->form();
			if (param('mode') == "multi") {$html['scripts'] .= uploadscript('ifilefilename');}
			}
		if ($uploader) {$html['gui'] = 5; $html['formtitle'] = '';}
		}
	elseif ($todo == "preview") {$html = preview($html, $rid);}
	elseif ($todo == "crop") {$html = crop_form($html, $rid);}
	elseif ($todo == "gamma") {$html = gamma_form($html, $rid);}
	elseif ($todo == "mirror") {$html = mirror_form($html, $rid);}
	elseif ($todo == "rotate") {$html = rotate_form($html, $rid);}
	//elseif ($todo == "annotate") {$html = annotate_form($html, $rid);}
	elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$sub = toggle_submen($sub, 2);
		$obj->before_table = make_submenu($sub);

		if (param('_del')) {
			delete_img($rid);
			$obj->delete();
			}
		$html = $obj->table($inputs);
		#$html['content'] .= $obj->query;
		}
	if ($uploaded) {
		$html['gui'] = 5;
		$html['content'] = $obj->feedback;
		$html['content'] .= " $target $uploaded";
		$html['content'] .= "
<script type='text/javascript'>
	\$(document).ready(function () {
	var target = \$('#$target', parent.document);
	if (target.attr('id') === undefined) {target = $('#subform', parent.document).contents().find('#$target');}
	target.val('/pictures/normal/$uploaded');
	\$('#pp$target', parent.document).fadeOut('slow',function(){\$('.dlg').remove();});
	target.focus();
	});
</script>\n";
		}
	$html['left'] = img_tree($parent, "images");
	$html['left'] .= htmltag('img', 'id="preview_img" src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs="', '');
	return $html;
    }

function folder_admin ($html) {
	$rid = param('rid');
	$todo = clean_var(param('todo'), "w");
	$parent = param('parent') ? clean_var(param('parent'), "n") : 1;

	$do = $parent ? true : false;
	$form = [
		"title"			=> i18n('pictures')." &ndash; ".i18n('portfolio'),
		"table"			=> "image_folder",
		"myconf"		=> "img_folder",
		"human"			=> "name",
		"orderby"		=> "sort",
		"filters"		=> ["parent"],
		//"allow_box"		=> "both",
		//"attr_to_set"	=> ["parent"],
		"html"			=> $html,
		"rid"			=> $rid,
		"no_del"		=> [1],
		"searchform"	=> 0,
		"table_fields"	=> ["name", "parent", "sort"]
		];

	$inputs = [
		'name' =>	[
			'type' => 'text',
			'duty' => 1,
			],
		'parent'	=>	[
			'caption'	=> i18n('portfolio'),
			'type'	=> 'lookup',
			'duty'	=> 1,
			'lid'	=> "id",
			'lval'	=> "graduated",
			'tval'	=> "name",
			'lord'	=> "parentsort",
			'ltable'	=> "image_folder",
			'default'	=> $parent
			],
		'sort' =>	[
			'type' => 'sort',
			'do' => $do,
			'default'	=> 10
			]
		];

	$sub = [
		[i18n('new_portfolio'), $html['myurl']."?sid={$html['sid']}&amp;_id=img_folder&amp;todo=edit&amp;parent=$parent", "inactive", "folder-add"],
		[i18n('pictures'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;parent=$parent", "inactive", "pictures"],
		[i18n('portfolio'), $html['myurl']."?sid={$html['sid']}&amp;_id=img_folder&amp;parent=$parent", "active", "folder"]
		];

	$obj = new access($form);

	$obj->set_attribute($inputs);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], "parent", $parent);
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$html['feedback'] = $obj->feedback; $todo = "edit"; $obj->error = 0;}
		else {
			$id = $obj->store($inputs);
			reconf_parent($form['table'], "name", "parent");
			$html['popup'] = $obj->feedback;
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$notin = intval($rid) ? check_dependencies("image_folder", $rid, "parent") : "";
			$inputs['parent']['lclause'] = $notin;
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		$obj->before_table = make_submenu($sub);
		if (param('_del')) {$obj->delete();}
		$html = $obj->table($inputs);
		//$html['content'] .= $obj->query;
		}
	$html['left'] = img_tree($parent, "img_folder");
	return $html;
	}

function preview($html, $rid) {
	global $image_dim;
	$sub = tabs2($rid);
	$sub = toggle_submen($sub, 2);
	$html['content'] = make_submenu($sub);
	$nocache = date('YMdHis');
	$data = get_image_file($rid);
	$file = $data['filename'];
	//$pdirs = ["thumbs", "small", "normal", "square", "cinemascope"];
	$pdirs = array_keys($image_dim);
	$img_info = $data['title'] ? "<h2>{$data['title']}</h2>" : "<h2>$file</h2>";
	list($x, $y) = getimagesize("{$html['dir']}/pictures/$file");
	$img_info .= "<p>".get_icon("search-plus", "")." <a href='/pictures/$file' target='_blank'>$file</a> ($x * $y)</p>";
	foreach ($pdirs as $a) {
		if (file_exists("{$html['dir']}/pictures/$a/$file")) {
			list($x, $y) = getimagesize("{$html['dir']}/pictures/$a/$file");
			if (!$x) {$x = $image_dim[$a];} // svg
			$img_info .= "<p><img src='/pictures/$a/$file?cc=$nocache' alt='$file $x x $y' width='$x' height='$y' /><br />$x * $y</p>";
			}
		}
	// exif data
	$exif = exif_read_data("{$html['dir']}/pictures/$file", 0, true);
	if ($exif) {
		$img_info .= htmltag('h2', '', 'EXIF');
		foreach ($exif as $key => $sect) {
			$img_info .= "<p>\n";
			foreach ($sect as $name => $val) {$img_info .= "$key.$name: $val<br />\n";}
			$img_info .= "</p>\n";
			}
		}
	$html['content'] .= $img_info;
	$html['title_suffix'] = i18n('pictures')." &ndash; ".i18n('preview');
	$html['formtitle'] = i18n('pictures')." &ndash; ".i18n('preview');
	$html['formtitle'] .= bubble('images.preview');
	return $html;
	}

function crop_form($html, $rid) {
	$sub = tabs2($rid);
	$sub = toggle_submen($sub, 3);
	$url = $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;todo=crop&amp;rid=$rid";
	$data = get_image_file($rid);
	$file = $data['filename'];
	list($x, $y) = getimagesize("{$html['dir']}/pictures/normal/$file");

	$html['scripts'] .= "
	<script src='/js/jquery.imgareaselect.min.js' type='text/javascript'></script>
	<link rel='stylesheet' type='text/css' media='screen' href='/css/imgareaselect-animated.css' />";
	list($w, $h) = array($x-intval($x/10),$y-intval($y/10));
	list($x1, $y1) = array(intval($x/20),intval($y/20));
	list($x2, $y2) = array($x1+$w, $y1+$h);
	$dim = "x1: $x1, y1: $y1, x2: $x2, y2: $y2,";

	if (param("aspect")) {
		list ($ax, $ay) = explode(":", param("aspect"));
		if ($ax > $ay) {
			$prop = $ay/$ax;
			list($x2, $y2) = array($x, $x*$prop);
			}
		else {
			$prop = $ax/$ay;
			list($x2, $y2) = array($y*$prop, $y);
			}
		list($x2, $y2) = array(intval($x2/2), intval($y2/2));
		list($w, $h) = array($x2-$x1,$y2-$y1);
		$dim = "x1: $x1, y1: $y1, x2: $x2, y2: $y2, aspectRatio: '".param("aspect")."',";
		}

	$none = i18n('none');
	$content  = <<<TNIRP
		<div class='row'><img id="theimage" class="natural" name="theimage" src="/pictures/normal/$file" width="$x" height="$y" border="0" /></div><br />
		<div class='row'>
<p>
	<a href="$url">$none</a> |
	<a href="$url&amp;aspect=4:3">4:3</a> |
	<a href="$url&amp;aspect=3:4">3:4</a> |
	<a href="$url&amp;aspect=16:9">16:9</a>
</p>
		$x * $y
		X: <input type="text" class="text" name="topX" size="4" value="$x1" readonly="readonly" />&nbsp;
		Y: <input type="text" class="text" name="topY" size="4" value="$y1" readonly="readonly" />&nbsp;|&nbsp;
		<input type="text" class="text" name="bottomX" size="4" value="$w" readonly="readonly" />&nbsp;x&nbsp;
		<input type="text" class="text" name="bottomY" size="4" value="$h" readonly="readonly" />
		</div>

<script type="text/javascript">
	\$(document).ready(function () {\$('img#theimage').imgAreaSelect({
		handles: true, show: true, $dim
		onSelectChange: function (img, selection) {
			\$('input[name=topX]').val(selection.x1);
			\$('input[name=topY]').val(selection.y1);
			\$('input[name=bottomX]').val(selection.width);
			\$('input[name=bottomY]').val(selection.height);
			}})});
</script>
TNIRP;

	$form = [
		"html"			=> $html,
		"rid"			=> $rid,
		"title"			=> i18n('images')." &ndash; ".i18n('crop'),
		"button_text"	=> i18n('crop'),
		"button_fa"		=> 'cut',
		"before_form"	=> make_submenu($sub),
		"in_form"		=> $content,
		"submit"		=> "_cropme"
		];
	$inputs = [
		"filename"		=> [
			'caption'	=> i18n('picture'),
			"type"		=> "text",
			"default"	=> $file,
			"in_label"	=> "&nbsp;".bubble('images.newfile')
			],
		"cropme"		=> [
			"type"		=> "hidden",
			"default"	=> "on"
			]
		];
	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['formtitle'] .= bubble('images.crop');
	if (!$x) {
		$html['content'] = make_submenu($sub);
		$html['content'] .= say_mess(i18n('op_not_pos'), i18n('info'), 'ban-red');
		}
	return $html;
	}

function mirror_form($html, $rid) {
	$data = get_image_file($rid);
	$file = $data['filename'];
	$sub = tabs2($rid);
	$sub = toggle_submen($sub, 4);
	$content = "<fieldset class='inside'><legend>".i18n('axis')."</legend>
	<div class='radiorow'><input type='radio' id='flop' name='direction' value='flop' checked='checked' />
	<label for='flop'>".get_icon('arrows-alt-v', i18n('vertical'))."</label></div>
	<div class='radiorow'><input type='radio' id='flip' name='direction' value='flip' />
	<label for='flip'>".get_icon('arrows-alt-h', i18n('horizontal'))."</label></div>
	</fieldset>";

	$form = [
		"html"			=> $html,
		"rid"			=> $rid,
		"title"			=> i18n('images')." &ndash; ".i18n('mirror'),
		"button_text"	=> i18n('mirror'),
		"button_fa"		=> 'arrows-alt-h',
		"before_form"	=> make_submenu($sub),
		"in_form"		=> $content,
		"submit"		=> "_mirror"
		];
	$inputs = [
		"filename"		=> [
			'caption'	=> i18n('picture'),
			"type"		=> "text",
			"default"	=> $file,
			"in_label"	=> "&nbsp;".bubble('images.newfile')
			]
		];
	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['formtitle'] .= bubble('images.mirror');
	// fallback
	if (preg_match("/\.svg$/",$file)) {
		$html['content'] = make_submenu($sub);
		$html['content'] .= say_mess(i18n('op_not_pos'), i18n('info'), 'ban-red');
		}
	return $html;
	}

function rotate_form($html, $rid) {
	$data = get_image_file($rid);
	$file = $data['filename'];
	$sub = tabs2($rid);
	$sub = toggle_submen($sub, 5);
	$content = "<fieldset class='inside'><legend>".i18n('degrees')."</legend>
	<div class='radiorow'><input id ='dir90' type='radio' name='direction' value='90' checked='checked' />
	<label for='dir90'> 90&deg;</label></div>
	<div class='radiorow'><input id ='dir180' type='radio' name='direction' value='180' />
	<label for='dir180'> 180&deg;</label></div>
	<div class='radiorow'><input id ='dir270' type='radio' name='direction' value='270' />
	<label for='dir270'> 270&deg;</label></div>
	</fieldset>";

	$form = [
		"html"			=> $html,
		"rid"			=> $rid,
		"title"			=> i18n('images')." &ndash; ".i18n('rotate'),
		"button_text"	=> i18n('rotate'),
		"button_fa"		=> 'sync',
		"before_form"	=> make_submenu($sub),
		"in_form"		=> $content,
		"submit"		=> "_rotate"
		];
	$inputs = [
		"filename"		=> [
			'caption'	=> i18n('picture'),
			"type"		=> "text",
			"default"	=> $file,
			"in_label"	=> "&nbsp;".bubble('images.newfile')
			]
		];
	$obj = new access($form);
	$obj->add_input($inputs);
	$html = $obj->form();
	$html['formtitle'] .= bubble('images.rotate');
	// fallback
	if (preg_match("/\.svg$/",$file)) {
		$html['content'] = make_submenu($sub);
		$html['content'] .= say_mess(i18n('op_not_pos'), i18n('info'), 'ban-red');
		}
	return $html;
	}

function annotate_form($html, $rid) {
	$sub = tabs2($rid);
	$sub = toggle_submen($sub, 5);
	$html['content'] = make_submenu($sub);
	// annotation has never been used by anyone so it has been discarded
	return $html;
	}

function gamma_form($html, $rid) {
	$sub = tabs2($rid);
	$sub = toggle_submen($sub, 6);
	$html['content'] = make_submenu($sub);
	// this has been discarded too
	return $html;
	}

function img_tree($open, $action) {
	global $html;
	$tree = "";
	$item = [
		"caption"	=> i18n('all'),
		"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}",
		"state"		=> "all",
		"sub"		=> "",
		"bubble"	=> ""
		];
	$tree .= list_item($item);
	$roots = [
		"parent"	=> 0,
		"pfield"	=> "parent",
		"field"		=> "name",
		"table"		=> "image_folder",
		"sort"		=> "sort",
		"index"		=> 0,
		"open"		=> $open,
		"action"	=> $action
		];
	$tree .= branch($roots);
	$tree = parse_in('gui_tree', ['treelist' => $tree]);
	return $tree;
	}

function tabs($me, $parent) {
	global $html;
	$subs = [
		[i18n('img_single'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;todo=edit&amp;parent=$parent", "inactive", "picture-add"],
		[i18n('img_multi'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;todo=edit&amp;mode=multi&amp;parent=$parent", "inactive", "add"],
		[i18n('pictures'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;parent=$parent", "inactive", "pictures"],
		[i18n('portfolio'), $html['myurl']."?sid={$html['sid']}&amp;_id=img_folder&amp;parent=$parent", "inactive", "folder"]
		];
		#if ($parent > 1) {push(@subs, ["$i18n{gallery}...", "$config{myscript}?action=gallery&amp;sid=$sid&amp;todo=prepare&amp;map=$parent", "inactive"]);}
	return $subs;
	}

function tabs2($id) {
	global $html;
	$subs = [
		[i18n('pictures'), $html['myurl']."?sid={$html['sid']}&amp;_id=images", "inactive", "image"],
		[i18n('data'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;todo=edit&amp;rid=$id", "inactive", "image_edit"],
		[i18n('preview'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;todo=preview&amp;rid=$id", "inactive", "preview"],
		[i18n('crop'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;todo=crop&amp;rid=$id", "inactive", "cut"],
		[i18n('mirror'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;todo=mirror&amp;rid=$id", "inactive", "mirror"],
		[i18n('rotate'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;todo=rotate&amp;rid=$id", "inactive", "update"]
		//[i18n('annotate'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;todo=annotate&amp;rid=$id", "inactive", "text"],
		//[i18n('brightness'), $html['myurl']."?sid={$html['sid']}&amp;_id=images&amp;todo=gamma&amp;rid=$id", "inactive", "gamma"]
		];
	return $subs;
	}

function delete_img($rid) {
	global $html;
	$pdirs = ["thumbs", "small", "normal", "square", "cinemascope"];
	if (is_array($rid)) {$ids = $rid;}
	else {$ids[0] = $rid;}
	foreach($ids as $id) {
		$data = get_image_file($id);
		$file = $data['filename'];
		unlink("{$html['dir']}/pictures/$file");
		foreach ($pdirs as $a) {
			unlink("{$html['dir']}/pictures/$a/$file");
			}
		}
	}

function get_image_file($rid){
	global $db;
	$arg = $db->prepare("SELECT * from `image_db` where `id` = ?;");
	$arg->execute(array($rid));
	$d = $arg->fetch(PDO::FETCH_ASSOC);
	return $d;
	}

function crop_action($rid) {
	global $html;
	$data = get_image_file($rid);
	$file = $data['filename'];
	$newfile = clean_var(param('filename'), "w");
	$img = getimagesize("{$html['dir']}/pictures/normal/$file");
	list($x, $y) = $img;
	$img = getimagesize("{$html['dir']}/pictures/$file");
	list($ex, $ey) = $img;
	$prop = $ex/$x;
	$image;
	$nx = intval(clean_var(param('topX'), "n")*$prop);
	$ny = intval(clean_var(param('topY'), "n")*$prop);
	$ox = intval(clean_var(param('bottomX'), "n")*$prop);
	$oy = intval(clean_var(param('bottomY'), "n")*$prop);
	$crop = array('x' => $nx, 'y' => $ny, 'width' => $ox, 'height'=> $oy);
	switch ($img['mime']) {
		case "image/jpeg": $image = imagecreatefromjpeg("{$html['dir']}/pictures/$file"); $data['ext'] = "jpg";break;
		case "image/gif": $image = imagecreatefromgif("{$html['dir']}/pictures/$file"); $data['ext'] = "gif"; break;
		case "image/png": $image = imagecreatefrompng("{$html['dir']}/pictures/$file"); $data['ext'] = "png"; break;
		}
	if ($file != $newfile) {
		$newfile = check_extension($newfile, $data['ext']);
		$newfile = clean_filename($newfile, "pictures");
		}
	# php 5.5 for better interpolation
	if (function_exists('imagesetinterpolation'))  {imagesetinterpolation($image, IMG_NEAREST_NEIGHBOUR);}
	imagealphablending($image, false);
	imagesavealpha($image, true);
	$image_new = imagecrop($image, $crop);
	switch ($img['mime']) {
		case "image/jpeg": imagejpeg($image_new,"{$html['dir']}/pictures/$newfile"); break;
		case "image/gif": imagegif($image_new,"{$html['dir']}/pictures/$newfile"); break;
		case "image/png": imagepng($image_new,"{$html['dir']}/pictures/$newfile"); break;
		}
	scale_image($newfile);
	if ($file != $newfile) {
		$data['filename'] = $newfile; db_image($data);
		}
	return "$nx $ny $ox $oy";
	}

function romi_action($rid) {
	global $html;
	$data = get_image_file($rid);
	$file = $data['filename'];
	$img = getimagesize("{$html['dir']}/pictures/normal/$file");
	$image; $image_new;
	$newfile = clean_var(param('filename'), "w");
	switch ($img['mime']) {
		case "image/jpeg": $image = imagecreatefromjpeg("{$html['dir']}/pictures/$file"); $data['ext'] = "jpg";break;
		case "image/gif": $image = imagecreatefromgif("{$html['dir']}/pictures/$file"); $data['ext'] = "gif"; break;
		case "image/png": $image = imagecreatefrompng("{$html['dir']}/pictures/$file"); $data['ext'] = "png"; break;
		}
	if ($file != $newfile) {
		$newfile = check_extension($newfile, $data['ext']);
		$newfile = clean_filename($newfile, "pictures");
		}
	if (function_exists('imagesetinterpolation'))  {imagesetinterpolation($image, IMG_NEAREST_NEIGHBOUR);}
	imagealphablending($image, false);
	imagesavealpha($image, true);
	if (param('_mirror')){
		if (param('direction') == 'flop') {imageflip($image, IMG_FLIP_VERTICAL);}
		else {imageflip($image, IMG_FLIP_HORIZONTAL);}
		$image_new = $image; // hm...
		}
	else {
		$image_new = imagerotate($image, param('direction'), 0);
		}
	switch ($img['mime']) {
		case "image/jpeg": imagejpeg($image_new,"{$html['dir']}/pictures/$newfile"); break;
		case "image/gif": imagegif($image_new,"{$html['dir']}/pictures/$newfile"); break;
		case "image/png": imagepng($image_new,"{$html['dir']}/pictures/$newfile"); break;
		}
	scale_image($newfile);
	if ($file != $newfile) {
		$data['filename'] = $newfile; db_image($data);
		}
	}

?>
