<?php

/**
 * plugin import_csv
 * @package consentio
 */

class import_csv {

	private $createID = "`id` bigint(20) unsigned NOT NULL AUTO_INCREMENT";
	private $createField = "varchar(255) DEFAULT NULL";
	private $createPrimary = "PRIMARY KEY (`id`)";
	private $createEng = "ENGINE=MyISAM DEFAULT CHARSET=utf8";

	public function __construct(){

		}

	public function plugin($html) {
		switch ($html['action']) {
			case "foo": $html = $this->foo($html); break;
			default: $html = $this->import_dialogue($html);
			}
		return $html;
		}

	private function import_dialogue($html) {
		$file = clean_var(param('csv_file'), 'w');
		$table = clean_var(param('table'), 'w');
		$delimiter = param('delimiter') ? param('delimiter') : ';';
		$feedback = '';
		if (array_key_exists("filecsv_file", $_FILES) and $_FILES["filecsv_file"]['size']) {
			$file = upload($html['dir'],"filecsv_file", 'u');
			}
		if (!file_exists($html['dir']."/$file")) {$feedback = "Missing CSV File ".$html['dir']."/$file";}

		if (!$table) {$feedback = "Enter a Table Name";}

		if ($feedback) {
			$form = [
				"title"			=> "Import CSV",
				"html"			=> $html,
				"feedback"		=> $feedback
				];
			$inputs = [
				"csv_file"	=> [
					"caption" => i18n('file'),
					"type" => "file",
					"duty"			=> 1
					],
				"table"	=> [
					"type" => "text",
					"duty"			=> 1,
					"default"	=> $table
					],
				"delimiter" => [
					'type'	=> 'array',
					'extra'	=> [';',',','\t'],
					'raw'	=> true,
					'default' => $delimiter
					],
				"truncate"=> [
					"caption" => 'TRUNCATE',
					"type" => "flag"
					]
				];
			$obj = new access($form);
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		else {$html = $this->read_csv($file, $table, $delimiter);}
		return $html;
		}

	private function read_csv($file, $table, $del) {
		global $html, $db;
		$CSV = fopen($html['dir']."/$file", 'r');
		$i = 0;
		$c = "";
		$f = 0;
		$insert = '';
		if (param('truncate') == 'on') {
			$q = "TRUNCATE TABLE `$table`;";
			$arg = $db->prepare($q);
			$check = $arg->execute();
			if ($check === false) {
				$err = $arg->errorInfo();
				$error = array_key_exists(2, $err) ? $err[2] : "";
				$c .= "<p class='red'>".i18n('error').": $error<br/>$q</p>";
				}
			}
		while (($data = fgetcsv($CSV, 1000, $del)) !== FALSE) {
			if (!$i) {
				$fields = '';
				$values = '';
				$q = "CREATE TABLE IF NOT EXISTS`$table` (";
				$q .= $this->createID.", ";
				foreach ($data as $field) {
					$q .= " `$field` ".$this->createField.", ";
					$fields .= "`$field`, ";
					$values .= "?, ";
					}
				$fields = preg_replace("/\, $/", "", $fields);
				$values = preg_replace("/\, $/", "", $values);
				$insert = "INSERT INTO `$table` ($fields) VALUES ($values);";
				$q .= $this->createPrimary;
				$q .= ") ". $this->createEng.";";
				$arg = $db->prepare($q);
				$check = $arg->execute();
				if ($check === false) {
					$err = $arg->errorInfo();
					$error = array_key_exists(2, $err) ? $err[2] : "";
					$c .= "<p class='red'>".i18n('error').": $error<br/>$q</p>";
					$f = 1;
					}
				else {$c .= "<p class='green'>CREATE TABLE `$table`: OK</p>";}
				}
			else {
				$arg = $db->prepare($insert);
				$row = array();
				foreach ($data as $field) {
					$field = rtrim($field);
					if (!$field) {$field = NULL;}
					array_push($row, $field);
					}
				$check = $arg->execute($row);
				if ($check === false) {
					$err = $arg->errorInfo();
					$error = array_key_exists(2, $err) ? $err[2] : "";
					$c .= "<p class='red'>Record #$i: ".i18n('error').": $error $data</p>";
					}
				}
			$i++;
			}
		fclose($CSV);
		$html['formtitle'] = 'Import CSV';
		$html['content'] = $c.htmltag('p', 'class="green"', "$i rows");
		return $html;
		}
	}
?>
