<?php
# @Author: consentio
# @Date:   2018-08-18T16:58:32+02:00
# @Project: Consentio CMS
# @Filename: news_generator.php
# @Last modified by:   consentio
# @Last modified time: 2023-01-17T12:32:01+01:00
# @License: GPL 2.0
# @Copyright: IMB Webdevelopment




function generate_article($data, $id) {
	global $db, $html, $website;
	$data = article_data($data);

	// picture
	if ($data['picture']) {
		$pic_size = "small";
		$pic_orig = "big";
		$templ = 'cms_articles_picture';
		list($w, $h) = getimagesize("{$html['dir']}/pictures/$pic_size/{$data['picture']}");
		list($w2, $h2) = getimagesize("{$html['dir']}/pictures/$pic_orig/{$data['picture']}");
		$data['width'] = $w;
		$data['height'] = $h;
		$data['resize'] = '';
		$data['eziser'] = '';
		$data['alt'] = $data['picturetext'];
		$used_pic = $pic_size;
		// big picture if big enough
		if ($w2 > 350 && $data['news_template'] == 1) {
			$templ = 'cms_articles_picture_big';
			$used_pic = $pic_orig;
			$data['width'] = $w2;
			$data['height'] = $h2;
			}
		// small picture reziseable
		elseif	(($w2*0.7 > $w)) {
			$data['resize'] = "<a href=\"/pictures/$pic_orig/{$data['picture']}\"  data-app=\"lightbox\">";
			$data['eziser'] = '</a>';
			}
		$data['src'] = "/pictures/$used_pic/{$data['picture']}";
		if ($data['picturetext']) {$data['picturetext'] = htmltag('p', 'class="picturetext" style="max-width:'.$data['width'].'px"', $data['picturetext']);}
		if ($data['copyright']) {$data['copyright'] = htmltag('p', 'class="copyright" style="max-width:'.$data['width'].'px"', "&copy; ".$data['copyright']);}
		$data['picture'] = parse_in($templ, $data);
		}

	// topstories have a limit
	// if this article is set to top, another one has to loose his top position
	if ($data['published'] > 1 && $data['top'] == 'on') {
		$settings = read_settings(['group' => 'news']);
		$limit = isset($settings['top_news_limit']) ? $settings['top_news_limit'] : 2;
		$arg = $db->prepare("SELECT `content`.`id` FROM `articles` LEFT JOIN `content` ON `articles`.`pid` = `content`.`id`
		WHERE `published` > 1 AND `articles`.`top` = 'on' AND `content`.`id` <> ? AND `content`.`lang` = ? ORDER BY `sort`;");
		$arg->execute([$id, $data['lang']]);
		$i = 1; $in = array();
		while ($top = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($i >= $limit) {array_push($in, $top['id']);}
			$i++;
			}
		$notop = implode(',', $in);
		$arg = $db->prepare("UPDATE `articles` SET `top` = '' WHERE `pid` IN ($notop);");
		$arg->execute();
		}

	//$atempl = $data['news_template'] == 1 ? 'cms_articles_body1' : 'cms_articles_body2';
	$atempl = 'cms_articles_body'.$data['news_template'];
	$content = parse_in($atempl, $data);
	$desc = $data['lead'] ? strip_tags($data['lead']) : '';
	$q = "UPDATE `content` SET `body` = ?, `generate` = 0, `description` = ? WHERE `id` = ?;";
	$arg = $db->prepare($q);
	$arg->execute(array($content, $desc, $id));

	// generate dummy html file
	if ($data['published'] > 1) {
		$art = ['id' => $id, 'defs' => ''];
		$c = parse_in('cms_dynamic_html', $art);
		$f = fopen("{$html['dir']}{$data['file']}", 'w');
		fwrite($f, $c);
		fclose($f);
		}
	}

function article_data($data) {
	global $website;
	// lead with p.lead
	if ($data['lead']) {
		$data['lead'] = wiki_text($data['lead']);
		$data['lead'] = htmltag('p', 'class="lead"', $data['lead']);
		}
	// subtitle with p.subtitle
	if ($data['subtitle']) {$data['subtitle'] = htmltag('p', 'class="subtitle"', $data['subtitle']);}
	// author with p.author
	if ($data['author']) {$data['author'] = htmltag('p', 'class="author"', $data['author']);}
	// authorshort with p.author.alright
	if ($data['authorshort']) {$data['authorshort'] = htmltag('p', 'class="author alright"', $data['authorshort']);}
	// split timestamps (update and written) into date and time
	list ($data['udate'], $data['utime']) = explode(' ', $data['update']);
	list ($data['wdate'], $data['wtime']) = explode(' ', $data['written']);
	// todo format date...
	// printversion
	$data['pid'] = $id;
	$data['print'] = i18n('print_version');
	$data['print'] = parse_in('cms_articles_print', $data);
	// share buttons
	$data['decURL'] = urlencode($website['website_url'].$data['file']);
	$data['share_buttons'] = parse_in('cms_share_buttons', $data);
	return $data;
	}

function teaser_data($data, $rubric) {
	global $html, $con;
	$def_dim = $rubric['def_dim'];
	if ($data['subtitle']) {$data['subtitle'] = htmltag('strong', '', $data['subtitle']);}
	if (!$data['lead']) {$data['lead'] = cut_text(co_strip_tags($data['body']), 280);}
	$data['lead'] = wiki_text($data['lead']);
	list ($data['udate'], $data['utime']) = explode(' ', $data['update']);
	list ($data['wdate'], $data['wtime']) = explode(' ', $data['written']);
	$data['more'] = $data['lang'] == $con['ln'] ? i18n('more') : sys_trans('more', $data['lang']);
	$data['more'] = parse_in('cms_articles_teaser_more', $data);
	if ($data['picture']) {
		$data['psrc'] = $data['picture'];
		$dims = ['thumbs', 'small', 'cinemascope', 'square'];
		$t = explode('_', $rubric['teaser_picture']);
		$given = end($t); // functions explode, end cannot be chained?
		if (!in_array($given, $dims)){$given = "small";}
		list($data['width'], $data['height']) = getimagesize("{$html['dir']}/pictures/$given/{$data['picture']}");
		$data['alt'] = $data['picturetext'];
		if ($data['picturetext']) {$data['picturetext'] = htmltag('p', 'class="picturetext"', $data['picturetext']);}
		if ($data['copyright']) {
			$data['crtitle'] = "&copy; ".$data['copyright'];
			$data['copyright'] = htmltag('p', 'class="copyright"', "&copy; ".$data['copyright']);
			}
		else {$data['crtitle'] = " ";}
		$data['picture'] = parse_in($rubric['teaser_picture'], $data);
		if ($given != $def_dim) {list($data['width'], $data['height']) = getimagesize("{$html['dir']}/pictures/$def_dim/{$data['psrc']}");}
		$data['def_picture'] = parse_in("cms_articles_teaser_picture_$def_dim", $data);
		}
	return $data;
	}

function generate_news() {
	global $db, $html, $con;

	// create new articles if coming from cron
	if (basename($_SERVER["SCRIPT_FILENAME"], '.php') == 'cocron') {
		$q = "SELECT `content`.`id`, `pid`, `title`, `subtitle`, `lead`, `articlebody`, `picture`, `picturetext`, `copyright`,
		`author`, `authorshort`, `file`, `articles`.`keywords`, `update`, `written`, `news_template`, `published`, `content`, `top` FROM `articles` LEFT JOIN `content` ON `articles`.`pid` = `content`.`id`
		WHERE `published` >= 1 AND `c_start` = ? ORDER BY `sort`;";
		$arg = $db->prepare($q);
		$arg->execute([date('Y-m-d')]);
		$rec = $arg->rowCount();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$data['written'] = date('Y-m-d H:i:s');
			$data['update'] = $data['written'];
			$arg2 = $db->prepare("UPDATE `content` SET `update` = ?, `written` = ? WHERE `id` =?;");
			$arg2->execute([$data['update'], $data['written'], $data['id']]);
			generate_article($data, $data['id']);
			}
		}

	// "ORDER BY `parentsort` DESC" is important: components of subrubrics have to be created first
	$q =
"SELECT `content`.`id`, `art_limit`, `top`, `rss`, `container`, `container_small`, `teaser`,
`teaser_small`, `teaser_picture`, `file`, `title`, `lang`, `refer_to` FROM `rubrics` LEFT JOIN `content` ON `rubrics`.`pid` = `content`.`id`
WHERE `published` > 1 ORDER BY `parentsort` DESC;";
	$arg = $db->prepare($q);
	$arg->execute();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		// get content teaser
		$teasers = make_teaser($data);

		// update this rubric
		$q = "UPDATE `content` SET `body` = ? WHERE `id` = ?;";
		$arg2 = $db->prepare($q);
		$arg2->execute(array($teasers['all'], $data['id']));

		// one rubric could be the same rubric of another languages
		$rub = $data['lang'] == $con['ln'] ? $data['id'] : $data['refer_to'];

		// update rubric as component
		$component = ['component' => "RUBRIC_$rub", 'title' => "{$data['title']} Rubric Box $rub", 'html' => $teasers['big'], 'lang' => $data['lang'], 'active' => 'on'];
		write_component($component);

		// update rubric as small component
		$component = ['component' => "RUBRIC_SMALL_$rub", 'title' => "{$data['title']} Small Rubric Box $rub", 'html' => $teasers['small'], 'lang' => $data['lang'], 'active' => 'on'];
		write_component($component);
		}
	foreach (array_keys($con['langs']) as $k) {make_top($k);}
	}

function generate_newsletter() {
	global $db, $html, $con;
	$c = '';

	// top news
	$settings = read_settings(['group' => 'news']);
	$limit = isset($settings['top_news_limit']) ? $settings['top_news_limit'] : 2;

	$q = "SELECT `content`.`id`, `pid`, `title`, `subtitle`, `lead`, `picture`, `picturetext`, `copyright`,
`author`, `file`, `update`, `written` FROM `articles` LEFT JOIN `content` ON `articles`.`pid` = `content`.`id`
WHERE `published` > 1 AND `articles`.`top` = 'on' ORDER BY `sort` LIMIT $limit;";
	$arg = $db->prepare($q);
	$arg->execute();
	if ($arg->rowCount()) {$c .= htmltag('h2', 'class="rubric_title"', i18n('topnews'));}
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		$data = teaser_data($data, ['teaser_picture' =>  'cms_articles_teaser_picture_small']);
		$c .= parse_in('cms_newsletter_teaser', $data);
		}

	$q = "SELECT `content`.`id`, `art_limit`, `top`, `rss`, `container`, `container_small`, `teaser`,
`teaser_small`, `teaser_picture`, `file`, `title`, `lang` FROM `rubrics` LEFT JOIN `content` ON `rubrics`.`pid` = `content`.`id`
WHERE `top` = 'on' AND `published` > 1 ORDER BY `parentsort` DESC;";
	$arg = $db->prepare($q);
	$arg->execute();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		// get content teaser
		$teasers = make_teaser($data);
		if ($teasers['newsletter']) {
			$c .= htmltag('h2', 'class="rubric_title"', $data['title']);
			$c .= $teasers['newsletter'];
			}
		}
	return $c;
	}

function generate_article_newsletter($data) {
	$data = article_data($data);
	// picture
	if ($data['picture']) {
		$pic_size = "small";
		$templ = 'cms_articles_picture';
		list($w, $h) = getimagesize("{$html['dir']}/pictures/$pic_size/{$data['picture']}");
		$data['width'] = $w;
		$data['height'] = $h;
		$data['alt'] = $data['picturetext'];
		$data['src'] = "/pictures/$pic_size/{$data['picture']}";
		if ($data['picturetext']) {$data['picturetext'] = htmltag('p', 'class="picturetext" style="max-width:'.$data['width'].'px"', $data['picturetext']);}
		if ($data['copyright']) {$data['copyright'] = htmltag('p', 'class="copyright" style="max-width:'.$data['width'].'px"', "&copy; ".$data['copyright']);}
		$data['picture'] = parse_in($templ, $data);
		}
	$content = parse_in('cms_articles_newsletter_body', $data);
	return $content;
	}

function make_teaser($rubric, $offset = 0) {
	global $db, $html, $con;
	$limit = 20;
	$settings = read_settings(['group' => 'news']);
	$rubric['def_dim'] = isset($settings['news_def_dim']) ? $settings['news_def_dim'] : 'cinemascope';
	$clause = '';

	if (param('last_newsletter')) {
		$last = clean_var(param('last_newsletter'), 'w');
		$clause = " AND `content`.`written` > '$last'";
		$limit = 100;
		}

	$teaser = ['all' => '', 'small' => '', 'big' => '', 'newsletter' => ''];
	$q = "SELECT `content`.`id`, `pid`, `title`, `subtitle`, `lead`, `picture`, `picturetext`, `copyright`,
`author`, `file`, `update`, `written`, `top`, `lang` FROM `articles` LEFT JOIN `content` ON `articles`.`pid` = `content`.`id`
WHERE `published` > 1 AND `parent` = ? AND `top` <> 'on'$clause ORDER BY `sort` LIMIT $offset, $limit;";
	$arg = $db->prepare($q);
	$arg->execute(array($rubric['id']));

	$i = 0;

	$cols = 1; $colno = 1;
	$rec = $arg->rowCount();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		$data = teaser_data($data, $rubric);
		$teaser['small'] .= parse_in($rubric['teaser_small'], $data);
		$teaser['newsletter'] .= parse_in('cms_newsletter_teaser', $data);
		// rotate html snippet if we have columns (or something like that)
		$myteaser = $data['top'] == 'on' ? 0 : parse_in($rubric['teaser'], $data);
		$data['picture'] = isset($data['def_picture']) ? $data['def_picture'] : '';
		$teaser['all'] .= parse_in('cms_articles_teaser', $data);

		if ($myteaser) {
			// only full rows
			if (($rec - $i) >= ($cols - $colno)+1) {
				if ($i < $rubric['art_limit']) {$teaser['big'] .= $myteaser;}
				}

			$colno++;
			if ($colno > $cols) {$colno = 1;}
			$i++;
			}
		}

	// check subrubrics
	// if there is one or more, the view will be divided in limited articles per rubric
	$q = "SELECT `id`, `lang` FROM `content` WHERE `published` > 1 AND `parent` = ? AND `type` = 'rubric' ORDER BY `sort`;";
	$arg = $db->prepare($q);
	$arg->execute(array($rubric['id']));
	$subrubrics = '';
	while ($sub = $arg->fetch(PDO::FETCH_ASSOC)) {
		$subrubrics .= read_component(['component' => "RUBRIC_{$sub['id']}", 'lang' => $sub['lang']]);
		}

	$title = htmltag('a', "href=\"{$rubric['file']}\"", $rubric['title']);
	if ($subrubrics) {
		$rubric['content'] = $teaser['big'];
		$rubric['title'] = '';
		$teaser['all'] = parse_in('cms_articles_rubric', $rubric);
		$teaser['all'] .= $subrubrics;
		}
	elseif ($teaser['all']) {
		$rubric['content'] = $teaser['all'];
		$rubric['title'] = '';
		$teaser['all'] = parse_in('cms_articles_rubric', $rubric);
		if ($rec == $limit) {
			$new_offset = $offset+$limit;
			$a = htmltag('a', "href=\"/content/index.html?_id=rubric&amp;_r={$rubric['id']}&amp;_o={$new_offset}\" class=\"as_button\"", i18n('next'));
			$teaser['all'] .= htmltag('p', 'class="center"', $a);
			}
		}

	if ($teaser['small']) {
		$rubric['content'] = $teaser['small'];
		$rubric['title'] = htmltag('h2', 'class="rubric_title"', $title);
		$teaser['small'] = parse_in($rubric['container_small'], $rubric);
		}

	if ($teaser['big']) {
		$rubric['title'] = htmltag('h2', 'class="rubric_title"', $title);
		$rubric['content'] = $teaser['big'];
		$teaser['big'] = parse_in($rubric['container'], $rubric);
		}

	return $teaser;
	}

function make_related_news($data) {
	global $db, $html, $con;
	$rel_news = $data['lang'] == $con['ln'] ? i18n('related_news') : sys_trans('related_news', $data['lang']);
	$teaser = '';
	$q = "SELECT DISTINCT `id_content` FROM `content_junction_articles_keywords` WHERE `id_articles_keywords` IN (SELECT `id_articles_keywords` FROM `content_junction_articles_keywords` WHERE `id_content` = '{$data['id']}') AND `id_content` <> '{$data['id']}';";
	$arg = $db->prepare($q);
	$arg->execute();
	$rel = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
	if (isset($rel[0])) {
		$rel = implode(',', $rel);
		$q = "SELECT `content`.`id`, `pid`, `title`, `subtitle`, `lead`, `picture`, `picturetext`, `copyright`, `author`, `file`, `update`, `written`, `lang` FROM `articles` LEFT JOIN `content` ON `articles`.`pid` = `content`.`id` WHERE `published` > 1  AND `lang` = '{$data['lang']}' AND `content`.`id` IN($rel) ORDER BY `sort` LIMIT 6;";
		$arg = $db->prepare($q);
		$arg->execute();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($data['subtitle']) {$data['subtitle'] = htmltag('strong', '', $data['subtitle']);}
			if (!$data['lead']) {$data['lead'] = cut_text(co_strip_tags($data['body']), 280);}
			list ($data['udate'], $data['utime']) = explode(' ', $data['update']);
			list ($data['wdate'], $data['wtime']) = explode(' ', $data['written']);
			$data['more'] = $data['lang'] == $con['ln'] ? i18n('more') : sys_trans('more', $data['lang']);
			$data['more'] = parse_in('cms_articles_teaser_more', $data);
			if ($data['picture']) {
				$data['psrc'] = $data['picture'];
				$given = "cinemascope";
				list($data['width'], $data['height']) = getimagesize("{$html['dir']}/pictures/$given/{$data['picture']}");
				$data['alt'] = $data['picturetext'];
				if ($data['copyright']) {$data['copyright'] = htmltag('p', 'class="copyright"', "&copy; ".$data['copyright']);}
				$data['picture'] = parse_in('cms_articles_teaser_picture_'.$given, $data);
				}
			$teaser .= parse_in('cms_articles_teaser_related_news', $data);
			}

		if ($teaser) {
			$reln['title'] = htmltag('h2', 'class="rubric_title"', $rel_news);
			$reln['content'] = $teaser;
			$teaser = parse_in('cms_articles_related_news', $reln);
			}
		}
	return $teaser;
	}

function make_top($lang) {
	global $db, $html, $con;
	$top = "";
	$settings = read_settings(['group' => 'news']);
	$limit = isset($settings['top_news_limit']) ? $settings['top_news_limit'] : 2;
	$q = "SELECT `content`.`id`, `pid`, `title`, `subtitle`, `lead`, `picture`, `picturetext`, `copyright`,
`author`, `file`, `update`, `written` FROM `articles` LEFT JOIN `content` ON `articles`.`pid` = `content`.`id`
WHERE `published` > 1 AND `articles`.`top` = 'on' AND `lang` = '$lang' ORDER BY `sort` LIMIT $limit;";
	$arg = $db->prepare($q);
	$arg->execute();
	$rec = $arg->rowCount();
	$i = 1;
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		if ($data['subtitle']) {$data['subtitle'] = htmltag('p', 'class="subtitle"', $data['subtitle']);}
		if (!$data['lead']) {$data['lead'] = cut_text(co_strip_tags($data['body']), 280);}
		$data['lead'] = wiki_text($data['lead']);
		list ($data['udate'], $data['utime']) = explode(' ', $data['update']);
		list ($data['wdate'], $data['wtime']) = explode(' ', $data['written']);
		$data['more'] = $lang == $con['ln'] ? i18n('more') : sys_trans('more', $lang);
		$data['more'] = parse_in('cms_articles_teaser_more', $data);
		if ($data['picture']) {
			$snippet = $i == 1 ? 'cms_articles_top_picture' : 'cms_articles_teaser_picture_'.$settings['news_def_dim'];
			$dim = $i == 1 ? 'big' : 'small';
			list($data['width'], $data['height']) = getimagesize("{$html['dir']}/pictures/$dim/{$data['picture']}");
			$data['alt'] = $data['picturetext'];
			$data['psrc'] = $data['picture'];
			if ($data['picturetext']) {$data['picturetext'] = htmltag('p', 'class="picturetext"', $data['picturetext']);}
			if ($data['copyright']) {
				$data['crtitle'] = "&copy; ".$data['copyright'];
				$data['copyright'] = htmltag('p', 'class="copyright"', "&copy; {$data['copyright']}&nbsp;");
				}
			$data['picture'] = parse_in($snippet, $data);
			// cms_articles_top_picture includes title!
			$data['title'] = $i == 1 ? "" : htmltag('h2', '', htmltag('a' , 'href="'.$data['file'].'"', $data['title']));
			}
		else {$data['title'] = htmltag('h2', '', htmltag('a' , 'href="'.$data['file'].'"', $data['title']));}
		$t = $i == 1 ? 'cms_articles_top_news' : 'cms_articles_teaser';
		if ($i == 2) {$top .= '<ul class="listing">';}
		$top .= parse_in($t, $data);
		$i++;
		}
	if ($i >= 2) {$top .= '</ul>';}
	$component = ['component' => "TOP_NEWS", 'html' => $top, 'title' => i18n('top_stories'), 'lang' => $lang, 'active' => 'on'];
	write_component($component);
	}

function build_rubric($html) {
	global $db;
	$id = clean_var(param('_r'), 'n');
	$of = clean_var(param('_o'), 'n');
	$q = "SELECT `content`.`id`, `art_limit`, `top`, `rss`, `container`, `container_small`, `teaser`,
`teaser_small`, `teaser_picture`, `file`, `short`, `title`, `lang`, `template`, `parent`, `folder`, `show_title`, `type` FROM `rubrics` LEFT JOIN `content` ON `rubrics`.`pid` = `content`.`id`
WHERE `content`.`id` = ?;";
	$arg = $db->prepare($q);
	$arg->execute([$id]);
	$rubric = $arg->fetch(PDO::FETCH_ASSOC);
	$teaser = make_teaser($rubric, $of);
	$data = ['file', 'short', 'title', 'lang', 'template', 'parent', 'folder', 'show_title', 'type'];
	foreach ($data as $k) {$html[$k] = $rubric[$k];}
	$html['body'] = $teaser['all'];
	$html['id'] = $id;
	return $html;
	}

function gen_all_articles() {
	global $db;
	$q = "SELECT `content`.`id`, `pid`, `title`, `subtitle`, `lead`, `articlebody`, `picture`, `picturetext`, `copyright`,
`author`, `authorshort`, `file`, `articles`.`keywords`, `update`, `written`, `news_template`, `published`, `content`, `top` FROM `articles` LEFT JOIN `content` ON `articles`.`pid` = `content`.`id`
WHERE `published` >= 1 ORDER BY `sort` LIMIT 200;"; // reset limit if necesarry
	$arg = $db->prepare($q);
	$arg->execute();
	$rec = $arg->rowCount();
	while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
		generate_article($data, $data['id']);
		}
	}
?>
