<?php

# plugin order_processing
# @Author: Rainer Imb <imb>
# @Date:   2018-04-24 14:44:52
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-07-04T12:24:30+02:00
# @License: GPL 2.0

require_once('shop_basics.php');
require_once('webshop_library.php');

class order_processing extends shop_basics {

	private $mail = false;
	private $footer = false;
	private $fullname = false;
	private $email = false;

	public function __construct(){
		$this->defs = read_settings(['group' => 'webshop']);
		$this->salut = [i18n('ms'), i18n('mr'), i18n('company')];
		}

	public function plugin($html) {
		global $i18n;
		if(param('todo') == '_printer') {$html['action'] = 'print';}
		if(param('todo') == '_turnover') {$html['action'] = 'turnover';}
		add_i18n('webshop'); // adds words from 'webshop' to i18n
		switch ($html['action']) {
			case ("order_items"): $html = $this->order_items($html); break;
			case ("print"): $html = $this->printing($html); break;
			case ("get_product"): $html = $this->ajax($html); break;
			case ("turnover"): $html = $this->turnover($html); break;
			default: $html = $this->order_processing_admin($html);
			}
		return $html;
		}

	private function order_processing_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$xml_button = '<input id="iexport" name="export" type="checkbox" />&nbsp;<label for="iexport">'.i18n('export_xml').'</label>';
		$pay_arr = explode(',', $this->defs['payment_options']);

		$form = [
			"title"			=> i18n('orders'),
			"table"			=> "webshop_order",
			"myconf"		=> "order_processing",
			"orderby"		=> "id",
			"defsort"		=> 'DESC',
			"human"			=> "id",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['client', 'note', 'lang'],
			"filters"		=> ['status'],
			"allow_del"		=> false,
			"allow_box"		=> 'attr',
			"attr_to_set"	=> ['payed'],
			"allow_something"	=> ['printer', 'print', 'print'],
			'in_form'		=> $this->get_files($rid),
			"table_fields"	=> ['id', 'status', 'client', 'date', 'total', 'payment', 'payed_date', 'payed']
			];

		$inputs = [
		'id'		=> [
			'caption'	=> i18n('order')." №",
			'type'	=> 'readonly',
			"pattern" => "%08d"
			],
		'client'	=> [
			'type'	=> 'readonly_lookup',
			'ltable'	=> 'clients',
			'lid'	=> 'id',
			'lval'	=> 'name',
			'lord'	=> 'name'
			],
		'country'	=> [
			'type'	=> 'country',
			'default'	=> 'at',
			'duty'	=> 1,
			],
		'date'	=> [
			'type'	=> 'readonly',
			],
		'freight'	=> [
			'type'	=> 'number',
			'default'	=> 0.00,
			],
		'total'	=> [
			'type'	=> 'text',
			'css_td' => 'makeSum'
			],
		'payment'	=> [
			'type'	=> 'array',
			'raw'	=> true,
			'extra'	=> $pay_arr,
			'view'	=> array_map("i18n", $pay_arr)
			],
		'payed_date'	=> [
			'caption'	=> i18n('date')." ".i18n('payment'),
			'type'	=> 'date'
			],
		'weight'	=> [
			'type'	=> 'text',
			],
		'order'		=> [
			'type'	=> 'subform',
			'conf'	=> "order_items",
			'foreign'	=> "order_id",
			'height'	=> 500
			],
		'note'	=> [
			'caption'	=> i18n('notes'),
			'type'	=> 'bigtext'
			],
		'lang'	=> [
			'caption'	=> i18n('language'),
			'type'	=> 'readonly',
			'default'	=> 'de'
			],
		'by_hand'	=> [
			'type'	=> 'hidden'
			]
		];

		$inputs_first = [
		'client'	=> [
			'type'	=> 'lookup',
			'ltable'	=> 'clients',
			'lid'	=> 'id',
			//'lval'	=> 'name',
			'lval'	=> ['name', 'prename', 'city'],
			'lord'	=> 'name'
			],
		'date'	=> [
			'type'	=> 'readonly',
			'default' => date('Y-m-d H:i:s')
			],
		'freight'	=> [
			'type'	=> 'number',
			'default'	=> 0.00,
			],
		'payment'	=> [
			'type'	=> 'array',
			'raw'	=> true,
			'extra'	=> $pay_arr,
			'view'	=> array_map("i18n", $pay_arr)
			],
		'weight'	=> [
			'type'	=> 'text',
			],
		'note'	=> [
			'caption'	=> i18n('notes'),
			'type'	=> 'bigtext'
			],
		'lang'	=> [
			'caption'	=> i18n('language'),
			'type'	=> 'hidden',
			'default'	=> 'de',
			],
		'country'	=> [
			'type'	=> 'hidden',
			'default'	=> 'at'
		],
		'by_hand'	=> [
			'type'	=> 'hidden',
			'default'	=> 1
			]
		];

		if (!$rid || $rid == "new") {$form['button_text'] = i18n('next');}

		$obj = new access($form);
		$obj->set_attribute($inputs);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				if ($obj->rid == "new") {
					$rid = $obj->store($inputs);
					$obj->rid = $rid;
					$inputs['id']['value'] = $rid;
					//$obj->feedback = '';
					// next form
					$todo = "edit";
					$obj->button_text = i18n('save');
					}
				else {
					$id = $obj->store($inputs);
					$html['popup'] = $obj->feedback;
					if (param('by_hand') == 1) { echo 'book_now';
						$this->set_stock($id); // set stock only once
						}
					}
				}
			}

		if ($todo == "edit") {
			$submen = array(
				[i18n('order'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;rid=$rid", "active", "clipboard"],
				[i18n('print'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=_printer&amp;rid=$rid", "inactive", "print"]
				);
			$obj->before_form = make_submenu($submen);
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				if (!$rid || $rid == "new") {$inputs = $inputs_first;}
				else {$inputs['client']['in_body'] = $this->get_client($inputs['client']['value']);}
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		elseif (param('_set_att')) {
			$inputs['payed'] = ['type'	=> 'flag'];
			$obj->in_form = "<div class='buttons'><input type='submit' name='_print' value='".i18n('print')."' class='button' /></div>";
			$html = $obj->attr_form($inputs);
			}
		elseif (param('_print')) {
			$html['content'] = say_mess($this->merge_pdf($rid), i18n('print'), 'print');
			$html['formtitle'] = $form['title'];
			}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "clipboard-add"],
				[i18n('order'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", "clipboard"],
				[i18n('turnover'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=_turnover", "inactive", "money"],
				);
			$obj->before_table = make_submenu($submen);
			$obj->table = 'webshop_order_view';
			$inputs['client'] = ['type'	=> 'text'];
			$inputs['payed'] = ['type'	=> 'flag', 'reload' => true];
			$extra = ['ordered', 'partly', 'delivered', 'cancelled', 'waiting', 'on_commission'];
			$view = array_map(function($s){return i18n($s);}, $extra);
			$inputs['status']	= [
				'caption'	=> i18n('status', true),
				'type'	=> 'array',
				'extra'	=> $extra,
				'view'	=> $view,
				'fontawesome'	=> ['cog', 'ban', 'truck-green', 'times-red', 'clock', 'certificate-purple']
				];
			if (@include_once("other/SimpleExcel/xlsxWriter.php")) {
				$obj->in_searchform .= ' <input id="iexportx" name="export" type="radio" value="xls" />&nbsp;<label for="iexportx">'.i18n('export_xls').'</label>';
				}
			$html = $obj->table($inputs);// export xml if asked for
			if (param('export')) {
				$html['content'] = export_xml($obj->export_q, $obj->taint, i18n('orders'));
				$html['gui'] = 6;
				}
			$html['scripts'] .= "<script src='/js/jQsumTD.js' type='text/javascript'></script>";
			}

		$html['left'] = get_tab_tree($html, "webshop", $form['myconf'], "");
		return $html;
		}

	private function order_items($html) {
		global $website;
		$this->get_taxes($website['country']);
		$tax_arr = array_splice($this->taxes[$website['country']], 0, 3); // 3 tax classes no taxname
		$rid = param('rid');
		$oid = clean_var(param('order_id'), 'n');
		$todo = clean_var(param('todo'), "w");

		$product = "<label for='gettmpl'>".i18n('search')." ".i18n('product_no')." </label> <input type='text' id='gettmpl' name='gettmpl' value='' class='text' size='40' />
	<script src='/js/jQautocomplete.js' type='text/javascript'></script>
	<script type='text/javascript'>
	function fillID (li){
		\$('#icopy_name').val(li.data[1]);
		\$('#icopy_product_no').val(li.data[0]);
		\$('#icopy_tax option[value='+li.data[3]+']').attr('selected', 'selected');
		\$('#iprice').attr({value:li.data[2]});
		\$('#iproduct').attr({value:li.data[4]});
		}
	$(document).ready(function (){\$('#gettmpl').autocomplete('{$html['myurl']}',{extraParams:{sid: '{$html['sid']}', '_id': 'get_product'},selectFirst:1,'minChars':2,onItemSelect:fillID})});
	</script>
	<hr />";
		$extra = ['ordered', 'delivered', 'cancelled', 'waiting', 'on_commission'];
		$view = array_map(function($s){return i18n($s);}, $extra);


		$form = [
			"title"			=> i18n('order').' '.$oid,
			"table"			=> "order_items",
			"myconf"		=> "order_items",
			"orderby"		=> "product",
			"human"			=> "copy_name",
			"html"			=> $html,
			"rid"			=> $rid,
			"filters"		=> ['order_id'],
			"search"		=> [],
			"searchform"	=> 0,
			//'allow_edit'	=> false,
			'allow_del'		=> false,
			"allow_box"		=> 'attr',
			"add_button"	=> "<button type='submit' name='_set_delivery' value='1'><i class='fas fa-truck fa-lg'></i> ".i18n('set_delivery')."</button>&nbsp;",
			"attr_to_set"	=> ['status'],
			"table_fields"	=> ['amount', 'status', 'copy_product_no', 'copy_name', 'price', 'discount', 'total'],
			"before_form"	=> $product
			];

		$inputs = [
		'order_id'	=> [
			'type'	=> 'hidden',
			'default'	=> $oid
			],
		'amount'	=> [
			'caption'	=> i18n('pieces'),
			'type'	=> 'spin',
			'min'	=> 1,
			'max'	=> 1000,
			'default'	=> 1,
			],
		'product'	=> [
			'type'	=> 'hidden',
			],
		'copy_product_no'	=> [
			'caption'	=> 'No.',
			'type'	=> 'text',
			],
		'copy_name'	=> [
			'caption'	=> i18n('name'),
			'type'	=> 'text',
			],
		'copy_tax'	=> [
			'caption'	=> i18n('tax'),
			'type'	=> 'array',
			'extra'	=> $tax_arr,
			'duty'	=> 1,
			],
		'price'	=> [
			'type'	=> 'number',
			'default'	=> 0.00,
			],
		'discount'	=> [
			'type'	=> 'spin',
			'min'	=> 0,
			'max'	=> 100,
			'interval'	=> 5,
			'default'	=> 0,
			'size'	=> 4,
			'in_body' => '%'
			],
		'total'	=> [
			'type'	=> 'function',
			'value'	=> "({price}*{amount})*(1-({discount}/100))",
			"pattern" => "%.02f"
			],
		'status'	=> [
			'caption'	=> i18n('status', true),
			'type'	=> 'array',
			'extra'	=> $extra,
			'view'	=> $view,
			'fontawesome'	=> ['cog', 'truck-green', 'times-red', 'clock', 'certificate-purple'],
			'duty'	=> 1,
			'default'	=> 2
			]
		];

		$obj = new access($form);
		$obj->set_attribute($inputs);

		if (param('_set_delivery')) {$this->set_delivered($oid);}

		$this->trigger_status($oid);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {
				$inputs = $obj->get_value($inputs);
				$obj->before_form = '';
				}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			if (param('_del')) {$obj->delete();}
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;order_id=$oid", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			$html = $obj->table($inputs);
			}
		$html['left'] = get_tab_tree($html, "webshop", $form['myconf'], "");;
		return $html;
		}

	private function ajax($html) {
		global $db;
		$html['gui'] = 6;
		$limit = 100;
		$html['content'] = "-|0\n";
		$value = param("q");
		$query = "SELECT `product_no`, `title`, `price`, `tax`, `pid` FROM `products`, `content` WHERE `pid` = `content`.`id` AND `product_no` LIKE ? ORDER BY `product_no` LIMIT $limit;";
		$value = preg_replace("/\+/", "", $value);
		if ($value) {
			$arg = $db->prepare($query);
			$arg->execute(array("%$value%"));
			while ($values = $arg->fetch(PDO::FETCH_ASSOC)) {
				$html['content'] .= "{$values['product_no']} {$values['title']}|{$values['product_no']}|{$values['title']}|{$values['price']}|{$values['tax']}|{$values['pid']}\n";
				}
			}
		return $html;
		}

	private function get_files($rid) {
		global $html;
		$c = '';
		if (!$rid) {$rid = 'new';}
		if ($rid != 'new') {
			$pat = sprintf($this->defs['pattern'], $rid);
			$pat = preg_replace('/^YY/', date('y'), $pat);
			$c = '<h2>'.i18n('files').'</h2><ul>';
			foreach (glob($this->defs['pdf_dir']."/*") as $f) {
				$fn = basename($f);
				$tst = date('Y-m-d H:i:s', filemtime($f));
				if (preg_match("/$pat/", $fn)) {
					$fn = preg_replace('/\.pdf$/', '', $fn);
					$l = $html['myurl']."?sid={$html['sid']}&amp;_id=get_invoice&amp;_f=$fn";
					$li = htmltag('a', "href=\"$l\" target=\"_blank\"", get_icon('far-file-pdf', 'pdf').' '.$fn);
					$li = htmltag('li', '', "$li ($tst)");
					$c .= $li;
					}
				}
			$c .= '</ul>';
			}

		return $c;
		}

	private function get_client($cid) {
		global $db, $html;
		$q = "SELECT * FROM `clients` WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($cid));
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		$l = htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=basic_crm&amp;todo=edit&amp;rid=$cid\"", get_icon('edit', i18n('edit')));
		$h = htmltag('h3', '', i18n('invoice')."&nbsp;$l");
		$c = htmltag('div', 'class="col w50p first"', $h.$this->parse_address($data));
		$q = "SELECT * FROM `clients_delivery` WHERE `cid` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($cid));
		if ($arg->rowCount()) {$data = $arg->fetch(PDO::FETCH_ASSOC);}
		$l = htmltag('a', "href=\"{$html['myurl']}?sid={$html['sid']}&amp;_id=order_delivery&amp;todo=edit&amp;rid={$data['id']}\"", get_icon('edit', i18n('edit')));
		$h = htmltag('h3', '', i18n('delivery')."&nbsp;$l");
		$c .= htmltag('div', 'class="col w50p last"', $h.$this->parse_address($data));
		$c = htmltag('div', 'class="clrfx"', $c);
		return $c;
		}

	private function parse_address($data) {
		$addr = nl2br($this->full_address($data), true);
		$addr = htmltag('p', '', $addr);
		return $addr;
		}

	private function full_address($data) {
		$s = ['', i18n('ms'), i18n('mr'), i18n('company')];
		$addr = $s[$data['salutation']].' ';
		if ($data['title']) {$addr .= $data['title'].' ';}
		$addr .= $data['prename'].' '.$data['name']."\n";
		if ($data['company']) {$addr .= $data['company']."\n";}
		if ($data['company_line2']) {$addr .= $data['company_line2']."\n";}
		$addr .= $data['street']."\n";
		$addr .= $data['postal_code'].' '.$data['city']."\n";
		if ($data['province']) {$addr .= ' '.$data['province']."\n";}
		$addr .= get_country_name($data['country'])."\n";
		return $addr;
		}

	private function set_delivered($oid) {
		global $db;
		$arg = $db->prepare("UPDATE `order_items` SET `status` = 2 WHERE `order_id` = '$oid';");
		$arg->execute();
		}

	private function trigger_status($oid) {
		global $db;
		$sum = 0;

		$arg = $db->prepare("SELECT `status` FROM `order_items` WHERE `order_id` = '$oid';");
		$arg->execute();
		$rows = $arg->rowCount();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {$sum += $data['status'];}

		$check = $sum/$rows;
		$status = 1; // ordered
		if ($check == 2) {$status = 3;} // delivered
		elseif ($check == 3) {$status = 4;}	// canceled
		elseif ($check == 4) {$status = 5;}	// waiting for something
		elseif ($check == 5) {$status = 6;}	// on commission
		elseif ($check > 1) {$status = 2;} // partly
		$arg = $db->prepare("UPDATE `webshop_order` SET `status` = '$status' WHERE `id` = '$oid';");
		$arg->execute();
		}

private function set_stock($oid) {
	global $db;
	$q = "SELECT `product`, `amount` FROM `order_items` WHERE `order_id` = ? order by `id` ASC;";
	$arg = $db->prepare($q);
	$arg->execute([$oid]);
	while ($a = $arg->fetch(PDO::FETCH_ASSOC)) {
		$q2 ="UPDATE `products` SET `stock` = `stock`- {$a['amount']} WHERE `pid` = ?;";
		$arg2 = $db->prepare($q2);
		$arg2->execute(array($a['product']));
		}
	$arg = $db->prepare("UPDATE `webshop_order` SET `by_hand` = 0 WHERE  `id` = ?;");
	$arg->execute([$oid]);
	}

	private function printing($html) {
		$rid = param('rid');
		$todo = clean_var(param('_t'), 'w');
		$submen = array(
				[i18n('order'), $html['myurl']."?sid={$html['sid']}&amp;_id=order_processing&amp;todo=edit&amp;rid=$rid", "inactive", "clipboard"],
				[i18n('print'), $html['myurl']."?sid={$html['sid']}&amp;_id=order_processing&amp;todo=_printer&amp;rid=$rid", "active", "print"]
				);
		$html['content'] =  make_submenu($submen);
		$f_id = sprintf($this->defs['pattern'], $rid);
		$f_id = preg_replace('/^YY/', date('y'), $f_id);
		$html['content'] .=  htmltag('h2', '', i18n('order')." № $f_id");
		if ($todo) {$this->make_invoice($rid, $todo);}
		if ($this->mail) {
			$d = ['text' => $this->mail, 'fullname' => htmltag('p', '', $this->fullname), 'footer' => $this->footer, 'total' => $this->total_am];
			$this->mail = parse_in('cms_shop_'.$todo, $d);
			list ($html['content'], $html['scripts']) = $this->mailform($rid);
			}
		else {
			$html['content'] .= $this->get_files($rid);
			$html['content'] .= htmltag('h2', '', i18n('create'));
			$div = '';
			foreach (['order', 'invoice', 'delivery_note', 'reminder', 'last_reminder'] as $type) {
				$l = $html['myurl']."?sid={$html['sid']}&amp;_id=order_processing&amp;todo=_printer&amp;rid=$rid&amp;_t=$type";
				$file = htmltag('a', "class=\"as_button\" href=\"$l\"", get_icon('sync', i18n('print'))."&nbsp;".i18n($type));
				$div .= htmltag('div', 'class="col w4"', $file);
				}
			$html['content'] .= htmltag('div', 'class="row clrfx"', $div);
			$html['content'] .= htmltag('h2', '', i18n('email'));
			$l = $html['myurl']."?sid={$html['sid']}&amp;_id=order_processing&amp;todo=_printer&amp;rid=$rid&amp;_t=delivery_mail";
			$l = htmltag('a', "class=\"as_button\" href=\"$l\"", get_icon('truck', i18n('delivery'))."&nbsp;".i18n('delivery'));
			$ll = $html['myurl']."?sid={$html['sid']}&amp;_id=order_processing&amp;todo=_printer&amp;rid=$rid&amp;_t=delivery_payment";
			$ll = htmltag('a', "class=\"as_button\" href=\"$ll\"", get_icon('money', i18n('delivery'))."&nbsp;".i18n('delivery')."&nbsp;&amp;&nbsp;".i18n('invoice'));
			$html['content'] .= htmltag('p', '', $l."&nbsp;".$ll);
			}

		$html['formtitle'] = i18n('order').' &mdash; '.i18n('print');
		$html['left'] = get_tab_tree($html, "webshop", 'order_processing', "");
		return $html;
		}

	private function turnover($html) {
		global $db;
		$rid = param('rid');
		$todo = clean_var(param('_t'), 'w');
		$y = param('_year') ? clean_var(param('_year'), 'n') : false;
		$submen = array(
			[i18n('order'), $html['myurl']."?sid={$html['sid']}&amp;_id=order_processing", "inactive", "clipboard"],
			[i18n('turnover'), $html['myurl']."?sid={$html['sid']}&amp;_id=order_processing&amp;todo=_turnover", "active", "money"],
			);
		$html['content'] = make_submenu($submen);

		if ($todo == 'updC') {$this->get_countries_of_orders();}

		$arg = $db->prepare("SELECT DISTINCT YEAR(`date`) AS `year` FROM `turnover`;");
		$arg->execute();
		$years = $arg->fetchAll(PDO::FETCH_COLUMN, 0);
		$period = $years[0]." &ndash; ".end($years);

		$oy = "";
		foreach ($years as $v) {
			$oy .= htmltag('a', 'href="'.$html['myurl']."?sid={$html['sid']}&amp;_id=order_processing&amp;todo=_turnover&_year=$v".'"', $v)." &middot ";
			}
		$html['content'] .= $oy;

		if ($y){$period = $y;}

		$qs = [
			"SELECT SUM(`amount`) AS `pieces`, SUM(`amount`*`price`) AS `turnover` FROM `turnover` WHERE `status` = 2;",
			"SELECT AVG(`pieces`) AS `avg_pieces`, AVG(`turnover`) AS `avg_turnover` FROM (SELECT `oid`, SUM(`amount`) AS `pieces`, SUM(`amount`*`price`) AS `turnover` FROM `turnover`  WHERE `status` = 2 GROUP BY `oid`) AS `average`;"
			];
		if ($y) {
			$qs = [
				"SELECT SUM(`amount`) AS `pieces`, SUM(`amount`*`price`) AS `turnover` FROM `turnover` WHERE YEAR(`date`) = '$y';",
				"SELECT AVG(`pieces`) AS `avg_pieces`, AVG(`turnover`) AS `avg_turnover` FROM (SELECT `oid`, SUM(`amount`) AS `pieces`, SUM(`amount`*`price`) AS `turnover` FROM `turnover`  WHERE YEAR(`date`) = '$y' GROUP BY `oid`) AS `average`"
				];
			}

		$stats = array('overview' => '');

		foreach ($qs as $q) {
			$arg = $db->prepare($q);
			$arg->execute();
			$data = $arg->fetch(PDO::FETCH_ASSOC);
			$ul = '';
			foreach ($data as $k=>$v) {
				if (!is_integer($v)) {$v = sprintf('%.2f', $v);}
				$ul .= htmltag('li', '', i18n($k).": $v ($period)");
				}
			if ($ul) {$stats['overview'] .= htmltag('ul', '', $ul);}
			else {$stats['overview'] .= $q.i18n('mess_no_entry');}
			}

		$q = "SELECT YEAR(`date`) AS `year`, MONTH(`date`) AS `month`, SUM(`freight`) AS `tfreight` FROM `webshop_order` WHERE `payed` = 'on' GROUP BY `year`, `month` ORDER BY `year` DESC, `month` DESC LIMIT 12;";

		if ($y){$q = "SELECT YEAR(`date`) AS `year`, MONTH(`date`) AS `month`, SUM(`freight`) AS `tfreight` FROM `webshop_order` WHERE `payed` = 'on' AND YEAR(`date`) = '$y' GROUP BY `year`, `month` ORDER BY `year` DESC, `month` DESC;";}

		$arg = $db->prepare($q);
		$arg->execute();
		$freight = [];
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$freight[$data['year'].$data['month']] = $data['tfreight'];
			}
		$q = "SELECT YEAR(`date`) AS `year`, MONTH(`date`) AS `month`, SUM(`amount`) AS `pieces`, COUNT(DISTINCT `oid`) AS `orders`, SUM(`amount`*`price`) AS `turnover` FROM `turnover` WHERE `status` = 2 GROUP BY `year`, `month` ORDER BY `year` DESC, `month` DESC LIMIT 12;";

		if ($y){$q = "SELECT YEAR(`date`) AS `year`, MONTH(`date`) AS `month`, SUM(`amount`) AS `pieces`, COUNT(DISTINCT `oid`) AS `orders`, SUM(`amount`*`price`) AS `turnover` FROM `turnover` WHERE `status` = 2 AND YEAR(`date`) = '$y' GROUP BY `year`, `month` ORDER BY `year` DESC, `month` DESC;";}
// SELECT YEAR(`date`) AS `year`, MONTH(`date`) AS `month`, SUM(`amount`) AS `pieces`, COUNT(`oid`) AS `orders`, SUM(`amount`*`price`) AS `turnover`, `country` FROM `turnover` WHERE YEAR(`date`) = '$y' AND MONTH(`date`) = '$m' GROUP BY `country`;
		$arg = $db->prepare($q);
		$arg->execute();
		$count = 0;
		$chart = [];
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if (!$count) {
				$tr = '';
				foreach($data as $k=>$v) {$tr .= htmltag('th', 'scope="col"', i18n($k));}
				if ($tr) {
					$tr .= htmltag('th', 'scope="col"', i18n('turnover').' + '.i18n('freight'));
					$stats['mtable'] = htmltag('tr', '', $tr);
					}
				}
			$tr = '';
			$l = '';
			$f = $freight[$data['year'].$data['month']];
			foreach($data as $k=>$v) {
				if ($k == 'year') {$l = $v;}
				if ($k == 'month') {$l .= "-$v";}
				if ($k == 'turnover') {
					$v = sprintf('%.2f', $v);
					$chart[$l] = $v;
					}
				$tr .= htmltag('td', '', $v);
				if ($k == 'turnover') {
					$tr .= htmltag('td', '', sprintf('%.2f', $v+$f));
					}
				}
			if ($tr) {$stats['mtable'] .= htmltag('tr', '', $tr);}
			$count++;
			}
		$chart = array_reverse($chart);
		$trh = htmltag('th', '', i18n('month'));
		$tr = htmltag('th', '', i18n('turnover'));
		foreach ($chart as $k=>$v) {
			$m = preg_replace('/^\d{4}\-/', '', $k);
			$trh .= htmltag('th', '', $m);
			$tr .= htmltag('td', '', $v);
			}
		if ($tr) {
			$stats['chart'] = htmltag('tr', '', $trh);
			$stats['chart'] .= htmltag('tr', '', $tr);
			}
		if (array_key_exists('chart', $stats)) {$stats['chart'] = htmltag('table', 'id="tmonths" class="table"', $stats['chart']);}
		if (array_key_exists('mtable', $stats))  {$stats['mtable'] = htmltag('table', 'class="table"', $stats['mtable']);}

		$q = "SELECT `product`, SUM(`amount`) AS `pieces`, SUM(`amount`*`price`) AS `turnover`
		FROM `turnover` GROUP BY `product` ORDER BY `turnover` DESC LIMIT 100;";

		if ($y){$q = "SELECT `product`, SUM(`amount`) AS `pieces`, SUM(`amount`*`price`) AS `turnover`
		FROM `turnover` WHERE YEAR(`date`) = '$y' GROUP BY `product` ORDER BY `turnover` DESC LIMIT 20;";}

		$arg = $db->prepare($q);
		$arg->execute();
		$count = 0;
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if (!$count) {
				$tr = '';
				foreach($data as $k=>$v) {
					if ($k == 'product') {$kk = i18n($k)." ($period)";}
					else {$kk = i18n($k);}
					$tr .= htmltag('th', 'scope="col"', $kk);
					}
				if ($tr) {$stats['table'] = htmltag('tr', '', $tr);}
				}
			$tr = '';
			foreach($data as $k=>$v) {
				if ($k == 'product') {$v = $this->get_product($v);}
				if ($k == 'turnover') {$v = sprintf('%.2f', $v);}
				$tr .= htmltag('td', '', $v);
				}
			if ($tr) {$stats['table'] .= htmltag('tr', '', $tr);}
			$count++;
			}
		if (array_key_exists('table', $stats))  {$stats['table'] = htmltag('table', 'class="table"', $stats['table']);}
		$html['content'] .= parse_in('gui_webshop_turnovers', $stats);
		$html['formtitle'] = i18n('turnover');
		$html['scripts'] .= "<script src='/js/jQcharts.js' type='text/javascript'></script>";
		$html['left'] = get_tab_tree($html, "webshop", 'order_processing', "");;
		return $html;
		}

	private function get_product($rid) {
		global $db;
		$q = "SELECT `title` FROM `content` WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($rid));
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		return $data['title'];
		}

	private function get_mess($t, $l) {
		global $db, $con;
		$arg = $db->prepare("SELECT * FROM `crm_messages` where `group` = ? AND `lang` = ?;");
		$arg->execute([$t, $l]);
		$mess = array();
		while ($all = $arg->fetch(PDO::FETCH_ASSOC)) {
			$mess[$all['key']] = $all['value'];
			}
		return $mess;
		}

	private function make_invoice($rid, $type) {
		global $db, $html, $website;
		$excl = false;
		if ($type == 'no_tax') {$type = 'invoice'; $excl = true;}
		$q = "SELECT * FROM `webshop_order` WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($rid));
		$invoice = $arg->fetch(PDO::FETCH_ASSOC);
		$invoice['defs'] = $this->defs;
		$invoice['Subject'] = i18n($type);
		$f_id = sprintf($this->defs['pattern'], $rid);
		$f_id = preg_replace('/^YY/', date('y'), $f_id);
		$file = $invoice['Subject']."-".$f_id.".pdf";
		$invoice['Subject'] .= " ".$f_id;
		$mess = $this->get_mess('shop', 'de');

		$q = "SELECT * FROM `clients` WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($invoice['client']));
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		$this->isoc = $data['country']; // VAT & Freight
		$invoice['inv_addr'] = $this->full_address($data);
		$this->full_salutation($data);
		$notice = false;

		foreach (['order', 'invoice', 'no_tax', 'delivery_note', 'reminder', 'last_reminder'] as $t) {
			if ($t == $type) {
				if (array_key_exists($t.'_notice', $mess)) {
					if (in_array($data['payment'], ['invoice', 'in_advance'])) {
						$notice = $mess[$t.'_notice'];
						$notice = preg_replace('/&&&&account&&&&/', $this->defs['account'], $notice);
						$notice = preg_replace('/&&&&total&&&&/', $invoice['total'], $notice);
						$notice = preg_replace('/&&&&date&&&&/', $invoice['date'], $notice);
						}
					}
				}
			}

		if (in_array($type, ['delivery_note', 'delivery_mail', 'delivery_payment'])){
			$q = "SELECT * FROM `clients_delivery` WHERE `cid` = ?;";
			$arg = $db->prepare($q);
			$arg->execute(array($invoice['client']));
			if ($arg->rowCount()) {
				$data = $arg->fetch(PDO::FETCH_ASSOC);
				$invoice['del_addr'] = $this->full_address($data);
				if ($data['use_del']) {
					$invoice['inv_addr'] = $this->full_address($data); // PDF
					$invoice['del_addr'] = false;
					$this->isoc = $data['country']; // VAT & Freight
					}
				}
			}

		if ($type == 'delivery_mail' || $type == 'delivery_payment'){
			$invoice['Subject'] = i18n('order')." ".$f_id;
			}

		$invoice['articles'] = array();
		$this->get_taxes($this->isoc);

		$q = "SELECT `amount`, `copy_product_no` AS `product_no`, `copy_name` AS `title`, `copy_tax` AS `tax`, `price`, `discount` FROM `order_items` WHERE `order_id` = ? AND `status`";
		if($type == 'invoice') {$q .= " IN(2,4);";}
		else {$q .= " IN(2,4,5);";}
		$arg = $db->prepare ($q);
		$arg->execute([$rid]);
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($data['discount']) {
				$data['price'] = $data['price']*(1-($data['discount']/100));
				}
			$data = $this->get_price($data);
			array_push($invoice['articles'], $data);
			}

		$cvat = $this->defs['eu_vat'] == 2 ? $this->isoc : $website['country'];
		$invoice['freight_tax'] = $this->taxes[$cvat]['tax'.$this->defs['tax_vat']];
		$invoice['defs']['tax_name'] = $this->taxes[$cvat]['tax_name'];

		$pdf = new webshop_lib([
			'data' => $invoice,
			'file' => $file,
			'excl' => $excl,
			'notes' => $notice,
			'image' => $html['dir'].'/pictures/'.$this->defs['logo']
			]);

		if ($type == 'delivery_mail' || $type == 'delivery_payment'){
			$pdf->build_list();
			$this->mail = $pdf->html;
			// need the footer seperated
			$pdf->html = '';
			$pdf->build_footer();
			$this->footer = $pdf->html;
			$this->total_am = $pdf->total;
			}
		else {
			$pdf->create_invoice_pdf();
			$this->total($rid, $pdf->total);
			}
		}

	private function total($id, $t) {
		global $db;
		$tax = array();
		$arg = $db->prepare("UPDATE `webshop_order` SET `total` = ? WHERE `id` = ?;");
		$arg->execute(array($t, $id));
		}

	private function full_salutation($data) {
		$c = $data['salutation'] == 2 ? i18n('salut_m') : i18n('salut_f');
		$c .= " ".$this->salut[($data['salutation']-1)].' ';
		if ($data['title']) {$c .= $data['title'].' ';}
		$c .= $data['prename'].' '.$data['name']."\n";
		$this->fullname = $c;
		$this->email = $data['email'];
		}

	private function merge_pdf($rid) {
		global $html;
		$file = "all".date('Y-m-d').".pdf";
		$invoice['Subject'] = i18n($type);
		$files = [];
		foreach ($rid as $id) {
			$f_id = sprintf($this->defs['pattern'], $id);
			$f_id = preg_replace('/^YY/', date('y'), $f_id);
			$f = i18n('invoice')."-".$f_id.".pdf";
			array_push($files, $f);
			}

		require_once('gs.php');
		$pdf = new gs([
			'input'		=> $files,
			'output'	=> $file,
			'dir'		=> $this->defs['pdf_dir']
			]);
		$pdf->merge();
		$fn = preg_replace('/\.pdf$/', '', $file);
		$href = $html['myurl']."?sid={$html['sid']}&amp;_id=get_invoice&amp;_f=$fn";
		$link = htmltag('a', "href=\"$href\" target=\"_blank\"", get_icon('mime/pdf', 'pdf').' '.$fn);
		return $link;
		}

	private function mailform($rid) {
		global $html;
		$todo = 'edit';
		$view = [i18n('none')];
		$extra = [''];
		$f_id = sprintf($this->defs['pattern'], $rid);
		$f_id = preg_replace('/^YY/', date('y'), $f_id);

		foreach (['order', 'invoice', 'no_tax', 'delivery_note', 'reminder', 'last_reminder'] as $type) {
			$file = i18n($type)."-$f_id.pdf";
			if (file_exists($this->defs['pdf_dir'].$file)) {
				array_push($view, i18n($type));
				array_push($extra, $file);
				}
			}

		$form = [
			"no_cancel"		=> 1,
			"html"			=> $html,
			"feedback"		=> $html['feedback'],
			"button_text"	=> i18n('send'),
			"button_fa"		=> 'envelope'
			];
		$inputs = [
			"email"	=> ["type" => "text",'value' =>  $this->email],
			"subject"	=> ["type" => "text", "duty" => 1],
			"message"	=> ["type" => "wysiwyg", 'caption' => i18n('text'), 'value' => $this->mail],
			"file"	=> [
				'caption' => i18n('attachment', true),
				'type'	=> 'radio',
				'raw'	=> true,
				"extra" => $extra,
				"view" => $view
				],
			"rid"	=> ["type" => "hidden", "value" => clean_var(param('rid'), 'w')],
			"todo" => ["type" => "hidden", "value" => "_printer"],
			"_t" => ["type" => "hidden", "value" => clean_var(param('_t'), 'w')]
			];
		$obj = new access($form);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$todo = 'done';
				$pdf = new webshop_lib(['data' => ['Subject' => $inputs['subject']['value'], 'defs' => $this->defs], 'file' => $inputs['file']['value']]);
				$pdf->html = $inputs['message']['value'];
				$pdf->plain = html2plain($inputs['message']['value']);
				$check = $pdf->send(['email' => $inputs['email']['value']]);
				if ($check) {$html2['content'] = say_mess($check, i18n('error'), 'error');}
				else { $html2['content'] =  say_mess(i18n('send_to')." {$inputs['email']['value']}", i18n('ok'), 'ok');}
				$html2['scripts'] = '';
				}
			}
		if ($todo == 'edit') {
			$obj->add_input($inputs);
			$html2 = $obj->form();
			}
		return [$html2['content'], $html2['scripts']];
		}

	private function get_countries_of_orders() {
		global $db;
		$q = "SELECT `webshop_order`.`id`, `webshop_order`.`client`, `clients`.`country`, `clients_delivery`.`country` AS `delcou`, `clients_delivery`.`use_del` FROM `webshop_order` LEFT JOIN `clients` ON `webshop_order`.`client` = `clients`.`id` LEFT JOIN `clients_delivery` ON `webshop_order`.`client` = `clients_delivery`.`cid`;";
		$arg = $db->prepare($q);
		$arg->execute();
		$arr = [];
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$country = $data['use_del'] == 'on' ? $data['delcou'] : $data['country'];
			$arr[$data['id']] = $country;
			}
		foreach ($arr as $k => $v) {
			$arg = $db->prepare('UPDATE `webshop_order` SET `country` = ? WHERE `id` = ?;');
			$arg->execute([$v, $k]);
			}
		}
	}

?>
