<?php

class UserAgent
{
    protected $agent;
    protected $os;
    protected $oid;
    protected $browser;
    protected $bid;
    protected $prefix;
    protected $version;
    protected $engine;
    protected $device = 'Desktop';
    protected $isBot = false;

    protected $oss = [
        'Android' => ['Android'],
        'Linux' => ['linux', 'Linux'],
        'Mac OS X' => ['Macintosh', 'Mac OS X'],
        'iOS' => ['like Mac OS X'],
		'Windows NT 10' => ['Windows NT 10'],
        'Windows 8' => ['Windows 8', 'Windows NT 6.2', 'Windows NT 6.3'],
        'Windows 7' => ['Windows NT 6'],
        'Windows XP' => ['Windows XP'],
        'Windows' => ['Windows NT', 'win32'],
        'Windows Phone' => ['Windows Phone'],
        'Chrome OS' => ['CrOS'],
    ];
    protected $osshort = [
        'Android' => 'AND',
        'Linux' => 'LIN',
        'Mac OS X' => 'MAC',
        'iOS' => 'MAC',
		'Windows NT 10' => 'WI10',
        'Windows 8' => 'WI8',
        'Windows 7' => 'WI7',
        'Windows' => 'WNT',
		'Windows XP' => 'WXP',
        'Windows Phone' => 'WPH',
        'Chrome OS' => 'CH',
    ];
    protected $browsers = [
		'Edge' => ['Edge', 'Edg'],
        'Opera' => ['OPR', 'Opera'],
        'Chrome' => ['Chrome'],
        'Safari' => ['Safari'],
        'Internet Explorer' => ['MSIE', 'msie','Trident', 'Internet Explorer'],
        'Firefox' => ['Firefox'],
        'Netscape' => ['Netscape']
    ];
    protected $browshorts = [
		'Chrome' => 'CH',
        'Safari' => 'SF',
        'Edge' => 'ED',
        'Internet Explorer' => 'IE',
        'Firefox' => 'FF',
        'Opera' => 'OP',
        'Netscape' => 'NS'
    ];
    protected $engines = [
        'Gecko' => ['Gecko'],
        'Blink' => ['AppleWebKit'],
        'WebKit' => ['X) AppleWebKit'],
        'EdgeHTML' => ['Edge'],
        'Trident' => ['Trident', 'MSIE'],
    ];
    protected $devices = [
        'iPad' => ['iPad'],
        'iPhone' => ['iPhone'],
        'Samsung' => ['SAMSUNG', 'SM-'],
        'Sony Xperia' => ['G8231', 'E6653'],
        'Amazon Kindle' => ['Kindle'],
        'Nintendo 3DS' => ['Nintendo 3DS'],
        'Nintendo Wii U' => ['Nintendo WiiU'],
        'Playstation Vita' => ['Playstation Vita'],
        'Playstation 4' => ['Playstation 4'],
        'Xbox One' => ['Xbox One'],
        'Xbox One S' => ['XBOX_ONE_ED'],
        'Apple TV' => ['AppleTV'],
        'Google Nexus Player' => ['Nexus Player'],
        'Amazon Fire TV' => ['AFTS'],
        'Chromecast' => ['CrKey'],
        'HTC' => ['HTC'],
    ];
    protected $bots = [
        'Ahrefs' => ['AhrefsBot'],
        'Baidu' => ['Baidu', 'baidu', 'Baiduspider', '360spider'],
        'BingBot' => ['bingbot', 'Bingbot', 'msnbot', 'BingPreview'],
        'DuckDuckGo' => ['DuckDuckBot'],
        'Googlebot' => ['Googlebot', 'feedfetcher-google'],
        'Yahoo!' => ['Slurp', 'Searchmonkey'],
        'Yandex' => ['Yandex', 'YandexBot'],
        'Telegram' => ['TelegramBot'],
        'Twitter' => ['TwitterBot'],
        'Sogou' => ['Sogou', 'sogou web spider', 'sogou inst spider'],
        'Exabot' => ['Exabot', 'Konqueror'],
        'Facebook' => ['facebot', 'facebookexternalhit', 'facebookexternal'],
        'Alexa' => ['ia_archiver', 'alexa'],
		'Misc'	=> ['Aprc', 'bot', 'crawl', 'crawler', 'Crawler', 'curl', 'archiver', 'page-preview-tool', 'preview-tool', 'Dataprovider', 'Wappalyzer', 'HeadlessChrome']
    ];

    public function __construct($agent = null)
    {
        if (!$agent && isset($_SERVER['HTTP_USER_AGENT'])) {
            $agent = $_SERVER['HTTP_USER_AGENT'];
        }

        $this->agent = $agent;

        $this->parse();
    }

    public function parse()
    {
        // Find OS
        foreach ($this->oss as $os => $patterns) {
            foreach ($patterns as $pattern) {
				if (strpos($this->agent, $pattern) !== false) {
                    $this->os = $os;
					$this->oid = $this->osshort[$os];
                    break 2;
                }
            }
        }

        // Find browser
        foreach ($this->browsers as $browser => $patterns) {
            foreach ($patterns as $pattern) {
                if (strpos($this->agent, $pattern) !== false) {
                    $this->browser = $browser;
                    $this->prefix = $pattern;
					$this->bid = $this->browshorts[$browser];
                    break 2;
                }
            }
        }

        // Engine
        foreach ($this->engines as $engine => $patterns) {
            foreach ($patterns as $pattern) {
                if (strpos($this->agent, $pattern) !== false) {
                    $this->engine = $engine;
                    break 2;
                }
            }
        }

        // Device
        foreach ($this->devices as $device => $patterns) {
            foreach ($patterns as $pattern) {
                if (strpos($this->agent, $pattern) !== false) {
					$this->device = $device;
                    break 2;
                }
            }
        }

        // Browser version
        $pattern = '#(?<browser>' . join('|', ['Version', $this->prefix, 'other']) . ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
        preg_match_all($pattern, $this->agent, $matches);

        $this->version = $matches['version'][0];

        if (count($matches['browser']) != 1) {
            $this->version = strripos($this->agent, "Version") < strripos($this->agent, $this->prefix) ? $matches['version'][0] : $matches['version'][1];
        }

		$ar = explode('.', $this->version);
		$this->version = implode('.', array_splice($ar,0,2));

        // Check if is a BOT
        foreach ($this->bots as $bot => $patterns) {
            foreach ($patterns as $pattern) {
                if (strpos($this->agent, $pattern) !== false) {
                    $this->isBot = true;
                    $this->device = 'BOT';
                    break 2;
                }
            }
        }
    }

    public function setAgent($agent)
    {
        $this->agent = $agent;
        $this->parse();
    }

    public function isBot()
    {
        return $this->isBot;
    }

    public function getInfo()
    {
        return [
            'agent' => $this->getAgent(),
            'device' => $this->getDevice(),
            'os' => $this->getOS(),
            'oid' => $this->getOid(),
            'browser' => $this->getBrowser(),
            'bid' => $this->getBid(),
            'engine' => $this->getEngine(),
            'prefix' => $this->getPrefix(),
            'version' => $this->getVersion(),
            'is_bot' => $this->isBot(),
        ];
    }

    public function getDevice()
    {
        return $this->device;
    }

    public function getEngine()
    {
        return $this->engine;
    }

    public function getAgent()
    {
        return $this->agent;
    }

    public function getOS()
    {
        return $this->os;
    }

    public function getBrowser()
    {
        return $this->browser;
    }

    public function getPrefix()
    {
        return $this->prefix;
    }

    public function getOid()
    {
        return $this->oid;
    }

   public function getBid()
    {
        return $this->bid;
    }

     public function getVersion()
    {
        return $this->version;
    }
}
