<?php
# @Author: Rainer Imb <consentio>
# @Date:   2019-11-28 12:42:32
# @Email:  imb@consentio.at
# @Project: consentio mccurdy
# @Filename: shop.php
# @Last modified by:   consentio
# @Last modified time: 2022-12-03T17:38:43+01:00
# @License: GPL 2.0

require_once('shop_basics.php');
require_once('webshop_library.php');

class shop extends shop_basics {
	private $id = 0;
	private $sid;
	public $isoc;
	public $taxes = [];
	private $isoserve = 'https://cowa.consentio.at/cms/isoserve.php';
	private $html = array();
	private $data = ['type' => 'none'];
	private $salut = array();
	private $customer = array();
	private $components = array();
	private $feedback = '';
	private $show_new = false;
	private $show_special = false;
	private $login_box = '';
	private $total = 0;
	private $subtotal = 0;
	private $freight = 0;
	private $proceed = 1;

	public function __construct(array$form){
		foreach($form as $k=>$v){
			$this->{$k}=$v;
			}
		$this->sid = isset($_SESSION['sid']) ? $_SESSION['sid'] : $this->create_sid();
		}

	/*
	 * show a product
	 */
	private function build_item() {
		$data = $this->extend_data($this->id);
		$this->data = array_merge($this->data, $data);
		$this->data['sid'] = $this->sid;
		$this->data['currency'] = $this->defs['currency'];
		$this->data = $this->get_price($this->data);

		if ($this->data['supplies']) {
			$s = explode(',', $this->data['supplies']);
			$items = $this->get_selection($s);
			$c = '';
			foreach ($items as $k) {
				$k = $this->get_price($k);
				$k['picture'] = $this->get_img($k['picture'], $k['title'], 'small', 'center');
				$k['currency'] = $this->defs['currency'];
				$c .= parse_in("cms_shop_supplies_item", $k);
				}
			$this->data['supplies'] = htmltag('h2', '', i18n('supplies'));
			$this->data['supplies'] .= htmltag('ul', 'id="shop-listing" class="yo-tiles"', $c);
			}

		if ($this->data['versions']) {
			$items = $this->get_versions($this->data['versions']);
			$me = $this->get_diff($this->data);
			$me['picture'] = $this->get_img($me['picture'], $me['title'], 'square', 'middle');
			$c = parse_in("cms_shop_versions_first", $me);
			foreach ($items as $k) {
				$k['picture'] = $this->get_img($k['picture'], $k['title'], 'square', 'middle');
				$c .= parse_in("cms_shop_versions_item", $k);
				}
			$this->data['versions'] = htmltag('p', '', htmltag('strong', '',i18n('options').':'));
			$this->data['versions'] .= htmltag('ul', 'id="shop_versions" class="neutral" data-app="collapse"', $c);
			$this->data['versions'] .= "<script type=\"text/javascript\">\$(document).ready(function () {\$(\"[data-app='collapse']\").collapse();});</script>";
			}

		$this->components['ADVICE_BOX'] = $this->get_promotion_box('rand');

		$button = parse_in('cms_shop_order_button', ['id' => $this->data['id'], 'txt' => i18n('add_to_basket')]);
		$this->data['delivery_info'] =  htmltag('span', 'class="green"', i18n('available'));
		if ($this->data['stock'] <= 0) {
			$txt = $this->data['new'] ? i18n('coming_soon') : i18n('out_of_stock');
			$this->data['delivery_info'] =  htmltag('span', 'class="red"', $txt);
			$this->data['stock'] = 0; // could be less than zero
			}
		elseif ($this->data['stock'] < $this->data['low_stock']) {$this->data['delivery_info'] =  htmltag('span', 'class="orange"', i18n('low_stock'));}
		if ($this->data['stock'] < $this->data['max_order_quant']) {$this->data['max_order_quant'] = $this->data['stock'];}
		$this->data['button'] = $this->data['stock'] ? $button : '';
		$this->data['order_pane'] =  parse_in('cms_shop_order_pane', $this->data);
		$this->data['body'] = parse_in('cms_shop_product', $this->data);
		}

	/*
	 * show a group
	 */
	private function build_group() {
		$this->components['ADVICE_BOX'] = $this->get_promotion_box($this->data['parent']);
		list($groups, $items) = $this->get_children();
		$list = $this->parse_groups($groups);
		$list .= $this->parse_products($items);
		$this->data['body'] .= $list;
		}

	private function build_new_products() {
			$items = $this->get_selection('new', 20);
			$this->data['body'] = $this->parse_products($items);
			$this->data['title'] = i18n('new_products', true);
			}

	private function build_sale() {
			$items = $this->get_selection('special', 20);
			$this->data['body'] = $this->parse_products($items);
			$this->data['title'] = i18n('sale', true);
			}

	/*
	 * no group, no item just the shop
	 */
	private function build_webshop() {
		$list = '';
		list($groups, $items) = $this->get_children();
		$list = $this->parse_groups($groups);
		$items = $this->get_selection('new', 6);
		$list .= $this->parse_products($items);
		$this->data['body'] = $list;
		}

	/*
	 * show the ordered products of a basket
	 */
	private function build_order() {
		$o = param('_o');
		$list = '';
		$this->set_amounts();
		$this->remove_item();
		if($o == 2 && isset($_SESSION['cid'])) {$o=5;}
		// switch trough different steps of order process
		switch ($o) {
			case 1: $this->order_table(); break;
			case 2: $this->order_auth(); break;
			case 3: $this->order_register(); break;
			case 4: $this->order_register(); break;
			case 5: $this->order_payment(); break;
			case 6: $this->order_delivery(); break;
			case 10: $this->order_finish(); break;
			case 11: $this->order_paypal(); break;
			default: $this->order_table();
			}
		$this->components['PROCEEDING'] = $this->proceeding();
		}

	/*
	 * get all groups and products of a group
	 * returns list two arrays one for group one for products
	 */
	private function get_children() {
		global $db;
		$groups = array();
		$items = array();
		$q = "SELECT * FROM `content` WHERE `parent` = ? and `published` >= 2 order by `sort`;";
		$arg = $db->prepare($q);
		$arg->execute(array($this->id));
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			if ($data['type'] == 'goodsgroup') {array_push($groups, $data);}
			else {
				$data2 = $this->extend_data($data['id']);
				$data = array_merge($data, $data2);
				array_push($items, $data);
				}
			}
		return array($groups, $items);
		}

	private function get_promotion_box($g) {
		$items = $this->get_selection($g);
		$promo = ['title' => i18n('advices'), 'content' => ''];
		foreach ($items as $k) {
			$k = $this->get_price($k);
			$k['img_dir'] = 'cinemascope';
			$k['template'] = 'cms_shop_promo_item';
			$promo['content'] .= $this->get_one_item($k);
			}
		$content = parse_in('cms_shop_promo', $promo);
		return $content;
		}

	private function get_selection($g, $limit = 4) {
		global $db;
		$items = array();
		$q = "SELECT `picture`, `file`, `product_no`, `title`, `price`, `special_price`, `tax`, `new` FROM `products_view` WHERE `published` = 2 ";
		if ($g == 'new') {$q .= "AND `new` = 'on' AND `pid` != ? ORDER BY `id` DESC LIMIT $limit;";}
		elseif ($g == 'special') {$q .= "AND `special_price` > 0 AND `pid` != ? ORDER BY `id` DESC LIMIT $limit;";}
		elseif ($g == 'rand') {$q .= "AND `stock` > 3 AND `pid` != ? ORDER BY rand() LIMIT $limit;";}
		elseif (is_array($g)) {
			$found = implode(',', $g);
			$q .= "AND `pid` IN($found);";
			}
		else {$q .= "AND `stock` > 3 AND `promotion` = 'on' AND `pid` != ? LIMIT $limit;";}
		$arg = $db->prepare($q);
		$arg->execute(array($this->id));
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			array_push($items, $data);
			}
		return $items;
		}

	private function get_versions($g) {
		global $db;
		$items = array();
		$q = "SELECT `content`.`picture`, `content`.`file`, `products`.`product_no`, `content`.`title`,
`products`.`colour`, `products`.`size`,`products`.`whatever`, `products`.`author`, `products`.`length`
FROM  `products` left join `content` on (`products`.`pid` = `content`.`id`)
WHERE `products`.`pid` IN ($g) AND `content`.`published` = 2 AND `products`.`stock` > 0;";
		$arg = $db->prepare($q);
		$arg->execute();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$data = $this->get_diff($data);
			array_push($items, $data);
			}
		return $items;
		}

	/**
	* find the difference of properties
	*/

	private function get_diff($data) {
		$props = ['colour' => '', 'size' => '', 'whatever' => '', 'author' => '', 'length' => ''];
		$data['diff'] = '';
			foreach ($props as $k => $v) {
				if ($data[$k] != $v) {$data['diff'] .= "{$data[$k]}, ";}
				}
		$data['diff'] = preg_replace("/, $/", '', $data['diff']);
		return $data;
		}

	private function parse_groups($data) {
		$content = '';
		foreach ($data as $g) {
			$g['src'] = $g['picture'] ? $g['picture'] : '';
			$g['picture'] = $this->get_img($g['picture'], $g['title'], 'cinemascope', '');
			$data['picture'] = parse_in('cms_shop_group_picture', $data);
			$content .= parse_in('cms_shop_group_col', $g);
			}
		$content = htmltag('ul', 'id="group-listing" class="yo-tiles"', $content);
		return $content;
		}

	private function parse_products($data) {
		$content = '';
		foreach ($data as $g) {
			$g['src'] = $g['picture'] ? $g['picture'] : '';
			$g['currency'] = $this->defs['currency'];
			if ($g['new']) {$g['new'] = htmltag('div', 'class="new_flag"', i18n('new'));}
			if ($g['special_price'] != 0) {$g['new'] = htmltag('div', 'class="new_flag"', "%");}
			$g['picture'] = $this->get_img($g['picture'], $g['title'], 'cinemascope', '');
			$g['picture'] = parse_in('cms_shop_group_picture', $g);
			$g = $this->get_price($g);
			$content .= parse_in('cms_shop_product_col', $g);
			}
		$content = htmltag('ul', 'id="shop-listing"class="yo-tiles"', $content);
		return $content;
		}

	/*
	 * extend cms-data of a product with warehouse data
	 */
	private function extend_data($id) {
		global $db;
		$q = "SELECT `pid`, `stock`, `free`, `price`, `tax`, `special_price`, `max_order_quant`, `low_stock`, `product_no`, `unit`, `colour`, `size`, `whatever`, `author`, `length`, `supplies`, `versions`, `new` FROM `products` WHERE `pid` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($id));
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		$data['destination'] = get_country_name($this->isoc);
		$data['discount'] = 0;
		return $data;
		}

	/*
	 * function for displaying the webshop
	 * according to given params
	 */

	public function shop() {
		global $db, $dba, $con, $html, $website;
		$con['coco'] = array_reverse(explode("/", __DIR__))[1]; # qui qu'a vu coco

		try {
			$dns = $dba['db_driver'].":dbname=".$dba['database'].";host=".$dba['host'].";charset=utf8";
			$db = new PDO($dns, $dba['db_user'], $dba['db_pw']);
			}
		catch (PDOException $e) {
			echo 'Connection failed: ' . $e->getMessage();
			exit;
			}

		$html = [
			"content"		=> "&nbsp;",
			"scripts"		=> '',
			"con"			=> $con,
			"myurl"		=> 'index.html',
			"bubbles"		=> "",
			"plugin"		=> "webshop",
			"feedback"		=> "",
			"popup"			=> "",
			"sid"			=> clean_var(param('sid'), "n"),
			"dir"			=> $_SERVER['DOCUMENT_ROOT']
			];

		used_langs();
		if (!isset($this->lang)) {
			$ln = param('lang') ? clean_var(param('lang'), 'wr') : $con['ln'];
			$ln = in_array($ln, array_keys($con['langs'])) ? $ln : $con['ln'];
			$this->lang = $ln;
			}

		$html['user']['language'] = $this->lang;
		$this->get_user();
		if (isset($_SESSION['cid'])) {$html['user']['cid'] = $_SESSION['cid'];}
		$website = read_settings(['group' => 'cms']);
		$this->isoc = isset($_SESSION['iso']) ? $_SESSION['iso'] : $this->get_iso();
		$this->defs = read_settings(['group' => 'webshop']);
		$this->salut = [i18n('ms'), i18n('mr'), i18n('company')];

		check_content_types();

		$page = new coco([
			'deflang'	=> $con['ln'],
			'cms_dir'	=> $_SERVER['DOCUMENT_ROOT'],
			'version'	=> $con['version'],
			'charset'	=> $con['charset'],
			'defaults'	=> $website
			]);

		if(param('_add')) {$this->set_basket();}
		if ($this->id) {$this->data = get_page_data($this->id);}
		if ($this->show_new) {$this->data['type'] = "new";}
		if ($this->show_special) {$this->data['type'] = "special";}
		if (param('_o')) {$this->data['type'] = "order";}
		if (param('_cc')) {$this->alter_destination($html);}
		elseif ($this->data['type'] == 'products') {$this->build_item();}
		elseif ($this->data['type'] == 'goodsgroup') {$this->build_group();}
		elseif ($this->data['type'] == 'order') {$this->build_order();}
		elseif ($this->data['type'] == 'new') {$this->build_new_products();}
		elseif ($this->data['type'] == 'special') {$this->build_sale();}
		else {$this->build_webshop();}

		if ($this->components) {$page->all_components = array_merge($page->all_components, $this->components);}
		if (param('_o') <= 4) {
			$arr = $this->get_basket(['cms_shop_basket', 'cms_shop_basket_item']);
			$page->all_components['BASKET'] = $this->login_box.$arr[0];
			$page->all_components['BASKET_INFO'] = $arr[1];
			}
		else {$page->all_components['BASKET'] = ' ';}
		if (param('_w')) {$this->data['body'] = safe_highlight($this->data['body'], clean_var(param('_w'), 'w'));}
		$this->data['ajax'] = "/{$con['coco']}/";

		if (param('_id') == 'basket') {$out = $page->all_components['BASKET'];} // ajax call

		else {
			// print version with zero template
			if (param('_pr') == 1) {$page->zero_template($this->data['template']);}
			// there is a own template for the webshop
			$page->alter_template($this->data['template'], ['body' => 'cms_webshop_body']);
			$page->build_page($this->data);
			$out = $page->page;
			}

		$db = null;
		return $out;
		}

	/*
	 * shows a box with products which the user has already put in the basket
	 */
	private function get_basket($template) {
		global $db, $website;
		$content = ['list' => '', 'url' => $website['website_url']];
		$mess = $this->get_mess('shop', $this->lang);
		$q = "SELECT `amount`, `content`.`picture`, `products`.`product_no`, `content`.`title`, `products`.`price`, `special_price`, `discount`, `tax`, `max_order_quant`, `products`.`weight` FROM `products`, `order_items` , `content` WHERE `order_items`.`product` = `products`.`pid` AND `products`.`pid` = `content`.`id` AND `order_items`.`sid` = ? ORDER BY `timestamp` DESC;";
		$arg = $db->prepare ($q);
		$arg->execute(array($this->sid));
		$content['rows'] = $arg->rowCount();
		$content['total'] = 0;
		$content['all'] = 0;
		$weight = 0;
		if ($content['rows']) {
			while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
				$data['img_dir'] = 'square';
				$data['img_class'] = 'left';
				$data['template'] = $template[1];
				$data = $this->get_price($data);
				$data['s_price'] = $data['price'];
				$data['price'] *= $data['amount'];
				$data['items'] = $data['amount'] > 1 ? i18n('pieces') : i18n('piece');
				$content['all'] += $data['amount'];
				$content['total'] += $data['price'];
				$weight += $data['amount']*$data['weight'];
				$data['price'] = sprintf('%0.2f', $data['price']);
				$content['list'] .= $this->get_one_item($data);
				}
			$content['items'] = $content['all'] > 1 ? i18n('pieces') : i18n('piece');
			$content['button'] = "<a href='/shop?_o=1' class='as_button'>".i18n('order_now')."</a>";
			$content['button_m'] = "<a href='/shop?_o=1' class='yo-dropdown-item'><i class='fas fa-shopping-cart fa-2x' title='".i18n('order_now')."'></i><span class='circle'>".$content['all']."</span></a>";
			}
		else {
			$content['button'] =  htmltag('p', '', i18n('mess_empty_basket'));
			$content['button_m'] = "<a href='/shop?_o=1'><i class='fas fa-shopping-cart fa-2x' title='".i18n('mess_empty_basket')."'></i></a>";
			}
		$content['currency'] = $this->defs['currency'];
		$content['total'] = sprintf('%0.2f', $content['total']);
		$content['freight'] = $this->get_freight($weight);
		$content['freight_txt'] = $content['freight'] ? htmltag('p', 'class="alright"', i18n('freight').' ('.get_country_name($this->isoc).') '.$content['freight']) : '';
		$content['invoice_total'] = sprintf('%0.2f', $content['total']+$content['freight']);
		$this->subtotal = $content['total'];
		$this->total = $content['invoice_total'];
		$this->freight = $content['freight'];
		$content = array_merge($content, $this->customer);
		$content['uc_country'] = array_key_exists('country', $content) ? strtoupper ($content['country']) : '';
		$c = parse_in($template[0], $content);
		$content['INFO_TEXT'] = $mess['basket_info'];
		$d = param('_add') ? parse_in('cms_shop_basket_info', $content) : '';
		return [$c, $d];
		}

	/*
	 * put something into the basket
	 */
	private function set_basket() {
		global $db;
		$bid =  clean_var(param('_add'), 'n');
		$amount =  clean_var(param('amount'), 'n');
		$arg = $db->prepare("select `product` from `order_items` where `product` = ? and `sid` = ?;");
		$arg->execute(array($bid, $this->sid));
		if ($arg->rowCount()) {
			$arg = $db->prepare("UPDATE `order_items` SET `amount` = `amount`+? WHERE `product` = ? AND `sid` = ?");
			$arg->execute(array($amount, $bid, $this->sid));
			}
		else {
			$arg = $db->prepare("INSERT INTO `order_items` (`sid`, `product`, `amount`) VALUES (?, ?, ?)");
			$arg->execute(array($this->sid, $bid, $amount));
			}
		}

	private function set_amounts() {
		global $db;

		foreach ($_POST as $k=>$v) {
			if (preg_match('/^amount/', $k)) {
				$amount = clean_var(param($k), 'n');
				$bid = preg_replace('/\D/', '', $k);
				$arg = $db->prepare("UPDATE `order_items` SET `amount` = ? WHERE `product` = ? AND `sid` = ?");
				$arg->execute(array($amount, $bid, $this->sid));
				}
			}

		}

	private function remove_item() {
		global $db;
		$rem = clean_var(param('_r'), 'n');
		$arg = $db->prepare("DELETE FROM `order_items` where `product` = ? and `sid` = ?");
		$arg->execute(array($rem, $this->sid));
		}


	private function create_sid() {
		$sid = param('sid') ? param('sid') : date('mdhis').gen_tan(8);
		$_SESSION['sid'] = $sid;
		return $sid;
		}

	private function get_one_item($data) {
		if($data['picture']) {
			if (!array_key_exists('img_class', $data)) {$data['img_class'] = '';}
			$data['picture'] = $this->get_img($data['picture'], $data['title'], $data['img_dir'], $data['img_class']);
			}
		$data['currency'] = $this->defs['currency'];
		$c = parse_in($data['template'], $data);
		return $c;
		}

	private function get_img($file, $alt, $dir, $class) {
		$image = '';
		if (!$file) {$file = "watermark.png";}
		if (!file_exists("../pictures/$dir/$file")) {$file = "watermark.png";}
		if (file_exists("../pictures/$dir/$file")) {
			list($x, $y) = getimagesize("../pictures/$dir/$file");
			$image = "<img src='/pictures/$dir/$file' width='$x' height='$y' alt='$alt' title='$alt' class='$class' />";
			}
		return $image;
		}

	private function order_table() {
		global $db;
		$c = '';
		// table header
		$tr = htmltag('th', 'id="ta"', i18n('product'));
		$tr .= htmltag('th', 'id="tb"', i18n('piece'));
		$tr .= htmltag('th', 'id="tc"', i18n('price_item'));
		$data['table'] = htmltag('tr', '', $tr);
		$data['sid'] = $this->sid;
		$data['lang'] = $this->lang;

		$q = "SELECT `amount`, `content`.`id`, `content`.`picture`, `products`.`product_no`, `content`.`title`, `products`.`price`, `special_price`, `discount`, `tax`, `max_order_quant`, `stock`, `weight` FROM `products`, `order_items` , `content` WHERE `order_items`.`product` = `products`.`pid` AND `products`.`pid` = `content`.`id` AND `order_items`.`sid` = ? ORDER BY `timestamp` DESC;";
		$arg = $db->prepare ($q);
		$arg->execute(array($this->sid));
		$data['total'] = 0;
		$data['weight'] = 0;
		$i = 2; // start with 2nd row
		if ($arg->rowCount()) {
			while ($d = $arg->fetch(PDO::FETCH_ASSOC)) {
				$d = $this->get_price($d);
				$d['tprice'] = $d['price']*$d['amount'];
				$data['total'] += $d['tprice'];
				$d['img_dir'] = 'square';
				$d['template'] = 'cms_shop_order_item';
				$d['currency'] = $this->defs['currency'];
				// $dicon = get_icon('basket-delete', i18n('delete').' '.$d['title']);
				$td = htmltag('a', "href=\"/shop/?_o=1&amp;_r={$d['id']}\" class=\"yo-right\"", get_icon('far-times-circle-red', i18n('delete').' '.$d['title']));
				$td .= $this->get_one_item($d);
				$td .= parse_in('cms_shop_order_price', $d);
				if ($d['stock'] < $d['max_order_quant']) {$d['max_order_quant'] = $d['stock'];}
				$corr = false;
				if ($d['amount'] > $d['stock']) {$d['amount'] = $d['stock']; $corr = true;}
				$spin = "<label for='i{$d['id']}' class='hidden'>".
				i18n('piece')." {$d['title']}</label>
				<input name='amount{$d['id']}' id='i{$d['id']}' value='{$d['amount']}' size='2' class='text loose' data-app='spin' data-max='{$d['max_order_quant']}' data-min='1' data-mess='warn'/>";
				if ($corr) {$spin .= htmltag('p', 'class="red"', i18n('max_pieces'));}
				$tr = htmltag('td', "id=\"row$i\"", $td);
				$tr .= htmltag('td', 'class="no-wrap"', $spin);
				$tr .= htmltag('td', "data-func=\"A$i*B$i\"", sprintf('%0.2f', $d['tprice']));
				$data['table'] .= htmltag('tr', '', $tr);
				$data['weight'] += $d['amount']*$d['weight'];
				$i++;
				}

			$data['freight'] = $this->get_freight($data['weight']);
			if ($data['freight']) {
				$tr = htmltag('td', "id=\"row$i\"", i18n('freight').' ('.get_country_name($this->isoc).')');
				$tr .= htmltag('td', "id=\"row$i\"", '1 '.i18n('piece'));
				$tr .= htmltag('td', "", sprintf('%0.2f', $data['freight']));
				$data['table'] .= htmltag('tr', '', $tr);
				$data['total'] += $data['freight'];
				$i++;
				}
			$tr = htmltag('td', "id=\"row$i\" colspan=\"2\"", i18n('total'));
			$tr .= htmltag('td', "data-func=\"SUM(C2:C$i)\"", sprintf('%0.2f', $d['tprice']));
			$data['table'] .= htmltag('tr', '', $tr);
			$data['step'] = 2;
			$c = parse_in('cms_shop_order_list', $data);
			}

		else {
			// empty basket, so buy something...
			$c = htmltag('p', 'class="red"', i18n('mess_empty_basket'));
			$c .= htmltag('h2', '', i18n('webshop'));
			list($groups, $items) = $this->get_children();
			$c .= $this->parse_groups($groups);
			$items = $this->get_selection('rand', 9);
			$c .= $this->parse_products($items);
			}
		$this->data['body'] = $c;
		$this->data['title'] = i18n('your_basket');
		$this->proceed = 1;
		}

	private function order_auth() {
		$data['sid'] = $this->sid;
		$data['lang'] = $this->lang;
		$data['bn'] = str_rot13('username');
		$data['pw'] = str_rot13('password');
		$data['feedback'] = param(str_rot13('username')) ? htmltag('p', 'class="red"', i18n('false_login')) : '';
		//if (in_array('paypal', explode(',', $this->defs['payment_options']))) {$data['paypal'] = parse_in('cms_shop_register_paypal', $data);}
		$data['paypal'] = ''; // Login with paypal sucks
		$this->data['body'] = parse_in('cms_shop_order_register', $data);
		$this->data['title'] = i18n('login');
		$this->proceed = 2;
		}

	private function order_register() {
		global $con, $html;
		$con['formtype'] = 'registration';
		if (param('_o') == 3) {$con['formtype'] = 'guest';}
		require_once('inquiry.php');
		$inquiry = new inquiry();
		$html['isoc'] = $this->isoc; // country of destination so far
		$html = $inquiry->plugin($html);

		// go to payment after registration
		// _f forces registration-form
		$force = isset($html['is_stored']) ? 0 : param('_f');
		if (isset($html['user']['cid']) && !$force) {
			if (!isset($_SESSION['cid'])) {$_SESSION['cid'] = $html['user']['cid'];}
			$this->get_user();
			$this->order_payment();
			$this->proceed = 3;
			}
		else {
			$this->data['body'] = $html['content'];
			$this->data['title'] = $html['formtitle'];
			$this->data['scripts'] = $html['scripts'];
			$this->proceed = 2;
			}
		}

	private function order_delivery() {
		global $html;
		$rid = $this->has_delivery_address();
		$todo = 'edit';

		$form = [
			"title"			=> i18n('delivery'),
			"table"			=> "clients_delivery",
			"myconf"		=> "delivery",
			"orderby"		=> "name",
			"human"			=> "name",
			"html"			=> $html,
			"rid"			=> $rid,
			"button_text"	=> i18n('ok'),
			"no_cancel"		=> 1, // needs a special button
			"button_fa"		=> 'check',
			"search"		=> ['name', 'prename', 'company'],
			"table_fields"	=> ['cid', 'salutation', 'title', 'name', 'prename'],
			"skipTitle"			=> true,
			"button_before" => htmltag('a', 'href="?_o=4" class="as_button"', '<i class="fas fa-times-circle fa-lg"></i>'.i18n('cancel'))
			];

		$inputs = [
		'cid'	=> [
			'type'	=> 'hidden',
			'default' => $html['user']['cid']
			],
		'use_del'	=> [
			'type'	=> 'flag',
			'default' => 'on'
			],
		'salutation'	=> [
			'type'	=> 'array',
			'extra'	=> $this->salut,
			'duty'	=> 1,
			],
		'title'	=> [
			'type'	=> 'text',
			],
		'name'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'prename'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'street'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'city'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'province'	=> [
			'type'	=> 'text',
			],
		'postal_code'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'country'	=> [
			'type'	=> 'country',
			'default'	=> 'at',
			'duty'	=> 1,
			]
		];


		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['feedback'] = $obj->feedback;
				//echo $html['feedback'];
				$todo = 'goon';
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		if ($todo == 'goon') {
			$this->order_payment();
			}
		else {
			$this->data['body'] = $html['content'];
			$this->data['title'] = $html['formtitle'];
			$this->data['scripts'] = $html['scripts'];
			}
		}

	private function alter_destination($html) {
		$intro = htmltag('h1','', i18n('alter_destination'));
		$intro .= htmltag('p','', i18n('deliver_to').':');
		$html['myurl'] = $_SERVER['HTTP_REFERER'];
		$form = [
			"title"			=> i18n('alter_destination'),
			"html"			=> $html,
			"button_text"	=> i18n('ok'),
			"no_cancel"		=> 1,
			"button_fa"		=> 'check',
			"before_form"	=> $intro
			];

		$inputs = [
			'country'	=> [
				'type'	=> 'country',
				'default'	=> $this->isoc,
				'duty'	=> 1
				],
			'_re'	=> [
				'type'	=> 'hidden',
				'value'	=> $this->id
				],
			'_cc'	=> [
				'type'	=> 'hidden',
				'value'	=> 1
				],
			];


		$obj = new access($form);

		if (param('_store')) {
			$_SESSION['iso'] = clean_var(param('country'), 'wr');
			$this->isoc = $_SESSION['iso'];
			//$this->id = clean_var(param('_re'), 'n');
			//$this->data = get_page_data($this->id);
			$this->build_item();
			}

		else {
			$obj->add_input($inputs);
			$html = $obj->form();
			$this->data['body'] = $html['content'];
			$this->data['title'] = $html['formtitle'];
			$this->data['scripts'] = $html['scripts'];
			}
		}

	private function order_payment() {
		global $html;
		$data['sid'] = $this->sid;
		$data['lang'] = $this->lang;
		$i18n_words = ['edit', 'address', 'invoice_address', 'delivery_address', 'payment'];
		foreach ($i18n_words as $w) {$data['i18n_'.$w] = i18n($w);}
		$data['full_invoice_addr'] = $this->full_address($this->customer);
		$data['full_delivery_addr'] = $this->delivery_address();
		$data['full_invoice_addr'] = htmltag('p', '', nl2br($data['full_invoice_addr']));
		$data['full_delivery_addr'] = htmltag('p', '', nl2br($data['full_delivery_addr']));
		$c = parse_in('cms_shop_addresses', $data);
		$arr = $this->get_basket(['cms_shop_basket', 'cms_shop_basket_item']);
		$this->components['BASKET'] = $this->login_box.$arr[0];
		$this->components['BASKET_INFO'] = $arr[1];

		# just payment in this case
		# coming back from order_finish
		if ($this->feedback) {
			$c = htmltag('p', 'class="red"', $this->feedback);
			}

		$c .= parse_in('cms_shop_total', ['subtotal' => $this->subtotal, 'total' => $this->total, 'freight' => $this->freight, 'country' => get_country_name($this->isoc)]);

		$mess = $this->get_mess('shop', $this->lang);
		$data['payment_options'] = '';
		$opt = explode(',', $this->defs['payment_options']);
		foreach ($opt as $k) {
			$k = ltrim($k);
			$chk = $k == param('payment') ? ' checked="checked"' : '';
			$dis = $k == 'invoice' ? ' disabled="disabled"' : '';
			$cl = $k == 'invoice' ? ' class="grey"' : '';
			if ($this->customer['level'] > 1) {$cl = ''; $dis = '';}
			$p = htmltag('input', "type=\"radio\" value=\"$k\" name=\"payment\" id=\"ipayment_$k\"$dis$chk", '').'&nbsp;';
			$p .= htmltag('label', "for=\"ipayment_$k\"$cl", i18n($k));
			if ($k == 'self_collect') {$mess["payment_$k"] = preg_replace('/&&&&address&&&&/', nl2br($this->defs['address']), $mess["payment_$k"]);}
			$p .= $mess["payment_$k"];
			$data['payment_options'] .= htmltag('li', '', $p);
			}
		$data['payment_options'] = htmltag('ul', 'class="listing"', $data['payment_options']);
		$d = htmltag('input', 'type="checkbox" name="GTC" id="iGTC"', '').'&nbsp;';
		$d .= htmltag('label', 'for="iGTC"', i18n('read_GTC'));
		$data['order_finish'] = htmltag('p', '', $d);
		$dd = htmltag('label', 'for="inote"', i18n('notes'))."<br />";
		$note = clean_var(param('note'), 'w');
		$dd .= htmltag('textarea', 'id="inote" name="note" class="text" cols="80" rows="5"', $note);
		$data['order_finish']  .= htmltag('p', '', $dd);
		$data['order_finish']  .= htmltag('p', 'class="alright"', htmltag('button', 'name="_store"', i18n('order_with_costs')));
		$data['GTC'] = $this->defs['GTC'];
		$c .= parse_in('cms_shop_payment', $data);

		$this->data['body'] = $c;
		$this->data['title'] = i18n('order');
		$this->proceed = 3;
		}

	private function order_paypal() {
		global $html, $website;
		/* $_SESSION is missing after redirect
		restore $cid from redirected param _c */
		$cid = clean_var(param('_c'), 'n');
		$this->get_user_byID($cid);
		$invoice = $this->get_invoice($cid);
		$invoice['inv_addr'] = $this->full_address($this->customer);
		$invoice['del_addr'] = $this->get_delivery_address($cid);
		if (!$invoice['del_addr']) {$invoice['del_addr'] = $invoice['inv_addr'];}
		$invoice['Subject'] = i18n('invoice');
		$invoice['defs'] = $this->defs;
		$f_id = sprintf($this->defs['pattern'], $invoice['id']);
		$f_id = preg_replace('/^YY/', date('y'), $f_id);
		$file = $invoice['Subject']."-".$f_id.".pdf";
		$invoice['Subject'] .= " ".$f_id;
		$mess = $this->get_mess('shop', $this->lang);
		$mess['order_mail'] = preg_replace('/&&&&email&&&&/', $this->customer['email'], $mess['order_mail']);
		$invoice['message'] = htmltag('p', '', $this->full_salutation($this->customer));
		$this->data['title'] = i18n('thank_you');
		$this->data['body'] = htmltag('p', '',$mess['order_mail']);
		$cvat = $this->defs['eu_vat'] == 2 ? $this->isoc : $website['country'];
		$invoice['freight_tax'] = $this->taxes[$cvat]['tax'.$this->defs['tax_vat']];
		$invoice['defs']['tax_name'] = $this->taxes[$cvat]['tax_name'];
		$pdf = new webshop_lib(['data' => $invoice, 'file' => $file, 'image' => $html['dir'].'/pictures/'.$this->defs['logo']]);
		$pdf->create_invoice_pdf();
		$pdf->create_mail();
		$pdf->send($this->customer);
		$this->proceed = 4;
		}

	private function order_finish() {
		global $html, $db;
		$pay = ltrim(clean_var(param('payment'), 'w'));
		if (!$pay) {$this->feedback = i18n('error_payment')." ";}
		if (!param('GTC')) {$this->feedback .= i18n('miss_gtc');}
		if ($this->feedback) {$this->order_payment();}
		else {
			// paypal items list
			$arr = $this->get_basket(['cms_shop_paypal', 'cms_shop_paypal_item']);
			$paypal = $arr[0];
			$del_addr = $this->get_delivery_address($_SESSION['cid']);
			// execute order
			$invoice = $this->execute_order();
			$invoice['inv_addr'] = $this->full_address($this->customer);
			$invoice['del_addr'] = $del_addr;
			if (!$invoice['del_addr']) {$invoice['del_addr'] = $invoice['inv_addr'];}
			$invoice['Subject'] = i18n('invoice');
			$mess = $this->get_mess('shop', $this->lang);
			$mess['order_mail'] = preg_replace('/&&&&email&&&&/', $this->customer['email'], $mess['order_mail']);
			$f_id = sprintf($this->defs['pattern'], $invoice['oid']);
			$f_id = preg_replace('/^YY/', date('y'), $f_id);
			$this->data['body'] = '';
			$this->data['title'] = i18n('thank_you');

			switch ($pay) {
				case "paypal":
					$paypal = preg_replace('/,$/', '', $paypal);
					$paypal = preg_replace('/&&&inv_no&&&/', $invoice['oid'], $paypal);
					$message = htmltag('p', '',$mess['order_paypal']);
					$this->data['body'] .= $message.htmltag('div', 'id="paypal-button-container"', '');
					$this->data['scripts'] .= $paypal;
					$this->data['title'] = i18n('paypal'); break;
				case "invoice":
					$message = htmltag('p', '',$mess['order_invoice']);
					$this->data['body'] .= $message; break;
				case "self_collect":
					$mess['order_self_collect'] = preg_replace('/&&&&tomorrow&&&&/', date("d-m-Y", time()+86400) , $mess['order_self_collect']);
					$mess['order_self_collect'] = preg_replace('/&&&&address&&&&/', nl2br($this->defs['address']), $mess['order_self_collect']);
					$message = htmltag('p', '',$mess['order_self_collect']);
					$this->data['body'] .= $message;
					$invoice['Subject'] = i18n('order'); break;
				case "in_advance":
					$ac = nl2br($this->defs['account'], true);
					$mess['order_in_advance'] = preg_replace('/&&&&total&&&&/', "<strong>{$invoice['total']} ".$this->defs['currency']."</strong>", $mess['order_in_advance']);
					$mess['order_in_advance'] = preg_replace('/&&&&account&&&&/', $ac, $mess['order_in_advance']);
					$message = htmltag('p', '',$mess['order_in_advance']);
					$this->data['body'] .= $message; break;
				}

			$invoice['defs'] = $this->defs;
			$file = $invoice['Subject']."-".$f_id.".pdf";
			$invoice['Subject'] .= " ".$f_id;
			$invoice['message'] = htmltag('p', '', $this->full_salutation($this->customer));
			$invoice['message'] .= $message;
			if ($pay != 'paypal') {
				$this->data['body'] = $mess['order_mail'].$this->data['body'];
				$cvat = $this->defs['eu_vat'] == 2 ? $this->isoc : $website['country'];
				$invoice['freight_tax'] = $this->taxes[$cvat]['tax'.$this->defs['tax_vat']];
				$invoice['defs']['tax_name'] = $this->taxes[$cvat]['tax_name'];
				$pdf = new webshop_lib(['data' => $invoice, 'file' => $file, 'image' => $html['dir'].'/pictures/'.$this->defs['logo']]);
				$pdf->create_invoice_pdf();
				$pdf->create_mail();
				$pdf->send($this->customer);
				}
			$this->proceed = 4;
			}
		}

	private function get_user() {
		global $db;
		if (param(str_rot13('username'))) {$this->login();}
		if (isset($_SESSION['cid'])) {
			$this->get_user_byID($_SESSION['cid']);
			$i18n_words = ['login', 'welcome'];
			foreach ($i18n_words as $w) {$data['i18n_'.$w] = i18n($w);}
			$this->login_box = parse_in('cms_shop_logged_in', $data);
			}
		else {
			$this->login_box = $this->login_box();
			}
		}

	private function get_user_byID($id) {
		global $db;
		$q = "SELECT * FROM `clients` WHERE `id` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($id));
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		// set destination country
		$this->isoc = $data['country'];
		$_SESSION['iso'] = $this->isoc;
		$this->customer = $data;
		}

	private function get_delivery_address($id) {
		global $db;
		$addr = false;
		$q = "SELECT * FROM `clients_delivery` WHERE `cid` = ?;";
		$arg = $db->prepare($q);
		$arg->execute(array($id));
		if ($arg->rowCount()) {
			$delivery = $arg->fetch(PDO::FETCH_ASSOC);
			if ($delivery['use_del']) {
				$addr = $this->full_address($delivery);
				 // set destination country
				$this->isoc = $delivery['country'];
				$_SESSION['iso'] = $this->isoc;
				}
			}
		return $addr;
		}

	private function has_delivery_address() {
		global $html, $db;
		$rid = 'new';
		$arg = $db->prepare("SELECT `id` FROM `clients_delivery` WHERE `cid` = ?;");
		$arg->execute([$html['user']['cid']]);
		if ($arg->rowCount()) {
			$d = $arg->fetch(PDO::FETCH_ASSOC);
			$rid = $d['id'];
			}
		return $rid;
		}

	private function get_invoice($id) {
		global $db;
		$q = "SELECT * FROM `webshop_order` WHERE client = ? ORDER BY `date` DESC LIMIT 1;";
		$arg = $db->prepare ($q);
		$arg->execute(array($id));
		$invoice = $arg->fetch(PDO::FETCH_ASSOC);
		$invoice['articles'] = array();
		$q = "SELECT `amount`, `copy_product_no` AS `product_no`, `copy_name` AS `title`, `copy_tax` AS `tax`, `price`, `discount` FROM `order_items` WHERE `order_id` = ?;";
		$arg = $db->prepare ($q);
		$arg->execute(array($invoice['id']));
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$data = $this->get_price($data);
			$data['total'] = $data['amount']*$data['price'];
			array_push($invoice['articles'], $data);
			}
		return $invoice;
		}

	private function login_box() {
		$data['sid'] = $this->sid;
		$data['lang'] = $this->lang;
		$data['feedback'] = param(str_rot13('username')) ? htmltag('p', 'class="red"', i18n('false_login')) : '';
		$data['open'] = $data['feedback'] ? 'yo-open' : 'yo-closed';
		$data['bn'] = str_rot13('username');
		$data['pw'] = str_rot13('password');
		$c = parse_in('cms_shop_login', $data);
		return $c;
		}

	private function full_address($data) {
		$addr = $this->salut[($data['salutation']-1)].' ';
		if ($data['title']) {$addr .= $data['title'].' ';}
		$addr .= $data['prename'].' '.$data['name']."\n";
		if ($data['company']) {$addr .= ' '.$data['company']."\n";}
		if ($data['company_line2']) {$addr .= ' '.$data['company_line2']."\n";}
		$addr .= $data['street']."\n";
		$addr .= $data['postal_code'].' '.$data['city']."\n";
		if ($data['province']) {$addr .= ' '.$data['province']."\n";}
		$addr .= get_country_name($data['country'])."\n";
		return $addr;
		}

	private function full_salutation($data) {
		$c = $data['salutation'] == 2 ? i18n('salut_m') : i18n('salut_f');
		$c .= " ".$this->salut[($data['salutation']-1)].' ';
		if ($data['title']) {$c .= $data['title'].' ';}
		$c .= $data['prename'].' '.$data['name']."\n";
		return $c;
		}

	private function delivery_address() {
		$addr = $this->get_delivery_address($_SESSION['cid']);
		if (!$addr) {$addr = i18n('use_inv_addr');}
		$addr .= '<p><a href="/shop?_o=6" class="as_button">'.i18n('edit').'</a></p>';
		return $addr;
		}

	private function get_mess($t, $l) {
		global $db, $con;
		$arg = $db->prepare("SELECT * FROM `crm_messages` where `group` = ? AND `lang` = ?;");
		$arg->execute([$t, $l]);
		$mess = array();
		while ($all = $arg->fetch(PDO::FETCH_ASSOC)) {
			if (preg_match("/<[^<]+>/",$all['value']) == 0) {
				$all['value'] = wiki_text($all['value']);
				$mess[$all['key']] = htmltag('p', '', $all['value']);
				}
			else {$mess[$all['key']] = $all['value'];}
			}
		return $mess;
		}

	private function execute_order() {
		global $db;
		$pay = clean_var(param('payment'), 'w');
		$note = clean_var(param('note'), 'w');
		$invoice = ['total' => 0, 'weight' => 0,];

		$invoice['articles'] = array();
		$q = "SELECT `order_items`.`id`, `products`.`id` AS 'pid', `amount`, `products`.`product_no`, `content`.`title`, `products`.`price`, `special_price`, `discount`, `tax`, `products`.`weight` FROM `products`, `order_items` , `content` WHERE `order_items`.`product` = `products`.`pid` AND `products`.`pid` = `content`.`id` AND `order_items`.`sid` = ? ORDER BY `timestamp` DESC;";
		$arg = $db->prepare ($q);
		$arg->execute(array($this->sid));
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$data = $this->get_price($data);
			$invoice['total'] += $data['amount']*$data['price'];
			$invoice['weight'] += $data['amount']*$data['weight'];
			array_push($invoice['articles'], $data);
			}

		$invoice['freight'] = $pay == 'self_collect' ? 0 : $this->get_freight($invoice['weight']);
		$invoice['total'] += $invoice['freight'];
		$invoice['total'] = sprintf('%0.2f', $invoice['total']);

		$q = "INSERT INTO `webshop_order` SET `client` = ?, `freight` = ?, `payment` = ?, `note` = ?, `status` = ?, `lang` = ?, `weight` = ?, `total` = ?, `country` = ?;";
		$arg = $db->prepare ($q);
		$arg->execute(array($this->customer['id'], $invoice['freight'], $pay, $note, 1, $this->lang, $invoice['weight'], $invoice['total'], $this->isoc));
		$invoice['oid'] = $db->lastInsertId();
		$invoice['date'] = date('Y-m-d');

		foreach ($invoice['articles'] as $a) {
			$q ="UPDATE `order_items` SET `sid` = '', `order_id` = ?, `status` = 1, `copy_product_no` = ?, `copy_name` = ?, `copy_tax` = ?, `price` = ? WHERE `id` = ?;";
			$arg = $db->prepare ($q);
			$arg->execute(array($invoice['oid'], $a['product_no'], $a['title'], $a['tax'], $a['price'], $a['id']));

			$q ="UPDATE `products` SET `stock` = `stock`- {$a['amount']} WHERE `id` = ?;";
			$arg = $db->prepare ($q);
			$arg->execute(array($a['pid']));
			}

		return $invoice;
		}

	private function get_freight($weight) {
		global $db;
		$q = "SELECT `id_webshop_freight`, `price`, `price2`, `price3` FROM `webshop_freight_junction_countries`, `webshop_freight` WHERE `webshop_freight`.`id` = `id_webshop_freight` AND `id_countries` = ?;";
		$arg = $db->prepare ($q);
		$arg->execute([$this->isoc]);
		$data = $arg->fetch(PDO::FETCH_ASSOC);
		$freight = $data['price'];
		if ($weight > 5000) {$freight = $data['price2'];}
		if ($weight > 15000) {$freight = $data['price3'];}
		$f = $this->get_price(['price' => $freight, 'tax' => $this->defs['tax_vat'], 'special_price' => 0, 'discount' => 0]);
		$freight = $f['price'];
		return $freight;
		}

	private function proceeding() {
		$c = '';
		for ($i=1; $i <= 4; $i++) {
			if ($this->proceed == $i) {$c .= htmltag('div', 'class="procsel col w3 m3"', $i);;}
			else {$c .= htmltag('div', 'class="proc col w3 m3"', $i);}
			}
		$c = htmltag('div', 'class="row"', $c);
		return $c;
		}

	private function login() {
		global $db;
		if (!isset($_SESSION['cid'])) {
			$pw = param(str_rot13('password'));
			$un = clean_var(param(str_rot13('username')), 'w');
			$q = "SELECT `id`, `pwd` FROM `clients` WHERE `username` = ?;";
			$arg = $db->prepare($q);
			$arg->execute(array($un));
			$data = $arg->fetch(PDO::FETCH_ASSOC);
			if (isset($data['id'])) {if (password_verify($pw, $data['pwd'])) {$_SESSION['cid'] = $data['id'];}
				}
			}
		}

	private function get_iso() {
		global $website;
		$isoc = $website['country']; // default in all cases
		if (ini_get('allow_url_fopen')) {
			$txt = @fopen($this->isoserve.'?_ip='.$_SERVER['REMOTE_ADDR'], "r");
			if ($txt) {
				$isoc = trim(stream_get_contents($txt));
				fclose($txt);
				}
			}
		// set cookie
		$_SESSION['iso'] = $isoc;
		return $isoc;
		}
	}

?>
