<?php
# @Author: consentio
# @Date:   2019-05-27T14:23:29+02:00
# @Last modified by:   consentio
# @Last modified time: 2023-07-24T17:51:26+02:00




/**
 * plugin overview information of webshop
 * @package consentio
 */

class shop_checks {
	public $defs = array();
	public $info;

	public function __construct(){
		$this->defs = read_settings(['group' => 'webshop']);
		}

	public function get_info() {
		global $html;
		if (!isset($this->defs['currency'])) {
			$text = htmltag('p', 'class="red"', i18n('mess_complete').': '.i18n('webshop').'-'.i18n('settings'));
			$this->info .= say_mess("$text<p class='alright'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id=shop_settings'>".i18n('ok')."</a></p>", '', 'warning');
			}
		$orders = $this->orders();
		if ($orders) {
			$ot = $orders == 1 ? i18n('order') : i18n('orders');
			$text = htmltag('p', 'class="red"', "$orders $ot");
			$this->info .= say_mess("$text<p class='alright'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id=order_processing&amp;status=1'>".i18n('ok')."</a></p>", '', 'truck-green');
			}
		$due = $this->due();
		if ($due) {
			$text = htmltag('p', 'class="red"', i18n('outstanding').": $due");
			$this->info .= say_mess("$text<p class='alright'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id=order_processing'>".i18n('ok')."</a></p>", '', 'warning');
			}
		$low = $this->low();
		if ($low) {
			$text = htmltag('p', 'class="red"', i18n('low_stock').":");
			$this->info .= say_mess("$text", '', 'info', false, "$low<p class='alright'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id=webshop_stock&amp;_l=1&amp;_sb=1&amp;_ob=stock&amp;_o=0&amp;_hl=50'>".i18n('ok')."</a></p>");
			}
		return $this->info;
		}

	private function due() {
		global $db;
		$twoWeeks = date('Y-m-d', strtotime('-14 days'));
		$q = "SELECT `id` FROM `webshop_order` WHERE  (`payed` IS NULL OR `payed` <> 'on') AND  `status` = 3 AND `date` <= '$twoWeeks';";
		$arg = $db->prepare($q);
		$arg->execute();
		return $arg->rowCount();
		}

	private function orders() {
		global $db;
		$q = "SELECT `id` FROM `webshop_order` WHERE `status` = 1;";
		$arg = $db->prepare($q);
		$arg->execute();
		return $arg->rowCount();
		}

	private function low() {
		global $db;
		$c = false;
		$q = "SELECT `product_no`, `title`, `stock` FROM `products_view` WHERE `stock` < `low_stock` AND `published` > 1 ORDER BY `stock`;";
		$arg = $db->prepare($q);
		$arg->execute();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)){
			$c .= htmltag('li', '', "<b>{$data['product_no']}</b> {$data['title']}: <b>{$data['stock']}</b>");
			}
		if ($c) {$c = htmltag('ul', '', $c);}
		return $c;
		}
	}
?>
