<?php
# @Author: Rainer Imb <imb>
# @Date:   2018-04-11 11:50:22
# @Project: consentio mccurdy
# @Last modified by:   consentio
# @Last modified time: 2023-09-11T12:07:16+02:00
# @License: GPL 2.0



/**
 * plugin webshop
 * @package consentio
 */

require_once('shop_basics.php');

class webshop extends shop_basics {
	private $total = 0;
	private $items = 0;
	public $defs = array();
	public $taxes = array();
	public $isoc;

	public function __construct(){
		global $website;
		$this->defs = read_settings(['group' => 'webshop']);
		$this->isoc = $website['country'];
		}

	public function plugin($html) {
		switch ($html['action']) {
			case ("webshop"): $html = $this->settings($html); break;
			case ("shop_settings"): $html = $this->shop_settings($html); break;
			case ("shop_taxes"): $html = $this->tax_settings($html); break;
			case ("shop_messages"): $html = $this->shop_messages($html); break;
			case ("webshop_freight"): $html = $this->webshop_freight($html); break;
			case ("webshop_stock"): $html = $this->webshop_stock($html); break;
			case ("promotion"): $html = $this->webshop_promotion($html); break;
			case ("manufacturer"): $html = $this->manufacturer_admin($html); break;
			case ("order_delivery"): $html = $this->order_delivery($html); break;
			case ("get_invoice"): $html = $this->get_file($html); break;
			case ("goodsgroup"): $html = $this->webshop_groups($html); break;
			case ("products"): $html = $this->webshop_admin($html); break;
			case ("shop_media"): $html = $this->shop_media_admin($html); break;
			case ("shop_sales"): $html = $this->shop_sales_admin($html); break;
			case ("pos"): $html = $this->pos($html); break;
			default: $html = $this->webshop_groups($html);
			}
		return $html;
		}

	private function webshop_admin($html) {
		global $website;
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$parent = clean_var(param('parent'), "n");
		$this->get_taxes($website['country']);
		$tax_arr = array_splice($this->taxes[$website['country']], 0, 3); // 3 tax classes no taxname
		list($mylang, $myparent, $ptype) = parents_def($parent);
		$form = form_by_type(1);
		$form['rid'] = $rid;
		$form['myconf'] = "products";
		$form['left'] = [['table' => 'products', 'foreign' => 'pid']];
		$form['title'] .= " &ndash; ".i18n("webshop");
		$form["button_after"] = htmltag('button', "name=\"_clone\" value=\"1\" class=\"button red yo-right\" type=\"submit\"", get_icon('clone', '').' '.i18n('duplicate'));
		$orig_inputs = inputs_by_type('plugin');
		$orig_inputs['title']['caption'] = i18n('name');
		$orig_inputs['label1']['end'] = 'stock';

		$inputs = [
		'title' 	=> $orig_inputs['title'],
		'lang'		=> $orig_inputs['lang'],
		'show_title' =>	['type' => 'hidden', 'value' => ''],
		'type'		=>	['type' => 'hidden', 'default' => 'products'],
		'generate'	=>	['type' => 'hidden', 'default' => 0],
		'description'	=>	['type' => 'hidden'],
		'product_no'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			'table'	=> 1
			],
		'product_no_ext'	=> [
			'type'	=> 'text',
			'table'	=> 1
			],
		'unit'	=> [
			'type'	=> 'text',
			'table'	=> 1
			],
		'picture'	=> [
			'type'	=> 'image',
			],
		"label2"		=> $orig_inputs['label1'],
		"published"		=> [
			'type'		=> 'radio',
			'abbr'		=> get_icon('world', i18n('published')),
			'extra'		=> [i18n('offline'), i18n('published')],
			'icons'		=> ['offline', 'published'],
			'default'	=> 1
			],
		'parent' 		=> [
			'caption'	=> i18n('goodsgroup'),
			'type' 		=> 'lookup',
			"lid"		=> "id",
			"lval"		=> "graduated",
			"lord"		=> "parentsort",
			"ltable"	=> "folder_view",
			"lclause"	=> "`type` = 'goodsgroup'",
			'default' => $parent,
			'duty' => 1
			],
		'sort'		=>  $orig_inputs['sort'],
		'promotion'	=> [
			'type'	=> 'flag',
			'table'	=> 1
			],
		'new'	=> [
			'type'	=> 'flag',
			'table'	=> 1
			],
		'stock'	=> [
			'type'	=> 'spin',
			'min'		=> 0,
			'max'	=> 1000000,
			'table'	=> 1
			],
		'price'	=> [
			'type'	=> 'number',
			'default'	=> 0.00,
			'table'	=> 1
			],
		'special_price'	=> [
			'type'	=> 'number',
			'table'	=> 1
			],
		'tax'	=> [
			'type'	=> 'array',
			'extra'	=> $tax_arr,
			'duty'	=> 1,
			'table'	=> 1,
			'in_body'	=> '%'
			],
		'weight'	=> [
			'type'	=> 'number',
			'table'	=> 1
			],
		'provider'	=> [
			'type'	=> 'lookup',
			'ltable'	=> 'shop_manufacturer',
			'lid'	=> 'id',
			'lval'	=> 'name',
			'lord'	=> 'name',
			'table'	=> 1
			],
		'specification'	=> [
			'caption'	=> i18n('description'),
			'type'	=> 'wysiwyg',
			'duty'	=> 1,
			'table'	=> 1
			],
		'properties'	=> [
			"icon"		=> "hand-o-right",
			"collapsed"	=> 1,
			'type'	=> 'fieldset'
			],
		'colour'	=> [
			'type'	=> 'text',
			'table'	=> 1
			],
		'size'	=> [
			'type'	=> 'text',
			'table'	=> 1
			],
		'author'	=> [
			'type'	=> 'text',
			'table'	=> 1
			],
		'length'	=> [
			'type'	=> 'text',
			'table'	=> 1
			],
		'whatever'	=> [
			'type'	=> 'text',
			'table'	=> 1
			],
		'versions'	=> [
			'type'	=> 'add_tags',
			"lid" => "id",
			"lval" => "title",
			"lord" => "title",
			"ltable" => "content",
			"lclause" => "`type` = 'products'",
			'match' => true,
			'table'	=> 1
			],
		'misc'	=> [
			"icon"		=> "star",
			"collapsed"	=> 1,
			'type'	=> 'fieldset',
			'end'	=> 'supplies'
			],
		'delivery'	=> [
			'type'	=> 'hidden',
			'default'	=> 1,
			'table'	=> 1
			],
		'max_order_quant'	=> [
			'type'	=> 'spin',
			'min'	=> 0,
			'default'	=> 99,
			'table'	=> 1
			],
		'low_stock'	=> [
			'abbr'	=> 'max.',
			'type'	=> 'spin',
			'min'	=> 0,
			'default'	=> 10,
			'table'	=> 1
			],
		'supplies'	=> [
			'type'	=> 'add_tags',
			"lid" => "id",
			"lval" => "title",
			"lord" => "title",
			"ltable" => "content",
			"lclause" => "`type` = 'products'",
			'match' => true,
			'table'	=> 1
			],
		'info' 	=> $orig_inputs['info'],
		'file' =>	['type' => 'readonly',],
		'written' => $orig_inputs['written'],
		'update'	=> $orig_inputs['update'],
		'cron'		=> [
			"icon"		=> "clock",
			"collapsed"	=> 1,
			"type"		=> "fieldset",
			"in_body"	=> "<p>".i18n('published').":</p>"
			],
		'c_start' => $orig_inputs['c_start'],
		'c_end' =>	 $orig_inputs['c_end']
		];

		$obj = new access($form);
		// $obj->set_attribute($inputs);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], '', '');
		}

	if (param('_clone')) {
		$inputs = $obj->get_value($inputs);
		$rid = 0;
		$inputs['title']['duty'] = 2;
		$inputs['product_no']['duty'] = 2;
		$inputs['price']['duty'] = 2;
		$inputs['file']['value'] = '';
		$obj->button_after = '';
		$obj->before_form = i18n('copy');
		$todo = 'edit';
		}

	if (param('_store')) {
		$inputs = $obj->get_params($inputs);
		if ($obj->error) {$todo = "edit"; $obj->error = 0;}
		else {
			if ($obj->rid == "new") {
				$inputs['file']['value'] = "/shop/".clean_filename($inputs['title']['value'].".html", $html['dir']."/shop");
				}
			$inputs['update']['value'] = date('Y-m-d H:i:s');
			$inputs['description']['value'] = cut_text(strip_tags($inputs['specification']['value']), 200);
			if (param('force_new_title')) {
				unlink("{$html['dir']}{$inputs['file']['value']}");
				$inputs['file']['value'] = "/shop/".clean_filename($inputs['title']['value'].".html", $html['dir']."/shop");
				}
			$id = $obj->store($inputs);

			// sync versions
			if (param('real_versions')) {
				$a = param('real_versions');
				array_unshift($a, $id);
				$this->sync_versions($a);
				}
			$html['popup'] = $obj->feedback;
			$data = $obj->stored;
			$data['lang'] = $inputs['lang']['value'];
			$this->generate_product($data, $id);
			generate();
			}
		}

	if ($todo == "edit") {
		if (!$rid) {$obj->rid = "new";}
		elseif ($rid != "new") {
			$inputs = $obj->get_value($inputs);
			// could be set to 3 but it has no effect
			if ($inputs['published']['value'] > 2){$inputs['published']['value'] = 2;}
			$inputs['picture']['in_body'] = "<a href='{$html['myurl']}?sid={$html['sid']}&amp;_id=shop_media&amp;foreign=$rid' target='_blank' id='subform3' class='popupform'>".i18n('more')."...</a>
			<script type=\"text/javascript\">
			\$(document).ready(function () {\$('#subform3').popLink({header: '".i18n('pictures')."', 'width': '800', 'height': '400', 'top': '30px', 'left': '30px'});});
			</script>";
			$inputs['file']['in_body'] = '<br /><input id="ifcnt" type="checkbox" name="force_new_title" /> <label for="ifcnt">'.i18n('update_now').'</label>';
			}
		if ($obj->error) {$html['content'] = $obj->feedback;}
		else {
			$inputs['parent']['lclause'] .= " AND `lang` = '$mylang'";
			$inputs['lang']['default'] = $mylang;
			$obj->add_input($inputs);
			$html = $obj->form();
			}
		}
	// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
	elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
	else {
		if (param('_del')) {$obj->delete();}
		$obj->myconf = 'pages'; // return to pages...
		$obj->title = i18n("pages");
		$inputs = inputs_by_type('view');
		$submen = pages_tabs($parent);
		$obj->before_table = make_submenu($submen);
		$html = $obj->table($inputs);
		}
	$html['left'] = content_tree($parent, "pages");
	return $html;
	}


	private function webshop_groups($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$parent = clean_var(param('parent'), "n");
		list($mylang, $myparent, $ptype) = parents_def($parent);
		$form = form_by_type(1);
		$form['rid'] = $rid;
		$form['myconf'] = "goodsgroup";
		$form['title'] .= " &ndash; ".i18n("webshop");
		//$form['left'] = [['table' => 'goodsgroups', 'foreign' => 'pid']];
		$inputs = inputs_by_type('plugin');
		$inputs = [
			'title' 		=>	$inputs['title'],
			'short' 		=>	$inputs['short'],
			'folder' 		=> ['type' => 'hidden', 'value' => 1],
			'picture'		=> [
				'caption'	=> i18n('picture'),
				'type' 		=> 'image'],
			'type' 			=>	['type' => 'hidden', 'default' => 'goodsgroup'],
			'generate' =>	['type'		=> 'hidden', 'value' => 0],
			"label1"		=> $inputs['label1'],
			'published'		=> $inputs['published'],
			'lang'			=>	$inputs['lang'],
			'parent' 		=> [
				'caption'	=> i18n('folder'),
				'type' 		=> 'lookup',
				"lid"		=> "id",
				"lval"		=> "graduated",
				"lord"		=> "parentsort",
				"ltable"	=> "folder_view",
				"lclause"	=> "`type` IN('root', 'goodsgroup')",
				'default' => $parent,
				'duty' => 1
				],
			'sort' 			=> $inputs['sort'],
			'file' =>	[
				'type' => 'readonly',
				],
			'update'		=> $inputs['update'],
			'last_editor' 		=> $inputs['last_editor']
			];

		//foreach ($inputs2 as $k=>$v) {$inputs2[$k]['table'] = 1;}
		//$inputs = array_merge($inputs, $inputs2);


		$obj = new access($form);
		// $obj->set_attribute($inputs);

	if (param('_sortlist')) {
		$obj->sort_list();
		reorder($form['table'], '', '');
		}

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				if ($obj->rid == "new") {
					$inputs['file']['value'] = "/shop/".clean_filename($inputs['title']['value'].".html", $html['dir']."/shop");
					}
				$inputs['update']['value'] = date('Y-m-d H:i:s');
				$inputs['last_editor']['value'] = $html['user']['id'];
				$id = $obj->store($inputs);
				reconf_parent("content", "short", "parent");
				$html['popup'] = $obj->feedback;
				$data = $obj->stored;
				$data['lang'] = $inputs['lang']['value'];
				$this->generate_group($data, $id);
				generate();
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$inputs['parent']['lclause'] .= " AND `lang` = '$mylang'";
				if (intval($rid)) {
					$notin = check_dependencies("folder_view", $rid, "parent");
					if ($notin) {$inputs['parent']['lclause'] .= " AND $notin";}
					}
				$inputs['lang']['default'] = $mylang;
				$obj->add_input($inputs);
				$html = $obj->form();
				$html['scripts'] .= "<script type='text/javascript'>\$(document).ready(function () {\$(\"#ishort\").title2short();});</script>\n";
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			if (param('_del')) {$obj->delete();}
			$obj->myconf = 'pages'; // return to pages...
			$obj->title = i18n("pages");
			$inputs = inputs_by_type('view');
			$submen = pages_tabs($parent);
			$obj->before_table = make_submenu($submen);
			$html = $obj->table($inputs);
			}
		$html['left'] = content_tree($parent, "pages");
		return $html;
		}

	private function shop_media_admin($html) {
		$rid = param('rid');
		$fid = clean_var(param('foreign'), 'n');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"table"			=> "media",
			"myconf"		=> "shop_media",
			"orderby"		=> "sort",
			"human"			=> "title",
			"filters"		=> ["foreign"],
			"html"			=> $html,
			"rid"			=> $rid,
			"searchform" 	=> 0,
			"table_fields"	=> ['media', 'sort', 'title', ]
			];

		$inputs = [
		'foreign'	=> [
			'type'	=> 'hidden',
			'default' => $fid
			],
		'group'	=> [
			'type'	=> 'hidden',
			'default' => 'ws'
			],
		'title'	=> [
			'type'	=> 'text'
			],
		'media'	=> [
			'type'	=> 'image',
			'caption'	=> i18n('picture'),
			'duty'	=> 1,
			],
		'sort'	=> [
			'type'		=> 'sort',
			'default'	=> 10,
			'do'	=> 1
			]
		];


		$obj = new access($form);

		if (param('_sortlist')) {
			$obj->sort_list();
			reorder($form['table'], '', '');
			}

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit&amp;foreign=$fid", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		$html['left'] = get_tab_tree($html, "webshop", $form['myconf'], "");
		return $html;
		}

	private function settings ($html) {
		$html['content'] = get_board($html, "webshop");
		$html['formtitle'] = i18n('webshop');
		$bubble = bubble('common.webshop');
		if ($bubble) {$html['formtitle'] .= $bubble;}
		require_once('plugins/shop_checks.php');
		$check = new shop_checks();
		$html['left'] .= $check->get_info();
		return $html;
		}

	private function shop_settings($html) {
		global $con, $website;
		$this->get_taxes($website['country']);
		$tax_arr = array_splice($this->taxes[$website['country']], 0, 3); // 3 tax classes no taxname
		$pay_arr = ['paypal','invoice','in_advance','self_collect'];

		$form = [
			"title"			=> i18n('webshop')." &ndash; ".i18n('settings'),
			"table"			=> "cms_settings",
			"myconf"		=> "shop_settings",
			"human"			=> "key",
			"no_cancel" 	=> "1",
			"table_fields"	=> ["key", "value", "lang"],
			"html"			=> $html,
			];

		$inputs = [
			"group"			=> ['type' => "free", 'default' => "webshop"],
			"rule"			=> ['type' => "free", 'default' => $con['rule']],
			"lang"			=> ['type' => "free", 'default' => '*'],
			"currency"		=> [
				'type'		=> "text",
				'duty'		=> 1,
				'default'	=> 'Euro'
				],
			"input_price"		=> [
				'caption'	=> i18n('price_input'),
				'type'		=> "radio",
				'duty'		=> 1,
				'default'	=> 1,
				'extra'		=> ["incl", "excl"],
				'view'		=> [i18n('incl_vat'), i18n('excl_vat')]
				],
			"eu_vat"		=> [
				'type'		=> "radio",
				'duty'		=> 1,
				'default'	=> 1,
				'extra'		=> ["inland", "country_of_destination"],
				'view'		=> [i18n('inland'), i18n('country_of_destination') ]
				],
			"tax_vat"		=> [
				'caption'	=> i18n('tax').' '.i18n('delivery_charges'),
				'type'	=> 'array',
				'extra'	=> $tax_arr,
				'duty'	=> 1,
				'default'	=> 1,
				'in_body'	=> '%'
				],
			"payment_options"	=> [
				'caption'	=> i18n('payment'),
				'type'		=> "multicheck",
				'raw'		=> 1,
				'extra'	=> $pay_arr,
				'view'	=> array_map("i18n", $pay_arr),
				'default'	=> "invoice,in_advance,self_collect"
				],
			'GTC'	=> [
				'type'	=> 'lookup',
				'ltable'	=> 'content',
				'lid'	=> 'id',
				'lval'	=> 'title',
				'lord'	=> 'title',
				'lclause'	=> "type = 'pages'",
				'duty'	=> 1
				],
			"promobox_limit" => [
				'caption'	=> i18n('promotion').' max.',
				'type'		=> "spin",
				'max'		=> 12,
				'min'		=> 3,
				'default'	=> 3,
				'interval'	=> 3,
				'size'		=> 5
				],
			"invoice"		=> [
				'type'		=> "fieldset"
				],
			"pattern"		=> [
				'type'	=> 'array',
				'extra'	=> ['%08d','%06d','%04d','YY%08d','YY%06d', 'YY%04d'],
				'view'	=> ['00000123', '000123','0123','YY00000123','YY000123','YY0123',],
				'raw'	=> 1,
				'duty' => 1
			],
			"logo"		=> [
				'caption'	=> i18n('print_logo'),
				'type'		=> "image",
				'duty' => 1
				],
			"company"	=> [
				'type'		=> "text",
				'duty'		=> 1
				],
			"address"	=> [
				'type'		=> "bigtext",
				'cols'		=> 50,
				'rows'		=> 10,
				'duty'		=> 1
				],
			"account"	=> [
				'caption'	=> i18n('account_data'),
				'type'		=> "bigtext",
				'cols'		=> 50,
				'rows'		=> 10,
				'duty'		=> 1,
				'duty'		=> 1
				],
			"phone_no"	=> [
				'caption'	=> i18n('phone'),
				'type'		=> "text",
				'duty'		=> 1
				],
			"reg_no"	=> [
				'type'		=> "text",
				'duty'		=> 1
				],
			"vat_no"	=> [
				'type'		=> "text",
				'duty'		=> 1
				],
			"pdf_dir"	=> [
				'caption'	=> 'PDF Directory',
				'type'		=> "text",
				'in_label'	 => ' <i class="fas fa-exclamation-triangle fa-lg gold"></i>',
				'duty'		=> 1
				]
			];

		$obj = new access($form);
		$submen = array(
			);
		$obj->before_form = make_submenu($submen);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {
				$obj->error = 0;
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			else {
				$obj->store_settings($inputs);
				$this->gen_all_products();
				generate();
				$feedback = "<p>".$obj->feedback."</p><p><a href='{$html['myurl']}?_id=webshop&amp;sid={$html['sid']}' class='as_button'>".i18n('ok')."</a></p>";
				$html['content'] = say_mess($feedback, i18n('info'), 'info');
				}
			}
		else {
			$inputs = $obj->get_settings_value($inputs);

			if (!isset($inputs['currency']['value'])){$this->init_shop();}

			$obj->add_input($inputs);
			$submen = array(
				[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}", "active", "wrench"],
				[i18n('taxes'), $html['myurl']."?sid={$html['sid']}&amp;_id=shop_taxes", "inactive", "percent"],
				[i18n('messages'), $html['myurl']."?sid={$html['sid']}&amp;_id=shop_messages", "inactive", "comments"]
				);
			$obj->before_form = make_submenu($submen);
			$html = $obj->form();
			}
		$html['left'] = get_tab_tree($html, "webshop", $form['myconf'], "");
		return ($html);
		}

	private function shop_messages($html) {
		global $con;
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('messages'),
			"table"			=> "crm_messages",
			"myconf"		=> "shop_messages",
			"orderby"		=> "key",
			"human"			=> "key",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['key', 'value'],
			"table_fields"	=> ['key', 'value', 'group', 'lang'],
			"clause"		=> "`group` = 'shop'"
			];

		$inputs = [
			'key'	=> [
				'type'	=> 'text',
				'duty'	=> 1,
				],
			'value'	=> [
				'type'	=> 'bigtext',
				'caption'	=> i18n('text'),
				'duty'	=> 1,
				],
			'group'	=> [
				'type'	=> 'readonly',
				'default' => 'shop'
				],
			'lang'	=> [
				'caption'	=> i18n('language'),
				'type'	=> 'array',
				'raw'	=> 1,
				'extra'		=> array_merge(['*'], array_keys($con['langs'])),
				'default' => $con['ln']
				],
			'rule'	=> [
				'type'	=> 'hidden',
				'default'	=> 1,
				],
			];


		$obj = new access($form);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"],
				[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=shop_settings", "inactive", "wrench"],
				[i18n('taxes'), $html['myurl']."?sid={$html['sid']}&amp;_id=shop_taxes", "inactive", "percent"],
				[i18n('messages'), $html['myurl']."?sid={$html['sid']}&amp;_id=shop_messages", "active", "comments"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		$html['left'] = get_tab_tree($html, "webshop", $form['myconf'], "");
		return $html;
		}

	private function webshop_freight($html) {
		global $con;
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('delivery_charges'),
			"table"			=> "webshop_freight",
			"myconf"		=> "webshop_freight",
			"orderby"		=> "id",
			"human"			=> "name",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> [],
			'searchform'	=> 0,
			"table_fields"	=> ['name', 'area', 'price', 'price2', 'price3']
			];

		$inputs = [
		'name'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'area'	=> [
			'caption'	=> i18n('country'),
			'size'		=> 30,
			'type' => 'multilookup',
			"lid" => "iso3166",
			"lval" => $con['ln'],
			"lord" => $con['ln'],
			"ltable" => "countries"
			],
		'price'	=> [
			'type'	=> 'number',
			'caption'	=> 'S',
			'default'	=> 0.00,
			'duty'	=> 1,
			'smart' => true
			],
		'price2'	=> [
			'type'	=> 'number',
			'caption'	=> 'M',
			'default'	=> 0.00,
			'duty'	=> 1,
			'smart' => true
			],
		'price3'	=> [
			'type'	=> 'number',
			'caption'	=> 'L',
			'default'	=> 0.00,
			'duty'	=> 1,
			'smart' => true
			],
		];

		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			if (param('_del')) {$obj->delete();}
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"]
				);
			$obj->before_table .= make_submenu($submen);
			$unbound = $this->get_unbound();
			if (count($unbound)) {
				$ubText = implode(', ', array_values($unbound));
				$obj->before_table .= i18n('not_found').": $ubText<br />";
				}
			$multi = $this->get_multi();
			if (count($multi)) {
				$muText = implode(', ', array_values($multi));
				$obj->before_table .= i18n('multiple').": $muText";
				}
			$html = $obj->table($inputs);
			}
		$html['left'] = get_tab_tree($html, "webshop", $form['myconf'], "");
		return $html;
		}

	private function webshop_stock($html) {
		global $website;
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");
		$parent = param('parent');
		$this->get_taxes($website['country']);
		$tax_arr = array_values(array_splice($this->taxes[$website['country']], 0, 3)); // 3 tax classes no taxname

		$form = [
			"title"			=> i18n('stock'),
			"table"			=> "products",
			"myconf"		=> "webshop_stock",
			"orderby"		=> "product_no",
			"human"			=> "product_no",
			"filters"		=> ['parent'],
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['product_no'],
			"allow_del"		=> false,
			"allow_box"		=> '',
			"table_fields"	=> ['picture', 'product_no', 'product_no_ext', 'title', 'stock', 'price', 'special_price', 'tax', 'max_order_quant', 'weight'],
			"xml_fields"	=> ['product_no', 'title', 'unit', 'stock', 'price', 'special_price', 'picture', 'tax', 'weight']
			];

		$inputs = [
			'pid'	=> ['type'	=> 'hidden'],
			'product_no'	=> [
				'abbr'	=> cut_text(i18n('product_no'), 2, '.'),
				'type'	=> 'readonly'
				],
			'product_no_ext'	=> [
				'abbr'	=> cut_text(i18n('product_no_ext'), 2, '.'),
				'type'	=> 'text'
				],
			'stock'	=> [
				'type'	=> 'spin',
				'max'	=> 1000000,
				'smart' => true,
				'smart_table' => 'products',
				'min'	=> 0
				],
			'price'	=> [
				'type'	=> 'number',
				'default'	=> 0.00
				],
			'tax'	=> [
				'type'	=> 'array',
				'extra'	=> $tax_arr,
				'duty'	=> 1
				],
			'weight'	=> [
				'type'	=> 'number'
				],
			'special_price'	=> [
				'type'	=> 'number'
				],
			'max_order_quant'	=> [
				'abbr'	=> 'max.',
				'type'	=> 'spin',
				'min'	=> 0,
				'default'	=> 99
				],
			'low_stock'	=> [
				'abbr'	=> 'max.',
				'type'	=> 'spin',
				'min'	=> 0,
				'default'	=> 10
				]
			];


		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				$html['content'] .= $this->get_history($inputs['pid']['value']);
				}
			}
		else {
			$obj->table = "products_view";
			$inputs['title'] = ['type'	=> 'readonly'];
			$inputs['parent'] = [
				'caption'	=> i18n('goodsgroup'),
				'type'		=> 'text',
				'type'		=> 'lookup',
				"lid"		=> "id",
				"lval"		=> "graduated",
				"lord"		=> "parentsort",
				"ltable"	=> "folder_view",
				"lclause"	=> "`type` IN ('webshop', 'goodsgroup')",
				];
			$inputs['picture']	= ['type'	=> 'image'];

			$obj->before_table = htmltag('p', '', i18n('val_of_goods').': '.$this->get_wvalue());
			if (@include_once("other/SimpleExcel/xlsxWriter.php")) {
				$obj->in_searchform = htmltag('p', '', '<input id="ixls" name="xls" type="checkbox" />&nbsp;<label for="ixls">'.i18n('export_xls').'</label>');
				}
			$html = $obj->table($inputs);
			// export xml if asked for
			if (param('xls')) {
				$html['content'] = export_xlsx($obj->export_q, $obj->taint, i18n('stock'));
				$html['gui'] = 6;
				}
			}
		$html['left'] = $this->shop_tree($parent, "webshop_stock");
		return $html;
		}

	private function webshop_promotion($html) {
		$rid = param('rid');
		$parent = param('parent');

		$form = [
			"title"			=> i18n('promotion'),
			"table"			=> "products",
			"myconf"		=> "promotion",
			"orderby"		=> "product_no",
			"human"			=> "product_no",
			"html"			=> $html,
			'rid'			=> $rid,
			"search"		=> ['title', 'product_no'],
			"filters"		=> ['parent', 'promotion', 'new'],
			"allow_box"		=> "both",
			"attr_to_set"	=> ['promotion', 'new'],
			"allow_del"		=> false,
			"allow_edit"	=> false,
			"table_fields"	=> ['picture', 'product_no', 'title', 'promotion', 'new']
			];

		$inputs = [
		'title'	=> ['type'	=> 'text'],
		'product_no'	=> ['type'	=> 'text'],
		'parent'	=> [
			'caption'	=> i18n('goodsgroup'),
			'type'	=> 'text',
			'type' => 'lookup',
			"lid"		=> "id",
			"lval"		=> "graduated",
			"lord"		=> "parentsort",
			"ltable"	=> "folder_view",
			"lclause"	=> "`type` IN ('webshop', 'goodsgroup')",
			],
		'picture'	=> ['type'	=> 'image'],
		'product_no'	=> [
			'abbr'	=> cut_text(i18n('product_no'), 2, '.'),
			'type'	=> 'readonly'
			],
		'promotion'	=> [
			'type'	=> 'flag',
			'ftable'	=> 'products',
			'table'	=> 1
			],
		'new'	=> [
			'type'	=> 'flag',
			'ftable'	=> 'products',
			]
		];


		$obj = new access($form);

		$obj->set_attribute($inputs);

		if (param('todo') == "gen") {
			$this->generate_promo_box();
			generate();
			$html['popup'] = i18n('ok');
			$obj->html_in($html);
			}

		if (param('_set_att')) {$html = $obj->attr_form($inputs);}
		else {
			$obj->table = "products_view";
			$html = $obj->table($inputs);
			}

		$html['left'] = $this->shop_tree($parent, $form['myconf']);
		$html['left'] .= "<h3>".i18n('action')."</h3><p class='center'><a class='as_button' href='{$html['myurl']}?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=gen'>".i18n('regenerate')."</a>";
		return $html;
		}


	private function tax_settings($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('eu_vat'),
			"table"			=> "eu_vat",
			"myconf"		=> "shop_taxes",
			"orderby"		=> "﻿iso",
			"defsort"		=> "ASC",
			"human"			=> "﻿iso",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['﻿iso', 'tax_name'],
			"table_fields"	=> ['﻿iso', 'tax1', 'tax2', 'tax3', 'tax_name']
			];

		$inputs = [
		'﻿iso'	=> [
			'caption'	=> i18n('country').' ISO',
			'type'	=> 'text',
			],
		'tax1'	=> [
			'caption'	=> i18n('tax').' 1',
			'type'	=> 'number',
			'smart'	=> 1
			],
		'tax2'	=> [
			'caption'	=> i18n('tax').' 2',
			'type'	=> 'number',
			'smart'	=> 1
			],
		'tax3'	=> [
			'caption'	=> i18n('tax').' 3',
			'type'	=> 'number',
			'smart'	=> 1
			],
		'tax_name'	=> [
			'caption'	=> i18n('name'),
			'type'	=> 'text',
			]
		];


		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('settings'), $html['myurl']."?sid={$html['sid']}&amp;_id=shop_settings", "inactive", "wrench"],
				[i18n('taxes'), $html['myurl']."?sid={$html['sid']}&amp;_id=shop_taxes", "active", "percent"],
				[i18n('messages'), $html['myurl']."?sid={$html['sid']}&amp;_id=shop_messages", "inactive", "comments"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		$html['left'] = get_tab_tree($html, "webshop", $form['myconf'], "");;
		return $html;
		}

	private function shop_sales_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('shop_sales'),
			"table"			=> "shop_sales",
			"myconf"		=> "shop_sales",
			"orderby"		=> "id",
			"defsort"		=> "DESC",
			"human"			=> "name",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> [],
			'searchform'	=> 0,
			"table_fields"	=> ['name', 'articles', 'percent', 'start', 'end']
			];

		$inputs = [
		'name'	=> [
			'type'	=> 'text',
			'placeholder' => 'Black Friday',
			'duty'	=> 1
			],
		'articles'	=> [
			'type'	=> 'add_tags',
			"lid" => "id",
			"lval" => "title",
			"lord" => "title",
			"ltable" => "products_view",
			'match' => true
			],
		'percent'	=> [
			'type'	=> 'spin',
			'min'	=> 5,
			'max'	=> 90,
			'interval'	=> 5,
			'default'	=> 5,
			'duty'	=> 1
			],
		'start'	=> [
			'type'	=> 'date',
			'default'	=> date('Y-m-d'),
			'duty'	=> 1
			],
		'end'	=> [
			'type'	=> 'date',
			'default'	=> date('Y-m-d', strtotime('+10 days')),
			'duty'	=> 1
			],
		];


		$obj = new access($form);
		// $obj->set_attribute($inputs);


		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		// elseif (param('_set_att')) {$html = $obj->attr_form($inputs);}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		// default tree shows plugins of group "plugins"
		$html['left'] = get_tab_tree($html, "plugins", $form['myconf'], "");;
		return $html;
		}

	private function pos($html) {
		$this->customer = param('client') ?  param('client') : 1;
		$tan = param('_tan') ?  param('_tan') : gen_tan(16);
		$parent = param('parent');
		$reg = '';
		if (param('_add')) {$this->set_basket($tan);}
		if (param('_reset')) {$tan = gen_tan(16);}

		if (param('_draw')) {
			$html['content'] = $this->drawer($tan);
			$html['gui'] = 6;
			/*$tan = gen_tan(16);
			$l = $html['myurl']."?sid={$html['sid']}&amp;_id=get_invoice&amp;_f=$fn";
			$reg = htmltag('a', "href=\"$l\" target=\"_blank\"", get_icon('file-pdf', 'pdf').' '.$fn);*/
			}

		else {
			$form = [
				"title"			=> 'POS',
				"table"			=> "products_view",
				"myconf"		=> "pos",
				"orderby"		=> "product_no",
				"human"			=> "product_no",
				"html"			=> $html,
				"rid"			=> 0,
				"search"		=> [],
				'searchform'	=> 0,
				"filters"		=> ['parent'],
				"allow_del"		=> false,
				"table_fields"	=> ['product_no', 'picture', 'title', '_tan', 'pid', 'stock']
				];

			$inputs = [
			'title'	=> ['type'	=> 'text'],
			'product_no'	=> ['type'	=> 'text'],
			'pid'	=> ['type'	=> 'text'],
			'parent'	=> [
				'caption'	=> i18n('goodsgroup'),
				'type'	=> 'text',
				'type' => 'lookup',
				"lid"		=> "id",
				"lval"		=> "graduated",
				"lord"		=> "parentsort",
				"ltable"	=> "folder_view",
				"lclause"	=> "`type` IN ('webshop', 'goodsgroup')",
				],
			'picture'	=> ['type'	=> 'text'],
			'_tan'		=> ['type'	=> 'free', 'default' => $tan]
			];

			$obj = new access($form);
			$html = $obj->table($inputs);
			$html['content'] = get_icon('parent', 'Webshop').' '.htmltag('a', "href=\"{$html['myurl']}?_id=webshop&amp;sid={$html['sid']}\"", 'Webshop');
			$html['content'] .= $obj->offsetText;
			$list = '';
			foreach ($obj->table_rows as $row) {
				$href = "{$html['myurl']}?_id=pos&amp;sid={$html['sid']}&amp;_tan=$tan&amp;_add={$row['pid']}&amp;parent=$parent";
				$img = get_thumb($row['picture'], '', 'cinemascope', '', $row['title']);
				if ($row['stock'] <= 0) {
					$img = get_big_icon('ban-red', 'Out of stock');
					$list .= "<li class=\"t4 no-pad\">$img <br>{$row['product_no']}</li>";
					}
				else {
					$list .= "<li class=\"t4 no-pad\"><a href=\"$href\">$img <br>{$row['product_no']}</a></li>";
					}
				}
			if ($list) {
				$list = htmltag('ul', 'class="yo-tiles"', $list);
				$list = htmltag('div', 'class="col w8 first"', $list);
				}
			else {$list = htmltag('div', 'class="col w8 first"', i18n('mess_no_entry'));}
			$html['content'] .= $list;
			$listing = $this->get_basket($tan);
			$inv = htmltag('p', 'class="big"', "{$this->total} {$this->defs['currency']}");
			if ($this->items) {
				$inv .= "<a href='{$html['myurl']}?_id=pos&amp;sid={$html['sid']}&amp;_tan=$tan&amp;_reset=1&amp;parent=$parent' class='as_button'>".get_icon('times', '').i18n('new')."</a>";
				$inv .= htmltag('h2', '', i18n('invoice'));
				$inv .= $listing;
				// $inv .= "<a href='{$html['myurl']}?_id=pos&amp;sid={$html['sid']}&amp;_tan=$tan&amp;_draw=1&amp;parent=$parent' class='as_button'>".get_icon('receipt', '').i18n('print')."</a>";
				$inv .= htmltag('div', 'class="yo-iframe" style="height: 150px;"', htmltag('iframe', "src='//localhost/POSprinter/?sid={$html['sid']}&amp;_tan=$tan' class='embedded'", ''));
				}
			$inv .= $reg;
			$html['content'] .= htmltag('div', 'id="invoice" class="col w4 last"', $inv);
			}
		return $html;
		}

	private function drawer($tan) {
		global $db, $html, $website;
		require_once('webshop_library.php');
		$this->isoc = $website['country'];
		$invoice = ['total' => 0, 'weight' => 0, 'articles' => []];
		$q = "SELECT `order_items`.`id`, `products`.`id` AS 'pid', `amount`, `products`.`product_no`, `weight`, `content`.`title`, `products`.`price`, `special_price`, `tax`, `products`.`weight` FROM `products`, `order_items` , `content` WHERE `order_items`.`product` = `products`.`pid` AND `products`.`pid` = `content`.`id` AND `order_items`.`sid` = ? ORDER BY `timestamp` DESC;";
		$arg = $db->prepare ($q);
		$arg->execute(array($tan));
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
			$data = $this->get_price($data);
			$invoice['total'] += $data['amount']*$data['incl'];
			$invoice['weight'] += $data['amount']*$data['weight'];
			array_push($invoice['articles'], $data);
			}

		$invoice['freight'] = 0;
		$invoice['total'] = sprintf('%0.2f', $invoice['total']);

		$q = "INSERT INTO `webshop_order` SET `client` = ?, `freight` = ?, `payment` = ?, `status` = ?, `weight` = ?, `total` = ?, `payed` = 'on', `payed_date` = ?, `country` = ?;";
		$arg = $db->prepare ($q);
		$arg->execute(array($this->customer, $invoice['freight'], 'invoice', 3, $invoice['weight'], $invoice['total'], date('Y-m-d'), $website['country']));
		$invoice['oid'] = $db->lastInsertId();

		foreach ($invoice['articles'] as $a) {
			$q ="UPDATE `order_items` SET `sid` = '', `order_id` = ?, `status` = 2, `copy_product_no` = ?, `copy_name` = ?, `copy_tax` = ?, `price` = ? WHERE `id` = ?;";
			$arg = $db->prepare ($q);
			$arg->execute(array($invoice['oid'], $a['product_no'], $a['title'], $a['tax'], $a['incl'], $a['id']));

			$q ="UPDATE `products` SET `stock` = `stock`- {$a['amount']} WHERE `id` = ?;";
			$arg = $db->prepare ($q);
			$arg->execute(array($a['pid']));
			}

		$f_id = sprintf($this->defs['pattern'], $invoice['oid']);
		$f_id = preg_replace('/^YY/', date('y'), $f_id);
		$file = i18n('invoice')."-$f_id.pdf";
		$invoice['Subject'] = i18n('invoice')." $f_id";
		$invoice['defs'] = $this->defs;
		$invoice['inv_addr'] = '';
		$invoice['date'] = date('Y-m-d');
		$pdf = new webshop_lib(['data' => $invoice, 'file' => $file, 'image' => $html['dir'].'/pictures/'.$this->defs['logo']]);
		$pdf->create_invoice_pdf();
		$json = json_encode($invoice);
		return $json;
		}

	private function order_delivery($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('delivery'),
			"table"			=> "clients_delivery",
			"myconf"		=> "order_delivery",
			"orderby"		=> "name",
			"human"			=> "name",
			"html"			=> $html,
			"rid"			=> $rid,
			"button_text"	=> i18n('ok'),
			"no_cancel"		=> 1,
			"search"		=> ['name', 'prename', 'company'],
			"table_fields"	=> ['salutation', 'title', 'name', 'prename', 'city', 'country']
			];

		$inputs = [
		'cid'	=> [
			'type'	=> 'lookup',
			'ltable'	=> 'clients',
			'lid'	=> 'id',
			'lval'	=> 'name',
			'lord'	=> 'name'
			],
		'use_del'	=> [
			'type'	=> 'flag',
			'default' => 'on'
			],
		'salutation'	=> [
			'type'	=> 'array',
			'extra'	=> [i18n('ms'), i18n('mr'), i18n('company')],
			'duty'	=> 1,
			],
		'title'	=> [
			'type'	=> 'text',
			],
		'name'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'prename'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'company'	=> [
			'type'	=> 'text'
			],
		'company_line2'	=> [
			'type'	=> 'text'
			],
		'street'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'city'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'province'	=> [
			'type'	=> 'text',
			],
		'postal_code'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'country'	=> [
			'type'	=> 'country',
			'default'	=> 'at',
			'duty'	=> 1,
			],
		'phone'	=> [
			'type'	=> 'text',
			],
		'fax'	=> [
			'type'	=> 'text',
			],
		'mobile'	=> [
			'type'	=> 'text',
			],
		'email'	=> [
			'type'	=> 'text',
			],
		];

		$obj = new access($form);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		$html['left'] = get_tab_tree($html, "webshop", $form['myconf'], "");
		return $html;
		}

	private function manufacturer_admin($html) {
		$rid = param('rid');
		$todo = clean_var(param('todo'), "w");

		$form = [
			"title"			=> i18n('provider'),
			"table"			=> "shop_manufacturer",
			"myconf"		=> "manufacturer",
			"orderby"		=> "name",
			"human"			=> "name",
			"html"			=> $html,
			"rid"			=> $rid,
			"search"		=> ['name'],
			"table_fields"	=> ['name', 'logo']
			];

		$inputs = [
		'name'	=> [
			'type'	=> 'text',
			'duty'	=> 1,
			],
		'logo'	=> [
			'caption'	=> i18n('website_logo'),
			'type'	=> 'image',
			],
		];


		$obj = new access($form);

		if (param('_store')) {
			$inputs = $obj->get_params($inputs);
			if ($obj->error) {$todo = "edit"; $obj->error = 0;}
			else {
				$id = $obj->store($inputs);
				$html['popup'] = $obj->feedback;
				}
			}

		if ($todo == "edit") {
			if (!$rid) {$obj->rid = "new";}
			elseif ($rid != "new") {$inputs = $obj->get_value($inputs);}
			if ($obj->error) {$html['content'] = $obj->feedback;}
			else {
				$obj->add_input($inputs);
				$html = $obj->form();
				}
			}
		elseif ($todo == "delete" || param('_del_all')) {$html = $obj->ask();}
		else {
			$submen = array(
				[i18n('new_entry'), $html['myurl']."?sid={$html['sid']}&amp;_id={$form['myconf']}&amp;todo=edit", "inactive", "add"]
				);
			$obj->before_table = make_submenu($submen);
			if (param('_del')) {$obj->delete();}
			$html = $obj->table($inputs);
			}
		$html['left'] = get_tab_tree($html, "webshop", $form['myconf'], "");
		return $html;
		}

	public function shop_tree($open, $action, $tan = '') {
		global $db, $html, $con;
		if ($tan) {$tan = "&amp;_tan=".$tan;}

		$item = [
			"caption"	=> i18n('webshop'),
			"link"		=> "{$html['myurl']}?_id=webshop&amp;sid={$html['sid']}",
			"state"		=> 'parent'
			];
		$tree = list_item($item);

		$roots = [
			"parent"	=> 1,
			"pfield"	=> "parent",
			"field"		=> "title",
			"table"		=> "folder_view",
			"sort"		=> "parent",
			"index"		=> 0,
			"exclusive"	=> 'goodsgroup',
			"open"		=> $open,
			"free"		=> $tan,
			"action"	=> $action
			];
		$subtree = branch($roots);
		$item = [
			"caption"	=> i18n('all'),
			"link"		=> "{$html['myurl']}?_id=$action&amp;sid={$html['sid']}$tan",
			"state"		=> 'all',
			"sub"		=> htmltag('ul', '', $subtree)
			];
		$tree .= list_item($item);

		$tree = parse_in('gui_tree', ['treelist' => $tree]);
		return $tree;
		}

	private function get_file($html) {
		$defs = read_settings(['group' => 'webshop']);
		$filename = clean_var(param('_f'), 'w').".pdf";
		$file = $defs['pdf_dir'].$filename;

		$html['gui'] = 6;
		header('Content-type: application/pdf');
		header('Content-Disposition: inline; filename="' . $filename . '"');
		header('Content-Transfer-Encoding: binary');
		header('Content-Length: ' . filesize($file));
		header('Accept-Ranges: bytes');
		$html['content'] = file_get_contents($file);
		return $html;
	}

	/*
	 * put something into the basket
	 */
	private function set_basket($tan) {
		global $db, $html;
		$bid =  clean_var(param('_add'), 'n');
		$arg = $db->prepare("SELECT `product` FROM `order_items` WHERE `product` = ? AND `sid` = ?;");
		$arg->execute(array($bid, $tan));
		if ($arg->rowCount()) {
			$arg = $db->prepare("UPDATE `order_items` SET `amount` = `amount`+1 WHERE `product` = ? AND `sid` = ?");
			$arg->execute(array($bid, $tan));
			}
		else {
			$arg = $db->prepare("INSERT INTO `order_items` (`sid`, `product`, `amount`) VALUES (?, ?, ?)");
			$arg->execute(array($tan, $bid, 1));
			}
		}

	// just for pos
	private function get_basket($tan) {
		global $db;
		$content= '';
		$q = "SELECT `amount`, `products`.`product_no`, `content`.`title`, `products`.`price`, `special_price`, `tax` FROM `products`, `order_items` , `content` WHERE `order_items`.`product` = `products`.`pid` AND `products`.`pid` = `content`.`id` AND `order_items`.`sid` = ? ORDER BY `timestamp` DESC;";
		$arg = $db->prepare ($q);
		$arg->execute(array($tan));
		$rows = $arg->rowCount();
		$total = 0;
		$all = 0;
		$weight = 0;
		if ($rows) {
			while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {
				$data = $this->get_price($data);
				$data['price'] = $data['amount']*$data['incl'];
				$data['title'] = cut_text($data['title'], 15, '');
				$all += $data['amount'];
				$total += $data['price'];
				$data['price'] = sprintf('%0.2f', $data['price']);
				$td = htmltag('td', '', $data['product_no']);
				$td .= htmltag('td', 'colspan="2"', $data['title']);
				$content .= htmltag('tr', '', $td);
				$td = htmltag('td', '', $data['amount']);
				$td .= htmltag('td', 'class="alright"', $data['incl']);
				$td .= htmltag('td', 'class="alright"', $data['price']);
				$content .= htmltag('tr', '', $td);
				}
			//$content['currency'] = $this->defs['currency'];
			$total = sprintf('%0.2f', $total);
			$td = htmltag('td', 'colspan="3" class="alright"', $total);
			$content .= htmltag('tr', '', $td);
			$this->total = $total;
			$this->items = $all;
			}
		else {$content = i18n('mess_no_entry');}

		return htmltag('table', 'class="table"', $content);
		}

	private function get_wvalue() {
		global $db;
		$q = "SELECT SUM(`stock`*`price`) AS `val_of_goods` FROM `products`;";
		$arg = $db->prepare($q);
		$arg->execute();
		$val = $arg->fetch(PDO::FETCH_ASSOC);
		return $val['val_of_goods'];
		}

	private function get_history($id) {
		global $db;
		$c = '';
		$q = "SELECT * FROM `stock_history` WHERE `pid` = ? ORDER BY `time` DESC;";
		$arg = $db->prepare($q);
		$arg->execute([$id]);
		while ($val = $arg->fetch(PDO::FETCH_ASSOC)) {
			$d = htmltag('td', '', $val['time']);
			$d .= htmltag('td', '', $val['stock']);
			$d .= htmltag('td', '', $val['delta']);
			$c .= htmltag('tr', '', $d);
			}
		if ($c) {
			$c = htmltag('table', 'class="table"', $c);
			$c = htmltag('h2', '', i18n('stock_history')).$c;
			}
		return $c;
		}

	private function sync_versions($a) {
		global $db;
		foreach ($a as $v) {
			$bobby = '';
			foreach ($a as $vv) {if ($v != $vv) {$bobby .= "$vv,";}}
			$bobby = preg_replace("/,$/", '', $bobby);
			$q = "UPDATE `products` SET `versions` = ? WHERE `pid` = ?;";
			$arg = $db->prepare($q);
			$arg->execute([$bobby, $v]);
			}
		}

	private function get_unbound() {
		global $db, $con;
		$unbound = [];
		$q = "SELECT `iso3166`, `{$con['ln']}` FROM `countries` WHERE `iso3166` NOT IN (SELECT `id_countries` FROM `webshop_freight_junction_countries`);";
		$arg = $db->prepare($q);
		$arg->execute();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {$unbound[$data['iso3166']] = $data[$con['ln']];}
		return $unbound;
		}

	private function get_multi() {
		global $db, $con;
		$multi = [];
		$q = "SELECT `id_countries`, count(`id`) AS `cc` FROM `webshop_freight_junction_countries` GROUP BY `id_countries` HAVING `cc` > 1;";
		$arg = $db->prepare($q);
		$arg->execute();
		while ($data = $arg->fetch(PDO::FETCH_ASSOC)) {$multi[$data['id_countries']] = get_country_name($data['id_countries']);}
		return $multi;
		}

	private function init_shop() {
		global $db, $con, $website;
		$q = "DROP TRIGGER IF EXISTS `set_payed`";
		$arg = $db->prepare($q); $arg->execute();
		$q = "CREATE TRIGGER `set_payed` BEFORE UPDATE ON `webshop_order` FOR EACH ROW BEGIN IF NEW.payed != OLD.payed OR OLD.payed IS NULL THEN IF NEW.payed = 'on' THEN SET NEW.payed_date = NOW(); END IF; IF NEW.payed != 'on' THEN SET NEW.payed_date = '1970-01-01'; END IF; END IF; END";
		$arg = $db->prepare($q); $arg->execute();
		$err = $arg->errorInfo();
		$error = array_key_exists(2, $err) ? $err[2] : "OK";
		echo $error;
		$q = "DROP TRIGGER IF EXISTS `set_stock`";
		$arg = $db->prepare($q); $arg->execute();
		$q = "CREATE TRIGGER `set_stock` BEFORE UPDATE ON `products` FOR EACH ROW BEGIN IF NEW.stock != OLD.stock THEN INSERT `stock_history` SET `pid` = NEW.pid, `stock` = NEW.stock, `delta` = (NEW.stock - OLD.stock); END IF; END";
		$arg = $db->prepare($q); $arg->execute();
		$err = $arg->errorInfo();
		$error = array_key_exists(2, $err) ? $err[2] : "OK";
		echo $error;
		// write html snippet according to design settings
		$q = "SELECT `key`, `code` FROM `html_presets` WHERE `key` = 'cms_webshop_body' AND `generation` = ? AND `main` = ? LIMIT 1;";
		$arg = $db->prepare($q);
		$arg->execute([$website['css_generation'], $website['act_layout']]);
		$code = $arg->fetch(PDO::FETCH_ASSOC);
		$q2 = "INSERT INTO `html_snippets` SET `code` = ?, `key` = ?, `group` = ?, `description` = ?;";
		$arg2 = $db->prepare($q2);
		$arg2->execute([$code['code'], $code['key'], '5', 'Body of Webshop']);
		}
	}
?>
