/**
 * @Author: consentio
 * @Date:   2018-08-18T16:58:21+02:00
 * @Project: Consentio CMS
 * @Filename: calendar.js
 * @Last modified by:   consentio
 * @Last modified time: 2022-05-16T12:21:18+02:00
 * @License: GPL 2.0
 * @Copyright: IMB Webdevelopment
 */



(function($) {
	$.fn.dragthem = function(options) {
		var defaults = {
			'type': 'month',
			'url': false,
			'snapx': 110,
			'snapy': 110,
			'start_hour': 6,
			'hours': 18,
			'rowheight': 0
			};
		options = $.extend(defaults, options);

		var zi = 10000;
		var last_left = 0;
		var i = 1;

		var table;
		var actTd = 0;
		var actDrag;

		$(this).each(
			function() {
				var oDiv = $(this);
				if (!table) {
					var oTable = oDiv.parents('table');
					var to = oTable.offset();
					oTh = $('th:first', oTable);
					table = {'id': oTable.attr('id'), 'x': oTh.outerWidth(),'y': oTh.outerHeight(), 'ox': to.left, 'oy': to.top};
					}

				var w = oDiv.width();
				options.rowheight = oDiv.parents('tr').outerHeight();
				var drag = $('.dragzone', oDiv);

				oDiv.click(function(e){
					zi = next_z(zi);
					oDiv.css('z-index', zi);
					});

				if (drag.html()) {
					if (options.type != 'month') {
						var times = $('.timestamp', oDiv).text().split('-');
						var top = timeToPos(times[0]);
						var height = timeToPos(times[1]) - top;
						oDiv.css({'position': 'absolute', 'width': w+'px', 'z-index': zi, 'top': top+'px', 'height': height+'px'});
						oDiv.append("<div class='resize'> </div>")
						$('.resize', oDiv).mousedown(function(e){
							e.preventDefault();
							e.stopPropagation();
							var firstdown = e.pageY;
							var height = oDiv.height();
							actDrag = oDiv;
							$(document).on('mousemove', function(e){
								var top = parseInt(oDiv.css('top')) - table.y;
								var start = posToTime(top);
								var newheight = height + (e.pageY - firstdown);
								if (newheight <= 20) {newheight = 20;}
								if (newheight + top >= options.hours*options.rowheight + 1) {newheight = parseInt(oDiv.css('height'));}
								var end = heightToTime(newheight, top);
								$('.timestamp', oDiv).text(start+'-'+end);
								oDiv.css('height', newheight+'px');
								});
							});
						$(document).mouseup(function(e){$(document).off('mousemove')});
						}
					var drag = $('.dragzone', oDiv);
					drag.css('cursor', 'move');
					drag.mousedown(function(e){
						e.preventDefault();
						e.stopPropagation();
						var pos = oDiv.offset();
						var a = parseInt(e.pageY - pos.top);
						var b = parseInt(e.pageX - pos.left);
						oDiv.css({'opacity': 1, 'position': 'absolute', 'width': w+'px', 'z-index': zi});
						$(document).on('mousemove', function(e){move(e, oDiv, a, b);});
						});
					$('#'+table.id).mouseup(function(e){
						if (actDrag != undefined) {
							var aid = actDrag.attr('data-id');
							if (options.type == 'month') {
								oDiv.css({'position': 'static', 'opacity': '0.8','top': "inherit", 'left': "inherit"});
								actTd.append(actDrag);
								actTd.removeClass('day_active');
								var date = actTd.attr('data-day');
								setAppointment(aid, 0, date);
								}
							else {
								oDiv.css({'opacity': '0.8'});
								var times = $('.timestamp', actDrag).text();
								var date = actDrag.attr('data-day');
								setAppointment(aid, times, date)
								}
							$(document).off('mousemove');
							//actDrag = undefined;
							}
						});
					}
				});


		function next_z (z) {
			$('.appointment').each(function(){
				if ($(this).css('z-index') > z) {z = $(this).css('z-index');}
				z++
				});
			z++; return z;
			}

		function move(e, win, a, b) {
			if (e) {
				var top = e.pageY - (a + table.oy);
				var left = e.pageX - (b + table.ox);
				var xtar = parseInt((left-table.x)/options.snapx);
				var ytar = parseInt((top-table.y)/options.snapy);

				if (options.type == 'month') {
					var snap = xtar+"-"+ytar;
					$("div[data-snap]").removeClass('day_active');
					actTd = $("div[data-snap="+snap+"]");
					actTd.addClass('day_active');
					win.css({'top': top + "px", 'left': left + "px"});
					}
				else {
					if (ytar <= 0) {top = table.y; ytar = 0;}
					if (ytar + win.height() >= options.hours*options.rowheight + 1) {
						top = parseInt(win.css('top'));
						ytar = top - table.y;
						}
					win.css({'top': top + "px"});
					var start = posToTime(ytar);
					var end = heightToTime(win.height(), ytar);
					$('.timestamp', win).text(start+' - '+end);
					if (options.type == 'week') {
						var pos = parseInt(win.css('left'));
						var next = pos + options.snapx/2;
						var prev = pos - options.snapx/2;
						if (left >= next && left <= 7*options.snapx) {
							left = pos + options.snapx;
							getNewDate(win, left, 1)
							}
						if (left <= prev && left >= table.x) {
							left = pos - options.snapx;
							getNewDate(win, left, -1)
							}
						}
					}
				actDrag = win;
				}
			}

		function posToTime(pos) {
			var time = pos / options.rowheight;
			var hour = Math.floor(time);
			var minute = Math.floor((time - hour) *60);
			hour += options.start_hour;
			if (String(hour).length < 2){hour = ("00" + hour).slice(-2);}
			if (String(minute).length < 2){minute = ("00" + minute).slice(-2);}
			return (hour+":"+minute);
			}

		function timeToPos(time) {
			var arr = time.split(':');
			var hour = (Math.round(parseInt(arr[0])) - options.start_hour) + (Math.round(arr[1])/60);
			var pos = Math.round(hour*options.rowheight) + table.y;
			return(pos);
			}

		function heightToTime(height, top) {
			var pos = top + height;
			var end = posToTime(pos);
			return(end);
			}

		function getNewDate(win, left, moveX) {
			win.css({'left': left + "px"})
			var date = win.attr('data-day');
			var oDate = new Date(date.split('-'));
			oDate.setDate(oDate.getDate() + moveX);
			win.attr('data-day', oDate.getFullYear()+"-"+parseInt(oDate.getMonth()+1)+"-"+oDate.getDate());
			}

		function setAppointment(id, time, date){
			var query = "sid="+options.sid+"&rid="+id+"&date="+date+"&_id=scheduler&todo=set";
			var oMessage = $('<div class="dlg"></div>');
			oMessage.css({'display': 'none', 'z-index': 100000, 'position': 'fixed', 'top': '25%', 'left': 0, 'right': 0, 'width': '100px', 'padding' : '3em 1em', 'text-align': 'center'});
			oMessage.append('<p><i class="fas fa-sync fa-4x fa-spin green"></i></p>')
			$('#site').prepend(oMessage);
			if (time) {
				var times = time.split('-');
				query += "&start="+times[0]+"&end="+times[1];
				}
			$.ajax({
				type: "POST",
				url: options.url,
				data: query,
				dataType: "html",
				beforeSend: function() {
					oMessage.show();
					return true;
					},
				success: function(msg){
					oMessage.fadeOut('slow');
					if (id == 'new') {
						var adate = date.split("-");
						}
					}
				});
			return false;
			}
		return false;
		}
	})(jQuery);
