/*
 * Based upon Tiny Carousel 1.76
 *
 * Copyright (c) 2010 Maarten Baijs
 *
 */
(function($){
	$.fn.tinycarousel = function(options){
		var defaults = { 
			start: 1, // where should the carousel start?
			axis: 'x', // vertical or horizontal scroller? ( x || y ).
			controls: true, // show left and right navigation buttons.
			pager: false, // is there a page number navigation present?
			interval: false, // move to another block on intervals.
			intervaltime: 3000, // interval time in milliseconds.
			animation: true, // false is instant, true is animate.
			duration: 1000, // how fast must the animation move in ms?
			callback: null, // function that executes after every move
			previous: "previous",
			next: "next",
			cycle: "once"
		};
		options = $.extend(defaults, options);
		var oSlider = $(this);
		var oViewport = $('.viewport', oSlider);
		var oContent = $('.overview', oSlider);
		var oPages = oContent.children();
		var oBtnNext;
		var oBtnPrev;
		var oPager;
		var iPageSize, iSteps, iCurrent, oTimer, bForward = true, bAxis = options.axis;
		var eResize;
		oSlider.keydown(function(event){
			switch (event.keyCode) {
				case(39) : move(1); break;
				case(37) : move(-1); break;
				}
			return true;
			});
		return this.each(function(){
			initialize();
		});
		function initialize(){
			oSlider.css({"overflow": "hidden"});
			oViewport.css({"overflow": "hidden"});
			var width = oViewport.outerWidth(true);
			oPages.css('width', width+"px");
			switch (bAxis) {
				case "x" : iPageSize = width; break;
				case "y" : iPageSize = oViewport.outerHeight(true); break;
				case "z" : iPageSize =  1; break;
				}
			if(options.controls){
				oBtnNext = $('<a href="#"></a>').append(options.next).addClass("next");
				oBtnPrev = $('<a href="#"></a>').append(options.previous).addClass("prev");
				oViewport.before(oBtnPrev).after(oBtnNext)
				}
			iSteps = oPages.length;
			if (options.pager) {
				oPager = $('<ul></ul>').addClass('pager');
				for (var i = 0; i < iSteps; i++)
				oPager.append($('<li></li>').append($('<a href="#"></a>').append(i+1).addClass("pagenum").attr("rel",i)));
				oSlider.append(oPager);
				}
			iCurrent = Math.min(iSteps, Math.max(1, options.start)) -2;
			switch (bAxis) {
				case "x" : oContent.css('width', (iPageSize * oPages.length));break;
				case "y" : oContent.css('height', (iPageSize * oPages.length));break;
				case "z" :$(oPages).css({'position': 'absolute', 'top': '0px', 'left': '0px', 'display': 'none'});break;
				}
			move(1);
			setEvents();
		}
		
		function setButtons(){
			if(options.controls){
				oBtnPrev.toggleClass('disable', !(iCurrent > 0));
				oBtnNext.toggleClass('disable', !(iCurrent +1 < iSteps));
			}
		}
		
		function setEvents(){
			if(options.controls && oBtnPrev.length > 0 && oBtnNext.length > 0){
				oBtnPrev.click(function(){move(-1); return false;});
				oBtnNext.click(function(){move( 1); return false;});
			}
			if(options.pager && oPager.length > 0){
				oPager.click(setPager);
			}
			$(window).resize(function() {
				if (eResize) {clearTimeout(eResize)}
				eResize = setTimeout(function() {
					var width = oViewport.outerWidth(true);
					var height = oViewport.outerHeight(true);
					oPages.css('width', width+"px");
					if (bAxis == "x") {iPageSize = width;}
					if (bAxis == "y") {iPageSize = height;}
					move(1);
					}, 300);
				});
		}
		function setPager(oEvent){
			var oTarget = oEvent.target;
			if($(oTarget).hasClass('pagenum')){
				iCurrent = parseInt(oTarget.rel) -1;
				move(1);
			}
			return false;
		}
		function setPagerActive(){
			if(options.pager){
				var oNumbers = $('.pagenum', oPager);
				oNumbers.removeClass('active');
				$(oNumbers[iCurrent]).addClass('active');
			}
		}
		function setTimer(bReset){
			if(options.interval && !bReset){
				clearInterval(oTimer);
				oTimer = window.setInterval(function(){
					if (options.cycle == "once") {
						iCurrent = iCurrent +1 == iSteps ? -1 : iCurrent;
						move(1, true);
						}
					else {
						bForward = iCurrent +1 == iSteps ? false : iCurrent == 0 ? true : bForward;
						move(bForward ? 1 : -1, true);
						}
				}, options.intervaltime);
			}
		}
		function move(iDirection, bTimerReset){
			if(iCurrent + iDirection > -1 && iCurrent + iDirection < iSteps){
				var last = iCurrent;
				iCurrent += iDirection;
				var oPosition = {};
				switch (bAxis) {
					case "x" : oPosition['left'] = -(iCurrent * iPageSize);break;
					case "y" : oPosition['top'] = -(iCurrent * iPageSize);break;
					case "z" : break;
					}
				if (bAxis != "z") {
					oContent.animate(oPosition,{
						queue: false,
						duration: options.animation ? options.duration : 0,
						complete: function(){
							if(typeof options.callback == 'function')
							options.callback.call(this, oPages[iCurrent], iCurrent);
							}
						});
					}
				else {
					if (iCurrent == 0 || bTimerReset !== true) {$(oPages).css('display', 'none');}
					if (iDirection > 0) {$(oPages[iCurrent]).fadeIn(options.duration);}
					else {
						$(oPages[iCurrent]).css('display', 'block');
						$(oPages[last]).fadeOut(options.duration);
						}
				}
				setButtons();
				setPagerActive();
				setTimer(bTimerReset);
			}
		}
	};
})(jQuery);