/* functions for the css-authoring tool */

/* save and get the last line */
$(document).ready(function () {
	var doc = myCodeMirror.getDoc();
	$('#itable').on('submit', function(){
	  var cur = doc.getCursor();
	  $('#ilast_pos').val(cur['line'])
	  });	
	if ($('#ilast_pos').val()) {
		doc.setCursor({line: $('#ilast_pos').val(), ch: 1});
		}
	});

(function($){
	$.fn.colorpicker = function(opt){
		var defaults = { 
			c: '#FFFFFF'
		};
		opt = $.extend(defaults, opt);
		var doc = myCodeMirror.getDoc();
		
		set_color(defaults.c);
		$('.pal').css('cursor', 'crosshair');
		$('.fill').css('cursor', 'pointer');
		$('.pal').each(function() {
			var obj = $(this);
			obj.on("click",function(){
				set_color(obj.attr('data-val'));
				});
			});
		
		$('#fillcout').on("click",function(){
			var start = doc.getCursor('start');
			var end = doc.getCursor('end');
			doc.replaceRange( $("#chex").val(), start, end);
			});
		
		$('#rgbfillcout').on("click",function(){
			var start = doc.getCursor('start');
			var end = doc.getCursor('end');
			doc.replaceRange( $("#crgb").val(), start, end);
			});
		
		$('#fillcin').on("click",function(){
			var newc = doc.getSelection();
			newc = newc.match(/^\#\S{3,6}/); // could be better...
			if (!newc) {newc = '#FF0000';}
			$("#chex").val(newc);
			set_color(newc);
			});	
		
		$('.fill').each(function() {
			var obj = $(this);
			obj.on("click",function(){
				obj.css('background-color', $("#chex").val());
				fill_color(obj.attr('id'), $("#chex").val());
				drawPalette();
				});
			});
		
		$('.cssbutton').css('cursor', 'pointer');
		drawPalette();
		
		function set_color(col) {
			$('#viewcolor').css('background-color', col);
			$('#crgb').val($('#viewcolor').css('background-color'));
			$("#chex").val(col);
			}
			
		function fill_color(id, col) {
			id = id.replace(/^f_/, '');
			var entry = $('#'+id).val(); 
			entry = entry.replace(/\#[0-9A-F]*/i, col);
			$('#'+id).val(entry);
			}			
		
		function hexme(c) {
			var result = '';
			var d = 1;
			for (k = 0; k < 3; k++) {
				val = Math.round(c[k]/d);
				piece = val.toString(16);
				if (piece.length < 2) {piece = '0' + piece;}
				result = result + piece;
				}
			result = '#' + result.toUpperCase();
			return result;
			}
			
		function drawPalette() {
			var col1 = $('#firstcolor').val().replace(/[\#\(]*/,'');
			var col2 = $('#secondcolor').val().replace(/[\#\(]*/,'');
			var rgb1 = Array(parseInt(col1.substr(0,2),16),parseInt(col1.substr(2,2),16),parseInt(col1.substr(4,2),16));
			var rgb2 = Array(parseInt(col2.substr(0,2),16),parseInt(col2.substr(2,2),16),parseInt(col2.substr(4,2),16));
			var rstep = (rgb2[0] - rgb1[0]) / 11;
			var gstep = (rgb2[1] - rgb1[1]) / 11;
			var bstep = (rgb2[2] - rgb1[2]) / 11;
			for (i = 1; i < 11; i++) {
				var rgb = Array(0,0,0);
				rgb[0] = (rgb1[0] + (rstep * i));
				rgb[1] = (rgb1[1] + (gstep * i));
				rgb[2] = (rgb1[2] + (bstep * i));
				var hex = hexme(rgb);
				$('#p'+i).css('background-color', hex);
				$('#p'+i).attr('title', hex);
				$('#p'+i).attr('data-val', hex);
				}
			}
	};
})(jQuery);