// jQuery plugin for consentio cms //
// jQmenu //

$.fn.dropdown = function (options) {
	var settings = $.extend({
		timeout: 500,
		effect: '', // slide, fade
		dropdown: 1,
		mobileID: 'responsive_menue',
		limit: 490
		}, options);
	var oMenu = $(this);
	var oID = oMenu.attr('id');
	var closetimer = null;
	var ddmenuitem = null;
	var oWidth = null;
	var first = $('li > a', oMenu);
	var layer = $('li > ul', oMenu);
	var second = $('.secondlevel > li > a');

	if (settings.mobileID) {
		jsddm_responsive();
		$(window).on('resize', jsddm_responsive);
		}
	else if (settings.dropdown) {
		first.on('mouseenter',jsddm_open);
		first.on('focus', jsddm_open);
		first.on('mouseout', jsddm_timer);
		first.on('blur', jsddm_timer);
		second.on('mouseover', jsddm_canceltimer);
		second.on('focus', jsddm_canceltimer);
		second.on('mouseout', jsddm_timer);
		second.on('blur', jsddm_timer);
		}

	function jsddm_open() {
		jsddm_canceltimer();
		jsddm_close();
		if (settings.effect == 'slide') {ddmenuitem = $(this).parents('li').find('ul').eq(0).slideDown("fast");}
		if (settings.effect == 'fade') {ddmenuitem = $(this).parents('li').find('ul').eq(0).fadeIn("fast");}
		else {ddmenuitem = $(this).parents('li').find('ul').eq(0).show();}
		}

	function jsddm_close(){
		jsddm_canceltimer();
		if (settings.effect == 'slide') {if(ddmenuitem) layer.slideUp("fast");}
		if (settings.effect == 'fade') {if(ddmenuitem) layer.fadeOut("fast");}
		else {if(ddmenuitem) layer.hide();}
		}

	function jsddm_timer() {
		jsddm_canceltimer();
		closetimer = setTimeout(jsddm_close, settings.timeout);
		}

	function jsddm_canceltimer(){
		if (settings.effect) {$('.secondlevel').stop()}
		if(closetimer){
			clearTimeout(closetimer);
			closetimer = null;
			}

		}

	function jsddm_responsive() {
		var width = $('.col.w12').outerWidth(false);
		if (width != oWidth) {
			if (width <= settings.limit) {
				oMenu.css('display', 'none');
				first.off();
				oMenu.attr('id', settings.mobileID);
				$('.jumpmarks :header').removeClass('hidden');
				$('.jumpmarks').addClass('responsive');
				$('.responsive').off();
				$('.responsive').on('click', jsddm_toggle);
				}
			else if (width > settings.limit) {
				$('.responsive').off();
				oMenu.attr('id', oID);
				oMenu.css('display', 'block');
				layer.css('display', 'none');
				first.off();
				second.off();
				if (settings.dropdown) {
					first.on('mouseenter', jsddm_open);
					first.on('focus', jsddm_open);
					first.on('mouseout', jsddm_timer);
					first.on('blur', jsddm_timer);
					second.on('mouseover', jsddm_canceltimer);
					second.on('focus', jsddm_canceltimer);
					second.on('mouseout', jsddm_timer);
					second.on('blur', jsddm_timer);
					}
				$('.jumpmarks :header').addClass('hidden');
				$('.jumpmarks').removeClass('responsive');
				}
			}
		oWidth = width;
		}

	function jsddm_toggle() {
		if (oMenu.css('display') == "block") {
			oMenu.slideUp();
			layer.css('display', 'none');
			}
		else {
			layer.css('display', 'block');
			oMenu.slideDown();
			}
		}

	return this;
	}
