(function($) {
	$.fn.openMap = function(opt) {
		var defaults = {
			'url': '/openStreetmap.php?',
			'src': '//www.openstreetmap.org/export/embed.html?layer=mapnik&',
			'link': '//www.openstreetmap.org/?',
			'zoom': 19,
			'height': 500,
			'q': 'Wien',
			'txt': 'Route planen'
			};
		opt = $.extend(defaults, opt);	

		var oMe = $(this);
		var q = "q="+encodeURI(opt.q);
		if (opt.country) {q += "&countrycodes="+encodeURI(opt.country);}
		if (opt.city) {q += "&city="+encodeURI(opt.city);}
		if (opt.street) {q += "&street="+encodeURI(opt.street);}
		var loc = [];
		var out = 'error';
		
		$.ajax({
			type: "GET",
			url: opt.url,
			data: q,
			dataType: "json",
			success: function(data){
				loc = data[0];
				var src = encodeURI('bbox='+loc['boundingbox'][2]+','+loc['boundingbox'][0]+','+loc['boundingbox'][3]+','+loc['boundingbox'][1]+'&marker='+loc['lat']+','+loc['lon']);
				var ifr = $('<iframe>').attr({'src': opt.src+src, 'height': opt.height, 'width': '100%'});
				oMe.append(ifr);
				var href = opt.link+'mlat='+loc['lat']+'&mlon='+loc['lon']+'#map='+opt.zoom+'/'+loc['lat']+'/'+loc['lon'];
				var lnk = $('<a>').attr({'href': href, 'target': '_blank'}).append(opt.txt);
				oMe.append($('<p>').append(lnk));
				},
			error: function(x, msg, z){oMe.html(msg);}
			});
		}
	})(jQuery);